/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.calculation.vo;

import java.util.Date;

import jp.mosp.time.settings.base.TimeSettingVo;

/**
 * 勤怠集計結果一覧の情報を格納する。
 */
public class TotalTimeListVo extends TimeSettingVo {
	
	private static final long	serialVersionUID	= 5688539242169607126L;
	
	private String				txtEditEmployeeCode;
	private String				txtEditEmployeeName;
	private String				pltEditWorkPlace;
	private String				pltEditEmployment;
	private String				pltEditSection;
	private String				pltEditPosition;
	private String				pltEditApproval;
	private String				pltEditCalc;
	private String[]			aryPersonalId;
	private String[]			aryLblEmployeeCode;
	private String[]			aryLblEmployeeName;
	private String[]			aryLblSection;
	private String[]			aryLblWorkDate;
	private String[]			aryLblWorkTime;
	private String[]			aryLblRestTime;
	private String[]			aryLblLateTime;
	private String[]			aryLblLeaveEarlyTime;
	private String[]			aryLblOverTimeIn;
	private String[]			aryLblOverTimeOut;
	private String[]			aryLblWorkOnHolidayTime;
	private String[]			aryLblLateNightTime;
	private String[]			aryLblApploval;
	private String[]			aryLblCalc;
	private String[]			aryLblPaidHoliday;
	private String[]			aryLblAllHoliday;
	private String[]			aryLblAbsence;
	private String[]			aryLblCorrection;
	
	private String[][]			aryPltEditWorkPlace;
	private String[][]			aryPltEditEmployment;
	private String[][]			aryPltEditSection;
	private String[][]			aryPltEditPosition;
	private String[][]			aryPltEditApproval;
	private String[][]			aryPltEditCalc;
	
	private String[]			claApploval;
	private String[]			claCalc;
	
	private Date				searchDate;
	private String				cutoffCode;
	private Date				cutoffDate;
	
	private String[]			aryDetailOnOff;
	
	private String				jsCutoffState;
	

	/**
	 * @return txtEditEmployeeCode
	 */
	public String getTxtEditEmployeeCode() {
		return txtEditEmployeeCode;
	}
	
	/**
	 * @param txtEditEmployeeCode セットする txtEditEmployeeCode
	 */
	public void setTxtEditEmployeeCode(String txtEditEmployeeCode) {
		this.txtEditEmployeeCode = txtEditEmployeeCode;
	}
	
	/**
	 * @return txtEditEmployeeName
	 */
	public String getTxtEditEmployeeName() {
		return txtEditEmployeeName;
	}
	
	/**
	 * @param txtEditEmployeeName セットする txtEditEmployeeName
	 */
	public void setTxtEditEmployeeName(String txtEditEmployeeName) {
		this.txtEditEmployeeName = txtEditEmployeeName;
	}
	
	/**
	 * @return pltEditWorkPlace
	 */
	public String getPltEditWorkPlace() {
		return pltEditWorkPlace;
	}
	
	/**
	 * @param pltEditWorkPlace セットする pltEditWorkPlace
	 */
	public void setPltEditWorkPlace(String pltEditWorkPlace) {
		this.pltEditWorkPlace = pltEditWorkPlace;
	}
	
	/**
	 * @return pltEditEmployment
	 */
	public String getPltEditEmployment() {
		return pltEditEmployment;
	}
	
	/**
	 * @param pltEditEmployment セットする pltEditEmployment
	 */
	public void setPltEditEmployment(String pltEditEmployment) {
		this.pltEditEmployment = pltEditEmployment;
	}
	
	/**
	 * @return pltEditSection
	 */
	public String getPltEditSection() {
		return pltEditSection;
	}
	
	/**
	 * @param pltEditSection セットする pltEditSection
	 */
	public void setPltEditSection(String pltEditSection) {
		this.pltEditSection = pltEditSection;
	}
	
	/**
	 * @return pltEditPosition
	 */
	public String getPltEditPosition() {
		return pltEditPosition;
	}
	
	/**
	 * @param pltEditPosition セットする pltEditPosition
	 */
	public void setPltEditPosition(String pltEditPosition) {
		this.pltEditPosition = pltEditPosition;
	}
	
	/**
	 * @return pltEditApproval
	 */
	public String getPltEditApproval() {
		return pltEditApproval;
	}
	
	/**
	 * @param pltEditApproval セットする pltEditApproval
	 */
	public void setPltEditApproval(String pltEditApproval) {
		this.pltEditApproval = pltEditApproval;
	}
	
	/**
	 * @return pltEditCalc
	 */
	public String getPltEditCalc() {
		return pltEditCalc;
	}
	
	/**
	 * @param pltEditCalc セットする pltEditCalc
	 */
	public void setPltEditCalc(String pltEditCalc) {
		this.pltEditCalc = pltEditCalc;
	}
	
	/**
	 * @param idx インデックス
	 * @return personalId
	 */
	public String getAryPersonalId(int idx) {
		return aryPersonalId[idx];
	}
	
	/**
	 * @param aryPersonalId セットする aryPersonalId
	 */
	public void setAryPersonalId(String[] aryPersonalId) {
		this.aryPersonalId = getStringArrayClone(aryPersonalId);
	}
	
	/**
	 * @return aryLblEmployeeCode
	 */
	public String[] getAryLblEmployeeCode() {
		return getStringArrayClone(aryLblEmployeeCode);
	}
	
	/**
	 * @param aryLblEmployeeCode セットする aryLblEmployeeCode
	 */
	public void setAryLblEmployeeCode(String[] aryLblEmployeeCode) {
		this.aryLblEmployeeCode = getStringArrayClone(aryLblEmployeeCode);
	}
	
	/**
	 * @return aryLblEmployeeName
	 */
	public String[] getAryLblEmployeeName() {
		return getStringArrayClone(aryLblEmployeeName);
	}
	
	/**
	 * @param aryLblEmployeeName セットする aryLblEmployeeName
	 */
	public void setAryLblEmployeeName(String[] aryLblEmployeeName) {
		this.aryLblEmployeeName = getStringArrayClone(aryLblEmployeeName);
	}
	
	/**
	 * @return aryLblSection
	 */
	public String[] getAryLblSection() {
		return getStringArrayClone(aryLblSection);
	}
	
	/**
	 * @param aryLblSection セットする aryLblSection
	 */
	public void setAryLblSection(String[] aryLblSection) {
		this.aryLblSection = getStringArrayClone(aryLblSection);
	}
	
	/**
	 * @return aryLblWorkDate
	 */
	public String[] getAryLblWorkDate() {
		return getStringArrayClone(aryLblWorkDate);
	}
	
	/**
	 * @param aryLblWorkDate セットする aryLblWorkDate
	 */
	public void setAryLblWorkDate(String[] aryLblWorkDate) {
		this.aryLblWorkDate = getStringArrayClone(aryLblWorkDate);
	}
	
	/**
	 * @return aryLblWorkTime
	 */
	public String[] getAryLblWorkTime() {
		return getStringArrayClone(aryLblWorkTime);
	}
	
	/**
	 * @param aryLblWorkTime セットする aryLblWorkTime
	 */
	public void setAryLblWorkTime(String[] aryLblWorkTime) {
		this.aryLblWorkTime = getStringArrayClone(aryLblWorkTime);
	}
	
	/**
	 * @return aryLblRestTime
	 */
	public String[] getAryLblRestTime() {
		return getStringArrayClone(aryLblRestTime);
	}
	
	/**
	 * @param aryLblRestTime セットする aryLblRestTime
	 */
	public void setAryLblRestTime(String[] aryLblRestTime) {
		this.aryLblRestTime = getStringArrayClone(aryLblRestTime);
	}
	
	/**
	 * @return aryLblLateTime
	 */
	public String[] getAryLblLateTime() {
		return getStringArrayClone(aryLblLateTime);
	}
	
	/**
	 * @param aryLblLateTime セットする aryLblLateTime
	 */
	public void setAryLblLateTime(String[] aryLblLateTime) {
		this.aryLblLateTime = getStringArrayClone(aryLblLateTime);
	}
	
	/**
	 * @return aryLblLeaveEarlyTime
	 */
	public String[] getAryLblLeaveEarlyTime() {
		return getStringArrayClone(aryLblLeaveEarlyTime);
	}
	
	/**
	 * @param aryLblLeaveEarlyTime セットする aryLblLeaveEarlyTime
	 */
	public void setAryLblLeaveEarlyTime(String[] aryLblLeaveEarlyTime) {
		this.aryLblLeaveEarlyTime = getStringArrayClone(aryLblLeaveEarlyTime);
	}
	
	/**
	 * @return aryLblOverTimeIn
	 */
	public String[] getAryLblOverTimeIn() {
		return getStringArrayClone(aryLblOverTimeIn);
	}
	
	/**
	 * @param aryLblOverTimeIn セットする aryLblOverTimeIn
	 */
	public void setAryLblOverTimeIn(String[] aryLblOverTimeIn) {
		this.aryLblOverTimeIn = getStringArrayClone(aryLblOverTimeIn);
	}
	
	/**
	 * @return aryLblOverTimeOut
	 */
	public String[] getAryLblOverTimeOut() {
		return getStringArrayClone(aryLblOverTimeOut);
	}
	
	/**
	 * @param aryLblOverTimeOut セットする aryLblOverTimeOut
	 */
	public void setAryLblOverTimeOut(String[] aryLblOverTimeOut) {
		this.aryLblOverTimeOut = getStringArrayClone(aryLblOverTimeOut);
	}
	
	/**
	 * @return aryLblWorkOnHolidayTime
	 */
	public String[] getAryLblWorkOnHolidayTime() {
		return getStringArrayClone(aryLblWorkOnHolidayTime);
	}
	
	/**
	 * @param aryLblWorkOnHolidayTime セットする aryLblWorkOnHolidayTime
	 */
	public void setAryLblWorkOnHolidayTime(String[] aryLblWorkOnHolidayTime) {
		this.aryLblWorkOnHolidayTime = getStringArrayClone(aryLblWorkOnHolidayTime);
	}
	
	/**
	 * @return aryLblLateNightTime
	 */
	public String[] getAryLblLateNightTime() {
		return getStringArrayClone(aryLblLateNightTime);
	}
	
	/**
	 * @param aryLblLateNightTime セットする aryLblLateNightTime
	 */
	public void setAryLblLateNightTime(String[] aryLblLateNightTime) {
		this.aryLblLateNightTime = getStringArrayClone(aryLblLateNightTime);
	}
	
	/**
	 * @return aryLblApploval
	 */
	public String[] getAryLblApploval() {
		return getStringArrayClone(aryLblApploval);
	}
	
	/**
	 * @param aryLblApploval セットする aryLblApploval
	 */
	public void setAryLblApploval(String[] aryLblApploval) {
		this.aryLblApploval = getStringArrayClone(aryLblApploval);
	}
	
	/**
	 * @return aryLblCalc
	 */
	public String[] getAryLblCalc() {
		return getStringArrayClone(aryLblCalc);
	}
	
	/**
	 * @param aryLblCalc セットする aryLblCalc
	 */
	public void setAryLblCalc(String[] aryLblCalc) {
		this.aryLblCalc = getStringArrayClone(aryLblCalc);
	}
	
	/**
	 * @return aryPltEditWorkPlace
	 */
	public String[][] getAryPltEditWorkPlace() {
		return getStringArrayClone(aryPltEditWorkPlace);
	}
	
	/**
	 * @param aryPltEditWorkPlace セットする aryPltEditWorkPlace
	 */
	public void setAryPltEditWorkPlace(String[][] aryPltEditWorkPlace) {
		this.aryPltEditWorkPlace = getStringArrayClone(aryPltEditWorkPlace);
	}
	
	/**
	 * @return aryPltEditEmployment
	 */
	public String[][] getAryPltEditEmployment() {
		return getStringArrayClone(aryPltEditEmployment);
	}
	
	/**
	 * @param aryPltEditEmployment セットする aryPltEditEmployment
	 */
	public void setAryPltEditEmployment(String[][] aryPltEditEmployment) {
		this.aryPltEditEmployment = getStringArrayClone(aryPltEditEmployment);
	}
	
	/**
	 * @return aryPltEditSection
	 */
	public String[][] getAryPltEditSection() {
		return getStringArrayClone(aryPltEditSection);
	}
	
	/**
	 * @param aryPltEditSection セットする aryPltEditSection
	 */
	public void setAryPltEditSection(String[][] aryPltEditSection) {
		this.aryPltEditSection = getStringArrayClone(aryPltEditSection);
	}
	
	/**
	 * @return aryPltEditPosition
	 */
	public String[][] getAryPltEditPosition() {
		return getStringArrayClone(aryPltEditPosition);
	}
	
	/**
	 * @param aryPltEditPosition セットする aryPltEditPosition
	 */
	public void setAryPltEditPosition(String[][] aryPltEditPosition) {
		this.aryPltEditPosition = getStringArrayClone(aryPltEditPosition);
	}
	
	/**
	 * @return aryPltEditApproval
	 */
	public String[][] getAryPltEditApproval() {
		return getStringArrayClone(aryPltEditApproval);
	}
	
	/**
	 * @param aryPltEditApproval セットする aryPltEditApproval
	 */
	public void setAryPltEditApproval(String[][] aryPltEditApproval) {
		this.aryPltEditApproval = getStringArrayClone(aryPltEditApproval);
	}
	
	/**
	 * @return aryPltEditCalc
	 */
	public String[][] getAryPltEditCalc() {
		return getStringArrayClone(aryPltEditCalc);
	}
	
	/**
	 * @param aryPltEditCalc セットする aryPltEditCalc
	 */
	public void setAryPltEditCalc(String[][] aryPltEditCalc) {
		this.aryPltEditCalc = getStringArrayClone(aryPltEditCalc);
	}
	
	/**
	 * @return aryLblPaidHoliday
	 */
	public String[] getAryLblPaidHoliday() {
		return getStringArrayClone(aryLblPaidHoliday);
	}
	
	/**
	 * @return aryLblAllHoliday
	 */
	public String[] getAryLblAllHoliday() {
		return getStringArrayClone(aryLblAllHoliday);
	}
	
	/**
	 * @return aryLblAbsence
	 */
	public String[] getAryLblAbsence() {
		return getStringArrayClone(aryLblAbsence);
	}
	
	/**
	 * @return aryLblCorrection
	 */
	public String[] getAryLblCorrection() {
		return getStringArrayClone(aryLblCorrection);
	}
	
	/**
	 * @param aryLblPaidHoliday セットする aryLblPaidHoliday
	 */
	public void setAryLblPaidHoliday(String[] aryLblPaidHoliday) {
		this.aryLblPaidHoliday = getStringArrayClone(aryLblPaidHoliday);
	}
	
	/**
	 * @param aryLblAllHoliday セットする aryLblAllHoliday
	 */
	public void setAryLblAllHoliday(String[] aryLblAllHoliday) {
		this.aryLblAllHoliday = getStringArrayClone(aryLblAllHoliday);
	}
	
	/**
	 * @param aryLblAbsence セットする aryLblAbsence
	 */
	public void setAryLblAbsence(String[] aryLblAbsence) {
		this.aryLblAbsence = getStringArrayClone(aryLblAbsence);
	}
	
	/**
	 * @param aryLblCorrection セットする aryLblCorrection
	 */
	public void setAryLblCorrection(String[] aryLblCorrection) {
		this.aryLblCorrection = getStringArrayClone(aryLblCorrection);
	}
	
	/**
	 * @return claApploval
	 */
	public String[] getClaApploval() {
		return getStringArrayClone(claApploval);
	}
	
	/**
	 * @return claCalc
	 */
	public String[] getClaCalc() {
		return getStringArrayClone(claCalc);
	}
	
	/**
	 * @param claApploval セットする claApploval
	 */
	public void setClaApploval(String[] claApploval) {
		this.claApploval = getStringArrayClone(claApploval);
	}
	
	/**
	 * @param claCalc セットする claCalc
	 */
	public void setClaCalc(String[] claCalc) {
		this.claCalc = getStringArrayClone(claCalc);
	}
	
	/**
	 * @return searchDate
	 */
	public Date getSearchDate() {
		return getDateClone(searchDate);
	}
	
	/**
	 * @param searchDate セットする searchDate
	 */
	public void setSearchDate(Date searchDate) {
		this.searchDate = getDateClone(searchDate);
	}
	
	/**
	 * @return cutoffCode
	 */
	public String getCutoffCode() {
		return cutoffCode;
	}
	
	/**
	 * @param cutoffCode セットする cutoffCode
	 */
	public void setCutoffCode(String cutoffCode) {
		this.cutoffCode = cutoffCode;
	}
	
	/**
	 * @return aryDetailOnOff
	 */
	public String[] getAryDetailOnOff() {
		return getStringArrayClone(aryDetailOnOff);
	}
	
	/**
	 * @param aryDetailOnOff セットする aryDetailOnOff
	 */
	public void setAryDetailOnOff(String[] aryDetailOnOff) {
		this.aryDetailOnOff = getStringArrayClone(aryDetailOnOff);
	}
	
	/**
	 * @return jsCutoffState
	 */
	public String getJsCutoffState() {
		return jsCutoffState;
	}
	
	/**
	 * @param jsCutoffState セットする jsCutoffState
	 */
	public void setJsCutoffState(String jsCutoffState) {
		this.jsCutoffState = jsCutoffState;
	}
	
	/**
	 * @param cutoffDate セットする cutoffDate
	 */
	public void setCutoffDate(Date cutoffDate) {
		this.cutoffDate = cutoffDate;
	}
	
	/**
	 * @return cutoffDate
	 */
	public Date getCutoffDate() {
		return cutoffDate;
	}
	
}
