/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.calculation.vo;

import java.util.Date;

import jp.mosp.time.base.TimeVo;

/**
 * 勤怠修正の情報を格納する。
 */
public class TotalTimeCardVo extends TimeVo {
	
	private static final long	serialVersionUID	= 2948705885220041246L;
	
	private String				lblMonth;
	private String				lblCorrectionHistory;
	private String				txtCorrectionReason;
	
	private String				txtWorkTimeHour;
	private String				txtWorkTimeMinute;
	private String				txtSpecificWorkTimeHour;
	private String				txtSpecificWorkTimeMinute;
	private String				txtTimesWorkDate;
	private String				txtTimesWork;
	private String				txtLegalWorkOnHoliday;
	private String				txtSpecificWorkOnHoliday;
	
	private String				txtRestTimeHour;
	private String				txtRestTimeMinute;
	private String				txtOverRestTimeHour;
	private String				txtOverRestTimeMinute;
	private String				txtRestLateNightHour;
	private String				txtRestLateNightMinute;
	private String				txtRestWorkOnSpecificHour;
	private String				txtRestWorkOnSpecificMinute;
	private String				txtRestWorkOnLegalHour;
	private String				txtRestWorkOnLegalMinute;
	private String				txtPrivateHour;
	private String				txtPrivateMinute;
	private String				txtPublicHour;
	private String				txtPublicMinute;
	
	private String				txtOverTimeInHour;
	private String				txtOverTimeInMinute;
	private String				txtOverTimeOutHour;
	private String				txtOverTimeOutMinute;
	private String				txtLateNightHour;
	private String				txtLateNightMinute;
	private String				txtWorkSpecificOnHolidayHour;
	private String				txtWorkSpecificOnHolidayMinute;
	private String				txtWorkOnHolidayHour;
	private String				txtWorkOnHolidayMinute;
	private String				txt45HourOverTimeHour;
	private String				txt45HourOverTimeMinute;
	private String				txtDecreaseTimeHour;
	private String				txtDecreaseTimeMinute;
	
	private String				txtTimesLate;
	private String				txtLateDeduction;
	private String				txtLateNoDeduction;
	private String				txtLateOther;
	private String				txtLateTimeHour;
	private String				txtLateTimeMinute;
	private String				txtLateDeductionHour;
	private String				txtLateDeductionMinute;
	private String				txtLateNoDeductionHour;
	private String				txtLateNoDeductionMinute;
	private String				txtLateOtherHour;
	private String				txtLateOtherMinute;
	private String				txtTimesLeaveEarly;
	private String				txtLeaveEarlyDeduction;
	private String				txtLeaveEarlyNoDeduction;
	private String				txtLeaveEarlyOther;
	private String				txtLeaveEarlyTimeHour;
	private String				txtLeaveEarlyTimeMinute;
	private String				txtLeaveEarlyDeductionHour;
	private String				txtLeaveEarlyDeductionMinute;
	private String				txtLeaveEarlyNoDeductionHour;
	private String				txtLeaveEarlyNoDeductionMinute;
	private String				txtLeaveEarlyOtherHour;
	private String				txtLeaveEarlyOtherMinute;
	
	private String				txtTimesHoliday;
	private String				txtTimesLegalHoliday;
	private String				txtTimesSpecificHoliday;
	private String				txtTimesSubstitute;
	private String				txtTimesPaidHoliday;
	private String				txtPaidholidayHour;
	private String				txtTimesStockHoliday;
	private String				txtTimesCompensation;
	private String				txtTimesLegalCompensation;
	private String				txtTimesSpecificCompensation;
	private String				txtTimesLateCompensation;
	private String				txtTimesSpecificHolidaySubstitute;
	
	private String				txtTimesSpecialLeave1;
	private String				txtTimesSpecialLeave2;
	private String				txtTimesSpecialLeave3;
	private String				txtTimesSpecialLeave4;
	private String				txtTimesSpecialLeave5;
	private String				txtTimesSpecialLeave6;
	private String				txtTimesSpecialLeave7;
	private String				txtTimesSpecialLeave8;
	private String				txtTimesSpecialLeave9;
	private String				txtTimesSpecialLeave10;
	private String				txtTimesSpecialLeave11;
	private String				txtTimesSpecialLeave12;
	private String				txtTimesSpecialLeave13;
	private String				txtTimesSpecialLeave14;
	private String				txtTimesSpecialLeave15;
	private String				txtTimesSpecialLeave16;
	private String				txtTimesSpecialLeave17;
	private String				txtTimesSpecialLeave18;
	private String				txtTimesSpecialLeave19;
	private String				txtTimesSpecialLeave20;
	private String				txtTimesSpecialLeave21;
	private String				txtTimesSpecialLeave22;
	private String				txtTimesSpecialLeave23;
	private String				txtTimesSpecialLeave24;
	private String				txtTimesSpecialLeave25;
	private String				txtTimesSpecialLeave26;
	private String				txtTimesSpecialLeave27;
	private String				txtTimesSpecialLeave28;
	private String				txtTimesSpecialLeave29;
	private String				txtTimesSpecialLeave30;
	private String[]			aryTxtTimesSpecialLeave;
	private String[]			aryTxtTimesSpecialLeaveTitle;
	private String[]			aryTxtTimesSpecialLeaveCode;
	private long[]				aryTimesSpecialLeaveId;
	private String				txtTotalSpecialHoliday;
	
	private String				txtTimesOtherVacation1;
	private String				txtTimesOtherVacation2;
	private String				txtTimesOtherVacation3;
	private String				txtTimesOtherVacation4;
	private String				txtTimesOtherVacation5;
	private String				txtTimesOtherVacation6;
	private String				txtTimesOtherVacation7;
	private String				txtTimesOtherVacation8;
	private String				txtTimesOtherVacation9;
	private String				txtTimesOtherVacation10;
	private String				txtTimesOtherVacation11;
	private String				txtTimesOtherVacation12;
	private String				txtTimesOtherVacation13;
	private String				txtTimesOtherVacation14;
	private String				txtTimesOtherVacation15;
	private String				txtTimesOtherVacation16;
	private String				txtTimesOtherVacation17;
	private String				txtTimesOtherVacation18;
	private String				txtTimesOtherVacation19;
	private String				txtTimesOtherVacation20;
	private String				txtTimesOtherVacation21;
	private String				txtTimesOtherVacation22;
	private String				txtTimesOtherVacation23;
	private String				txtTimesOtherVacation24;
	private String				txtTimesOtherVacation25;
	private String				txtTimesOtherVacation26;
	private String				txtTimesOtherVacation27;
	private String				txtTimesOtherVacation28;
	private String				txtTimesOtherVacation29;
	private String				txtTimesOtherVacation30;
	private String[]			aryTxtTimesOtherVacation;
	private String[]			aryTxtTimesOtherVacationTitle;
	private String[]			aryTxtTimesOtherVacationCode;
	private long[]				aryTimesOtherVacationId;
	private String				txtTotalOtherHoliday;
	
	private String				txtDeduction1;
	private String				txtDeduction2;
	private String				txtDeduction3;
	private String				txtDeduction4;
	private String				txtDeduction5;
	private String				txtDeduction6;
	private String				txtDeduction7;
	private String				txtDeduction8;
	private String				txtDeduction9;
	private String				txtDeduction10;
	private String				txtDeduction11;
	private String				txtDeduction12;
	private String				txtDeduction13;
	private String				txtDeduction14;
	private String				txtDeduction15;
	private String				txtDeduction16;
	private String				txtDeduction17;
	private String				txtDeduction18;
	private String				txtDeduction19;
	private String				txtDeduction20;
	private String[]			aryTxtDeduction;
	private String[]			aryTxtDeductionTitle;
	private String[]			aryTxtDeductionCode;
	private long[]				aryDeductionId;
	private String				txtTotalDeduction;
	
	private String				txtTimesAllowance1;
	private String				txtTimesAllowance2;
	private String				txtTimesAllowance3;
	private String				txtTimesAllowance4;
	private String				txtTimesAllowance5;
	private String				txtTimesAllowance6;
	private String				txtTimesAllowance7;
	private String				txtTimesAllowance8;
	private String				txtTimesAllowance9;
	private String				txtTimesAllowance10;
	private String				txtTotalAllowance;
	
	private String				txt60HourOverTimeHour;
	private String				txt60HourOverTimeMinute;
	private String				txtWeekDayOverTimeHour;
	private String				txtWeekDayOverTimeMinute;
	private String				txtSpecificOverTimeHour;
	private String				txtSpecificOverTimeMiunte;
	private String				txtTimesAlternative;
	
	private String				lblEmployeeCode;
	private String				lblEmployeeName;
	private String				lblSection;
	
	private String				txtRestWorkOnOverHour;
	private String				txtRestWorkOnOverMinute;
	private String				txtWorkOnOverHour;
	private String				txtWorkOnOverMinute;
	private String				txtTimesLegalHolidaySubstitute;
	
	private String				editEmployeeCode;
	private Date				editDate;
	
	private long				tmdTotalTimeId;
	private long				tmdAllowanceId;
	private long				tmdOvertimeRequestId;
	
	private String				txtTimesAchievement;
	private String				txtTimesTotalWorkDate;
	private String				txtTimesOvertime;
	private String				txtTimesWorkingHoliday;
	

	/**
	 * @return txtCorrectionReason
	 */
	public String getTxtCorrectionReason() {
		return txtCorrectionReason;
	}
	
	/**
	 * @param txtCorrectionReason セットする txtCorrectionReason
	 */
	public void setTxtCorrectionReason(String txtCorrectionReason) {
		this.txtCorrectionReason = txtCorrectionReason;
	}
	
	/**
	 * @return txtWorkTimeHour
	 */
	public String getTxtWorkTimeHour() {
		return txtWorkTimeHour;
	}
	
	/**
	 * @param txtWorkTimeHour セットする txtWorkTimeHour
	 */
	public void setTxtWorkTimeHour(String txtWorkTimeHour) {
		this.txtWorkTimeHour = txtWorkTimeHour;
	}
	
	/**
	 * @return txtWorkTimeMinute
	 */
	public String getTxtWorkTimeMinute() {
		return txtWorkTimeMinute;
	}
	
	/**
	 * @param txtWorkTimeMinute セットする txtWorkTimeMinute
	 */
	public void setTxtWorkTimeMinute(String txtWorkTimeMinute) {
		this.txtWorkTimeMinute = txtWorkTimeMinute;
	}
	
	/**
	 * @return txtSpecificWorkTimeHour
	 */
	public String getTxtSpecificWorkTimeHour() {
		return txtSpecificWorkTimeHour;
	}
	
	/**
	 * @param txtSpecificWorkTimeHour セットする txtSpecificWorkTimeHour
	 */
	public void setTxtSpecificWorkTimeHour(String txtSpecificWorkTimeHour) {
		this.txtSpecificWorkTimeHour = txtSpecificWorkTimeHour;
	}
	
	/**
	 * @return txtSpecificWorkTimeMinute
	 */
	public String getTxtSpecificWorkTimeMinute() {
		return txtSpecificWorkTimeMinute;
	}
	
	/**
	 * @param txtSpecificWorkTimeMinute セットする txtSpecificWorkTimeMinute
	 */
	public void setTxtSpecificWorkTimeMinute(String txtSpecificWorkTimeMinute) {
		this.txtSpecificWorkTimeMinute = txtSpecificWorkTimeMinute;
	}
	
	/**
	 * @return txtTimesWorkDate
	 */
	public String getTxtTimesWorkDate() {
		return txtTimesWorkDate;
	}
	
	/**
	 * @param txtTimesWorkDate セットする txtTimesWorkDate
	 */
	public void setTxtTimesWorkDate(String txtTimesWorkDate) {
		this.txtTimesWorkDate = txtTimesWorkDate;
	}
	
	/**
	 * @return txtTimesWork
	 */
	public String getTxtTimesWork() {
		return txtTimesWork;
	}
	
	/**
	 * @param txtTimesWork セットする txtTimesWork
	 */
	public void setTxtTimesWork(String txtTimesWork) {
		this.txtTimesWork = txtTimesWork;
	}
	
	/**
	 * @return txtLegalWorkOnHoliday
	 */
	public String getTxtLegalWorkOnHoliday() {
		return txtLegalWorkOnHoliday;
	}
	
	/**
	 * @param txtLegalWorkOnHoliday セットする txtLegalWorkOnHoliday
	 */
	public void setTxtLegalWorkOnHoliday(String txtLegalWorkOnHoliday) {
		this.txtLegalWorkOnHoliday = txtLegalWorkOnHoliday;
	}
	
	/**
	 * @return txtSpecificWorkOnHoliday
	 */
	public String getTxtSpecificWorkOnHoliday() {
		return txtSpecificWorkOnHoliday;
	}
	
	/**
	 * @param txtSpecificWorkOnHoliday セットする txtSpecificWorkOnHoliday
	 */
	public void setTxtSpecificWorkOnHoliday(String txtSpecificWorkOnHoliday) {
		this.txtSpecificWorkOnHoliday = txtSpecificWorkOnHoliday;
	}
	
	/**
	 * @return txtRestTimeHour
	 */
	public String getTxtRestTimeHour() {
		return txtRestTimeHour;
	}
	
	/**
	 * @param txtRestTimeHour セットする txtRestTimeHour
	 */
	public void setTxtRestTimeHour(String txtRestTimeHour) {
		this.txtRestTimeHour = txtRestTimeHour;
	}
	
	/**
	 * @return txtRestTimeMinute
	 */
	public String getTxtRestTimeMinute() {
		return txtRestTimeMinute;
	}
	
	/**
	 * @param txtRestTimeMinute セットする txtRestTimeMinute
	 */
	public void setTxtRestTimeMinute(String txtRestTimeMinute) {
		this.txtRestTimeMinute = txtRestTimeMinute;
	}
	
	/**
	 * @return txtOverRestTimeHour
	 */
	public String getTxtOverRestTimeHour() {
		return txtOverRestTimeHour;
	}
	
	/**
	 * @param txtOverRestTimeHour セットする txtOverRestTimeHour
	 */
	public void setTxtOverRestTimeHour(String txtOverRestTimeHour) {
		this.txtOverRestTimeHour = txtOverRestTimeHour;
	}
	
	/**
	 * @return txtOverRestTimeMinute
	 */
	public String getTxtOverRestTimeMinute() {
		return txtOverRestTimeMinute;
	}
	
	/**
	 * @param txtOverRestTimeMinute セットする txtOverRestTimeMinute
	 */
	public void setTxtOverRestTimeMinute(String txtOverRestTimeMinute) {
		this.txtOverRestTimeMinute = txtOverRestTimeMinute;
	}
	
	/**
	 * @return txtRestLateNightHour
	 */
	public String getTxtRestLateNightHour() {
		return txtRestLateNightHour;
	}
	
	/**
	 * @param txtRestLateNightHour セットする txtRestLateNightHour
	 */
	public void setTxtRestLateNightHour(String txtRestLateNightHour) {
		this.txtRestLateNightHour = txtRestLateNightHour;
	}
	
	/**
	 * @return txtRestLateNightMinute
	 */
	public String getTxtRestLateNightMinute() {
		return txtRestLateNightMinute;
	}
	
	/**
	 * @param txtRestLateNightMinute セットする txtRestLateNightMinute
	 */
	public void setTxtRestLateNightMinute(String txtRestLateNightMinute) {
		this.txtRestLateNightMinute = txtRestLateNightMinute;
	}
	
	/**
	 * @return txtRestWorkOnSpecificHour
	 */
	public String getTxtRestWorkOnSpecificHour() {
		return txtRestWorkOnSpecificHour;
	}
	
	/**
	 * @param txtRestWorkOnSpecificHour セットする txtRestWorkOnSpecificHour
	 */
	public void setTxtRestWorkOnSpecificHour(String txtRestWorkOnSpecificHour) {
		this.txtRestWorkOnSpecificHour = txtRestWorkOnSpecificHour;
	}
	
	/**
	 * @return txtRestWorkOnSpecificMinute
	 */
	public String getTxtRestWorkOnSpecificMinute() {
		return txtRestWorkOnSpecificMinute;
	}
	
	/**
	 * @param txtRestWorkOnSpecificMinute セットする txtRestWorkOnSpecificMinute
	 */
	public void setTxtRestWorkOnSpecificMinute(String txtRestWorkOnSpecificMinute) {
		this.txtRestWorkOnSpecificMinute = txtRestWorkOnSpecificMinute;
	}
	
	/**
	 * @return txtRestWorkOnLegalHour
	 */
	public String getTxtRestWorkOnLegalHour() {
		return txtRestWorkOnLegalHour;
	}
	
	/**
	 * @param txtRestWorkOnLegalHour セットする txtRestWorkOnLegalHour
	 */
	public void setTxtRestWorkOnLegalHour(String txtRestWorkOnLegalHour) {
		this.txtRestWorkOnLegalHour = txtRestWorkOnLegalHour;
	}
	
	/**
	 * @return txtRestWorkOnLegalMinute
	 */
	public String getTxtRestWorkOnLegalMinute() {
		return txtRestWorkOnLegalMinute;
	}
	
	/**
	 * @param txtRestWorkOnLegalMinute セットする txtRestWorkOnLegalMinute
	 */
	public void setTxtRestWorkOnLegalMinute(String txtRestWorkOnLegalMinute) {
		this.txtRestWorkOnLegalMinute = txtRestWorkOnLegalMinute;
	}
	
	/**
	 * @return txtPrivateHour
	 */
	public String getTxtPrivateHour() {
		return txtPrivateHour;
	}
	
	/**
	 * @param txtPrivateHour セットする txtPrivateHour
	 */
	public void setTxtPrivateHour(String txtPrivateHour) {
		this.txtPrivateHour = txtPrivateHour;
	}
	
	/**
	 * @return txtPrivateMinute
	 */
	public String getTxtPrivateMinute() {
		return txtPrivateMinute;
	}
	
	/**
	 * @param txtPrivateMinute セットする txtPrivateMinute
	 */
	public void setTxtPrivateMinute(String txtPrivateMinute) {
		this.txtPrivateMinute = txtPrivateMinute;
	}
	
	/**
	 * @return txtPublicHour
	 */
	public String getTxtPublicHour() {
		return txtPublicHour;
	}
	
	/**
	 * @param txtPublicHour セットする txtPublicHour
	 */
	public void setTxtPublicHour(String txtPublicHour) {
		this.txtPublicHour = txtPublicHour;
	}
	
	/**
	 * @return txtPublicMinute
	 */
	public String getTxtPublicMinute() {
		return txtPublicMinute;
	}
	
	/**
	 * @param txtPublicMinute セットする txtPublicMinute
	 */
	public void setTxtPublicMinute(String txtPublicMinute) {
		this.txtPublicMinute = txtPublicMinute;
	}
	
	/**
	 * @return txtOverTimeInHour
	 */
	public String getTxtOverTimeInHour() {
		return txtOverTimeInHour;
	}
	
	/**
	 * @param txtOverTimeInHour セットする txtOverTimeInHour
	 */
	public void setTxtOverTimeInHour(String txtOverTimeInHour) {
		this.txtOverTimeInHour = txtOverTimeInHour;
	}
	
	/**
	 * @return txtOverTimeInMinute
	 */
	public String getTxtOverTimeInMinute() {
		return txtOverTimeInMinute;
	}
	
	/**
	 * @param txtOverTimeInMinute セットする txtOverTimeInMinute
	 */
	public void setTxtOverTimeInMinute(String txtOverTimeInMinute) {
		this.txtOverTimeInMinute = txtOverTimeInMinute;
	}
	
	/**
	 * @return txtOverTimeOutHour
	 */
	public String getTxtOverTimeOutHour() {
		return txtOverTimeOutHour;
	}
	
	/**
	 * @param txtOverTimeOutHour セットする txtOverTimeOutHour
	 */
	public void setTxtOverTimeOutHour(String txtOverTimeOutHour) {
		this.txtOverTimeOutHour = txtOverTimeOutHour;
	}
	
	/**
	 * @return txtOverTimeOutMinute
	 */
	public String getTxtOverTimeOutMinute() {
		return txtOverTimeOutMinute;
	}
	
	/**
	 * @param txtOverTimeOutMinute セットする txtOverTimeOutMinute
	 */
	public void setTxtOverTimeOutMinute(String txtOverTimeOutMinute) {
		this.txtOverTimeOutMinute = txtOverTimeOutMinute;
	}
	
	/**
	 * @return txtLateNightHour
	 */
	public String getTxtLateNightHour() {
		return txtLateNightHour;
	}
	
	/**
	 * @param txtLateNightHour セットする txtLateNightHour
	 */
	public void setTxtLateNightHour(String txtLateNightHour) {
		this.txtLateNightHour = txtLateNightHour;
	}
	
	/**
	 * @return txtLateNightMinute
	 */
	public String getTxtLateNightMinute() {
		return txtLateNightMinute;
	}
	
	/**
	 * @param txtLateNightMinute セットする txtLateNightMinute
	 */
	public void setTxtLateNightMinute(String txtLateNightMinute) {
		this.txtLateNightMinute = txtLateNightMinute;
	}
	
	/**
	 * @return txtWorkSpecificOnHolidayHour
	 */
	public String getTxtWorkSpecificOnHolidayHour() {
		return txtWorkSpecificOnHolidayHour;
	}
	
	/**
	 * @param txtWorkSpecificOnHolidayHour セットする txtWorkSpecificOnHolidayHour
	 */
	public void setTxtWorkSpecificOnHolidayHour(String txtWorkSpecificOnHolidayHour) {
		this.txtWorkSpecificOnHolidayHour = txtWorkSpecificOnHolidayHour;
	}
	
	/**
	 * @return txtWorkSpecificOnHolidayMinute
	 */
	public String getTxtWorkSpecificOnHolidayMinute() {
		return txtWorkSpecificOnHolidayMinute;
	}
	
	/**
	 * @param txtWorkSpecificOnHolidayMinute セットする txtWorkSpecificOnHolidayMinute
	 */
	public void setTxtWorkSpecificOnHolidayMinute(String txtWorkSpecificOnHolidayMinute) {
		this.txtWorkSpecificOnHolidayMinute = txtWorkSpecificOnHolidayMinute;
	}
	
	/**
	 * @return txtWorkOnHolidayHour
	 */
	public String getTxtWorkOnHolidayHour() {
		return txtWorkOnHolidayHour;
	}
	
	/**
	 * @param txtWorkOnHolidayHour セットする txtWorkOnHolidayHour
	 */
	public void setTxtWorkOnHolidayHour(String txtWorkOnHolidayHour) {
		this.txtWorkOnHolidayHour = txtWorkOnHolidayHour;
	}
	
	/**
	 * @return txtWorkOnHolidayMinute
	 */
	public String getTxtWorkOnHolidayMinute() {
		return txtWorkOnHolidayMinute;
	}
	
	/**
	 * @param txtWorkOnHolidayMinute セットする txtWorkOnHolidayMinute
	 */
	public void setTxtWorkOnHolidayMinute(String txtWorkOnHolidayMinute) {
		this.txtWorkOnHolidayMinute = txtWorkOnHolidayMinute;
	}
	
	/**
	 * @return txt45HourOverTimeHour
	 */
	public String getTxt45HourOverTimeHour() {
		return txt45HourOverTimeHour;
	}
	
	/**
	 * @param txt45HourOverTimeHour セットする txt45HourOverTimeHour
	 */
	public void setTxt45HourOverTimeHour(String txt45HourOverTimeHour) {
		this.txt45HourOverTimeHour = txt45HourOverTimeHour;
	}
	
	/**
	 * @return txt45HourOverTimeMinute
	 */
	public String getTxt45HourOverTimeMinute() {
		return txt45HourOverTimeMinute;
	}
	
	/**
	 * @param txt45HourOverTimeMinute セットする txt45HourOverTimeMinute
	 */
	public void setTxt45HourOverTimeMinute(String txt45HourOverTimeMinute) {
		this.txt45HourOverTimeMinute = txt45HourOverTimeMinute;
	}
	
	/**
	 * @return txtDecreaseTimeHour
	 */
	public String getTxtDecreaseTimeHour() {
		return txtDecreaseTimeHour;
	}
	
	/**
	 * @param txtDecreaseTimeHour セットする txtDecreaseTimeHour
	 */
	public void setTxtDecreaseTimeHour(String txtDecreaseTimeHour) {
		this.txtDecreaseTimeHour = txtDecreaseTimeHour;
	}
	
	/**
	 * @return txtDecreaseTimeMinute
	 */
	public String getTxtDecreaseTimeMinute() {
		return txtDecreaseTimeMinute;
	}
	
	/**
	 * @param txtDecreaseTimeMinute セットする txtDecreaseTimeMinute
	 */
	public void setTxtDecreaseTimeMinute(String txtDecreaseTimeMinute) {
		this.txtDecreaseTimeMinute = txtDecreaseTimeMinute;
	}
	
	/**
	 * @return txtTimesLate
	 */
	public String getTxtTimesLate() {
		return txtTimesLate;
	}
	
	/**
	 * @param txtTimesLate セットする txtTimesLate
	 */
	public void setTxtTimesLate(String txtTimesLate) {
		this.txtTimesLate = txtTimesLate;
	}
	
	/**
	 * @return txtLateDeduction
	 */
	public String getTxtLateDeduction() {
		return txtLateDeduction;
	}
	
	/**
	 * @param txtLateDeduction セットする txtLateDeduction
	 */
	public void setTxtLateDeduction(String txtLateDeduction) {
		this.txtLateDeduction = txtLateDeduction;
	}
	
	/**
	 * @return txtLateNoDeduction
	 */
	public String getTxtLateNoDeduction() {
		return txtLateNoDeduction;
	}
	
	/**
	 * @param txtLateNoDeduction セットする txtLateNoDeduction
	 */
	public void setTxtLateNoDeduction(String txtLateNoDeduction) {
		this.txtLateNoDeduction = txtLateNoDeduction;
	}
	
	/**
	 * @return txtLateOther
	 */
	public String getTxtLateOther() {
		return txtLateOther;
	}
	
	/**
	 * @param txtLateOther セットする txtLateOther
	 */
	public void setTxtLateOther(String txtLateOther) {
		this.txtLateOther = txtLateOther;
	}
	
	/**
	 * @return txtLateTimeHour
	 */
	public String getTxtLateTimeHour() {
		return txtLateTimeHour;
	}
	
	/**
	 * @param txtLateTimeHour セットする txtLateTimeHour
	 */
	public void setTxtLateTimeHour(String txtLateTimeHour) {
		this.txtLateTimeHour = txtLateTimeHour;
	}
	
	/**
	 * @return txtLateTimeMinute
	 */
	public String getTxtLateTimeMinute() {
		return txtLateTimeMinute;
	}
	
	/**
	 * @param txtLateTimeMinute セットする txtLateTimeMinute
	 */
	public void setTxtLateTimeMinute(String txtLateTimeMinute) {
		this.txtLateTimeMinute = txtLateTimeMinute;
	}
	
	/**
	 * @return txtLateDeductionHour
	 */
	public String getTxtLateDeductionHour() {
		return txtLateDeductionHour;
	}
	
	/**
	 * @param txtLateDeductionHour セットする txtLateDeductionHour
	 */
	public void setTxtLateDeductionHour(String txtLateDeductionHour) {
		this.txtLateDeductionHour = txtLateDeductionHour;
	}
	
	/**
	 * @return txtLateDeductionMinute
	 */
	public String getTxtLateDeductionMinute() {
		return txtLateDeductionMinute;
	}
	
	/**
	 * @param txtLateDeductionMinute セットする txtLateDeductionMinute
	 */
	public void setTxtLateDeductionMinute(String txtLateDeductionMinute) {
		this.txtLateDeductionMinute = txtLateDeductionMinute;
	}
	
	/**
	 * @return txtLateNoDeductionHour
	 */
	public String getTxtLateNoDeductionHour() {
		return txtLateNoDeductionHour;
	}
	
	/**
	 * @param txtLateNoDeductionHour セットする txtLateNoDeductionHour
	 */
	public void setTxtLateNoDeductionHour(String txtLateNoDeductionHour) {
		this.txtLateNoDeductionHour = txtLateNoDeductionHour;
	}
	
	/**
	 * @return txtLateNoDeductionMinute
	 */
	public String getTxtLateNoDeductionMinute() {
		return txtLateNoDeductionMinute;
	}
	
	/**
	 * @param txtLateNoDeductionMinute セットする txtLateNoDeductionMinute
	 */
	public void setTxtLateNoDeductionMinute(String txtLateNoDeductionMinute) {
		this.txtLateNoDeductionMinute = txtLateNoDeductionMinute;
	}
	
	/**
	 * @return txtLateOtherHour
	 */
	public String getTxtLateOtherHour() {
		return txtLateOtherHour;
	}
	
	/**
	 * @param txtLateOtherHour セットする txtLateOtherHour
	 */
	public void setTxtLateOtherHour(String txtLateOtherHour) {
		this.txtLateOtherHour = txtLateOtherHour;
	}
	
	/**
	 * @return txtLateOtherMinute
	 */
	public String getTxtLateOtherMinute() {
		return txtLateOtherMinute;
	}
	
	/**
	 * @param txtLateOtherMinute セットする txtLateOtherMinute
	 */
	public void setTxtLateOtherMinute(String txtLateOtherMinute) {
		this.txtLateOtherMinute = txtLateOtherMinute;
	}
	
	/**
	 * @return txtTimesLeaveEarly
	 */
	public String getTxtTimesLeaveEarly() {
		return txtTimesLeaveEarly;
	}
	
	/**
	 * @param txtTimesLeaveEarly セットする txtTimesLeaveEarly
	 */
	public void setTxtTimesLeaveEarly(String txtTimesLeaveEarly) {
		this.txtTimesLeaveEarly = txtTimesLeaveEarly;
	}
	
	/**
	 * @return txtLeaveEarlyDeduction
	 */
	public String getTxtLeaveEarlyDeduction() {
		return txtLeaveEarlyDeduction;
	}
	
	/**
	 * @param txtLeaveEarlyDeduction セットする txtLeaveEarlyDeduction
	 */
	public void setTxtLeaveEarlyDeduction(String txtLeaveEarlyDeduction) {
		this.txtLeaveEarlyDeduction = txtLeaveEarlyDeduction;
	}
	
	/**
	 * @return txtLeaveEarlyNoDeduction
	 */
	public String getTxtLeaveEarlyNoDeduction() {
		return txtLeaveEarlyNoDeduction;
	}
	
	/**
	 * @param txtLeaveEarlyNoDeduction セットする txtLeaveEarlyNoDeduction
	 */
	public void setTxtLeaveEarlyNoDeduction(String txtLeaveEarlyNoDeduction) {
		this.txtLeaveEarlyNoDeduction = txtLeaveEarlyNoDeduction;
	}
	
	/**
	 * @return txtLeaveEarlyOther
	 */
	public String getTxtLeaveEarlyOther() {
		return txtLeaveEarlyOther;
	}
	
	/**
	 * @param txtLeaveEarlyOther セットする txtLeaveEarlyOther
	 */
	public void setTxtLeaveEarlyOther(String txtLeaveEarlyOther) {
		this.txtLeaveEarlyOther = txtLeaveEarlyOther;
	}
	
	/**
	 * @return txtLeaveEarlyTimeHour
	 */
	public String getTxtLeaveEarlyTimeHour() {
		return txtLeaveEarlyTimeHour;
	}
	
	/**
	 * @param txtLeaveEarlyTimeHour セットする txtLeaveEarlyTimeHour
	 */
	public void setTxtLeaveEarlyTimeHour(String txtLeaveEarlyTimeHour) {
		this.txtLeaveEarlyTimeHour = txtLeaveEarlyTimeHour;
	}
	
	/**
	 * @return txtLeaveEarlyTimeMinute
	 */
	public String getTxtLeaveEarlyTimeMinute() {
		return txtLeaveEarlyTimeMinute;
	}
	
	/**
	 * @param txtLeaveEarlyTimeMinute セットする txtLeaveEarlyTimeMinute
	 */
	public void setTxtLeaveEarlyTimeMinute(String txtLeaveEarlyTimeMinute) {
		this.txtLeaveEarlyTimeMinute = txtLeaveEarlyTimeMinute;
	}
	
	/**
	 * @return txtLeaveEarlyDeductionHour
	 */
	public String getTxtLeaveEarlyDeductionHour() {
		return txtLeaveEarlyDeductionHour;
	}
	
	/**
	 * @param txtLeaveEarlyDeductionHour セットする txtLeaveEarlyDeductionHour
	 */
	public void setTxtLeaveEarlyDeductionHour(String txtLeaveEarlyDeductionHour) {
		this.txtLeaveEarlyDeductionHour = txtLeaveEarlyDeductionHour;
	}
	
	/**
	 * @return txtLeaveEarlyDeductionMinute
	 */
	public String getTxtLeaveEarlyDeductionMinute() {
		return txtLeaveEarlyDeductionMinute;
	}
	
	/**
	 * @param txtLeaveEarlyDeductionMinute セットする txtLeaveEarlyDeductionMinute
	 */
	public void setTxtLeaveEarlyDeductionMinute(String txtLeaveEarlyDeductionMinute) {
		this.txtLeaveEarlyDeductionMinute = txtLeaveEarlyDeductionMinute;
	}
	
	/**
	 * @return txtLeaveEarlyNoDeductionHour
	 */
	public String getTxtLeaveEarlyNoDeductionHour() {
		return txtLeaveEarlyNoDeductionHour;
	}
	
	/**
	 * @param txtLeaveEarlyNoDeductionHour セットする txtLeaveEarlyNoDeductionHour
	 */
	public void setTxtLeaveEarlyNoDeductionHour(String txtLeaveEarlyNoDeductionHour) {
		this.txtLeaveEarlyNoDeductionHour = txtLeaveEarlyNoDeductionHour;
	}
	
	/**
	 * @return txtLeaveEarlyNoDeductionMinute
	 */
	public String getTxtLeaveEarlyNoDeductionMinute() {
		return txtLeaveEarlyNoDeductionMinute;
	}
	
	/**
	 * @param txtLeaveEarlyNoDeductionMinute セットする txtLeaveEarlyNoDeductionMinute
	 */
	public void setTxtLeaveEarlyNoDeductionMinute(String txtLeaveEarlyNoDeductionMinute) {
		this.txtLeaveEarlyNoDeductionMinute = txtLeaveEarlyNoDeductionMinute;
	}
	
	/**
	 * @return txtLeaveEarlyOtherHour
	 */
	public String getTxtLeaveEarlyOtherHour() {
		return txtLeaveEarlyOtherHour;
	}
	
	/**
	 * @param txtLeaveEarlyOtherHour セットする txtLeaveEarlyOtherHour
	 */
	public void setTxtLeaveEarlyOtherHour(String txtLeaveEarlyOtherHour) {
		this.txtLeaveEarlyOtherHour = txtLeaveEarlyOtherHour;
	}
	
	/**
	 * @return txtLeaveEarlyOtherMinute
	 */
	public String getTxtLeaveEarlyOtherMinute() {
		return txtLeaveEarlyOtherMinute;
	}
	
	/**
	 * @param txtLeaveEarlyOtherMinute セットする txtLeaveEarlyOtherMinute
	 */
	public void setTxtLeaveEarlyOtherMinute(String txtLeaveEarlyOtherMinute) {
		this.txtLeaveEarlyOtherMinute = txtLeaveEarlyOtherMinute;
	}
	
	/**
	 * @return txtTimesHoliday
	 */
	public String getTxtTimesHoliday() {
		return txtTimesHoliday;
	}
	
	/**
	 * @param txtTimesHoliday セットする txtTimesHoliday
	 */
	public void setTxtTimesHoliday(String txtTimesHoliday) {
		this.txtTimesHoliday = txtTimesHoliday;
	}
	
	/**
	 * @return txtTimesLegalHoliday
	 */
	public String getTxtTimesLegalHoliday() {
		return txtTimesLegalHoliday;
	}
	
	/**
	 * @param txtTimesLegalHoliday セットする txtTimesLegalHoliday
	 */
	public void setTxtTimesLegalHoliday(String txtTimesLegalHoliday) {
		this.txtTimesLegalHoliday = txtTimesLegalHoliday;
	}
	
	/**
	 * @return txtTimesSpecificHoliday
	 */
	public String getTxtTimesSpecificHoliday() {
		return txtTimesSpecificHoliday;
	}
	
	/**
	 * @param txtTimesSpecificHoliday セットする txtTimesSpecificHoliday
	 */
	public void setTxtTimesSpecificHoliday(String txtTimesSpecificHoliday) {
		this.txtTimesSpecificHoliday = txtTimesSpecificHoliday;
	}
	
	/**
	 * @return txtTimesSubstitute
	 */
	public String getTxtTimesSubstitute() {
		return txtTimesSubstitute;
	}
	
	/**
	 * @param txtTimesSubstitute セットする txtTimesSubstitute
	 */
	public void setTxtTimesSubstitute(String txtTimesSubstitute) {
		this.txtTimesSubstitute = txtTimesSubstitute;
	}
	
	/**
	 * @return txtTimesPaidHoliday
	 */
	public String getTxtTimesPaidHoliday() {
		return txtTimesPaidHoliday;
	}
	
	/**
	 * @param txtTimesPaidHoliday セットする txtTimesPaidHoliday
	 */
	public void setTxtTimesPaidHoliday(String txtTimesPaidHoliday) {
		this.txtTimesPaidHoliday = txtTimesPaidHoliday;
	}
	
	/**
	 * @return txtPaidholidayHour
	 */
	public String getTxtPaidholidayHour() {
		return txtPaidholidayHour;
	}
	
	/**
	 * @param txtPaidholidayHour セットする txtPaidholidayHour
	 */
	public void setTxtPaidholidayHour(String txtPaidholidayHour) {
		this.txtPaidholidayHour = txtPaidholidayHour;
	}
	
	/**
	 * @return txtTimesStockHoliday
	 */
	public String getTxtTimesStockHoliday() {
		return txtTimesStockHoliday;
	}
	
	/**
	 * @param txtTimesStockHoliday セットする txtTimesStockHoliday
	 */
	public void setTxtTimesStockHoliday(String txtTimesStockHoliday) {
		this.txtTimesStockHoliday = txtTimesStockHoliday;
	}
	
	/**
	 * @return txtTimesCompensation
	 */
	public String getTxtTimesCompensation() {
		return txtTimesCompensation;
	}
	
	/**
	 * @param txtTimesCompensation セットする txtTimesCompensation
	 */
	public void setTxtTimesCompensation(String txtTimesCompensation) {
		this.txtTimesCompensation = txtTimesCompensation;
	}
	
	/**
	 * @return txtTimesLegalCompensation
	 */
	public String getTxtTimesLegalCompensation() {
		return txtTimesLegalCompensation;
	}
	
	/**
	 * @param txtTimesLegalCompensation セットする txtTimesLegalCompensation
	 */
	public void setTxtTimesLegalCompensation(String txtTimesLegalCompensation) {
		this.txtTimesLegalCompensation = txtTimesLegalCompensation;
	}
	
	/**
	 * @return txtTimesSpecificCompensation
	 */
	public String getTxtTimesSpecificCompensation() {
		return txtTimesSpecificCompensation;
	}
	
	/**
	 * @param txtTimesSpecificCompensation セットする txtTimesSpecificCompensation
	 */
	public void setTxtTimesSpecificCompensation(String txtTimesSpecificCompensation) {
		this.txtTimesSpecificCompensation = txtTimesSpecificCompensation;
	}
	
	/**
	 * @return txtTimesLateCompensation
	 */
	public String getTxtTimesLateCompensation() {
		return txtTimesLateCompensation;
	}
	
	/**
	 * @param txtTimesLateCompensation セットする txtTimesLateCompensation
	 */
	public void setTxtTimesLateCompensation(String txtTimesLateCompensation) {
		this.txtTimesLateCompensation = txtTimesLateCompensation;
	}
	
	/**
	 * @return txtTimesSpecificHolidaySubstitute
	 */
	public String getTxtTimesSpecificHolidaySubstitute() {
		return txtTimesSpecificHolidaySubstitute;
	}
	
	/**
	 * @param txtTimesSpecificHolidaySubstitute セットする txtTimesSpecificHolidaySubstitute
	 */
	public void setTxtTimesSpecificHolidaySubstitute(String txtTimesSpecificHolidaySubstitute) {
		this.txtTimesSpecificHolidaySubstitute = txtTimesSpecificHolidaySubstitute;
	}
	
	/**
	 * @return txtTotalSpecialHoliday
	 */
	public String getTxtTotalSpecialHoliday() {
		return txtTotalSpecialHoliday;
	}
	
	/**
	 * @param txtTotalSpecialHoliday セットする txtTotalSpecialHoliday
	 */
	public void setTxtTotalSpecialHoliday(String txtTotalSpecialHoliday) {
		this.txtTotalSpecialHoliday = txtTotalSpecialHoliday;
	}
	
	/**
	 * @return txtTotalOtherHoliday
	 */
	public String getTxtTotalOtherHoliday() {
		return txtTotalOtherHoliday;
	}
	
	/**
	 * @param txtTotalOtherHoliday セットする txtTotalOtherHoliday
	 */
	public void setTxtTotalOtherHoliday(String txtTotalOtherHoliday) {
		this.txtTotalOtherHoliday = txtTotalOtherHoliday;
	}
	
	/**
	 * @return txtTotalDeduction
	 */
	public String getTxtTotalDeduction() {
		return txtTotalDeduction;
	}
	
	/**
	 * @param txtTotalDeduction セットする txtTotalDeduction
	 */
	public void setTxtTotalDeduction(String txtTotalDeduction) {
		this.txtTotalDeduction = txtTotalDeduction;
	}
	
	/**
	 * @return txtTimesAllowance1
	 */
	public String getTxtTimesAllowance1() {
		return txtTimesAllowance1;
	}
	
	/**
	 * @param txtTimesAllowance1 セットする txtTimesAllowance1
	 */
	public void setTxtTimesAllowance1(String txtTimesAllowance1) {
		this.txtTimesAllowance1 = txtTimesAllowance1;
	}
	
	/**
	 * @return txtTimesAllowance2
	 */
	public String getTxtTimesAllowance2() {
		return txtTimesAllowance2;
	}
	
	/**
	 * @param txtTimesAllowance2 セットする txtTimesAllowance2
	 */
	public void setTxtTimesAllowance2(String txtTimesAllowance2) {
		this.txtTimesAllowance2 = txtTimesAllowance2;
	}
	
	/**
	 * @return txtTimesAllowance3
	 */
	public String getTxtTimesAllowance3() {
		return txtTimesAllowance3;
	}
	
	/**
	 * @param txtTimesAllowance3 セットする txtTimesAllowance3
	 */
	public void setTxtTimesAllowance3(String txtTimesAllowance3) {
		this.txtTimesAllowance3 = txtTimesAllowance3;
	}
	
	/**
	 * @return txtTimesAllowance4
	 */
	public String getTxtTimesAllowance4() {
		return txtTimesAllowance4;
	}
	
	/**
	 * @param txtTimesAllowance4 セットする txtTimesAllowance4
	 */
	public void setTxtTimesAllowance4(String txtTimesAllowance4) {
		this.txtTimesAllowance4 = txtTimesAllowance4;
	}
	
	/**
	 * @return txtTimesAllowance5
	 */
	public String getTxtTimesAllowance5() {
		return txtTimesAllowance5;
	}
	
	/**
	 * @param txtTimesAllowance5 セットする txtTimesAllowance5
	 */
	public void setTxtTimesAllowance5(String txtTimesAllowance5) {
		this.txtTimesAllowance5 = txtTimesAllowance5;
	}
	
	/**
	 * @return txtTimesAllowance6
	 */
	public String getTxtTimesAllowance6() {
		return txtTimesAllowance6;
	}
	
	/**
	 * @param txtTimesAllowance6 セットする txtTimesAllowance6
	 */
	public void setTxtTimesAllowance6(String txtTimesAllowance6) {
		this.txtTimesAllowance6 = txtTimesAllowance6;
	}
	
	/**
	 * @return txtTimesAllowance7
	 */
	public String getTxtTimesAllowance7() {
		return txtTimesAllowance7;
	}
	
	/**
	 * @param txtTimesAllowance7 セットする txtTimesAllowance7
	 */
	public void setTxtTimesAllowance7(String txtTimesAllowance7) {
		this.txtTimesAllowance7 = txtTimesAllowance7;
	}
	
	/**
	 * @return txtTimesAllowance8
	 */
	public String getTxtTimesAllowance8() {
		return txtTimesAllowance8;
	}
	
	/**
	 * @param txtTimesAllowance8 セットする txtTimesAllowance8
	 */
	public void setTxtTimesAllowance8(String txtTimesAllowance8) {
		this.txtTimesAllowance8 = txtTimesAllowance8;
	}
	
	/**
	 * @return txtTimesAllowance9
	 */
	public String getTxtTimesAllowance9() {
		return txtTimesAllowance9;
	}
	
	/**
	 * @param txtTimesAllowance9 セットする txtTimesAllowance9
	 */
	public void setTxtTimesAllowance9(String txtTimesAllowance9) {
		this.txtTimesAllowance9 = txtTimesAllowance9;
	}
	
	/**
	 * @return txtTimesAllowance10
	 */
	public String getTxtTimesAllowance10() {
		return txtTimesAllowance10;
	}
	
	/**
	 * @param txtTimesAllowance10 セットする txtTimesAllowance10
	 */
	public void setTxtTimesAllowance10(String txtTimesAllowance10) {
		this.txtTimesAllowance10 = txtTimesAllowance10;
	}
	
	/**
	 * @return txtTotalAllowance
	 */
	public String getTxtTotalAllowance() {
		return txtTotalAllowance;
	}
	
	/**
	 * @param txtTotalAllowance セットする txtTotalAllowance
	 */
	public void setTxtTotalAllowance(String txtTotalAllowance) {
		this.txtTotalAllowance = txtTotalAllowance;
	}
	
	/**
	 * @return txt60HourOverTimeHour
	 */
	public String getTxt60HourOverTimeHour() {
		return txt60HourOverTimeHour;
	}
	
	/**
	 * @param txt60HourOverTimeHour セットする txt60HourOverTimeHour
	 */
	public void setTxt60HourOverTimeHour(String txt60HourOverTimeHour) {
		this.txt60HourOverTimeHour = txt60HourOverTimeHour;
	}
	
	/**
	 * @return txt60HourOverTimeMinute
	 */
	public String getTxt60HourOverTimeMinute() {
		return txt60HourOverTimeMinute;
	}
	
	/**
	 * @param txt60HourOverTimeMinute セットする txt60HourOverTimeMinute
	 */
	public void setTxt60HourOverTimeMinute(String txt60HourOverTimeMinute) {
		this.txt60HourOverTimeMinute = txt60HourOverTimeMinute;
	}
	
	/**
	 * @return txtWeekDayOverTimeHour
	 */
	public String getTxtWeekDayOverTimeHour() {
		return txtWeekDayOverTimeHour;
	}
	
	/**
	 * @param txtWeekDayOverTimeHour セットする txtWeekDayOverTimeHour
	 */
	public void setTxtWeekDayOverTimeHour(String txtWeekDayOverTimeHour) {
		this.txtWeekDayOverTimeHour = txtWeekDayOverTimeHour;
	}
	
	/**
	 * @return txtWeekDayOverTimeMinute
	 */
	public String getTxtWeekDayOverTimeMinute() {
		return txtWeekDayOverTimeMinute;
	}
	
	/**
	 * @param txtWeekDayOverTimeMinute セットする txtWeekDayOverTimeMinute
	 */
	public void setTxtWeekDayOverTimeMinute(String txtWeekDayOverTimeMinute) {
		this.txtWeekDayOverTimeMinute = txtWeekDayOverTimeMinute;
	}
	
	/**
	 * @return txtSpecificOverTimeHour
	 */
	public String getTxtSpecificOverTimeHour() {
		return txtSpecificOverTimeHour;
	}
	
	/**
	 * @param txtSpecificOverTimeHour セットする txtSpecificOverTimeHour
	 */
	public void setTxtSpecificOverTimeHour(String txtSpecificOverTimeHour) {
		this.txtSpecificOverTimeHour = txtSpecificOverTimeHour;
	}
	
	/**
	 * @return txtSpecificOverTimeMiunte
	 */
	public String getTxtSpecificOverTimeMiunte() {
		return txtSpecificOverTimeMiunte;
	}
	
	/**
	 * @param txtSpecificOverTimeMiunte セットする txtSpecificOverTimeMiunte
	 */
	public void setTxtSpecificOverTimeMiunte(String txtSpecificOverTimeMiunte) {
		this.txtSpecificOverTimeMiunte = txtSpecificOverTimeMiunte;
	}
	
	/**
	 * @return txtTimesAlternative
	 */
	public String getTxtTimesAlternative() {
		return txtTimesAlternative;
	}
	
	/**
	 * @param txtTimesAlternative セットする txtTimesAlternative
	 */
	public void setTxtTimesAlternative(String txtTimesAlternative) {
		this.txtTimesAlternative = txtTimesAlternative;
	}
	
	/**
	 * @return lblEmployeeCode
	 */
	@Override
	public String getLblEmployeeCode() {
		return lblEmployeeCode;
	}
	
	/**
	 * @param lblEmployeeCode セットする lblEmployeeCode
	 */
	@Override
	public void setLblEmployeeCode(String lblEmployeeCode) {
		this.lblEmployeeCode = lblEmployeeCode;
	}
	
	/**
	 * @return lblEmployeeName
	 */
	@Override
	public String getLblEmployeeName() {
		return lblEmployeeName;
	}
	
	/**
	 * @param lblEmployeeName セットする lblEmployeeName
	 */
	@Override
	public void setLblEmployeeName(String lblEmployeeName) {
		this.lblEmployeeName = lblEmployeeName;
	}
	
	/**
	 * @return lblSection
	 */
	public String getLblSection() {
		return lblSection;
	}
	
	/**
	 * @param lblSection セットする lblSection
	 */
	public void setLblSection(String lblSection) {
		this.lblSection = lblSection;
	}
	
	/**
	 * @return lblMonth
	 */
	public String getLblMonth() {
		return lblMonth;
	}
	
	/**
	 * @param lblMonth セットする lblMonth
	 */
	public void setLblMonth(String lblMonth) {
		this.lblMonth = lblMonth;
	}
	
	/**
	 * @return lblCorrectionHistory
	 */
	public String getLblCorrectionHistory() {
		return lblCorrectionHistory;
	}
	
	/**
	 * @param lblCorrectionHistory セットする lblCorrectionHistory
	 */
	public void setLblCorrectionHistory(String lblCorrectionHistory) {
		this.lblCorrectionHistory = lblCorrectionHistory;
	}
	
	/**
	 * @return txtRestWorkOnOverHour
	 */
	public String getTxtRestWorkOnOverHour() {
		return txtRestWorkOnOverHour;
	}
	
	/**
	 * @return txtRestWorkOnOverMinute
	 */
	public String getTxtRestWorkOnOverMinute() {
		return txtRestWorkOnOverMinute;
	}
	
	/**
	 * @return txtWorkOnOverHour
	 */
	public String getTxtWorkOnOverHour() {
		return txtWorkOnOverHour;
	}
	
	/**
	 * @return txtWorkOnOverMinute
	 */
	public String getTxtWorkOnOverMinute() {
		return txtWorkOnOverMinute;
	}
	
	/**
	 * @return txtTimesLegalHolidaySubstitute
	 */
	public String getTxtTimesLegalHolidaySubstitute() {
		return txtTimesLegalHolidaySubstitute;
	}
	
	/**
	 * @param txtRestWorkOnOverHour セットする txtRestWorkOnOverHour
	 */
	public void setTxtRestWorkOnOverHour(String txtRestWorkOnOverHour) {
		this.txtRestWorkOnOverHour = txtRestWorkOnOverHour;
	}
	
	/**
	 * @param txtRestWorkOnOverMinute セットする txtRestWorkOnOverMinute
	 */
	public void setTxtRestWorkOnOverMinute(String txtRestWorkOnOverMinute) {
		this.txtRestWorkOnOverMinute = txtRestWorkOnOverMinute;
	}
	
	/**
	 * @param txtWorkOnOverHour セットする txtWorkOnOverHour
	 */
	public void setTxtWorkOnOverHour(String txtWorkOnOverHour) {
		this.txtWorkOnOverHour = txtWorkOnOverHour;
	}
	
	/**
	 * @param txtWorkOnOverMinute セットする txtWorkOnOverMinute
	 */
	public void setTxtWorkOnOverMinute(String txtWorkOnOverMinute) {
		this.txtWorkOnOverMinute = txtWorkOnOverMinute;
	}
	
	/**
	 * @param txtTimesLegalHolidaySubstitute セットする txtTimesLegalHolidaySubstitute
	 */
	public void setTxtTimesLegalHolidaySubstitute(String txtTimesLegalHolidaySubstitute) {
		this.txtTimesLegalHolidaySubstitute = txtTimesLegalHolidaySubstitute;
	}
	
	/**
	 * @return editDate
	 */
	public Date getEditDate() {
		return editDate;
	}
	
	/**
	 * @param editDate セットする editDate
	 */
	public void setEditDate(Date editDate) {
		this.editDate = editDate;
	}
	
	/**
	 * @return editEmployeeCode
	 */
	public String getEditEmployeeCode() {
		return editEmployeeCode;
	}
	
	/**
	 * @param editEmployeeCode セットする editEmployeeCode
	 */
	public void setEditEmployeeCode(String editEmployeeCode) {
		this.editEmployeeCode = editEmployeeCode;
	}
	
	/**
	 * @return tmdTotalTimeId
	 */
	public long getTmdTotalTimeId() {
		return tmdTotalTimeId;
	}
	
	/**
	 * @param tmdTotalTimeId セットする tmdTotalTimeId
	 */
	public void setTmdTotalTimeId(long tmdTotalTimeId) {
		this.tmdTotalTimeId = tmdTotalTimeId;
	}
	
	/**
	 * @return tmdAllowanceId
	 */
	public long getTmdAllowanceId() {
		return tmdAllowanceId;
	}
	
	/**
	 * @param tmdAllowanceId セットする tmdAllowanceId
	 */
	public void setTmdAllowanceId(long tmdAllowanceId) {
		this.tmdAllowanceId = tmdAllowanceId;
	}
	
	/**
	 * @return tmdOvertimeRequestId
	 */
	public long getTmdOvertimeRequestId() {
		return tmdOvertimeRequestId;
	}
	
	/**
	 * @param tmdOvertimeRequestId セットする tmdOvertimeRequestId
	 */
	public void setTmdOvertimeRequestId(long tmdOvertimeRequestId) {
		this.tmdOvertimeRequestId = tmdOvertimeRequestId;
	}
	
	/**
	 * @return txtTimesAchievement
	 */
	public String getTxtTimesAchievement() {
		return txtTimesAchievement;
	}
	
	/**
	 * @param txtTimesAchievement セットする txtTimesAchievement
	 */
	public void setTxtTimesAchievement(String txtTimesAchievement) {
		this.txtTimesAchievement = txtTimesAchievement;
	}
	
	/**
	 * @return txtTimesTotalWorkDate
	 */
	public String getTxtTimesTotalWorkDate() {
		return txtTimesTotalWorkDate;
	}
	
	/**
	 * @param txtTimesTotalWorkDate セットする txtTimesTotalWorkDate
	 */
	public void setTxtTimesTotalWorkDate(String txtTimesTotalWorkDate) {
		this.txtTimesTotalWorkDate = txtTimesTotalWorkDate;
	}
	
	/**
	 * @return txtTimesOvertime
	 */
	public String getTxtTimesOvertime() {
		return txtTimesOvertime;
	}
	
	/**
	 * @param txtTimesOvertime セットする txtTimesOvertime
	 */
	public void setTxtTimesOvertime(String txtTimesOvertime) {
		this.txtTimesOvertime = txtTimesOvertime;
	}
	
	/**
	 * @return txtTimesWorkingHoliday
	 */
	public String getTxtTimesWorkingHoliday() {
		return txtTimesWorkingHoliday;
	}
	
	/**
	 * @param txtTimesWorkingHoliday セットする txtTimesWorkingHoliday
	 */
	public void setTxtTimesWorkingHoliday(String txtTimesWorkingHoliday) {
		this.txtTimesWorkingHoliday = txtTimesWorkingHoliday;
	}
	
	/**
	 * @return aryTxtTimesSpecialLeave
	 */
	public String[] getAryTxtTimesSpecialLeave() {
		return getStringArrayClone(aryTxtTimesSpecialLeave);
	}
	
	/**
	 * @param aryTxtTimesSpecialLeave セットする aryTxtTimesSpecialLeave
	 */
	public void setAryTxtTimesSpecialLeave(String[] aryTxtTimesSpecialLeave) {
		this.aryTxtTimesSpecialLeave = getStringArrayClone(aryTxtTimesSpecialLeave);
	}
	
	/**
	 * @return aryTxtTimesOtherVacation
	 */
	public String[] getAryTxtTimesOtherVacation() {
		return getStringArrayClone(aryTxtTimesOtherVacation);
	}
	
	/**
	 * @param aryTxtTimesOtherVacation セットする aryTxtTimesOtherVacation
	 */
	public void setAryTxtTimesOtherVacation(String[] aryTxtTimesOtherVacation) {
		this.aryTxtTimesOtherVacation = getStringArrayClone(aryTxtTimesOtherVacation);
	}
	
	/**
	 * @return aryTxtDeduction
	 */
	public String[] getAryTxtDeduction() {
		return getStringArrayClone(aryTxtDeduction);
	}
	
	/**
	 * @param aryTxtDeduction セットする aryTxtDeduction
	 */
	public void setAryTxtDeduction(String[] aryTxtDeduction) {
		this.aryTxtDeduction = getStringArrayClone(aryTxtDeduction);
	}
	
	/**
	 * @return aryTxtTimesSpecialLeaveTitle
	 */
	public String[] getAryTxtTimesSpecialLeaveTitle() {
		return getStringArrayClone(aryTxtTimesSpecialLeaveTitle);
	}
	
	/**
	 * @param aryTxtTimesSpecialLeaveTitle セットする aryTxtTimesSpecialLeaveTitle
	 */
	public void setAryTxtTimesSpecialLeaveTitle(String[] aryTxtTimesSpecialLeaveTitle) {
		this.aryTxtTimesSpecialLeaveTitle = getStringArrayClone(aryTxtTimesSpecialLeaveTitle);
	}
	
	/**
	 * @return aryTxtTimesOtherVacationTitle
	 */
	public String[] getAryTxtTimesOtherVacationTitle() {
		return getStringArrayClone(aryTxtTimesOtherVacationTitle);
	}
	
	/**
	 * @param aryTxtTimesOtherVacationTitle セットする aryTxtTimesOtherVacationTitle
	 */
	public void setAryTxtTimesOtherVacationTitle(String[] aryTxtTimesOtherVacationTitle) {
		this.aryTxtTimesOtherVacationTitle = getStringArrayClone(aryTxtTimesOtherVacationTitle);
	}
	
	/**
	 * @return aryTxtDeductionTitle
	 */
	public String[] getAryTxtDeductionTitle() {
		return getStringArrayClone(aryTxtDeductionTitle);
	}
	
	/**
	 * @param aryTxtDeductionTitle セットする aryTxtDeductionTitle
	 */
	public void setAryTxtDeductionTitle(String[] aryTxtDeductionTitle) {
		this.aryTxtDeductionTitle = getStringArrayClone(aryTxtDeductionTitle);
	}
	
	/**
	 * @return aryTxtTimesSpecialLeaveCode
	 */
	public String[] getAryTxtTimesSpecialLeaveCode() {
		return aryTxtTimesSpecialLeaveCode;
	}
	
	/**
	 * @param aryTxtTimesSpecialLeaveCode セットする aryTxtTimesSpecialLeaveCode
	 */
	public void setAryTxtTimesSpecialLeaveCode(String[] aryTxtTimesSpecialLeaveCode) {
		this.aryTxtTimesSpecialLeaveCode = aryTxtTimesSpecialLeaveCode;
	}
	
	/**
	 * @return aryTxtTimesOtherVacationCode
	 */
	public String[] getAryTxtTimesOtherVacationCode() {
		return aryTxtTimesOtherVacationCode;
	}
	
	/**
	 * @param aryTxtTimesOtherVacationCode セットする aryTxtTimesOtherVacationCode
	 */
	public void setAryTxtTimesOtherVacationCode(String[] aryTxtTimesOtherVacationCode) {
		this.aryTxtTimesOtherVacationCode = aryTxtTimesOtherVacationCode;
	}
	
	/**
	 * @return aryTxtDeductionCode
	 */
	public String[] getAryTxtDeductionCode() {
		return aryTxtDeductionCode;
	}
	
	/**
	 * @param aryTxtDeductionCode セットする aryTxtDeductionCode
	 */
	public void setAryTxtDeductionCode(String[] aryTxtDeductionCode) {
		this.aryTxtDeductionCode = aryTxtDeductionCode;
	}
	
	/**
	 * @return txtTimesSpecialLeave1
	 */
	public String getTxtTimesSpecialLeave1() {
		return txtTimesSpecialLeave1;
	}
	
	/**
	 * @param txtTimesSpecialLeave1 セットする txtTimesSpecialLeave1
	 */
	public void setTxtTimesSpecialLeave1(String txtTimesSpecialLeave1) {
		this.txtTimesSpecialLeave1 = txtTimesSpecialLeave1;
	}
	
	/**
	 * @return txtTimesSpecialLeave2
	 */
	public String getTxtTimesSpecialLeave2() {
		return txtTimesSpecialLeave2;
	}
	
	/**
	 * @param txtTimesSpecialLeave2 セットする txtTimesSpecialLeave2
	 */
	public void setTxtTimesSpecialLeave2(String txtTimesSpecialLeave2) {
		this.txtTimesSpecialLeave2 = txtTimesSpecialLeave2;
	}
	
	/**
	 * @return txtTimesSpecialLeave3
	 */
	public String getTxtTimesSpecialLeave3() {
		return txtTimesSpecialLeave3;
	}
	
	/**
	 * @param txtTimesSpecialLeave3 セットする txtTimesSpecialLeave3
	 */
	public void setTxtTimesSpecialLeave3(String txtTimesSpecialLeave3) {
		this.txtTimesSpecialLeave3 = txtTimesSpecialLeave3;
	}
	
	/**
	 * @return txtTimesSpecialLeave4
	 */
	public String getTxtTimesSpecialLeave4() {
		return txtTimesSpecialLeave4;
	}
	
	/**
	 * @param txtTimesSpecialLeave4 セットする txtTimesSpecialLeave4
	 */
	public void setTxtTimesSpecialLeave4(String txtTimesSpecialLeave4) {
		this.txtTimesSpecialLeave4 = txtTimesSpecialLeave4;
	}
	
	/**
	 * @return txtTimesSpecialLeave5
	 */
	public String getTxtTimesSpecialLeave5() {
		return txtTimesSpecialLeave5;
	}
	
	/**
	 * @param txtTimesSpecialLeave5 セットする txtTimesSpecialLeave5
	 */
	public void setTxtTimesSpecialLeave5(String txtTimesSpecialLeave5) {
		this.txtTimesSpecialLeave5 = txtTimesSpecialLeave5;
	}
	
	/**
	 * @return txtTimesSpecialLeave6
	 */
	public String getTxtTimesSpecialLeave6() {
		return txtTimesSpecialLeave6;
	}
	
	/**
	 * @param txtTimesSpecialLeave6 セットする txtTimesSpecialLeave6
	 */
	public void setTxtTimesSpecialLeave6(String txtTimesSpecialLeave6) {
		this.txtTimesSpecialLeave6 = txtTimesSpecialLeave6;
	}
	
	/**
	 * @return txtTimesSpecialLeave7
	 */
	public String getTxtTimesSpecialLeave7() {
		return txtTimesSpecialLeave7;
	}
	
	/**
	 * @param txtTimesSpecialLeave7 セットする txtTimesSpecialLeave7
	 */
	public void setTxtTimesSpecialLeave7(String txtTimesSpecialLeave7) {
		this.txtTimesSpecialLeave7 = txtTimesSpecialLeave7;
	}
	
	/**
	 * @return txtTimesSpecialLeave8
	 */
	public String getTxtTimesSpecialLeave8() {
		return txtTimesSpecialLeave8;
	}
	
	/**
	 * @param txtTimesSpecialLeave8 セットする txtTimesSpecialLeave8
	 */
	public void setTxtTimesSpecialLeave8(String txtTimesSpecialLeave8) {
		this.txtTimesSpecialLeave8 = txtTimesSpecialLeave8;
	}
	
	/**
	 * @return txtTimesSpecialLeave9
	 */
	public String getTxtTimesSpecialLeave9() {
		return txtTimesSpecialLeave9;
	}
	
	/**
	 * @param txtTimesSpecialLeave9 セットする txtTimesSpecialLeave9
	 */
	public void setTxtTimesSpecialLeave9(String txtTimesSpecialLeave9) {
		this.txtTimesSpecialLeave9 = txtTimesSpecialLeave9;
	}
	
	/**
	 * @return txtTimesSpecialLeave10
	 */
	public String getTxtTimesSpecialLeave10() {
		return txtTimesSpecialLeave10;
	}
	
	/**
	 * @param txtTimesSpecialLeave10 セットする txtTimesSpecialLeave10
	 */
	public void setTxtTimesSpecialLeave10(String txtTimesSpecialLeave10) {
		this.txtTimesSpecialLeave10 = txtTimesSpecialLeave10;
	}
	
	/**
	 * @return txtTimesSpecialLeave11
	 */
	public String getTxtTimesSpecialLeave11() {
		return txtTimesSpecialLeave11;
	}
	
	/**
	 * @param txtTimesSpecialLeave11 セットする txtTimesSpecialLeave11
	 */
	public void setTxtTimesSpecialLeave11(String txtTimesSpecialLeave11) {
		this.txtTimesSpecialLeave11 = txtTimesSpecialLeave11;
	}
	
	/**
	 * @return txtTimesSpecialLeave12
	 */
	public String getTxtTimesSpecialLeave12() {
		return txtTimesSpecialLeave12;
	}
	
	/**
	 * @param txtTimesSpecialLeave12 セットする txtTimesSpecialLeave12
	 */
	public void setTxtTimesSpecialLeave12(String txtTimesSpecialLeave12) {
		this.txtTimesSpecialLeave12 = txtTimesSpecialLeave12;
	}
	
	/**
	 * @return txtTimesSpecialLeave13
	 */
	public String getTxtTimesSpecialLeave13() {
		return txtTimesSpecialLeave13;
	}
	
	/**
	 * @param txtTimesSpecialLeave13 セットする txtTimesSpecialLeave13
	 */
	public void setTxtTimesSpecialLeave13(String txtTimesSpecialLeave13) {
		this.txtTimesSpecialLeave13 = txtTimesSpecialLeave13;
	}
	
	/**
	 * @return txtTimesSpecialLeave14
	 */
	public String getTxtTimesSpecialLeave14() {
		return txtTimesSpecialLeave14;
	}
	
	/**
	 * @param txtTimesSpecialLeave14 セットする txtTimesSpecialLeave14
	 */
	public void setTxtTimesSpecialLeave14(String txtTimesSpecialLeave14) {
		this.txtTimesSpecialLeave14 = txtTimesSpecialLeave14;
	}
	
	/**
	 * @return txtTimesSpecialLeave15
	 */
	public String getTxtTimesSpecialLeave15() {
		return txtTimesSpecialLeave15;
	}
	
	/**
	 * @param txtTimesSpecialLeave15 セットする txtTimesSpecialLeave15
	 */
	public void setTxtTimesSpecialLeave15(String txtTimesSpecialLeave15) {
		this.txtTimesSpecialLeave15 = txtTimesSpecialLeave15;
	}
	
	/**
	 * @return txtTimesSpecialLeave16
	 */
	public String getTxtTimesSpecialLeave16() {
		return txtTimesSpecialLeave16;
	}
	
	/**
	 * @param txtTimesSpecialLeave16 セットする txtTimesSpecialLeave16
	 */
	public void setTxtTimesSpecialLeave16(String txtTimesSpecialLeave16) {
		this.txtTimesSpecialLeave16 = txtTimesSpecialLeave16;
	}
	
	/**
	 * @return txtTimesSpecialLeave17
	 */
	public String getTxtTimesSpecialLeave17() {
		return txtTimesSpecialLeave17;
	}
	
	/**
	 * @param txtTimesSpecialLeave17 セットする txtTimesSpecialLeave17
	 */
	public void setTxtTimesSpecialLeave17(String txtTimesSpecialLeave17) {
		this.txtTimesSpecialLeave17 = txtTimesSpecialLeave17;
	}
	
	/**
	 * @return txtTimesSpecialLeave18
	 */
	public String getTxtTimesSpecialLeave18() {
		return txtTimesSpecialLeave18;
	}
	
	/**
	 * @param txtTimesSpecialLeave18 セットする txtTimesSpecialLeave18
	 */
	public void setTxtTimesSpecialLeave18(String txtTimesSpecialLeave18) {
		this.txtTimesSpecialLeave18 = txtTimesSpecialLeave18;
	}
	
	/**
	 * @return txtTimesSpecialLeave19
	 */
	public String getTxtTimesSpecialLeave19() {
		return txtTimesSpecialLeave19;
	}
	
	/**
	 * @param txtTimesSpecialLeave19 セットする txtTimesSpecialLeave19
	 */
	public void setTxtTimesSpecialLeave19(String txtTimesSpecialLeave19) {
		this.txtTimesSpecialLeave19 = txtTimesSpecialLeave19;
	}
	
	/**
	 * @return txtTimesSpecialLeave20
	 */
	public String getTxtTimesSpecialLeave20() {
		return txtTimesSpecialLeave20;
	}
	
	/**
	 * @param txtTimesSpecialLeave20 セットする txtTimesSpecialLeave20
	 */
	public void setTxtTimesSpecialLeave20(String txtTimesSpecialLeave20) {
		this.txtTimesSpecialLeave20 = txtTimesSpecialLeave20;
	}
	
	/**
	 * @return txtTimesSpecialLeave21
	 */
	public String getTxtTimesSpecialLeave21() {
		return txtTimesSpecialLeave21;
	}
	
	/**
	 * @param txtTimesSpecialLeave21 セットする txtTimesSpecialLeave21
	 */
	public void setTxtTimesSpecialLeave21(String txtTimesSpecialLeave21) {
		this.txtTimesSpecialLeave21 = txtTimesSpecialLeave21;
	}
	
	/**
	 * @return txtTimesSpecialLeave22
	 */
	public String getTxtTimesSpecialLeave22() {
		return txtTimesSpecialLeave22;
	}
	
	/**
	 * @param txtTimesSpecialLeave22 セットする txtTimesSpecialLeave22
	 */
	public void setTxtTimesSpecialLeave22(String txtTimesSpecialLeave22) {
		this.txtTimesSpecialLeave22 = txtTimesSpecialLeave22;
	}
	
	/**
	 * @return txtTimesSpecialLeave23
	 */
	public String getTxtTimesSpecialLeave23() {
		return txtTimesSpecialLeave23;
	}
	
	/**
	 * @param txtTimesSpecialLeave23 セットする txtTimesSpecialLeave23
	 */
	public void setTxtTimesSpecialLeave23(String txtTimesSpecialLeave23) {
		this.txtTimesSpecialLeave23 = txtTimesSpecialLeave23;
	}
	
	/**
	 * @return txtTimesSpecialLeave24
	 */
	public String getTxtTimesSpecialLeave24() {
		return txtTimesSpecialLeave24;
	}
	
	/**
	 * @param txtTimesSpecialLeave24 セットする txtTimesSpecialLeave24
	 */
	public void setTxtTimesSpecialLeave24(String txtTimesSpecialLeave24) {
		this.txtTimesSpecialLeave24 = txtTimesSpecialLeave24;
	}
	
	/**
	 * @return txtTimesSpecialLeave25
	 */
	public String getTxtTimesSpecialLeave25() {
		return txtTimesSpecialLeave25;
	}
	
	/**
	 * @param txtTimesSpecialLeave25 セットする txtTimesSpecialLeave25
	 */
	public void setTxtTimesSpecialLeave25(String txtTimesSpecialLeave25) {
		this.txtTimesSpecialLeave25 = txtTimesSpecialLeave25;
	}
	
	/**
	 * @return txtTimesSpecialLeave26
	 */
	public String getTxtTimesSpecialLeave26() {
		return txtTimesSpecialLeave26;
	}
	
	/**
	 * @param txtTimesSpecialLeave26 セットする txtTimesSpecialLeave26
	 */
	public void setTxtTimesSpecialLeave26(String txtTimesSpecialLeave26) {
		this.txtTimesSpecialLeave26 = txtTimesSpecialLeave26;
	}
	
	/**
	 * @return txtTimesSpecialLeave27
	 */
	public String getTxtTimesSpecialLeave27() {
		return txtTimesSpecialLeave27;
	}
	
	/**
	 * @param txtTimesSpecialLeave27 セットする txtTimesSpecialLeave27
	 */
	public void setTxtTimesSpecialLeave27(String txtTimesSpecialLeave27) {
		this.txtTimesSpecialLeave27 = txtTimesSpecialLeave27;
	}
	
	/**
	 * @return txtTimesSpecialLeave28
	 */
	public String getTxtTimesSpecialLeave28() {
		return txtTimesSpecialLeave28;
	}
	
	/**
	 * @param txtTimesSpecialLeave28 セットする txtTimesSpecialLeave28
	 */
	public void setTxtTimesSpecialLeave28(String txtTimesSpecialLeave28) {
		this.txtTimesSpecialLeave28 = txtTimesSpecialLeave28;
	}
	
	/**
	 * @return txtTimesSpecialLeave29
	 */
	public String getTxtTimesSpecialLeave29() {
		return txtTimesSpecialLeave29;
	}
	
	/**
	 * @param txtTimesSpecialLeave29 セットする txtTimesSpecialLeave29
	 */
	public void setTxtTimesSpecialLeave29(String txtTimesSpecialLeave29) {
		this.txtTimesSpecialLeave29 = txtTimesSpecialLeave29;
	}
	
	/**
	 * @return txtTimesSpecialLeave30
	 */
	public String getTxtTimesSpecialLeave30() {
		return txtTimesSpecialLeave30;
	}
	
	/**
	 * @param txtTimesSpecialLeave30 セットする txtTimesSpecialLeave30
	 */
	public void setTxtTimesSpecialLeave30(String txtTimesSpecialLeave30) {
		this.txtTimesSpecialLeave30 = txtTimesSpecialLeave30;
	}
	
	/**
	 * @return txtTimesOtherVacation1
	 */
	public String getTxtTimesOtherVacation1() {
		return txtTimesOtherVacation1;
	}
	
	/**
	 * @param txtTimesOtherVacation1 セットする txtTimesOtherVacation1
	 */
	public void setTxtTimesOtherVacation1(String txtTimesOtherVacation1) {
		this.txtTimesOtherVacation1 = txtTimesOtherVacation1;
	}
	
	/**
	 * @return txtTimesOtherVacation2
	 */
	public String getTxtTimesOtherVacation2() {
		return txtTimesOtherVacation2;
	}
	
	/**
	 * @param txtTimesOtherVacation2 セットする txtTimesOtherVacation2
	 */
	public void setTxtTimesOtherVacation2(String txtTimesOtherVacation2) {
		this.txtTimesOtherVacation2 = txtTimesOtherVacation2;
	}
	
	/**
	 * @return txtTimesOtherVacation3
	 */
	public String getTxtTimesOtherVacation3() {
		return txtTimesOtherVacation3;
	}
	
	/**
	 * @param txtTimesOtherVacation3 セットする txtTimesOtherVacation3
	 */
	public void setTxtTimesOtherVacation3(String txtTimesOtherVacation3) {
		this.txtTimesOtherVacation3 = txtTimesOtherVacation3;
	}
	
	/**
	 * @return txtTimesOtherVacation4
	 */
	public String getTxtTimesOtherVacation4() {
		return txtTimesOtherVacation4;
	}
	
	/**
	 * @param txtTimesOtherVacation4 セットする txtTimesOtherVacation4
	 */
	public void setTxtTimesOtherVacation4(String txtTimesOtherVacation4) {
		this.txtTimesOtherVacation4 = txtTimesOtherVacation4;
	}
	
	/**
	 * @return txtTimesOtherVacation5
	 */
	public String getTxtTimesOtherVacation5() {
		return txtTimesOtherVacation5;
	}
	
	/**
	 * @param txtTimesOtherVacation5 セットする txtTimesOtherVacation5
	 */
	public void setTxtTimesOtherVacation5(String txtTimesOtherVacation5) {
		this.txtTimesOtherVacation5 = txtTimesOtherVacation5;
	}
	
	/**
	 * @return txtTimesOtherVacation6
	 */
	public String getTxtTimesOtherVacation6() {
		return txtTimesOtherVacation6;
	}
	
	/**
	 * @param txtTimesOtherVacation6 セットする txtTimesOtherVacation6
	 */
	public void setTxtTimesOtherVacation6(String txtTimesOtherVacation6) {
		this.txtTimesOtherVacation6 = txtTimesOtherVacation6;
	}
	
	/**
	 * @return txtTimesOtherVacation7
	 */
	public String getTxtTimesOtherVacation7() {
		return txtTimesOtherVacation7;
	}
	
	/**
	 * @param txtTimesOtherVacation7 セットする txtTimesOtherVacation7
	 */
	public void setTxtTimesOtherVacation7(String txtTimesOtherVacation7) {
		this.txtTimesOtherVacation7 = txtTimesOtherVacation7;
	}
	
	/**
	 * @return txtTimesOtherVacation8
	 */
	public String getTxtTimesOtherVacation8() {
		return txtTimesOtherVacation8;
	}
	
	/**
	 * @param txtTimesOtherVacation8 セットする txtTimesOtherVacation8
	 */
	public void setTxtTimesOtherVacation8(String txtTimesOtherVacation8) {
		this.txtTimesOtherVacation8 = txtTimesOtherVacation8;
	}
	
	/**
	 * @return txtTimesOtherVacation9
	 */
	public String getTxtTimesOtherVacation9() {
		return txtTimesOtherVacation9;
	}
	
	/**
	 * @param txtTimesOtherVacation9 セットする txtTimesOtherVacation9
	 */
	public void setTxtTimesOtherVacation9(String txtTimesOtherVacation9) {
		this.txtTimesOtherVacation9 = txtTimesOtherVacation9;
	}
	
	/**
	 * @return txtTimesOtherVacation10
	 */
	public String getTxtTimesOtherVacation10() {
		return txtTimesOtherVacation10;
	}
	
	/**
	 * @param txtTimesOtherVacation10 セットする txtTimesOtherVacation10
	 */
	public void setTxtTimesOtherVacation10(String txtTimesOtherVacation10) {
		this.txtTimesOtherVacation10 = txtTimesOtherVacation10;
	}
	
	/**
	 * @return txtTimesOtherVacation11
	 */
	public String getTxtTimesOtherVacation11() {
		return txtTimesOtherVacation11;
	}
	
	/**
	 * @param txtTimesOtherVacation11 セットする txtTimesOtherVacation11
	 */
	public void setTxtTimesOtherVacation11(String txtTimesOtherVacation11) {
		this.txtTimesOtherVacation11 = txtTimesOtherVacation11;
	}
	
	/**
	 * @return txtTimesOtherVacation12
	 */
	public String getTxtTimesOtherVacation12() {
		return txtTimesOtherVacation12;
	}
	
	/**
	 * @param txtTimesOtherVacation12 セットする txtTimesOtherVacation12
	 */
	public void setTxtTimesOtherVacation12(String txtTimesOtherVacation12) {
		this.txtTimesOtherVacation12 = txtTimesOtherVacation12;
	}
	
	/**
	 * @return txtTimesOtherVacation13
	 */
	public String getTxtTimesOtherVacation13() {
		return txtTimesOtherVacation13;
	}
	
	/**
	 * @param txtTimesOtherVacation13 セットする txtTimesOtherVacation13
	 */
	public void setTxtTimesOtherVacation13(String txtTimesOtherVacation13) {
		this.txtTimesOtherVacation13 = txtTimesOtherVacation13;
	}
	
	/**
	 * @return txtTimesOtherVacation14
	 */
	public String getTxtTimesOtherVacation14() {
		return txtTimesOtherVacation14;
	}
	
	/**
	 * @param txtTimesOtherVacation14 セットする txtTimesOtherVacation14
	 */
	public void setTxtTimesOtherVacation14(String txtTimesOtherVacation14) {
		this.txtTimesOtherVacation14 = txtTimesOtherVacation14;
	}
	
	/**
	 * @return txtTimesOtherVacation15
	 */
	public String getTxtTimesOtherVacation15() {
		return txtTimesOtherVacation15;
	}
	
	/**
	 * @param txtTimesOtherVacation15 セットする txtTimesOtherVacation15
	 */
	public void setTxtTimesOtherVacation15(String txtTimesOtherVacation15) {
		this.txtTimesOtherVacation15 = txtTimesOtherVacation15;
	}
	
	/**
	 * @return txtTimesOtherVacation16
	 */
	public String getTxtTimesOtherVacation16() {
		return txtTimesOtherVacation16;
	}
	
	/**
	 * @param txtTimesOtherVacation16 セットする txtTimesOtherVacation16
	 */
	public void setTxtTimesOtherVacation16(String txtTimesOtherVacation16) {
		this.txtTimesOtherVacation16 = txtTimesOtherVacation16;
	}
	
	/**
	 * @return txtTimesOtherVacation17
	 */
	public String getTxtTimesOtherVacation17() {
		return txtTimesOtherVacation17;
	}
	
	/**
	 * @param txtTimesOtherVacation17 セットする txtTimesOtherVacation17
	 */
	public void setTxtTimesOtherVacation17(String txtTimesOtherVacation17) {
		this.txtTimesOtherVacation17 = txtTimesOtherVacation17;
	}
	
	/**
	 * @return txtTimesOtherVacation18
	 */
	public String getTxtTimesOtherVacation18() {
		return txtTimesOtherVacation18;
	}
	
	/**
	 * @param txtTimesOtherVacation18 セットする txtTimesOtherVacation18
	 */
	public void setTxtTimesOtherVacation18(String txtTimesOtherVacation18) {
		this.txtTimesOtherVacation18 = txtTimesOtherVacation18;
	}
	
	/**
	 * @return txtTimesOtherVacation19
	 */
	public String getTxtTimesOtherVacation19() {
		return txtTimesOtherVacation19;
	}
	
	/**
	 * @param txtTimesOtherVacation19 セットする txtTimesOtherVacation19
	 */
	public void setTxtTimesOtherVacation19(String txtTimesOtherVacation19) {
		this.txtTimesOtherVacation19 = txtTimesOtherVacation19;
	}
	
	/**
	 * @return txtTimesOtherVacation20
	 */
	public String getTxtTimesOtherVacation20() {
		return txtTimesOtherVacation20;
	}
	
	/**
	 * @param txtTimesOtherVacation20 セットする txtTimesOtherVacation20
	 */
	public void setTxtTimesOtherVacation20(String txtTimesOtherVacation20) {
		this.txtTimesOtherVacation20 = txtTimesOtherVacation20;
	}
	
	/**
	 * @return txtTimesOtherVacation21
	 */
	public String getTxtTimesOtherVacation21() {
		return txtTimesOtherVacation21;
	}
	
	/**
	 * @param txtTimesOtherVacation21 セットする txtTimesOtherVacation21
	 */
	public void setTxtTimesOtherVacation21(String txtTimesOtherVacation21) {
		this.txtTimesOtherVacation21 = txtTimesOtherVacation21;
	}
	
	/**
	 * @return txtTimesOtherVacation22
	 */
	public String getTxtTimesOtherVacation22() {
		return txtTimesOtherVacation22;
	}
	
	/**
	 * @param txtTimesOtherVacation22 セットする txtTimesOtherVacation22
	 */
	public void setTxtTimesOtherVacation22(String txtTimesOtherVacation22) {
		this.txtTimesOtherVacation22 = txtTimesOtherVacation22;
	}
	
	/**
	 * @return txtTimesOtherVacation23
	 */
	public String getTxtTimesOtherVacation23() {
		return txtTimesOtherVacation23;
	}
	
	/**
	 * @param txtTimesOtherVacation23 セットする txtTimesOtherVacation23
	 */
	public void setTxtTimesOtherVacation23(String txtTimesOtherVacation23) {
		this.txtTimesOtherVacation23 = txtTimesOtherVacation23;
	}
	
	/**
	 * @return txtTimesOtherVacation24
	 */
	public String getTxtTimesOtherVacation24() {
		return txtTimesOtherVacation24;
	}
	
	/**
	 * @param txtTimesOtherVacation24 セットする txtTimesOtherVacation24
	 */
	public void setTxtTimesOtherVacation24(String txtTimesOtherVacation24) {
		this.txtTimesOtherVacation24 = txtTimesOtherVacation24;
	}
	
	/**
	 * @return txtTimesOtherVacation25
	 */
	public String getTxtTimesOtherVacation25() {
		return txtTimesOtherVacation25;
	}
	
	/**
	 * @param txtTimesOtherVacation25 セットする txtTimesOtherVacation25
	 */
	public void setTxtTimesOtherVacation25(String txtTimesOtherVacation25) {
		this.txtTimesOtherVacation25 = txtTimesOtherVacation25;
	}
	
	/**
	 * @return txtTimesOtherVacation26
	 */
	public String getTxtTimesOtherVacation26() {
		return txtTimesOtherVacation26;
	}
	
	/**
	 * @param txtTimesOtherVacation26 セットする txtTimesOtherVacation26
	 */
	public void setTxtTimesOtherVacation26(String txtTimesOtherVacation26) {
		this.txtTimesOtherVacation26 = txtTimesOtherVacation26;
	}
	
	/**
	 * @return txtTimesOtherVacation27
	 */
	public String getTxtTimesOtherVacation27() {
		return txtTimesOtherVacation27;
	}
	
	/**
	 * @param txtTimesOtherVacation27 セットする txtTimesOtherVacation27
	 */
	public void setTxtTimesOtherVacation27(String txtTimesOtherVacation27) {
		this.txtTimesOtherVacation27 = txtTimesOtherVacation27;
	}
	
	/**
	 * @return txtTimesOtherVacation28
	 */
	public String getTxtTimesOtherVacation28() {
		return txtTimesOtherVacation28;
	}
	
	/**
	 * @param txtTimesOtherVacation28 セットする txtTimesOtherVacation28
	 */
	public void setTxtTimesOtherVacation28(String txtTimesOtherVacation28) {
		this.txtTimesOtherVacation28 = txtTimesOtherVacation28;
	}
	
	/**
	 * @return txtTimesOtherVacation29
	 */
	public String getTxtTimesOtherVacation29() {
		return txtTimesOtherVacation29;
	}
	
	/**
	 * @param txtTimesOtherVacation29 セットする txtTimesOtherVacation29
	 */
	public void setTxtTimesOtherVacation29(String txtTimesOtherVacation29) {
		this.txtTimesOtherVacation29 = txtTimesOtherVacation29;
	}
	
	/**
	 * @return txtTimesOtherVacation30
	 */
	public String getTxtTimesOtherVacation30() {
		return txtTimesOtherVacation30;
	}
	
	/**
	 * @param txtTimesOtherVacation30 セットする txtTimesOtherVacation30
	 */
	public void setTxtTimesOtherVacation30(String txtTimesOtherVacation30) {
		this.txtTimesOtherVacation30 = txtTimesOtherVacation30;
	}
	
	/**
	 * @return txtDeduction1
	 */
	public String getTxtDeduction1() {
		return txtDeduction1;
	}
	
	/**
	 * @param txtDeduction1 セットする txtDeduction1
	 */
	public void setTxtDeduction1(String txtDeduction1) {
		this.txtDeduction1 = txtDeduction1;
	}
	
	/**
	 * @return txtDeduction2
	 */
	public String getTxtDeduction2() {
		return txtDeduction2;
	}
	
	/**
	 * @param txtDeduction2 セットする txtDeduction2
	 */
	public void setTxtDeduction2(String txtDeduction2) {
		this.txtDeduction2 = txtDeduction2;
	}
	
	/**
	 * @return txtDeduction3
	 */
	public String getTxtDeduction3() {
		return txtDeduction3;
	}
	
	/**
	 * @param txtDeduction3 セットする txtDeduction3
	 */
	public void setTxtDeduction3(String txtDeduction3) {
		this.txtDeduction3 = txtDeduction3;
	}
	
	/**
	 * @return txtDeduction4
	 */
	public String getTxtDeduction4() {
		return txtDeduction4;
	}
	
	/**
	 * @param txtDeduction4 セットする txtDeduction4
	 */
	public void setTxtDeduction4(String txtDeduction4) {
		this.txtDeduction4 = txtDeduction4;
	}
	
	/**
	 * @return txtDeduction5
	 */
	public String getTxtDeduction5() {
		return txtDeduction5;
	}
	
	/**
	 * @param txtDeduction5 セットする txtDeduction5
	 */
	public void setTxtDeduction5(String txtDeduction5) {
		this.txtDeduction5 = txtDeduction5;
	}
	
	/**
	 * @return txtDeduction6
	 */
	public String getTxtDeduction6() {
		return txtDeduction6;
	}
	
	/**
	 * @param txtDeduction6 セットする txtDeduction6
	 */
	public void setTxtDeduction6(String txtDeduction6) {
		this.txtDeduction6 = txtDeduction6;
	}
	
	/**
	 * @return txtDeduction7
	 */
	public String getTxtDeduction7() {
		return txtDeduction7;
	}
	
	/**
	 * @param txtDeduction7 セットする txtDeduction7
	 */
	public void setTxtDeduction7(String txtDeduction7) {
		this.txtDeduction7 = txtDeduction7;
	}
	
	/**
	 * @return txtDeduction8
	 */
	public String getTxtDeduction8() {
		return txtDeduction8;
	}
	
	/**
	 * @param txtDeduction8 セットする txtDeduction8
	 */
	public void setTxtDeduction8(String txtDeduction8) {
		this.txtDeduction8 = txtDeduction8;
	}
	
	/**
	 * @return txtDeduction9
	 */
	public String getTxtDeduction9() {
		return txtDeduction9;
	}
	
	/**
	 * @param txtDeduction9 セットする txtDeduction9
	 */
	public void setTxtDeduction9(String txtDeduction9) {
		this.txtDeduction9 = txtDeduction9;
	}
	
	/**
	 * @return txtDeduction10
	 */
	public String getTxtDeduction10() {
		return txtDeduction10;
	}
	
	/**
	 * @param txtDeduction10 セットする txtDeduction10
	 */
	public void setTxtDeduction10(String txtDeduction10) {
		this.txtDeduction10 = txtDeduction10;
	}
	
	/**
	 * @return txtDeduction11
	 */
	public String getTxtDeduction11() {
		return txtDeduction11;
	}
	
	/**
	 * @param txtDeduction11 セットする txtDeduction11
	 */
	public void setTxtDeduction11(String txtDeduction11) {
		this.txtDeduction11 = txtDeduction11;
	}
	
	/**
	 * @return txtDeduction12
	 */
	public String getTxtDeduction12() {
		return txtDeduction12;
	}
	
	/**
	 * @param txtDeduction12 セットする txtDeduction12
	 */
	public void setTxtDeduction12(String txtDeduction12) {
		this.txtDeduction12 = txtDeduction12;
	}
	
	/**
	 * @return txtDeduction13
	 */
	public String getTxtDeduction13() {
		return txtDeduction13;
	}
	
	/**
	 * @param txtDeduction13 セットする txtDeduction13
	 */
	public void setTxtDeduction13(String txtDeduction13) {
		this.txtDeduction13 = txtDeduction13;
	}
	
	/**
	 * @return txtDeduction14
	 */
	public String getTxtDeduction14() {
		return txtDeduction14;
	}
	
	/**
	 * @param txtDeduction14 セットする txtDeduction14
	 */
	public void setTxtDeduction14(String txtDeduction14) {
		this.txtDeduction14 = txtDeduction14;
	}
	
	/**
	 * @return txtDeduction15
	 */
	public String getTxtDeduction15() {
		return txtDeduction15;
	}
	
	/**
	 * @param txtDeduction15 セットする txtDeduction15
	 */
	public void setTxtDeduction15(String txtDeduction15) {
		this.txtDeduction15 = txtDeduction15;
	}
	
	/**
	 * @return txtDeduction16
	 */
	public String getTxtDeduction16() {
		return txtDeduction16;
	}
	
	/**
	 * @param txtDeduction16 セットする txtDeduction16
	 */
	public void setTxtDeduction16(String txtDeduction16) {
		this.txtDeduction16 = txtDeduction16;
	}
	
	/**
	 * @return txtDeduction17
	 */
	public String getTxtDeduction17() {
		return txtDeduction17;
	}
	
	/**
	 * @param txtDeduction17 セットする txtDeduction17
	 */
	public void setTxtDeduction17(String txtDeduction17) {
		this.txtDeduction17 = txtDeduction17;
	}
	
	/**
	 * @return txtDeduction18
	 */
	public String getTxtDeduction18() {
		return txtDeduction18;
	}
	
	/**
	 * @param txtDeduction18 セットする txtDeduction18
	 */
	public void setTxtDeduction18(String txtDeduction18) {
		this.txtDeduction18 = txtDeduction18;
	}
	
	/**
	 * @return txtDeduction19
	 */
	public String getTxtDeduction19() {
		return txtDeduction19;
	}
	
	/**
	 * @param txtDeduction19 セットする txtDeduction19
	 */
	public void setTxtDeduction19(String txtDeduction19) {
		this.txtDeduction19 = txtDeduction19;
	}
	
	/**
	 * @return txtDeduction20
	 */
	public String getTxtDeduction20() {
		return txtDeduction20;
	}
	
	/**
	 * @param txtDeduction20 セットする txtDeduction20
	 */
	public void setTxtDeduction20(String txtDeduction20) {
		this.txtDeduction20 = txtDeduction20;
	}
	
	/**
	 * @return aryTimesSpecialLeaveId
	 */
	public long[] getAryTimesSpecialLeaveId() {
		return aryTimesSpecialLeaveId;
	}
	
	/**
	 * @param aryTimesSpecialLeaveId セットする aryTimesSpecialLeaveId
	 */
	public void setAryTimesSpecialLeaveId(long[] aryTimesSpecialLeaveId) {
		this.aryTimesSpecialLeaveId = aryTimesSpecialLeaveId;
	}
	
	/**
	 * @return aryTimesOtherVacation
	 */
	public long[] getAryTimesOtherVacationId() {
		return aryTimesOtherVacationId;
	}
	
	/**
	 * @param aryTimesOtherVacationId セットする aryTimesOtherVacationId
	 */
	public void setAryTimesOtherVacationId(long[] aryTimesOtherVacationId) {
		this.aryTimesOtherVacationId = aryTimesOtherVacationId;
	}
	
	/**
	 * @return aryDeduction
	 */
	public long[] getAryDeductionId() {
		return aryDeductionId;
	}
	
	/**
	 * @param aryDeductionId セットする aryDeductionId
	 */
	public void setAryDeductionId(long[] aryDeductionId) {
		this.aryDeductionId = aryDeductionId;
	}
	
}
