/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.TotalTimeCorrectionReferenceBeanInterface;
import jp.mosp.time.dao.settings.TotalTimeCorrectionDaoInterface;
import jp.mosp.time.dto.settings.TotalTimeCorrectionDtoInterface;

/**
 * 勤怠集計修正情報参照クラス。
 */
public class TotalTimeCorrectionReferenceBean extends PlatformBean implements TotalTimeCorrectionReferenceBeanInterface {
	
	/**
	 * 勤怠データ修正情報DAOクラス。<br>
	 */
	TotalTimeCorrectionDaoInterface	dao;
	

	/**
	 * {@link PlatformBean#PlatformBean()}を実行する。<br>
	 */
	public TotalTimeCorrectionReferenceBean() {
		super();
	}
	
	/**
	 * {@link PlatformBean#PlatformBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	public TotalTimeCorrectionReferenceBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		dao = (TotalTimeCorrectionDaoInterface)createDao(TotalTimeCorrectionDaoInterface.class);
	}
	
	@Override
	public TotalTimeCorrectionDtoInterface getLatestTotalTimeCorrectionInfo(String personalId, int calculationYear,
			int calculationMonth) throws MospException {
		return dao.findForKey(personalId, calculationYear, calculationMonth);
	}
	
	@Override
	public List<TotalTimeCorrectionDtoInterface> getTotalTimeCorrectionHistory(String personalId, int calculationYear,
			int calculationMonth) throws MospException {
		return dao.findForHistory(personalId, calculationYear, calculationMonth);
	}
	
}
