/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.constant.MospConst;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.constant.TimeConst;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;

/**
 * 休暇データ参照クラス。
 */
public class HolidayInfoReferenceBean extends PlatformBean implements HolidayInfoReferenceBeanInterface {
	
	/**
	 * 休暇データDAO。
	 */
	private HolidayDataDaoInterface					dao;
	
	/**
	 * 休暇申請参照。
	 */
	private HolidayRequestReferenceBeanInterface	holidayRequest;
	

	/**
	 * {@link PlatformBean#PlatformBean()}を実行する。<br>
	 */
	public HolidayInfoReferenceBean() {
		super();
	}
	
	/**
	 * {@link PlatformBean#PlatformBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosP処理情報
	 * @param connection DBコネクション
	 */
	public HolidayInfoReferenceBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		dao = (HolidayDataDaoInterface)createDao(HolidayDataDaoInterface.class);
		holidayRequest = (HolidayRequestReferenceBeanInterface)createBean(HolidayRequestReferenceBeanInterface.class);
	}
	
	@Override
	public List<HolidayDataDtoInterface> getHolidayInfo(String personalId, Date targetDate, int holidayType)
			throws MospException {
		List<HolidayDataDtoInterface> list = new ArrayList<HolidayDataDtoInterface>();
		List<HolidayDataDtoInterface> holidayDataList = dao.findForInfoList(personalId, targetDate, String
			.valueOf(MospConst.DELETE_FLAG_OFF), holidayType);
		for (HolidayDataDtoInterface holidayDataDto : holidayDataList) {
			Map<String, Object> map = holidayRequest.getRequestDayHour(personalId, holidayDataDto.getActivateDate(),
					holidayType, holidayDataDto.getHolidayCode(), holidayDataDto.getActivateDate(), holidayDataDto
						.getHolidayLimitDate());
			double requestDay = ((Double)map.get(TimeConst.CODE_REQUEST_DAY)).doubleValue();
			if (holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay() - requestDay > 0) {
				holidayDataDto.setCancelDay(holidayDataDto.getCancelDay() + requestDay);
				list.add(holidayDataDto);
			}
		}
		return list;
	}
	
	@Override
	public HolidayDataDtoInterface getHolidayPossibleRequest(String personalId, Date targetDate, String holidayCode,
			int holidayType) throws MospException {
		List<HolidayDataDtoInterface> list = dao.findForEarliestList(personalId, targetDate, holidayCode, holidayType);
		for (HolidayDataDtoInterface holidayDataDto : list) {
			Map<String, Object> map = holidayRequest.getRequestDayHour(personalId, holidayDataDto.getActivateDate(),
					holidayType, holidayCode, holidayDataDto.getActivateDate(), holidayDataDto.getHolidayLimitDate());
			double requestDay = ((Double)map.get(TimeConst.CODE_REQUEST_DAY)).doubleValue();
			if (holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay() - requestDay > 0) {
				holidayDataDto.setCancelDay(holidayDataDto.getCancelDay() + requestDay);
				return holidayDataDto;
			}
		}
		return null;
	}
	
}
