/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.CutoffSearchBeanInterface;
import jp.mosp.time.dao.settings.CutoffDaoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;

/**
 * 締日管理検索クラス。
 */
public class CutoffSearchBean extends PlatformBean implements CutoffSearchBeanInterface {
	
	/**
	 * 締日管理DAO
	 */
	private CutoffDaoInterface	cutoffDao;
	
	/**
	 * 有効日。
	 */
	private Date				activateDate;
	
	/**
	 * 締日コード
	 */
	private String				cutoffCode;
	
	/**
	 * 締日名称。
	 */
	private String				cutoffName;
	
	/**
	 * 締日略称。
	 */
	private String				cutoffAbbr;
	
	/**
	 * 締日。
	 */
	private String				cutoffDate;
	
	/**
	 * 未承認仮締。
	 */
	private String				noApproval;
	
	/**
	 * 有効無効フラグ。
	 */
	private String				inactivateFlag;
	

	/**
	 * コンストラクタ。
	 */
	public CutoffSearchBean() {
		// 処理無し
	}
	
	/**
	 * コンストラクタ。
	 * @param mospParams MosPパラメータクラス。
	 * @param connection DBコネクション。
	 */
	public CutoffSearchBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	public void initBean() throws MospException {
		// 締日管理マスタDAO取得
		cutoffDao = (CutoffDaoInterface)createDao(CutoffDaoInterface.class);
	}
	
	public List<CutoffDtoInterface> getSearchList() throws MospException {
		// Mapに検索条件を設定
		Map<String, Object> param = cutoffDao.getParamsMap();
		param.put("activateDate", activateDate);
		param.put("cutoffCode", cutoffCode);
		param.put("cutoffName", cutoffName);
		param.put("cutoffAbbr", cutoffAbbr);
		param.put("cutoffDate", cutoffDate);
		param.put("noApproval", noApproval);
		param.put("inactivateFlag", inactivateFlag);
		// 検索
		return cutoffDao.findForSearch(param);
	}
	
	public void setActivateDate(Date activateDate) {
		this.activateDate = getDateClone(activateDate);
	}
	
	public void setCutoffCode(String cutoffCode) {
		this.cutoffCode = cutoffCode;
	}
	
	public void setCutoffName(String cutoffName) {
		this.cutoffName = cutoffName;
	}
	
	public void setCutoffAbbr(String cutoffAbbr) {
		this.cutoffAbbr = cutoffAbbr;
	}
	
	public void setCutoffDate(String cutoffDate) {
		this.cutoffDate = cutoffDate;
	}
	
	public void setInactivateFlag(String inactivateFlag) {
		this.inactivateFlag = inactivateFlag;
	}
	
	@Override
	public void setNoApproval(String noApproval) {
		this.noApproval = noApproval;
	}
}
