/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.AttendanceCorrectionRegistBeanInterface;
import jp.mosp.time.constant.TimeConst;
import jp.mosp.time.dao.settings.AttendanceCorrectionDaoInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.GoOutDaoInterface;
import jp.mosp.time.dao.settings.RestDaoInterface;
import jp.mosp.time.dto.settings.AllowanceDtoInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdAttendanceCorrectionDto;

/**
 * 勤怠データ修正情報登録クラス。
 */
public class AttendanceCorrectionRegistBean extends PlatformBean implements AttendanceCorrectionRegistBeanInterface {
	
	/**
	 * 勤怠修正データDAOクラス。<br>
	 */
	AttendanceCorrectionDaoInterface	attendanceCorrectionDao;
	
	/**
	 * 勤怠データDAOクラス。<br>
	 */
	AttendanceDaoInterface				attendanceDao;
	
	/**
	 * 勤怠データDAOクラス。<br>
	 */
	RestDaoInterface					restDao;
	
	/**
	 * 休出DAOクラス。<br>
	 */
	GoOutDaoInterface					goOutDao;
	

	/**
	 * 勤怠データAOクラス。<br>
	 */
	
	/**
	 * {@link PlatformBean#PlatformBean()}を実行する。<br>
	 */
	public AttendanceCorrectionRegistBean() {
		super();
	}
	
	/**
	 * {@link PlatformBean#PlatformBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	public AttendanceCorrectionRegistBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		attendanceCorrectionDao = (AttendanceCorrectionDaoInterface)createDao(AttendanceCorrectionDaoInterface.class);
		attendanceDao = (AttendanceDaoInterface)createDao(AttendanceDaoInterface.class);
		restDao = (RestDaoInterface)createDao(RestDaoInterface.class);
		goOutDao = (GoOutDaoInterface)createDao(GoOutDaoInterface.class);
		
	}
	
	@Override
	public AttendanceCorrectionDtoInterface getInitDto() {
		return new TmdAttendanceCorrectionDto();
	}
	
	@Override
	public void insert(AttendanceCorrectionDtoInterface dto) {
		// 現在使用しないメソッド
	}
	
	@Override
	public void update(AttendanceCorrectionDtoInterface dto) {
		// TODO 自動生成されたメソッド・スタブ
	}
	
	@Override
	public void insertAttendance(AttendanceCorrectionDtoInterface dto, AttendanceDtoInterface oldAttendanceDto,
			AttendanceDtoInterface newAttendanceDto) throws MospException {
		// DTOの妥当性確認
		validate(dto);
		// 変更部分の検索
		List<AttendanceCorrectionDtoInterface> list = setChangePointAttendance(dto, oldAttendanceDto, newAttendanceDto);
		for (int i = 0; i < list.size(); i++) {
			// 勤怠情報設定
			setValueAttendanceCorrection(dto, list.get(i));
			// 
			if (mospParams.hasErrorMessage()) {
				return;
			}
			// ロック対象テーブルの追加
			addTargetTable(attendanceCorrectionDao.getTable(attendanceCorrectionDao.getClass()), true);
			// ロック開始
			lockTables();
			if (mospParams.hasErrorMessage()) {
				// ロック解除
				unLockTable();
				return;
			}
			// レコード識別ID最大値をインクリメントしてDTOに設定
			dto.setTmdAttendanceCorrectionId(findForMaxId(attendanceCorrectionDao) + 1);
			// 登録処理
			attendanceCorrectionDao.insert(dto);
			// ロック解除
			unLockTable();
		}
	}
	
	@Override
	public void insertAllowance(AttendanceCorrectionDtoInterface dto, AllowanceDtoInterface oldAllowanceDto,
			AllowanceDtoInterface newAllowanceDto) throws MospException {
		// DTOの妥当性確認
		validate(dto);
		// 変更部分の検索
		AttendanceCorrectionDtoInterface newAttendanceCorrection = setChangePointAllowance(dto, oldAllowanceDto,
				newAllowanceDto);
		// 勤怠情報設定
		setValueAttendanceCorrection(dto, newAttendanceCorrection);
		// 
		if (mospParams.hasErrorMessage()) {
			return;
		}
		// ロック対象テーブルの追加
		addTargetTable(attendanceCorrectionDao.getTable(attendanceCorrectionDao.getClass()), true);
		// ロック開始
		lockTables();
		if (mospParams.hasErrorMessage()) {
			// ロック解除
			unLockTable();
			return;
		}
		// レコード識別ID最大値をインクリメントしてDTOに設定
		dto.setTmdAttendanceCorrectionId(findForMaxId(attendanceCorrectionDao) + 1);
		// 登録処理
		attendanceCorrectionDao.insert(dto);
		// ロック解除
		unLockTable();
	}
	
	@Override
	public void insertRest(AttendanceCorrectionDtoInterface dto, RestDtoInterface oldRestDto,
			RestDtoInterface newRestDto) throws MospException {
		// DTOの妥当性確認
		validate(dto);
		// 変更部分の検索
		AttendanceCorrectionDtoInterface newAttendanceCorrection = setChangePointRest(dto, oldRestDto, newRestDto);
		// 勤怠情報設定
		setValueAttendanceCorrection(dto, newAttendanceCorrection);
		// 
		if (mospParams.hasErrorMessage()) {
			return;
		}
		// ロック対象テーブルの追加
		addTargetTable(attendanceCorrectionDao.getTable(attendanceCorrectionDao.getClass()), true);
		// ロック開始
		lockTables();
		if (mospParams.hasErrorMessage()) {
			// ロック解除
			unLockTable();
			return;
		}
		// レコード識別ID最大値をインクリメントしてDTOに設定
		dto.setTmdAttendanceCorrectionId(findForMaxId(attendanceCorrectionDao) + 1);
		// 登録処理
		attendanceCorrectionDao.insert(dto);
		// ロック解除
		unLockTable();
	}
	
	public void insertaGoOut(AttendanceCorrectionDtoInterface dto, GoOutDtoInterface oldGoOutDto,
			GoOutDtoInterface newGoOutDto) throws MospException {
		// DTOの妥当性確認
		validate(dto);
		// 変更部分の検索
		AttendanceCorrectionDtoInterface newAttendanceCorrection = setChangePointGoOut(dto, oldGoOutDto, newGoOutDto);
		// 勤怠情報設定
		setValueAttendanceCorrection(dto, newAttendanceCorrection);
		// 
		if (mospParams.hasErrorMessage()) {
			return;
		}
		// ロック対象テーブルの追加
		addTargetTable(attendanceCorrectionDao.getTable(attendanceCorrectionDao.getClass()), true);
		// ロック開始
		lockTables();
		if (mospParams.hasErrorMessage()) {
			// ロック解除
			unLockTable();
			return;
		}
		// レコード識別ID最大値をインクリメントしてDTOに設定
		dto.setTmdAttendanceCorrectionId(findForMaxId(attendanceCorrectionDao) + 1);
		// 登録処理
		attendanceCorrectionDao.insert(dto);
		// ロック解除
		unLockTable();
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param dto 対象DTO
	 */
	protected void validate(AttendanceCorrectionDtoInterface dto) {
		// TODO 保留
	}
	
	/**
	 * 修正前/修正後のDTOを見て修正コメントを作成する。
	 * @param dto 対象DTO
	 * @param oldAttendanceDto 修正前データ
	 * @param newAttendanceDto 修正後データ
	 * @return 修正コメント
	 */
	protected List<AttendanceCorrectionDtoInterface> setChangePointAttendance(AttendanceCorrectionDtoInterface dto,
			AttendanceDtoInterface oldAttendanceDto, AttendanceDtoInterface newAttendanceDto) {
		
		List<AttendanceCorrectionDtoInterface> list = new ArrayList<AttendanceCorrectionDtoInterface>();
		AttendanceCorrectionDtoInterface dto1 = new TmdAttendanceCorrectionDto();
		
		if (oldAttendanceDto == null) {
			// 修正前のデータがNULL（新規登録）ならば修正前データには全て"-"を設定する
			// 勤怠設定
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_WORKTYPECODE);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(newAttendanceDto.getWorkTypeCode());
			list.add(dto1);
			// 出勤時刻
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_STARTTIME);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(DateUtility.getStringTime(newAttendanceDto.getStartTime()));
			list.add(dto1);
			// 退勤時刻
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ENDTIME);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(DateUtility.getStringTime(newAttendanceDto.getEndTime()));
			list.add(dto1);
			// 直行
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTSTART);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getDirectStart()));
			list.add(dto1);
			// 直帰
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTEND);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getDirectEnd()));
			list.add(dto1);
			// 勤怠コメント
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_TIMECOMMENT);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getTimeComment()));
			list.add(dto1);
			// 遅刻理由
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATEREASON);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(newAttendanceDto.getLateReason());
			list.add(dto1);
			// 遅刻証明書
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECERTIFICATE);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLateCertificate()));
			list.add(dto1);
			// 遅刻コメント
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECERTIFICATE);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLateComment()));
			list.add(dto1);
			// 早退理由
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYREASON);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(newAttendanceDto.getLeaveEarlyReason());
			list.add(dto1);
			// 早退証明書
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCERTIFICATE);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLeaveEarlyCertificate()));
			list.add(dto1);
			// 早退コメント
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCOMMENT);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLeaveEarlyComment()));
			list.add(dto1);
			// 一つでもNULLが存在したら修正前データには全て"-"を設定する
		} else if (oldAttendanceDto.getWorkTypeCode() == null || oldAttendanceDto.getStartTime() == null
				|| oldAttendanceDto.getEndTime() == null || oldAttendanceDto.getTimeComment() == null
				|| oldAttendanceDto.getLateReason() == null || oldAttendanceDto.getLateComment() == null
				|| oldAttendanceDto.getLeaveEarlyReason() == null || oldAttendanceDto.getLeaveEarlyComment() == null) {
			// 勤怠設定
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_WORKTYPECODE);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(newAttendanceDto.getWorkTypeCode());
			list.add(dto1);
			// 出勤時刻
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_STARTTIME);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(DateUtility.getStringTime(newAttendanceDto.getStartTime()));
			list.add(dto1);
			// 退勤時刻
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ENDTIME);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(DateUtility.getStringTime(newAttendanceDto.getEndTime()));
			list.add(dto1);
			// 直行
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTSTART);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getDirectStart()));
			list.add(dto1);
			// 直帰
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTEND);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getDirectEnd()));
			list.add(dto1);
			// 勤怠コメント
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_TIMECOMMENT);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getTimeComment()));
			list.add(dto1);
			// 遅刻理由
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATEREASON);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(newAttendanceDto.getLateReason());
			list.add(dto1);
			// 遅刻証明書
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECERTIFICATE);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLateCertificate()));
			list.add(dto1);
			// 遅刻コメント
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECOMMENT);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLateComment()));
			list.add(dto1);
			// 早退理由
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYREASON);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(newAttendanceDto.getLeaveEarlyReason());
			list.add(dto1);
			// 早退証明書
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCERTIFICATE);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLeaveEarlyCertificate()));
			list.add(dto1);
			// 早退コメント
			dto1 = new TmdAttendanceCorrectionDto();
			dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCOMMENT);
			dto1.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLeaveEarlyComment()));
			list.add(dto1);
		} else {
			// 勤怠設定
			if (!oldAttendanceDto.getWorkTypeCode().equals(newAttendanceDto.getWorkTypeCode())) {
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_WORKTYPECODE);
				dto1.setCorrectionBefore(oldAttendanceDto.getWorkTypeCode());
				dto1.setCorrectionAfter(newAttendanceDto.getWorkTypeCode());
				list.add(dto1);
			}
			// 出勤時刻
			if (oldAttendanceDto.getStartTime().compareTo(newAttendanceDto.getStartTime()) == 0) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_STARTTIME);
				dto1.setCorrectionBefore(DateUtility.getStringTime(oldAttendanceDto.getStartTime()));
				dto1.setCorrectionAfter(DateUtility.getStringTime(newAttendanceDto.getStartTime()));
				list.add(dto1);
			}
			// 退勤時刻
			if (oldAttendanceDto.getEndTime().compareTo(newAttendanceDto.getEndTime()) == 0) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ENDTIME);
				dto1.setCorrectionBefore(DateUtility.getStringTime(oldAttendanceDto.getEndTime()));
				dto1.setCorrectionAfter(DateUtility.getStringTime(newAttendanceDto.getEndTime()));
				list.add(dto1);
			}
			// 直行
			if (oldAttendanceDto.getDirectStart() != newAttendanceDto.getDirectStart()) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTSTART);
				dto1.setCorrectionBefore(String.valueOf(oldAttendanceDto.getDirectStart()));
				dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getDirectStart()));
				list.add(dto1);
			}
			// 直帰
			if (oldAttendanceDto.getDirectEnd() != newAttendanceDto.getDirectEnd()) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTEND);
				dto1.setCorrectionBefore(String.valueOf(oldAttendanceDto.getDirectEnd()));
				dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getDirectEnd()));
				list.add(dto1);
			}
			// 勤怠コメント
			if (!oldAttendanceDto.getTimeComment().equals(newAttendanceDto.getTimeComment())) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_TIMECOMMENT);
				dto1.setCorrectionBefore(String.valueOf(oldAttendanceDto.getTimeComment()));
				dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getTimeComment()));
				list.add(dto1);
			}
			// 遅刻理由
			if (!oldAttendanceDto.getLateReason().equals(newAttendanceDto.getLateReason())) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATEREASON);
				dto1.setCorrectionBefore(oldAttendanceDto.getLateReason());
				dto1.setCorrectionAfter(newAttendanceDto.getLateReason());
				list.add(dto1);
			}
			// 遅刻証明書
			if (oldAttendanceDto.getLateCertificate() == newAttendanceDto.getLateCertificate()) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECERTIFICATE);
				dto1.setCorrectionBefore(String.valueOf(oldAttendanceDto.getLateCertificate()));
				dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLateCertificate()));
				list.add(dto1);
			}
			// 遅刻コメント
			if (oldAttendanceDto.getLateComment().equals(newAttendanceDto.getLateComment())) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECOMMENT);
				dto1.setCorrectionBefore(String.valueOf(oldAttendanceDto.getLateComment()));
				dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLateComment()));
				list.add(dto1);
			}
			// 早退理由
			if (!oldAttendanceDto.getLeaveEarlyReason().equals(newAttendanceDto.getLeaveEarlyReason())) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYREASON);
				dto1.setCorrectionBefore(oldAttendanceDto.getLeaveEarlyReason());
				dto1.setCorrectionAfter(newAttendanceDto.getLeaveEarlyReason());
				list.add(dto1);
			}
			// 早退証明書
			if (oldAttendanceDto.getLeaveEarlyCertificate() == newAttendanceDto.getLeaveEarlyCertificate()) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCERTIFICATE);
				dto1.setCorrectionBefore(String.valueOf(oldAttendanceDto.getLeaveEarlyCertificate()));
				dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLeaveEarlyCertificate()));
				list.add(dto1);
			}
			// 早退コメント
			if (oldAttendanceDto.getLeaveEarlyComment().equals(newAttendanceDto.getLeaveEarlyComment())) {
				dto1 = new TmdAttendanceCorrectionDto();
				dto1.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCOMMENT);
				dto1.setCorrectionBefore(String.valueOf(oldAttendanceDto.getLeaveEarlyComment()));
				dto1.setCorrectionAfter(String.valueOf(newAttendanceDto.getLeaveEarlyComment()));
				list.add(dto1);
			}
		}
		return list;
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param dto 対象DTO
	 * @param oldAllowanceDto 修正前データ
	 * @param newAllowanceDto 修正後データ
	 * @return 修正コメント
	 */
	protected AttendanceCorrectionDtoInterface setChangePointAllowance(AttendanceCorrectionDtoInterface dto,
			AllowanceDtoInterface oldAllowanceDto, AllowanceDtoInterface newAllowanceDto) {
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO1)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE1);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO2)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE2);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO3)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE3);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO4)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE4);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO5)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE5);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO6)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE6);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO7)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE7);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO8)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE8);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO9)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE9);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INF10)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE10);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		return dto;
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param dto 対象DTO
	 * @param oldRestDto 修正前データ
	 * @param newRestDto 修正後データ
	 * @return 修正コメント
	 */
	protected AttendanceCorrectionDtoInterface setChangePointRest(AttendanceCorrectionDtoInterface dto,
			RestDtoInterface oldRestDto, RestDtoInterface newRestDto) {
		if (oldRestDto.getRestStart() == null) {
			if (newRestDto.getRest() == 1) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK1);
			}
			if (newRestDto.getRest() == 2) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK2);
			}
			if (newRestDto.getRest() == 3) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK3);
			}
			if (newRestDto.getRest() == 4) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK4);
			}
			if (newRestDto.getRest() == 5) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK5);
			}
			if (newRestDto.getRest() == 6) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK6);
			}
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(DateUtility.getStringTime(newRestDto.getRestStart()) + mospParams.getName("Hyphen")
					+ DateUtility.getStringTime(newRestDto.getRestEnd()));
		} else if (oldRestDto.getRestStart() == null) {
			if (newRestDto.getRest() == 1) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK1);
			}
			if (newRestDto.getRest() == 2) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK2);
			}
			if (newRestDto.getRest() == 3) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK3);
			}
			if (newRestDto.getRest() == 4) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK4);
			}
			if (newRestDto.getRest() == 5) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK5);
			}
			if (newRestDto.getRest() == 6) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK6);
			}
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(DateUtility.getStringTime(newRestDto.getRestStart()) + mospParams.getName("Hyphen")
					+ DateUtility.getStringTime(newRestDto.getRestEnd()));
		} else {
			if (newRestDto.getRest() == 1) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK1);
			}
			if (newRestDto.getRest() == 2) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK2);
			}
			if (newRestDto.getRest() == 3) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK3);
			}
			if (newRestDto.getRest() == 4) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK4);
			}
			if (newRestDto.getRest() == 5) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK5);
			}
			if (newRestDto.getRest() == 6) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK6);
			}
			dto.setCorrectionBefore(DateUtility.getStringTime(newRestDto.getRestStart()) + mospParams.getName("Hyphen")
					+ DateUtility.getStringTime(newRestDto.getRestEnd()));
			dto.setCorrectionAfter(DateUtility.getStringTime(newRestDto.getRestStart()) + mospParams.getName("Hyphen")
					+ DateUtility.getStringTime(newRestDto.getRestEnd()));
		}
		return dto;
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param dto 対象DTO
	 * @param oldGoOutDto 旧外出データDTO
	 * @param newGoOutDto 新外出データDTO
	 * @return 変更箇所
	 */
	protected AttendanceCorrectionDtoInterface setChangePointGoOut(AttendanceCorrectionDtoInterface dto,
			GoOutDtoInterface oldGoOutDto, GoOutDtoInterface newGoOutDto) {
		// 公用
		if (newGoOutDto.getGoOutType() == 1) {
			if (newGoOutDto.getTimesGoOut() == 1) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT1);
			}
			if (newGoOutDto.getTimesGoOut() == 2) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT2);
			}
		}
		// 私用
		if (newGoOutDto.getGoOutType() == 2) {
			if (newGoOutDto.getTimesGoOut() == 1) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT1);
			}
			if (newGoOutDto.getTimesGoOut() == 2) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT2);
			}
		}
		if (oldGoOutDto != null) {
			if (oldGoOutDto.getGoOutStart() != null) {
				dto.setCorrectionBefore(DateUtility.getStringTime(oldGoOutDto.getGoOutStart())
						+ mospParams.getName("Hyphen") + DateUtility.getStringTime(oldGoOutDto.getGoOutEnd()));
			} else {
				dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			}
		} else {
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
		}
		dto.setCorrectionAfter(DateUtility.getStringTime(newGoOutDto.getGoOutStart()) + mospParams.getName("Hyphen")
				+ DateUtility.getStringTime(newGoOutDto.getGoOutEnd()));
		return dto;
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param contentsDto 変更内容情報のDTO
	 * @param registerDto 登録用DTO
	 */
	protected void setValueAttendanceCorrection(AttendanceCorrectionDtoInterface contentsDto,
			AttendanceCorrectionDtoInterface registerDto) {
		contentsDto.setCorrectionDate(new Date());
		contentsDto.setCorrectionPersonalId(mospParams.getUser().getPersonalId());
		contentsDto.setCorrectionType(registerDto.getCorrectionType());
		contentsDto.setCorrectionBefore(registerDto.getCorrectionBefore());
		contentsDto.setCorrectionAfter(registerDto.getCorrectionAfter());
	}
}
