/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.bean;

import java.util.Date;
import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.time.dto.settings.ManagementRequestListDtoInterface;

/**
 * 申請検索インターフェース。
 */
public interface RequestSearchBeanInterface extends HumanSearchBeanInterface {
	
	/**
	 * 検索条件から申請リストを取得する。<br><br>
	 * 設定された条件で、検索を行う。
	 * @return 申請リスト
	 * @throws MospException インスタンスの取得、SQLの作成及び実行に失敗した場合
	 */
	List<ManagementRequestListDtoInterface> getSearchList() throws MospException;
	
	/**
	 * @param startDate セットする 開始年月日。
	 */
	void setStartDate(Date startDate);
	
	/**
	 * @param endDate セットする 終了年月日。
	 */
	void setEndDate(Date endDate);
	
	/**
	 * @param approvalType セットする 申請カテゴリ。
	 */
	void setApprovalType(String approvalType);
	
	/**
	 * @param state セットする 状態。
	 */
	void setState(String state);
	
}
