/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.bean;

import jp.mosp.framework.base.MospException;

/**
 * 勤怠一覧登録インターフェース。<br>
 */
public interface AttendanceListRegistBeanInterface {
	
	/**
	 * 一括下書を行う。<br>
	 * @param personalId  個人ID
	 * @param targetDates 対象日配列
	 * @param startTimes  始業時刻配列
	 * @param endTimes    終業時刻配列
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	void draft(String personalId, String[] targetDates, String[] startTimes, String[] endTimes) throws MospException;
	
	/**
	 * 一括申請を行う。<br>
	 * @param personalId  個人ID
	 * @param targetDates 対象日配列
	 * @param startTimes  始業時刻配列
	 * @param endTimes    終業時刻配列
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	void apply(String personalId, String[] targetDates, String[] startTimes, String[] endTimes) throws MospException;
	
}
