/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.dto.human;

import java.util.Date;

import jp.mosp.framework.base.BaseDtoInterface;

/**
 * 人事マスタDTOインターフェース。
 */
public interface HumanDtoInterface extends BaseDtoInterface {
	
	/**
	 * @return レコード識別ID。
	 */
	long getPfmHumanId();
	
	/**
	 * @return 個人ID。
	 */
	String getPersonalId();
	
	/**
	 * @return 有効日。
	 */
	Date getActivateDate();
	
	/**
	 * @return 社員コード。
	 */
	String getEmployeeCode();
	
	/**
	 * @return 姓。
	 */
	String getLastName();
	
	/**
	 * @return 名。
	 */
	String getFirstName();
	
	/**
	 * @return カナ姓。
	 */
	String getLastKana();
	
	/**
	 * @return カナ名。
	 */
	String getFirstKana();
	
	/**
	 * @return 雇用契約コード。
	 */
	String getEmploymentContractCode();
	
	/**
	 * @return 所属コード。
	 */
	String getSectionCode();
	
	/**
	 * @return 職位コード。
	 */
	String getPositionCode();
	
	/**
	 * @return 勤務地コード。
	 */
	String getWorkPlaceCode();
	
	/**
	 * @return メールアドレス。
	 */
	String getMail();
	
	/**
	 * @param pfmHumanId セットする レコード識別ID。
	 */
	void setPfmHumanId(long pfmHumanId);
	
	/**
	 * @param personalId セットする 個人ID。
	 */
	void setPersonalId(String personalId);
	
	/**
	 * @param activateDate セットする 有効日。
	 */
	void setActivateDate(Date activateDate);
	
	/**
	 * @param employeeCode セットする 社員コード。
	 */
	void setEmployeeCode(String employeeCode);
	
	/**
	 * @param lastName セットする 姓。
	 */
	void setLastName(String lastName);
	
	/**
	 * @param firstName セットする 名。
	 */
	void setFirstName(String firstName);
	
	/**
	 * @param lastKana セットする カナ姓。
	 */
	void setLastKana(String lastKana);
	
	/**
	 * @param firstKana セットする カナ名。
	 */
	void setFirstKana(String firstKana);
	
	/**
	 * @param employmentContractCode セットする 雇用契約コード。
	 */
	void setEmploymentContractCode(String employmentContractCode);
	
	/**
	 * @param sectionCode セットする 所属コード。
	 */
	void setSectionCode(String sectionCode);
	
	/**
	 * @param positionCode セットする 職位コード。
	 */
	void setPositionCode(String positionCode);
	
	/**
	 * @param workPlaceCode セットする 勤務地コード。
	 */
	void setWorkPlaceCode(String workPlaceCode);
	
	/**
	 * @param mail セットする メールアドレス。
	 */
	void setMail(String mail);
	
}
