/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.List;

import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;

/**
 * ワークフロー参照クラス。
 */
public class WorkflowReferenceBean extends PlatformBean implements WorkflowReferenceBeanInterface {
	
	/**
	 * ワークフローDAOクラス。<br>
	 */
	private WorkflowDaoInterface	dao;
	

	/**
	 * {@link PlatformBean#PlatformBean()}を実行する。<br>
	 */
	public WorkflowReferenceBean() {
		super();
	}
	
	/**
	 * {@link PlatformBean#PlatformBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	public WorkflowReferenceBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		// DAO準備
		dao = (WorkflowDaoInterface)createDao(WorkflowDaoInterface.class);
	}
	
	@Override
	public WorkflowDtoInterface getLatestWorkflowInfo(long workflow) throws MospException {
		return dao.findForKey(workflow);
	}
	
	@Override
	public List<WorkflowDtoInterface> getListForApproverId(String functionCode, String approverId) throws MospException {
		return dao.findForApproverId(functionCode, approverId);
	}
	
	@Override
	public List<WorkflowDtoInterface> getListForRoute(int workflowStage, String workflowStatus, String routeCode,
			String functionCode) throws MospException {
		return dao.findForRoute(workflowStage, workflowStatus, routeCode, functionCode);
	}
	
	@Override
	public List<WorkflowDtoInterface> getListForRoute(String workflowStatus, String routeCode, String functionCode)
			throws MospException {
		return dao.findForRoute(workflowStatus, routeCode, functionCode);
	}
	
	@Override
	public WorkflowDtoInterface findForId(long id) throws MospException {
		BaseDtoInterface baseDto = findForKey(dao, id, false);
		if (baseDto != null) {
			return (WorkflowDtoInterface)baseDto;
		}
		return null;
	}
	
}
