/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.bean.file.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.SectionImportBeanInterface;
import jp.mosp.platform.bean.system.impl.SectionRegistBean;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.system.constant.PlatformSystemConst;

/**
 * 所属マスタインポートクラス。
 */
public class SectionImportBean extends SectionRegistBean implements SectionImportBeanInterface {
	
	/**
	 * 所属情報リスト。<br>
	 */
	protected List<SectionDtoInterface>	sectionList;
	

	/**
	 * {@link PlatformBean#PlatformBean()}を実行する。<br>
	 */
	public SectionImportBean() {
		super();
	}
	
	/**
	 * {@link PlatformBean#PlatformBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	public SectionImportBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		super.initBean();
	}
	
	@Override
	public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
		// TODO 当メソッドは全て仮処理
		// ファイルパス宣言
		String filePath = "C:\\section.csv";
		// アップロードファイルを登録情報リストに変換
		List<String[]> dataList;
		try {
			dataList = OrangeSignalUtility.parse(new FileInputStream(filePath));
		} catch (FileNotFoundException e) {
			throw new MospException(e);
		}
		sectionList = new ArrayList<SectionDtoInterface>();
		// 登録情報リスト毎に処理
		for (int i = 0; i < dataList.size(); i++) {
			// 登録情報取得
			String[] data = dataList.get(i);
			// 所属情報取得及び確認
			SectionDtoInterface sectionDto = getSectionDto(null, data, i);
			if (sectionDto != null) {
				// 所属情報リストに追加
				sectionList.add(sectionDto);
			}
		}
		// 経路設定(全て新規と考えて)
		for (SectionDtoInterface sectionDto : sectionList) {
			// 経路設定
			sectionDto.setClassRoute(PlatformSystemConst.SEPARATOR_CLASS_ROUTE);
			// 上位所属コード取得
			String upperSection = getUpperSection(sectionDto.getSectionCode(), dataList);
			while (upperSection.isEmpty() == false) {
				// 経路追加
				sectionDto.setClassRoute(PlatformSystemConst.SEPARATOR_CLASS_ROUTE + upperSection
						+ sectionDto.getClassRoute());
				upperSection = getUpperSection(upperSection, dataList);
			}
			
		}
		// エラー確認
		if (mospParams.hasErrorMessage()) {
			return 0;
		}
		// 人事マスタ情報毎に登録
		for (int i = 0; i < sectionList.size(); i++) {
			// ユーザ情報登録
			registSectionDto(sectionList.get(i));
		}
		// 登録件数取得
		return sectionList.size();
		
	}
	
	/**
	 * 登録情報リストから対象所属の上位所属コードを取得する。<br>
	 * @param sectionCode 対象所属コード
	 * @param dataList    登録情報リスト
	 * @return 上位所属コード
	 */
	private String getUpperSection(String sectionCode, List<String[]> dataList) {
		for (String[] data : dataList) {
			if (sectionCode.equals(data[1])) {
				return data[6];
			}
		}
		return "";
	}
	
	/**
	 * 所属情報を取得する。<br>
	 * インポートフィールド情報リストに従い、登録情報リストから所属情報に変換する。<br>
	 * インポート不能登録情報が存在した場合は、MosP処理情報にエラーメッセージを残す。<br>
	 * インポート不能登録情報の場合は、nullを返す。<br>
	 * @param fieldList インポートフィールド情報リスト
	 * @param data      登録情報
	 * @param row       行インデックス
	 * @return 所属情報
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected SectionDtoInterface getSectionDto(List<ImportFieldDtoInterface> fieldList, String[] data, int row)
			throws MospException {
		// TODO 登録情報の内容を取得(登録情報に含まれない場合はnull)
		/*
		String sectionCode = getFieldValue(PlatformFileConst.FIELD_USER_ID, fieldList, data);
		Date activateDate = getDateFieldValue(PlatformFileConst.FIELD_ACTIVATE_DATE, fieldList, data);
		String sectionName = getFieldValue(PlatformFileConst.FIELD_USER_ID, fieldList, data);
		String sectionAbbr = getFieldValue(PlatformFileConst.FIELD_USER_ID, fieldList, data);
		String sectionDisplay = getFieldValue(PlatformFileConst.FIELD_USER_ID, fieldList, data);
		String upperSection = getFieldValue(PlatformFileConst.FIELD_USER_ID, fieldList, data);
		String classRoute = "";
		*/
		String sectionCode = data[1];
		Date activateDate = getDate(data[0]);
		String sectionName = data[5];
		String sectionAbbr = data[3];
		String sectionDisplay = data[4];
		// 略称調整
		// TODO 削除する
		if (sectionAbbr.length() > LEN_SECTION_ABBR) {
			String[] array = sectionAbbr.split(" ");
			sectionAbbr = array[array.length - 1];
			if (sectionAbbr.length() > LEN_SECTION_ABBR) {
				sectionAbbr = sectionAbbr.substring(0, LEN_SECTION_ABBR);
			}
		}
		// 所属コード確認
		if (sectionCode == null || sectionCode.isEmpty()) {
			// エラーメッセージ追加
			addRequiredErrorMessage(getNameSectionCode(), Integer.valueOf(row));
			return null;
		}
		// 有効日確認
		if (activateDate == null) {
			// エラーメッセージ追加
			addRequiredErrorMessage(getNameActivateDate(), Integer.valueOf(row));
			return null;
		}
		// 所属情報準備
		SectionDtoInterface section = dao.findForInfo(sectionCode, activateDate);
		// 所属情報確認
		if (section == null) {
			section = getInitDto();
		}
		// 所属情報に登録情報の内容を設定
		section.setSectionCode(sectionCode);
		section.setActivateDate(activateDate);
		if (sectionName != null) {
			section.setSectionName(sectionName);
		} else if (section.getSectionName() == null) {
			section.setSectionName("");
		}
		if (sectionAbbr != null) {
			section.setSectionAbbr(sectionAbbr);
		} else if (section.getSectionAbbr() == null) {
			section.setSectionAbbr("");
		}
		if (sectionDisplay != null) {
			section.setSectionDisplay(sectionDisplay);
		} else if (section.getSectionDisplay() == null) {
			section.setSectionDisplay("");
		}
		// THINK 更新で上位所属を変更した場合
		// 入力チェック
		validate(section, Integer.valueOf(row));
		return section;
	}
	
	/**
	 * 所属情報を登録する。<br>
	 * @param section 所属情報
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected void registSectionDto(SectionDtoInterface section) throws MospException {
		// 所属情報確認
		if (section == null) {
			return;
		}
		// 所属情報取得及び確認
		List<SectionDtoInterface> list = dao.findForHistory(section.getSectionCode());
		if (list.isEmpty()) {
			// 新規登録
			insert(section);
			return;
		}
		// 所属情報取得及び確認
		SectionDtoInterface dto = dao.findForKey(section.getSectionCode(), section.getActivateDate());
		if (dto == null) {
			// 履歴追加
			add(section);
			return;
		}
		// 履歴更新
		update(section);
	}
	
}
