/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.orangesignal;

import java.util.List;

import jp.sf.orangesignal.csv.CsvConfig;

/**
 * OrangeSignal処理情報を保持するクラス。<br>
 */
public class OrangeSignalParams {
	
	// TODO 定数は確実に足りません。必要だと思うものは随時追加していってください。
	
	/**
	 * デフォルト文字コード(shift-jis)。
	 */
	public static final String	DEFAULT_ENCODING	= "shift-jis";
	
	/**
	 * 区切り文字。
	 */
	private char				separator;
	
	/**
	 * 囲み文字。
	 */
	private char				quote;
	
	/**
	 * エスケープ文字。
	 */
	private char				escape;
	
	/**
	 * 	空行無視フラグ。 
	 */
	private boolean				ignoreEmptyLines;
	
	/**
	 * 文字コード。<br>
	 */
	private String				encoding;
	
	/**
	 * 出力対象リスト。<br>
	 */
	private List<String[]>		csvDataList;
	

	/**
	 * 各フィールドに初期値を設定する。<br>
	 */
	public OrangeSignalParams() {
		// 区切り文字(,)
		separator = CsvConfig.DEFAULT_SEPARATOR;
		// 囲み文字(")
		quote = CsvConfig.DEFAULT_QUOTE;
		// エスケープ文字(\)
		escape = CsvConfig.DEFAULT_ESCAPE;
		// 文字コード
		encoding = DEFAULT_ENCODING;
		// 空行無視フラグ(空行無視)
		ignoreEmptyLines = true;
	}
	
	/**
	 * @return separator
	 */
	public char getSeparator() {
		return separator;
	}
	
	/**
	 * @param separator セットする separator
	 */
	public void setSeparator(char separator) {
		this.separator = separator;
	}
	
	/**
	 * @return quote
	 */
	public char getQuote() {
		return quote;
	}
	
	/**
	 * @param quote セットする quote
	 */
	public void setQuote(char quote) {
		this.quote = quote;
	}
	
	/**
	 * @return escape
	 */
	public char getEscape() {
		return escape;
	}
	
	/**
	 * @param escape セットする escape
	 */
	public void setEscape(char escape) {
		this.escape = escape;
	}
	
	/**
	 * @return ignoreEmptyLines
	 */
	public boolean isIgnoreEmptyLines() {
		return ignoreEmptyLines;
	}
	
	/**
	 * @param ignoreEmptyLines セットする ignoreEmptyLines
	 */
	public void setIgnoreEmptyLines(boolean ignoreEmptyLines) {
		this.ignoreEmptyLines = ignoreEmptyLines;
	}
	
	/**
	 * @return encoding
	 */
	public String getEncoding() {
		return encoding;
	}
	
	/**
	 * @param encoding セットする encoding
	 */
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}
	
	/**
	 * @return csvDataList
	 */
	public List<String[]> getCsvDataList() {
		return csvDataList;
	}
	
	/**
	 * @param csvDataList セットする csvDataList
	 */
	public void setCsvDataList(List<String[]> csvDataList) {
		this.csvDataList = csvDataList;
	}
	
}
