-- 
-- MosP - Mind Open Source Project    http://www.mosp.jp/
-- Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
-- 
-- This program is free software: you can redistribute it and/or
-- modify it under the terms of the GNU Affero General Public License
-- as published by the Free Software Foundation, either version 3
-- of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
-- 
-- Table: tmd_attendance

-- DROP TABLE tmd_attendance;

CREATE TABLE tmd_attendance
(
  tmd_attendance_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  work_date date NOT NULL, -- 勤務日
  times_work integer NOT NULL DEFAULT 0, -- 勤務回数
  work_type_code character varying(20) NOT NULL DEFAULT ''::character varying, -- 勤務形態コード
  direct_start integer NOT NULL DEFAULT 0, -- 直行
  direct_end integer NOT NULL DEFAULT 0, -- 直帰
  start_time timestamp without time zone, -- 出勤時刻
  end_time timestamp without time zone, -- 退勤時刻
  late_time integer NOT NULL DEFAULT 0, -- 遅刻時間
  late_reason character varying(10) NOT NULL DEFAULT ''::character varying, -- 遅刻理由
  late_certificate character varying(10) NOT NULL DEFAULT ''::character varying, -- 遅刻証明書
  late_comment character varying(50) NOT NULL DEFAULT ''::character varying, -- 遅刻コメント
  leave_early_time integer NOT NULL DEFAULT 0, -- 早退時間
  leave_early_reason character varying(10) NOT NULL DEFAULT ''::character varying, -- 早退理由
  leave_early_certificate character varying(10) NOT NULL DEFAULT ''::character varying, -- 早退証明書
  leave_early_comment character varying(50) NOT NULL DEFAULT ''::character varying, -- 早退コメント
  work_time integer NOT NULL DEFAULT 0, -- 勤務時間
  general_work_time integer NOT NULL DEFAULT 0, -- 所定労働時間
  rest_time integer NOT NULL DEFAULT 0, -- 休憩時間
  over_rest_time integer NOT NULL DEFAULT 0, -- 法定外休憩時間
  night_rest_time integer NOT NULL DEFAULT 0, -- 深夜休憩時間
  public_time integer NOT NULL DEFAULT 0, -- 公用外出時間
  private_time integer NOT NULL DEFAULT 0, -- 私用外出時間
  overtime integer NOT NULL DEFAULT 0, -- 残業時間
  overtime_before integer NOT NULL DEFAULT 0, -- 前残業時間
  overtime_after integer NOT NULL DEFAULT 0, -- 後残業時間
  overtime_in integer NOT NULL DEFAULT 0, -- 法定内残業時間
  overtime_out integer NOT NULL DEFAULT 0, -- 法定外残業時間
  late_night_time integer NOT NULL DEFAULT 0, -- 深夜勤務時間
  specific_work_time integer NOT NULL DEFAULT 0, -- 所定休日勤務時間
  legal_work_time integer NOT NULL DEFAULT 0, -- 法定休日勤務時間
  decrease_time integer NOT NULL DEFAULT 0, -- 減額対象時間
  time_comment text NOT NULL DEFAULT ''::character varying, -- 勤怠コメント
  workflow bigint NOT NULL DEFAULT 0, -- ワークフロー番号
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_attendance_pkey PRIMARY KEY (tmd_attendance_id)
)
;
COMMENT ON TABLE tmd_attendance IS '勤怠データ';
COMMENT ON COLUMN tmd_attendance.tmd_attendance_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_attendance.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_attendance.work_date IS '勤務日';
COMMENT ON COLUMN tmd_attendance.times_work IS '勤務回数';
COMMENT ON COLUMN tmd_attendance.work_type_code IS '勤務形態コード';
COMMENT ON COLUMN tmd_attendance.direct_start IS '直行';
COMMENT ON COLUMN tmd_attendance.direct_end IS '直帰';
COMMENT ON COLUMN tmd_attendance.start_time IS '出勤時刻';
COMMENT ON COLUMN tmd_attendance.end_time IS '退勤時刻';
COMMENT ON COLUMN tmd_attendance.late_time IS '遅刻時間';
COMMENT ON COLUMN tmd_attendance.late_reason IS '遅刻理由';
COMMENT ON COLUMN tmd_attendance.late_certificate IS '遅刻証明書';
COMMENT ON COLUMN tmd_attendance.late_comment IS '遅刻コメント';
COMMENT ON COLUMN tmd_attendance.leave_early_time IS '早退時間';
COMMENT ON COLUMN tmd_attendance.leave_early_reason IS '早退理由';
COMMENT ON COLUMN tmd_attendance.leave_early_certificate IS '早退証明書';
COMMENT ON COLUMN tmd_attendance.leave_early_comment IS '早退コメント';
COMMENT ON COLUMN tmd_attendance.work_time IS '勤務時間';
COMMENT ON COLUMN tmd_attendance.general_work_time IS '所定労働時間';
COMMENT ON COLUMN tmd_attendance.rest_time IS '休憩時間';
COMMENT ON COLUMN tmd_attendance.over_rest_time IS '法定外休憩時間';
COMMENT ON COLUMN tmd_attendance.night_rest_time IS '深夜休憩時間';
COMMENT ON COLUMN tmd_attendance.public_time IS '公用外出時間';
COMMENT ON COLUMN tmd_attendance.private_time IS '私用外出時間';
COMMENT ON COLUMN tmd_attendance.overtime IS '残業時間';
COMMENT ON COLUMN tmd_attendance.overtime_before IS '前残業時間';
COMMENT ON COLUMN tmd_attendance.overtime_after IS '後残業時間';
COMMENT ON COLUMN tmd_attendance.overtime_in IS '法定内残業時間';
COMMENT ON COLUMN tmd_attendance.overtime_out IS '法定外残業時間';
COMMENT ON COLUMN tmd_attendance.late_night_time IS '深夜勤務時間';
COMMENT ON COLUMN tmd_attendance.specific_work_time IS '所定休日勤務時間';
COMMENT ON COLUMN tmd_attendance.legal_work_time IS '法定休日勤務時間';
COMMENT ON COLUMN tmd_attendance.decrease_time IS '減額対象時間';
COMMENT ON COLUMN tmd_attendance.time_comment IS '勤怠コメント';
COMMENT ON COLUMN tmd_attendance.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN tmd_attendance.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_attendance.insert_date IS '登録日';
COMMENT ON COLUMN tmd_attendance.insert_user IS '登録者';
COMMENT ON COLUMN tmd_attendance.update_date IS '更新日';
COMMENT ON COLUMN tmd_attendance.update_user IS '更新者';

-- Table: tmd_attendance_correction

-- DROP TABLE tmd_attendance_correction;

CREATE TABLE tmd_attendance_correction
(
  tmd_attendance_correction_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  work_date date NOT NULL, -- 勤務日
  works integer NOT NULL DEFAULT 0, -- 勤務回数
  correction_times integer NOT NULL DEFAULT 0, -- 修正番号
  correction_type character varying(50) NOT NULL DEFAULT ''::character varying, -- 修正箇所
  correction_date timestamp without time zone NOT NULL, -- 修正日時
  correction_personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 修正個人ID
  correction_before text NOT NULL DEFAULT ''::character varying, -- 修正前
  correction_after text NOT NULL DEFAULT ''::character varying, -- 修正後
  correction_reason character varying(50) NOT NULL DEFAULT ''::character varying, -- 修正理由
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_attendance_correction_pkey PRIMARY KEY (tmd_attendance_correction_id)
)
;
COMMENT ON TABLE tmd_attendance_correction IS '勤怠修正データ';
COMMENT ON COLUMN tmd_attendance_correction.tmd_attendance_correction_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_attendance_correction.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_attendance_correction.work_date IS '勤務日';
COMMENT ON COLUMN tmd_attendance_correction.works IS '勤務回数';
COMMENT ON COLUMN tmd_attendance_correction.correction_times IS '修正番号';
COMMENT ON COLUMN tmd_attendance_correction.correction_type IS '修正箇所';
COMMENT ON COLUMN tmd_attendance_correction.correction_date IS '修正日時';
COMMENT ON COLUMN tmd_attendance_correction.correction_personal_id IS '修正個人ID';
COMMENT ON COLUMN tmd_attendance_correction.correction_before IS '修正前';
COMMENT ON COLUMN tmd_attendance_correction.correction_after IS '修正後';
COMMENT ON COLUMN tmd_attendance_correction.correction_reason IS '修正理由';
COMMENT ON COLUMN tmd_attendance_correction.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_attendance_correction.insert_date IS '登録日';
COMMENT ON COLUMN tmd_attendance_correction.insert_user IS '登録者';
COMMENT ON COLUMN tmd_attendance_correction.update_date IS '更新日';
COMMENT ON COLUMN tmd_attendance_correction.update_user IS '更新者';

-- Table: tmd_allowance

-- DROP TABLE tmd_allowance;

CREATE TABLE tmd_allowance
(
  tmd_allowance_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  work_date date NOT NULL, -- 勤務日
  works integer NOT NULL DEFAULT 0, -- 勤務回数
  allowance_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 手当コード
  allowance integer NOT NULL DEFAULT 0, -- 手当
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_allowance_pkey PRIMARY KEY (tmd_allowance_id)
)
;
COMMENT ON TABLE tmd_allowance IS '手当データ';
COMMENT ON COLUMN tmd_allowance.tmd_allowance_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_allowance.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_allowance.work_date IS '勤務日';
COMMENT ON COLUMN tmd_allowance.works IS '勤務回数';
COMMENT ON COLUMN tmd_allowance.allowance_code IS '手当コード';
COMMENT ON COLUMN tmd_allowance.allowance IS '手当';
COMMENT ON COLUMN tmd_allowance.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_allowance.insert_date IS '登録日';
COMMENT ON COLUMN tmd_allowance.insert_user IS '登録者';
COMMENT ON COLUMN tmd_allowance.update_date IS '更新日';
COMMENT ON COLUMN tmd_allowance.update_user IS '更新者';

-- Table: tmd_rest

-- DROP TABLE tmd_rest;

CREATE TABLE tmd_rest
(
  tmd_rest_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  work_date date NOT NULL, -- 勤務日
  times_work integer NOT NULL DEFAULT 0, -- 勤務回数
  rest integer NOT NULL DEFAULT 0, -- 休憩回数
  rest_start timestamp without time zone NOT NULL, -- 休憩開始時刻
  rest_end timestamp without time zone NOT NULL, -- 休憩終了時刻
  rest_time integer NOT NULL DEFAULT 0, -- 休憩時間
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_rest_pkey PRIMARY KEY (tmd_rest_id)
)
;
COMMENT ON TABLE tmd_rest IS '休憩データ';
COMMENT ON COLUMN tmd_rest.tmd_rest_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_rest.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_rest.work_date IS '勤務日';
COMMENT ON COLUMN tmd_rest.times_work IS '勤務回数';
COMMENT ON COLUMN tmd_rest.rest IS '休憩回数';
COMMENT ON COLUMN tmd_rest.rest_start IS '休憩開始時刻';
COMMENT ON COLUMN tmd_rest.rest_end IS '休憩終了時刻';
COMMENT ON COLUMN tmd_rest.rest_time IS '休憩時間';
COMMENT ON COLUMN tmd_rest.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_rest.insert_date IS '登録日';
COMMENT ON COLUMN tmd_rest.insert_user IS '登録者';
COMMENT ON COLUMN tmd_rest.update_date IS '更新日';
COMMENT ON COLUMN tmd_rest.update_user IS '更新者';

-- Table: tmd_go_out

-- DROP TABLE tmd_go_out;

CREATE TABLE tmd_go_out
(
  tmd_go_out_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  work_date date NOT NULL, -- 勤務日
  times_work integer NOT NULL DEFAULT 0, -- 勤務回数
  go_out_type integer NOT NULL DEFAULT 0, -- 外出区分
  times_go_out integer NOT NULL DEFAULT 0, -- 外出回数
  go_out_start timestamp without time zone NOT NULL, -- 外出開始時刻
  go_out_end timestamp without time zone NOT NULL, -- 外出終了時刻
  go_out_time integer NOT NULL DEFAULT 0, -- 外出時間
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_go_out_pkey PRIMARY KEY (tmd_go_out_id)
)
;
COMMENT ON TABLE tmd_go_out IS '外出データ';
COMMENT ON COLUMN tmd_go_out.tmd_go_out_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_go_out.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_go_out.work_date IS '勤務日';
COMMENT ON COLUMN tmd_go_out.times_work IS '勤務回数';
COMMENT ON COLUMN tmd_go_out.go_out_type IS '外出区分';
COMMENT ON COLUMN tmd_go_out.times_go_out IS '外出回数';
COMMENT ON COLUMN tmd_go_out.go_out_start IS '外出開始時刻';
COMMENT ON COLUMN tmd_go_out.go_out_end IS '外出終了時刻';
COMMENT ON COLUMN tmd_go_out.go_out_time IS '外出時間';
COMMENT ON COLUMN tmd_go_out.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_go_out.insert_date IS '登録日';
COMMENT ON COLUMN tmd_go_out.insert_user IS '登録者';
COMMENT ON COLUMN tmd_go_out.update_date IS '更新日';
COMMENT ON COLUMN tmd_go_out.update_user IS '更新者';

-- Table: tmd_total_time

-- DROP TABLE tmd_total_time;

CREATE TABLE tmd_total_time
(
  tmd_total_time_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  calculation_year integer NOT NULL DEFAULT 0, -- 年
  calculation_month integer NOT NULL DEFAULT 0, -- 月
  calculation_date date NOT NULL, -- 集計日
  work_time integer NOT NULL DEFAULT 0, -- 勤務時間
  specific_work_time integer NOT NULL DEFAULT 0, -- 所定勤務時間
  times_work_date double precision NOT NULL DEFAULT 0, -- 出勤日数
  times_work integer NOT NULL DEFAULT 0, -- 出勤回数
  legal_work_on_holiday double precision NOT NULL DEFAULT 0, -- 法定休日出勤日数
  specific_work_on_holiday double precision NOT NULL DEFAULT 0, -- 所定休日出勤日数
  times_achievement integer NOT NULL DEFAULT 0, -- 出勤実績日数
  times_total_work_date integer NOT NULL DEFAULT 0, -- 出勤対象日数
  direct_start integer NOT NULL DEFAULT 0, -- 直行回数
  direct_end integer NOT NULL DEFAULT 0, -- 直帰回数
  rest_time integer NOT NULL DEFAULT 0, -- 休憩時間
  rest_late_night integer NOT NULL DEFAULT 0, -- 深夜休憩時間
  rest_work_on_specific_holiday integer NOT NULL DEFAULT 0, -- 所定休出休憩時間
  rest_work_on_holiday integer NOT NULL DEFAULT 0, -- 法定休出休憩時間
  public_time integer NOT NULL DEFAULT 0, -- 公用外出時間
  private_time integer NOT NULL DEFAULT 0, -- 私用外出時間
  overtime_in integer NOT NULL DEFAULT 0, -- 残業時間
  overtime_out integer NOT NULL DEFAULT 0, -- 法定外残業時間
  late_night integer NOT NULL DEFAULT 0, -- 深夜時間
  work_on_specific_holiday integer NOT NULL DEFAULT 0, -- 所定休出時間
  work_on_holiday integer NOT NULL DEFAULT 0, -- 法定休出時間
  decrease_time integer NOT NULL DEFAULT 0, -- 減額対象時間
  forty_five_hour_overtime integer NOT NULL DEFAULT 0, -- 45時間超残業時間
  times_overtime integer NOT NULL DEFAULT 0, -- 残業回数
  times_working_holiday integer NOT NULL DEFAULT 0, -- 休日出勤回数
  late_days integer NOT NULL DEFAULT 0, -- 遅刻日数
  late_deduction integer NOT NULL DEFAULT 0, -- 遅刻控除有り日数
  late_no_deduction integer NOT NULL DEFAULT 0, -- 遅刻控除無し日数
  late_other integer NOT NULL DEFAULT 0, -- 遅刻その他日数
  late_time integer NOT NULL DEFAULT 0, -- 遅刻時間
  late_deduction_time integer NOT NULL DEFAULT 0, -- 遅刻控除有り時間
  late_no_deduction_time integer NOT NULL DEFAULT 0, -- 遅刻控除無し時間
  late_other_time integer NOT NULL DEFAULT 0, -- 遅刻その他時間
  times_late integer NOT NULL DEFAULT 0, -- 遅刻回数
  leave_early_days integer NOT NULL DEFAULT 0, -- 早退日数
  leave_early_deduction integer NOT NULL DEFAULT 0, -- 早退控除有り日数
  leave_early_no_deduction integer NOT NULL DEFAULT 0, -- 早退控除無し日数
  leave_early_other integer NOT NULL DEFAULT 0, -- 早退その他日数
  leave_early_time integer NOT NULL DEFAULT 0, -- 早退時間
  leave_early_deduction_time integer NOT NULL DEFAULT 0, -- 早退控除有り時間
  leave_early_no_deduction_time integer NOT NULL DEFAULT 0, -- 早退控除無し時間
  leave_early_other_time integer NOT NULL DEFAULT 0, -- 早退その他時間
  times_leave_early integer NOT NULL DEFAULT 0, -- 早退回数
  times_holiday integer NOT NULL DEFAULT 0, -- 休日日数
  times_legal_holiday integer NOT NULL DEFAULT 0, -- 法定休日日数
  times_specific_holiday integer NOT NULL DEFAULT 0, -- 所定休日日数
  times_paid_holiday double precision NOT NULL DEFAULT 0, -- 有給休暇日数
  paid_holiday_hour integer NOT NULL DEFAULT 0, -- 有給休暇時間
  times_stock_holiday double precision NOT NULL DEFAULT 0, -- ストック休暇日数
  times_compensation double precision NOT NULL DEFAULT 0, -- 代休日数
  times_legal_compensation double precision NOT NULL DEFAULT 0, -- 法定代休日数
  times_specific_compensation double precision NOT NULL DEFAULT 0, -- 所定代休日数
  times_late_compensation double precision NOT NULL DEFAULT 0, -- 深夜代休日数
  times_holiday_substitute double precision NOT NULL DEFAULT 0, -- 振替休日日数
  times_legal_holiday_substitute double precision NOT NULL DEFAULT 0, -- 法定振替休日日数
  times_specific_holiday_substitute double precision NOT NULL DEFAULT 0, -- 所定振替休日日数
  total_special_holiday double precision NOT NULL DEFAULT 0, -- 特別休暇合計日数
  total_other_holiday double precision NOT NULL DEFAULT 0, -- その他休暇合計日数
  total_absence double precision NOT NULL DEFAULT 0, -- 欠勤合計日数
  total_allowance integer NOT NULL DEFAULT 0, -- 手当合計
  sixty_hour_overtime integer NOT NULL DEFAULT 0, -- 60時間超残業時間
  week_day_overtime integer NOT NULL DEFAULT 0, -- 平日時間外時間
  specific_overtime integer NOT NULL DEFAULT 0, -- 所定休日時間外時間
  times_alternative double precision NOT NULL DEFAULT 0, -- 代替休暇日数
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_total_time_pkey PRIMARY KEY (tmd_total_time_id)
)
;
COMMENT ON TABLE tmd_total_time IS '勤怠集計データ';
COMMENT ON COLUMN tmd_total_time.tmd_total_time_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_total_time.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_total_time.calculation_year IS '年';
COMMENT ON COLUMN tmd_total_time.calculation_month IS '月';
COMMENT ON COLUMN tmd_total_time.calculation_date IS '集計日';
COMMENT ON COLUMN tmd_total_time.work_time IS '勤務時間';
COMMENT ON COLUMN tmd_total_time.specific_work_time IS '所定勤務時間';
COMMENT ON COLUMN tmd_total_time.times_work_date IS '出勤日数';
COMMENT ON COLUMN tmd_total_time.times_work IS '出勤回数';
COMMENT ON COLUMN tmd_total_time.legal_work_on_holiday IS '法定休日出勤日数';
COMMENT ON COLUMN tmd_total_time.specific_work_on_holiday IS '所定休日出勤日数';
COMMENT ON COLUMN tmd_total_time.times_achievement IS '出勤実績日数';
COMMENT ON COLUMN tmd_total_time.times_total_work_date IS '出勤対象日数';
COMMENT ON COLUMN tmd_total_time.direct_start IS '直行回数';
COMMENT ON COLUMN tmd_total_time.direct_end IS '直帰回数';
COMMENT ON COLUMN tmd_total_time.rest_time IS '休憩時間';
COMMENT ON COLUMN tmd_total_time.rest_late_night IS '深夜休憩時間';
COMMENT ON COLUMN tmd_total_time.rest_work_on_specific_holiday IS '所定休出休憩時間';
COMMENT ON COLUMN tmd_total_time.rest_work_on_holiday IS '法定休出休憩時間';
COMMENT ON COLUMN tmd_total_time.public_time IS '公用外出時間';
COMMENT ON COLUMN tmd_total_time.private_time IS '私用外出時間';
COMMENT ON COLUMN tmd_total_time.overtime_in IS '残業時間';
COMMENT ON COLUMN tmd_total_time.overtime_out IS '法定外残業時間';
COMMENT ON COLUMN tmd_total_time.late_night IS '深夜時間';
COMMENT ON COLUMN tmd_total_time.work_on_specific_holiday IS '所定休出時間';
COMMENT ON COLUMN tmd_total_time.work_on_holiday IS '法定休出時間';
COMMENT ON COLUMN tmd_total_time.decrease_time IS '減額対象時間';
COMMENT ON COLUMN tmd_total_time.forty_five_hour_overtime IS '45時間超残業時間';
COMMENT ON COLUMN tmd_total_time.times_overtime IS '残業回数';
COMMENT ON COLUMN tmd_total_time.times_working_holiday IS '休日出勤回数';
COMMENT ON COLUMN tmd_total_time.late_days IS '遅刻日数';
COMMENT ON COLUMN tmd_total_time.late_deduction IS '遅刻控除有り日数';
COMMENT ON COLUMN tmd_total_time.late_no_deduction IS '遅刻控除無し日数';
COMMENT ON COLUMN tmd_total_time.late_other IS '遅刻その他日数';
COMMENT ON COLUMN tmd_total_time.late_time IS '遅刻時間';
COMMENT ON COLUMN tmd_total_time.late_deduction_time IS '遅刻控除有り時間';
COMMENT ON COLUMN tmd_total_time.late_no_deduction_time IS '遅刻控除無し時間';
COMMENT ON COLUMN tmd_total_time.late_other_time IS '遅刻その他時間';
COMMENT ON COLUMN tmd_total_time.times_late IS '遅刻回数';
COMMENT ON COLUMN tmd_total_time.leave_early_days IS '早退日数';
COMMENT ON COLUMN tmd_total_time.leave_early_deduction IS '早退控除有り日数';
COMMENT ON COLUMN tmd_total_time.leave_early_no_deduction IS '早退控除無し日数';
COMMENT ON COLUMN tmd_total_time.leave_early_other IS '早退その他日数';
COMMENT ON COLUMN tmd_total_time.leave_early_time IS '早退時間';
COMMENT ON COLUMN tmd_total_time.leave_early_deduction_time IS '早退控除有り時間';
COMMENT ON COLUMN tmd_total_time.leave_early_no_deduction_time IS '早退控除無し時間';
COMMENT ON COLUMN tmd_total_time.leave_early_other_time IS '早退その他時間';
COMMENT ON COLUMN tmd_total_time.times_leave_early IS '早退回数';
COMMENT ON COLUMN tmd_total_time.times_holiday IS '休日日数';
COMMENT ON COLUMN tmd_total_time.times_legal_holiday IS '法定休日日数';
COMMENT ON COLUMN tmd_total_time.times_specific_holiday IS '所定休日日数';
COMMENT ON COLUMN tmd_total_time.times_paid_holiday IS '有給休暇日数';
COMMENT ON COLUMN tmd_total_time.paid_holiday_hour IS '有給休暇時間';
COMMENT ON COLUMN tmd_total_time.times_stock_holiday IS 'ストック休暇日数';
COMMENT ON COLUMN tmd_total_time.times_compensation IS '代休日数';
COMMENT ON COLUMN tmd_total_time.times_legal_compensation IS '法定代休日数';
COMMENT ON COLUMN tmd_total_time.times_specific_compensation IS '所定代休日数';
COMMENT ON COLUMN tmd_total_time.times_late_compensation IS '深夜代休日数';
COMMENT ON COLUMN tmd_total_time.times_holiday_substitute IS '振替休日日数';
COMMENT ON COLUMN tmd_total_time.times_legal_holiday_substitute IS '法定振替休日日数';
COMMENT ON COLUMN tmd_total_time.times_specific_holiday_substitute IS '所定振替休日日数';
COMMENT ON COLUMN tmd_total_time.total_special_holiday IS '特別休暇合計日数';
COMMENT ON COLUMN tmd_total_time.total_other_holiday IS 'その他休暇合計日数';
COMMENT ON COLUMN tmd_total_time.total_absence IS '欠勤合計日数';
COMMENT ON COLUMN tmd_total_time.total_allowance IS '手当合計';
COMMENT ON COLUMN tmd_total_time.sixty_hour_overtime IS '60時間超残業時間';
COMMENT ON COLUMN tmd_total_time.week_day_overtime IS '平日時間外時間';
COMMENT ON COLUMN tmd_total_time.specific_overtime IS '所定休日時間外時間';
COMMENT ON COLUMN tmd_total_time.times_alternative IS '代替休暇日数';
COMMENT ON COLUMN tmd_total_time.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_total_time.insert_date IS '登録日';
COMMENT ON COLUMN tmd_total_time.insert_user IS '登録者';
COMMENT ON COLUMN tmd_total_time.update_date IS '更新日';
COMMENT ON COLUMN tmd_total_time.update_user IS '更新者';

-- Table: tmd_total_time_correction

-- DROP TABLE tmd_total_time_correction;

CREATE TABLE tmd_total_time_correction
(
  tmd_total_time_correction_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  calculation_year integer NOT NULL DEFAULT 0, -- 年
  calculation_month integer NOT NULL DEFAULT 0, -- 月
  correction_times integer NOT NULL DEFAULT 0, -- 修正番号
  correction_date timestamp without time zone NOT NULL, -- 修正日時
  correction_personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 修正個人ID
  correction_type character varying(50) NOT NULL DEFAULT ''::character varying, -- 修正箇所
  correction_before text NOT NULL DEFAULT ''::character varying, -- 修正前
  correction_after text NOT NULL DEFAULT ''::character varying, -- 修正後
  correction_reason character varying(50) NOT NULL DEFAULT ''::character varying, -- 修正理由
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_total_time_correction_pkey PRIMARY KEY (tmd_total_time_correction_id)
)
;
COMMENT ON TABLE tmd_total_time_correction IS '勤怠集計修正データ';
COMMENT ON COLUMN tmd_total_time_correction.tmd_total_time_correction_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_total_time_correction.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_total_time_correction.calculation_year IS '年';
COMMENT ON COLUMN tmd_total_time_correction.calculation_month IS '月';
COMMENT ON COLUMN tmd_total_time_correction.correction_times IS '修正番号';
COMMENT ON COLUMN tmd_total_time_correction.correction_date IS '修正日時';
COMMENT ON COLUMN tmd_total_time_correction.correction_personal_id IS '修正個人ID';
COMMENT ON COLUMN tmd_total_time_correction.correction_type IS '修正箇所';
COMMENT ON COLUMN tmd_total_time_correction.correction_before IS '修正前';
COMMENT ON COLUMN tmd_total_time_correction.correction_after IS '修正後';
COMMENT ON COLUMN tmd_total_time_correction.correction_reason IS '修正理由';
COMMENT ON COLUMN tmd_total_time_correction.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_total_time_correction.insert_date IS '登録日';
COMMENT ON COLUMN tmd_total_time_correction.insert_user IS '登録者';
COMMENT ON COLUMN tmd_total_time_correction.update_date IS '更新日';
COMMENT ON COLUMN tmd_total_time_correction.update_user IS '更新者';

-- Table: tmd_total_leave

-- DROP TABLE tmd_total_leave;

CREATE TABLE tmd_total_leave
(
  tmd_total_leave_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  calculation_year integer NOT NULL DEFAULT 0, -- 年
  calculation_month integer NOT NULL DEFAULT 0, -- 月
  holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 休暇コード
  times double precision NOT NULL DEFAULT 0, -- 特別休暇日数
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_total_leave_pkey PRIMARY KEY (tmd_total_leave_id)
)
;
COMMENT ON TABLE tmd_total_leave IS '特別休暇集計データ';
COMMENT ON COLUMN tmd_total_leave.tmd_total_leave_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_total_leave.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_total_leave.calculation_year IS '年';
COMMENT ON COLUMN tmd_total_leave.calculation_month IS '月';
COMMENT ON COLUMN tmd_total_leave.holiday_code IS '休暇コード';
COMMENT ON COLUMN tmd_total_leave.times IS '特別休暇日数';
COMMENT ON COLUMN tmd_total_time.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_total_time.insert_date IS '登録日';
COMMENT ON COLUMN tmd_total_time.insert_user IS '登録者';
COMMENT ON COLUMN tmd_total_time.update_date IS '更新日';
COMMENT ON COLUMN tmd_total_time.update_user IS '更新者';

-- Table: tmd_total_other_vacation

-- DROP TABLE tmd_total_other_vacation;

CREATE TABLE tmd_total_other_vacation
(
  tmd_total_other_vacation_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  calculation_year integer NOT NULL DEFAULT 0, -- 年
  calculation_month integer NOT NULL DEFAULT 0, -- 月
  holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 休暇コード
  times double precision NOT NULL DEFAULT 0, -- その他休暇日数
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_total_other_vacation_pkey PRIMARY KEY (tmd_total_other_vacation_id)
)
;
COMMENT ON TABLE tmd_total_other_vacation IS 'その他休暇集計データ';
COMMENT ON COLUMN tmd_total_other_vacation.tmd_total_other_vacation_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_total_other_vacation.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_total_other_vacation.calculation_year IS '年';
COMMENT ON COLUMN tmd_total_other_vacation.calculation_month IS '月';
COMMENT ON COLUMN tmd_total_other_vacation.holiday_code IS '休暇コード';
COMMENT ON COLUMN tmd_total_other_vacation.times IS 'その他休暇日数';
COMMENT ON COLUMN tmd_total_other_vacation.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_total_other_vacation.insert_date IS '登録日';
COMMENT ON COLUMN tmd_total_other_vacation.insert_user IS '登録者';
COMMENT ON COLUMN tmd_total_other_vacation.update_date IS '更新日';
COMMENT ON COLUMN tmd_total_other_vacation.update_user IS '更新者';

-- Table: tmd_total_absence

-- DROP TABLE tmd_total_absence;

CREATE TABLE tmd_total_absence
(
  tmd_total_absence_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  calculation_year integer NOT NULL DEFAULT 0, -- 年
  calculation_month integer NOT NULL DEFAULT 0, -- 月
  absence_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 欠勤コード
  times double precision NOT NULL DEFAULT 0, -- 欠勤日数
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_total_absence_pkey PRIMARY KEY (tmd_total_absence_id)
)
;
COMMENT ON TABLE tmd_total_absence IS '欠勤集計データ';
COMMENT ON COLUMN tmd_total_absence.tmd_total_absence_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_total_absence.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_total_absence.calculation_year IS '年';
COMMENT ON COLUMN tmd_total_absence.calculation_month IS '月';
COMMENT ON COLUMN tmd_total_absence.absence_code IS '欠勤コード';
COMMENT ON COLUMN tmd_total_absence.times IS '欠勤日数';
COMMENT ON COLUMN tmd_total_absence.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_total_absence.insert_date IS '登録日';
COMMENT ON COLUMN tmd_total_absence.insert_user IS '登録者';
COMMENT ON COLUMN tmd_total_absence.update_date IS '更新日';
COMMENT ON COLUMN tmd_total_absence.update_user IS '更新者';

-- Table: tmd_total_allowance

-- DROP TABLE tmd_total_allowance;

CREATE TABLE tmd_total_allowance
(
  tmd_total_allowance_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  calculation_year integer NOT NULL DEFAULT 0, -- 年
  calculation_month integer NOT NULL DEFAULT 0, -- 月
  allowance_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 手当コード
  times integer NOT NULL DEFAULT 0, -- 手当回数
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_total_allowance_pkey PRIMARY KEY (tmd_total_allowance_id)
)
;
COMMENT ON TABLE tmd_total_allowance IS '手当集計データ';
COMMENT ON COLUMN tmd_total_allowance.tmd_total_allowance_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_total_allowance.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_total_allowance.calculation_year IS '年';
COMMENT ON COLUMN tmd_total_allowance.calculation_month IS '月';
COMMENT ON COLUMN tmd_total_allowance.allowance_code IS '手当コード';
COMMENT ON COLUMN tmd_total_allowance.times IS '手当回数';
COMMENT ON COLUMN tmd_total_allowance.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_total_allowance.insert_date IS '登録日';
COMMENT ON COLUMN tmd_total_allowance.insert_user IS '登録者';
COMMENT ON COLUMN tmd_total_allowance.update_date IS '更新日';
COMMENT ON COLUMN tmd_total_allowance.update_user IS '更新者';

-- Table: tmt_total_time

-- DROP TABLE tmt_total_time;

CREATE TABLE tmt_total_time
(
  tmt_total_time_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  calculation_year integer NOT NULL DEFAULT 0, -- 集計年
  calculation_month integer NOT NULL DEFAULT 0, -- 集計月
  cutoff_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 締日コード
  calculation_date date NOT NULL, -- 集計日
  cutoff_state integer NOT NULL DEFAULT 0, -- 締状態
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmt_total_time_pkey PRIMARY KEY (tmt_total_time_id)
)
;
COMMENT ON TABLE tmt_total_time IS '勤怠集計管理';
COMMENT ON COLUMN tmt_total_time.tmt_total_time_id IS 'レコード識別ID';
COMMENT ON COLUMN tmt_total_time.calculation_year IS '集計年';
COMMENT ON COLUMN tmt_total_time.calculation_month IS '集計月';
COMMENT ON COLUMN tmt_total_time.cutoff_code IS '締日コード';
COMMENT ON COLUMN tmt_total_time.calculation_date IS '集計日';
COMMENT ON COLUMN tmt_total_time.cutoff_state IS '締状態';
COMMENT ON COLUMN tmt_total_time.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmt_total_time.insert_date IS '登録日';
COMMENT ON COLUMN tmt_total_time.insert_user IS '登録者';
COMMENT ON COLUMN tmt_total_time.update_date IS '更新日';
COMMENT ON COLUMN tmt_total_time.update_user IS '更新者';

-- Table: tmt_total_time_employee

-- DROP TABLE tmt_total_time_employee;

CREATE TABLE tmt_total_time_employee
(
  tmt_total_time_employee_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  calculation_year integer NOT NULL DEFAULT 0, -- 集計年
  calculation_month integer NOT NULL DEFAULT 0, -- 集計月
  cutoff_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 締日コード
  calculation_date date NOT NULL, -- 集計日
  cutoff_state integer NOT NULL DEFAULT 0, -- 締状態
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmt_total_time_employee_pkey PRIMARY KEY (tmt_total_time_employee_id)
)
;
COMMENT ON TABLE tmt_total_time_employee IS '社員勤怠集計管理';
COMMENT ON COLUMN tmt_total_time_employee.tmt_total_time_employee_id IS 'レコード識別ID';
COMMENT ON COLUMN tmt_total_time_employee.personal_id IS '個人ID';
COMMENT ON COLUMN tmt_total_time_employee.calculation_year IS '集計年';
COMMENT ON COLUMN tmt_total_time_employee.calculation_month IS '集計月';
COMMENT ON COLUMN tmt_total_time_employee.cutoff_code IS '締日コード';
COMMENT ON COLUMN tmt_total_time_employee.calculation_date IS '集計日';
COMMENT ON COLUMN tmt_total_time_employee.cutoff_state IS '締状態';
COMMENT ON COLUMN tmt_total_time_employee.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmt_total_time_employee.insert_date IS '登録日';
COMMENT ON COLUMN tmt_total_time_employee.insert_user IS '登録者';
COMMENT ON COLUMN tmt_total_time_employee.update_date IS '更新日';
COMMENT ON COLUMN tmt_total_time_employee.update_user IS '更新者';

-- Table: tmd_overtime_request

-- DROP TABLE tmd_overtime_request;

CREATE TABLE tmd_overtime_request
(
  tmd_overtime_request_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  request_date date NOT NULL, -- 申請日
  times_work integer NOT NULL DEFAULT 0, -- 勤務回数
  overtime_type integer NOT NULL DEFAULT 0, -- 残業区分
  request_time integer NOT NULL DEFAULT 0, -- 申請時間
  request_reason character varying(50) NOT NULL DEFAULT ''::character varying, -- 理由
  workflow bigint NOT NULL DEFAULT 0, -- ワークフロー番号
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_overtime_request_pkey PRIMARY KEY (tmd_overtime_request_id)
)
;
COMMENT ON TABLE tmd_overtime_request IS '残業申請';
COMMENT ON COLUMN tmd_overtime_request.tmd_overtime_request_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_overtime_request.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_overtime_request.request_date IS '申請日';
COMMENT ON COLUMN tmd_overtime_request.times_work IS '勤務回数';
COMMENT ON COLUMN tmd_overtime_request.overtime_type IS '残業区分';
COMMENT ON COLUMN tmd_overtime_request.request_time IS '申請時間';
COMMENT ON COLUMN tmd_overtime_request.request_reason IS '理由';
COMMENT ON COLUMN tmd_overtime_request.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN tmd_overtime_request.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_overtime_request.insert_date IS '登録日';
COMMENT ON COLUMN tmd_overtime_request.insert_user IS '登録者';
COMMENT ON COLUMN tmd_overtime_request.update_date IS '更新日';
COMMENT ON COLUMN tmd_overtime_request.update_user IS '更新者';

-- Table: tmd_holiday_request

-- DROP TABLE tmd_holiday_request;

CREATE TABLE tmd_holiday_request
(
  tmd_holiday_request_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  request_start_date date NOT NULL, -- 申請開始日
  request_end_date date NOT NULL, -- 申請終了日
  holiday_type1 integer NOT NULL DEFAULT 0, -- 休暇種別1
  holiday_type2 character varying(10) NOT NULL DEFAULT ''::character varying, -- 休暇種別2
  holiday_range integer NOT NULL DEFAULT 0, -- 休暇範囲
  start_time time without time zone, -- 時休開始時刻
  end_time time without time zone, -- 時休終了時刻
  holiday_acquisition_date date NOT NULL, -- 休暇取得日
  use_day double precision NOT NULL DEFAULT 0, -- 使用日数
  use_hour integer NOT NULL DEFAULT 0, -- 使用時間数
  request_reason character varying(50) NOT NULL DEFAULT ''::character varying, -- 理由
  workflow bigint NOT NULL DEFAULT 0, -- ワークフロー番号
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_holiday_request_pkey PRIMARY KEY (tmd_holiday_request_id)
)
;
COMMENT ON TABLE tmd_holiday_request IS '休暇申請';
COMMENT ON COLUMN tmd_holiday_request.tmd_holiday_request_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_holiday_request.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_holiday_request.request_start_date IS '申請開始日';
COMMENT ON COLUMN tmd_holiday_request.request_end_date IS '申請終了日';
COMMENT ON COLUMN tmd_holiday_request.holiday_type1 IS '休暇種別1';
COMMENT ON COLUMN tmd_holiday_request.holiday_type2 IS '休暇種別2';
COMMENT ON COLUMN tmd_holiday_request.holiday_range IS '休暇範囲';
COMMENT ON COLUMN tmd_holiday_request.start_time IS '時休開始時刻';
COMMENT ON COLUMN tmd_holiday_request.end_time IS '時休終了時刻';
COMMENT ON COLUMN tmd_holiday_request.holiday_acquisition_date IS '休暇取得日';
COMMENT ON COLUMN tmd_holiday_request.use_day IS '使用日数';
COMMENT ON COLUMN tmd_holiday_request.use_hour IS '使用時間数';
COMMENT ON COLUMN tmd_holiday_request.request_reason IS '理由';
COMMENT ON COLUMN tmd_holiday_request.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN tmd_holiday_request.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_holiday_request.insert_date IS '登録日';
COMMENT ON COLUMN tmd_holiday_request.insert_user IS '登録者';
COMMENT ON COLUMN tmd_holiday_request.update_date IS '更新日';
COMMENT ON COLUMN tmd_holiday_request.update_user IS '更新者';

-- Table: tmd_work_on_holiday_request

-- DROP TABLE tmd_work_on_holiday_request;

CREATE TABLE tmd_work_on_holiday_request
(
  tmd_work_on_holiday_request_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  request_date date NOT NULL, -- 出勤日
  times_work integer NOT NULL DEFAULT 0, -- 勤務回数
  work_on_holiday_type character varying(20) NOT NULL DEFAULT ''::character varying, -- 休出種別
  substitute integer NOT NULL DEFAULT 0, -- 振替申請
  start_time timestamp without time zone, -- 出勤予定時刻
  end_time timestamp without time zone, -- 退勤予定時刻
  request_reason character varying(50) NOT NULL DEFAULT ''::character varying, -- 理由
  workflow bigint NOT NULL DEFAULT 0, -- ワークフロー番号
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_work_on_holiday_request_pkey PRIMARY KEY (tmd_work_on_holiday_request_id)
)
;
COMMENT ON TABLE tmd_work_on_holiday_request IS '休日出勤申請';
COMMENT ON COLUMN tmd_work_on_holiday_request.tmd_work_on_holiday_request_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_work_on_holiday_request.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_work_on_holiday_request.request_date IS '出勤日';
COMMENT ON COLUMN tmd_work_on_holiday_request.times_work IS '勤務回数';
COMMENT ON COLUMN tmd_work_on_holiday_request.work_on_holiday_type IS '休出種別';
COMMENT ON COLUMN tmd_work_on_holiday_request.substitute IS '振替申請';
COMMENT ON COLUMN tmd_work_on_holiday_request.start_time IS '出勤予定時刻';
COMMENT ON COLUMN tmd_work_on_holiday_request.end_time IS '退勤予定時刻';
COMMENT ON COLUMN tmd_work_on_holiday_request.request_reason IS '理由';
COMMENT ON COLUMN tmd_work_on_holiday_request.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN tmd_work_on_holiday_request.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_work_on_holiday_request.insert_date IS '登録日';
COMMENT ON COLUMN tmd_work_on_holiday_request.insert_user IS '登録者';
COMMENT ON COLUMN tmd_work_on_holiday_request.update_date IS '更新日';
COMMENT ON COLUMN tmd_work_on_holiday_request.update_user IS '更新者';

-- Table: tmd_sub_holiday_request

-- DROP TABLE tmd_sub_holiday_request;

CREATE TABLE tmd_sub_holiday_request
(
  tmd_sub_holiday_request_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  request_date date NOT NULL, -- 代休日
  holiday_range integer NOT NULL DEFAULT 0, -- 休暇範囲
  work_date date NOT NULL, -- 出勤日
  times_work integer NOT NULL DEFAULT 0, -- 勤務回数
  work_date_sub_holiday_type integer NOT NULL DEFAULT 0, -- 代休種別
  workflow bigint NOT NULL DEFAULT 0, -- ワークフロー番号
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_sub_holiday_request_pkey PRIMARY KEY (tmd_sub_holiday_request_id)
)
;
COMMENT ON TABLE tmd_sub_holiday_request IS '代休申請';
COMMENT ON COLUMN tmd_sub_holiday_request.tmd_sub_holiday_request_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_sub_holiday_request.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_sub_holiday_request.request_date IS '代休日';
COMMENT ON COLUMN tmd_sub_holiday_request.holiday_range IS '休暇範囲';
COMMENT ON COLUMN tmd_sub_holiday_request.work_date IS '出勤日';
COMMENT ON COLUMN tmd_sub_holiday_request.times_work IS '勤務回数';
COMMENT ON COLUMN tmd_sub_holiday_request.work_date_sub_holiday_type IS '代休種別';
COMMENT ON COLUMN tmd_sub_holiday_request.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN tmd_sub_holiday_request.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_sub_holiday_request.insert_date IS '登録日';
COMMENT ON COLUMN tmd_sub_holiday_request.insert_user IS '登録者';
COMMENT ON COLUMN tmd_sub_holiday_request.update_date IS '更新日';
COMMENT ON COLUMN tmd_sub_holiday_request.update_user IS '更新者';

-- Table: tmd_difference_request

-- DROP TABLE tmd_difference_request;

CREATE TABLE tmd_difference_request
(
  tmd_difference_request_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  request_date date NOT NULL, -- 時差出勤日
  times_work integer NOT NULL DEFAULT 0, -- 勤務回数
  difference_type character varying(10) NOT NULL DEFAULT ''::character varying, -- 時差出勤区分
  work_type_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤務形態コード
  start_date integer NOT NULL DEFAULT 0, -- 開始日
  request_start timestamp without time zone NOT NULL, -- 時差出勤開始時刻
  request_end timestamp without time zone NOT NULL, -- 時差出勤終了時刻
  request_reason character varying(50) NOT NULL DEFAULT ''::character varying, -- 理由
  workflow bigint NOT NULL DEFAULT 0, -- ワークフロー番号
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_difference_request_pkey PRIMARY KEY (tmd_difference_request_id)
)
;
COMMENT ON TABLE tmd_difference_request IS '時差出勤申請';
COMMENT ON COLUMN tmd_difference_request.tmd_difference_request_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_difference_request.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_difference_request.request_date IS '時差出勤日';
COMMENT ON COLUMN tmd_difference_request.times_work IS '勤務回数';
COMMENT ON COLUMN tmd_difference_request.difference_type IS '時差出勤区分';
COMMENT ON COLUMN tmd_difference_request.work_type_code IS '勤務形態コード';
COMMENT ON COLUMN tmd_difference_request.start_date IS '開始日';
COMMENT ON COLUMN tmd_difference_request.request_start IS '時差出勤開始時刻';
COMMENT ON COLUMN tmd_difference_request.request_end IS '時差出勤終了時刻';
COMMENT ON COLUMN tmd_difference_request.request_reason IS '理由';
COMMENT ON COLUMN tmd_difference_request.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN tmd_difference_request.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_difference_request.insert_date IS '登録日';
COMMENT ON COLUMN tmd_difference_request.insert_user IS '登録者';
COMMENT ON COLUMN tmd_difference_request.update_date IS '更新日';
COMMENT ON COLUMN tmd_difference_request.update_user IS '更新者';

-- Table: tmd_substitute

-- DROP TABLE tmd_substitute;

CREATE TABLE tmd_substitute
(
  tmd_substitute_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  substitute_date date, -- 振替日
  substitute_type character varying(20) NOT NULL DEFAULT ''::character varying, -- 振替種別
  substitute_range integer NOT NULL DEFAULT 0, -- 振替範囲
  work_date date NOT NULL, -- 出勤日
  times_work integer NOT NULL DEFAULT 0, -- 勤務回数
  workflow bigint NOT NULL DEFAULT 0, -- ワークフロー番号
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_substitute_pkey PRIMARY KEY (tmd_substitute_id)
)
;
COMMENT ON TABLE tmd_substitute IS '振替休日データ';
COMMENT ON COLUMN tmd_substitute.tmd_substitute_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_substitute.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_substitute.substitute_date IS '振替日';
COMMENT ON COLUMN tmd_substitute.substitute_type IS '振替種別';
COMMENT ON COLUMN tmd_substitute.substitute_range IS '振替範囲';
COMMENT ON COLUMN tmd_substitute.work_date IS '出勤日';
COMMENT ON COLUMN tmd_substitute.times_work IS '勤務回数';
COMMENT ON COLUMN tmd_substitute.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN tmd_substitute.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_substitute.insert_date IS '登録日';
COMMENT ON COLUMN tmd_substitute.insert_user IS '登録者';
COMMENT ON COLUMN tmd_substitute.update_date IS '更新日';
COMMENT ON COLUMN tmd_substitute.update_user IS '更新者';

-- Table: tmd_sub_holiday

-- DROP TABLE tmd_sub_holiday;

CREATE TABLE tmd_sub_holiday
(
  tmd_sub_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  work_date date NOT NULL, -- 出勤日
  times_work integer NOT NULL DEFAULT 0, -- 勤務回数
  sub_holiday_type integer NOT NULL DEFAULT 0, -- 代休種別
  sub_holiday_days double precision NOT NULL DEFAULT 0, -- 代休日数
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_sub_holiday_pkey PRIMARY KEY (tmd_sub_holiday_id)
)
;
COMMENT ON TABLE tmd_sub_holiday IS '代休データ';
COMMENT ON COLUMN tmd_sub_holiday.tmd_sub_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_sub_holiday.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_sub_holiday.work_date IS '出勤日';
COMMENT ON COLUMN tmd_sub_holiday.times_work IS '勤務回数';
COMMENT ON COLUMN tmd_sub_holiday.sub_holiday_type IS '代休種別';
COMMENT ON COLUMN tmd_sub_holiday.sub_holiday_days IS '代休日数';
COMMENT ON COLUMN tmd_sub_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_sub_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmd_sub_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmd_sub_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmd_sub_holiday.update_user IS '更新者';

-- Table: tmm_time_setting

-- DROP TABLE tmm_time_setting;

CREATE TABLE tmm_time_setting
(
  tmm_time_setting_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  work_setting_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤怠設定コード
  activate_date date NOT NULL, -- 有効日
  work_setting_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 勤怠設定名称
  work_setting_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 勤怠設定略称
  cutoff_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 締日コード
  time_management_flag integer NOT NULL DEFAULT 0, -- 勤怠管理対象フラグ
  daily_approval_flag integer NOT NULL DEFAULT 0, -- 日々申請対象フラグ
  before_overtime_flag integer NOT NULL DEFAULT 0, -- 勤務前残業フラグ
  specific_holiday_handling integer NOT NULL DEFAULT 0, -- 所定休日取扱
  round_daily_start_unit integer NOT NULL DEFAULT 0, -- 日出勤丸め単位
  round_daily_start integer NOT NULL DEFAULT 0, -- 日出勤丸め
  round_daily_end_unit integer NOT NULL DEFAULT 0, -- 日退勤丸め単位
  round_daily_end integer NOT NULL DEFAULT 0, -- 日退勤丸め
  round_daily_time_work integer NOT NULL DEFAULT 0, -- 日勤務時間丸め単位
  round_daily_work integer NOT NULL DEFAULT 0, -- 日勤務時間丸め
  round_daily_rest_start_unit integer NOT NULL DEFAULT 0, -- 日休憩入丸め単位
  round_daily_rest_start integer NOT NULL DEFAULT 0, -- 日休憩入丸め
  round_daily_rest_end_unit integer NOT NULL DEFAULT 0, -- 日休憩戻丸め単位
  round_daily_rest_end integer NOT NULL DEFAULT 0, -- 日休憩戻丸め
  round_daily_rest_time_unit integer NOT NULL DEFAULT 0, -- 日休憩時間丸め単位
  round_daily_rest_time integer NOT NULL DEFAULT 0, -- 日休憩時間丸め
  round_daily_late_unit integer NOT NULL DEFAULT 0, -- 日遅刻丸め単位
  round_daily_late integer NOT NULL DEFAULT 0, -- 日遅刻丸め
  round_daily_leave_early_unit integer NOT NULL DEFAULT 0, -- 日早退丸め単位
  round_daily_leave_early integer NOT NULL DEFAULT 0, -- 日早退丸め
  round_daily_private_time_start integer NOT NULL DEFAULT 0, -- 日私用外出入丸め単位
  round_daily_private_in integer NOT NULL DEFAULT 0, -- 日私用外出入丸め
  round_daily_private_time_end integer NOT NULL DEFAULT 0, -- 日私用外出戻丸め単位
  round_daily_private_out integer NOT NULL DEFAULT 0, -- 日私用外出戻丸め
  round_daily_public_time_start integer NOT NULL DEFAULT 0, -- 日公用外出入丸め単位
  round_daily_public_in integer NOT NULL DEFAULT 0, -- 日公用外出入丸め
  round_daily_public_time_end integer NOT NULL DEFAULT 0, -- 日公用外出戻丸め単位
  round_daily_public_out integer NOT NULL DEFAULT 0, -- 日公用外出戻丸め
  round_daily_decrease_time_unit integer NOT NULL DEFAULT 0, -- 日減額対象丸め単位
  round_daily_decrease_time integer NOT NULL DEFAULT 0, -- 日減額対象時間丸め
  round_monthly_work_unit integer NOT NULL DEFAULT 0, -- 月勤務時間丸め単位
  round_monthly_work integer NOT NULL DEFAULT 0, -- 月勤務時間丸め
  round_monthly_rest_unit integer NOT NULL DEFAULT 0, -- 月休憩時間丸め単位
  round_monthly_rest integer NOT NULL DEFAULT 0, -- 月休憩時間丸め
  round_monthly_late_unit integer NOT NULL DEFAULT 0, -- 月遅刻丸め単位
  round_monthly_late integer NOT NULL DEFAULT 0, -- 月遅刻時間丸め
  round_monthly_early_unit integer NOT NULL DEFAULT 0, -- 月早退丸め単位
  round_monthly_early integer NOT NULL DEFAULT 0, -- 月早退丸め
  round_monthly_private_time integer NOT NULL DEFAULT 0, -- 月私用外出丸め単位
  round_monthly_private integer NOT NULL DEFAULT 0, -- 月私用外出時間丸め
  round_monthly_public_time integer NOT NULL DEFAULT 0, -- 月公用外出丸め単位
  round_monthly_public integer NOT NULL DEFAULT 0, -- 月公用外出時間丸め
  round_monthly_decrease_time integer NOT NULL DEFAULT 0, -- 月減額対象丸め単位
  round_monthly_decrease integer NOT NULL DEFAULT 0, -- 月減額対象時間丸め
  start_week integer NOT NULL DEFAULT 0, -- 週の起算曜日
  start_month integer NOT NULL DEFAULT 0, -- 月の起算日
  start_year integer NOT NULL DEFAULT 0, -- 年の起算月
  general_work_time time without time zone NOT NULL, -- 所定労働時間
  start_day_time time without time zone NOT NULL, -- 一日の起算時
  late_early_full time without time zone NOT NULL, -- 遅刻早退限度時間(全日)
  late_early_half time without time zone NOT NULL, -- 遅刻早退限度時間(半日)
  transfer_ahead_limit_month integer NOT NULL DEFAULT 0, -- 振休取得期限月(休出前)
  transfer_ahead_limit_date integer NOT NULL DEFAULT 0, -- 振休取得期限日(休出前)
  transfer_later_limit_month integer NOT NULL DEFAULT 0, -- 振休取得期限月(休出後)
  transfer_later_limit_date integer NOT NULL DEFAULT 0, -- 振休取得期限日(休出後)
  sub_holiday_limit_month integer NOT NULL DEFAULT 0, -- 代休取得期限月
  sub_holiday_limit_date integer NOT NULL DEFAULT 0, -- 代休取得期限日
  transfer_exchange integer NOT NULL DEFAULT 0, -- 半休入替取得(振休)
  sub_holiday_exchange integer NOT NULL DEFAULT 0, -- 半休入替取得(代休)
  sub_holiday_all_norm time without time zone NOT NULL, -- 代休基準時間(全休)
  sub_holiday_half_norm time without time zone NOT NULL, -- 代休基準時間(半休)
  sixty_hour_function_flag integer NOT NULL DEFAULT 0, -- 60時間超割増機能
  sixty_hour_alternative_flag integer NOT NULL DEFAULT 0, -- 60時間超代替休暇
  month_sixty_hour_surcharge integer NOT NULL DEFAULT 0, -- 月60時間超割増
  weekday_over integer NOT NULL DEFAULT 0, -- 平日残業割増
  weekday_alternative integer NOT NULL DEFAULT 0, -- 代替休暇平日
  alternative_cancel integer NOT NULL DEFAULT 0, -- 代替休暇放棄
  alternative_specific integer NOT NULL DEFAULT 0, -- 代替休暇所定休日
  alternative_legal integer NOT NULL DEFAULT 0, -- 代替休暇法定休日
  specific_holiday integer NOT NULL DEFAULT 0, -- 所定休日割増率
  legal_holiday integer NOT NULL DEFAULT 0, -- 法定休日割増率
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_time_setting_pkey PRIMARY KEY (tmm_time_setting_id)
)
;
COMMENT ON TABLE tmm_time_setting IS '勤怠設定マスタ';
COMMENT ON COLUMN tmm_time_setting.tmm_time_setting_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_time_setting.work_setting_code IS '勤怠設定コード';
COMMENT ON COLUMN tmm_time_setting.activate_date IS '有効日';
COMMENT ON COLUMN tmm_time_setting.work_setting_name IS '勤怠設定名称';
COMMENT ON COLUMN tmm_time_setting.work_setting_abbr IS '勤怠設定略称';
COMMENT ON COLUMN tmm_time_setting.cutoff_code IS '締日コード';
COMMENT ON COLUMN tmm_time_setting.time_management_flag IS '勤怠管理対象フラグ';
COMMENT ON COLUMN tmm_time_setting.daily_approval_flag IS '日々申請対象フラグ';
COMMENT ON COLUMN tmm_time_setting.before_overtime_flag IS '勤務前残業フラグ';
COMMENT ON COLUMN tmm_time_setting.specific_holiday_handling IS '所定休日取扱';
COMMENT ON COLUMN tmm_time_setting.round_daily_start_unit IS '日出勤丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_start IS '日出勤丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_end_unit IS '日退勤丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_end IS '日退勤丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_time_work IS '日勤務時間丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_work IS '日勤務時間丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_rest_start_unit IS '日休憩入丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_rest_start IS '日休憩入丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_rest_end_unit IS '日休憩戻丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_rest_end IS '日休憩戻丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_rest_time_unit IS '日休憩時間丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_rest_time IS '日休憩時間丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_late_unit IS '日遅刻丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_late IS '日遅刻丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_leave_early_unit IS '日早退丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_leave_early IS '日早退丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_private_time_start IS '日私用外出入丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_private_in IS '日私用外出入丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_private_time_end IS '日私用外出戻丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_private_out IS '日私用外出戻丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_public_time_start IS '日公用外出入丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_public_in IS '日公用外出入丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_public_time_end IS '日公用外出戻丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_public_out IS '日公用外出戻丸め';
COMMENT ON COLUMN tmm_time_setting.round_daily_decrease_time_unit IS '日減額対象丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_daily_decrease_time IS '日減額対象時間丸め';
COMMENT ON COLUMN tmm_time_setting.round_monthly_work_unit IS '月勤務時間丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_monthly_work IS '月勤務時間丸め';
COMMENT ON COLUMN tmm_time_setting.round_monthly_rest_unit IS '月休憩時間丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_monthly_rest IS '月休憩時間丸め';
COMMENT ON COLUMN tmm_time_setting.round_monthly_late_unit IS '月遅刻丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_monthly_late IS '月遅刻時間丸め';
COMMENT ON COLUMN tmm_time_setting.round_monthly_early_unit IS '月早退丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_monthly_early IS '月早退丸め';
COMMENT ON COLUMN tmm_time_setting.round_monthly_private_time IS '月私用外出丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_monthly_private IS '月私用外出時間丸め';
COMMENT ON COLUMN tmm_time_setting.round_monthly_public_time IS '月公用外出丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_monthly_public IS '月公用外出時間丸め';
COMMENT ON COLUMN tmm_time_setting.round_monthly_decrease_time IS '月減額対象丸め単位';
COMMENT ON COLUMN tmm_time_setting.round_monthly_decrease IS '月減額対象時間丸め';
COMMENT ON COLUMN tmm_time_setting.start_week IS '週の起算曜日';
COMMENT ON COLUMN tmm_time_setting.start_month IS '月の起算日';
COMMENT ON COLUMN tmm_time_setting.start_year IS '年の起算月';
COMMENT ON COLUMN tmm_time_setting.general_work_time IS '所定労働時間';
COMMENT ON COLUMN tmm_time_setting.start_day_time IS '一日の起算時';
COMMENT ON COLUMN tmm_time_setting.late_early_full IS '遅刻早退限度時間(全日)';
COMMENT ON COLUMN tmm_time_setting.late_early_half IS '遅刻早退限度時間(半日)';
COMMENT ON COLUMN tmm_time_setting.transfer_ahead_limit_month IS '振休取得期限月(休出前)';
COMMENT ON COLUMN tmm_time_setting.transfer_ahead_limit_date IS '振休取得期限日(休出前)';
COMMENT ON COLUMN tmm_time_setting.transfer_later_limit_month IS '振休取得期限月(休出後)';
COMMENT ON COLUMN tmm_time_setting.transfer_later_limit_date IS '振休取得期限日(休出後)';
COMMENT ON COLUMN tmm_time_setting.sub_holiday_limit_month IS '代休取得期限月';
COMMENT ON COLUMN tmm_time_setting.sub_holiday_limit_date IS '代休取得期限日';
COMMENT ON COLUMN tmm_time_setting.transfer_exchange IS '半休入替取得(振休)';
COMMENT ON COLUMN tmm_time_setting.sub_holiday_exchange IS '半休入替取得(代休)';
COMMENT ON COLUMN tmm_time_setting.sub_holiday_all_norm IS '代休基準時間(全休)';
COMMENT ON COLUMN tmm_time_setting.sub_holiday_half_norm IS '代休基準時間(半休)';
COMMENT ON COLUMN tmm_time_setting.sixty_hour_function_flag IS '60時間超割増機能';
COMMENT ON COLUMN tmm_time_setting.sixty_hour_alternative_flag IS '60時間超代替休暇';
COMMENT ON COLUMN tmm_time_setting.month_sixty_hour_surcharge IS '月60時間超割増';
COMMENT ON COLUMN tmm_time_setting.weekday_over IS '平日残業割増';
COMMENT ON COLUMN tmm_time_setting.weekday_alternative IS '代替休暇平日';
COMMENT ON COLUMN tmm_time_setting.alternative_cancel IS '代替休暇放棄';
COMMENT ON COLUMN tmm_time_setting.alternative_specific IS '代替休暇所定休日';
COMMENT ON COLUMN tmm_time_setting.alternative_legal IS '代替休暇法定休日';
COMMENT ON COLUMN tmm_time_setting.specific_holiday IS '所定休日割増率';
COMMENT ON COLUMN tmm_time_setting.legal_holiday IS '法定休日割増率';
COMMENT ON COLUMN tmm_time_setting.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_time_setting.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_time_setting.insert_date IS '登録日';
COMMENT ON COLUMN tmm_time_setting.insert_user IS '登録者';
COMMENT ON COLUMN tmm_time_setting.update_date IS '更新日';
COMMENT ON COLUMN tmm_time_setting.update_user IS '更新者';

-- Table: tmm_limit_standard

-- DROP TABLE tmm_limit_standard;

CREATE TABLE tmm_limit_standard
(
  tmm_limit_standard_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  work_setting_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤怠設定コード
  activate_date date NOT NULL, -- 有効日
  term character varying(50) NOT NULL DEFAULT ''::character varying, -- 期間
  limit_time integer NOT NULL DEFAULT 0, -- 時間外限度時間
  attention_time integer NOT NULL DEFAULT 0, -- 時間外注意時間
  warning_time integer NOT NULL DEFAULT 0, -- 時間外警告時間
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_limit_standard_pkey PRIMARY KEY (tmm_limit_standard_id)
)
;
COMMENT ON TABLE tmm_limit_standard IS '限度基準マスタ';
COMMENT ON COLUMN tmm_limit_standard.tmm_limit_standard_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_limit_standard.work_setting_code IS '勤怠設定コード';
COMMENT ON COLUMN tmm_limit_standard.activate_date IS '有効日';
COMMENT ON COLUMN tmm_limit_standard.term IS '期間';
COMMENT ON COLUMN tmm_limit_standard.limit_time IS '時間外限度時間';
COMMENT ON COLUMN tmm_limit_standard.attention_time IS '時間外注意時間';
COMMENT ON COLUMN tmm_limit_standard.warning_time IS '時間外警告時間';
COMMENT ON COLUMN tmm_limit_standard.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_limit_standard.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_limit_standard.insert_date IS '登録日';
COMMENT ON COLUMN tmm_limit_standard.insert_user IS '登録者';
COMMENT ON COLUMN tmm_limit_standard.update_date IS '更新日';
COMMENT ON COLUMN tmm_limit_standard.update_user IS '更新者';

-- Table: tmm_work_type

-- DROP TABLE tmm_work_type;

CREATE TABLE tmm_work_type
(
  tmm_work_type_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  work_type_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤務形態コード
  activate_date date NOT NULL, -- 有効日
  work_type_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 勤務形態名称
  work_type_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 勤務形態略称
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_work_type_pkey PRIMARY KEY (tmm_work_type_id)
)
;
COMMENT ON TABLE tmm_work_type IS '勤務形態マスタ';
COMMENT ON COLUMN tmm_work_type.tmm_work_type_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_work_type.work_type_code IS '勤務形態コード';
COMMENT ON COLUMN tmm_work_type.activate_date IS '有効日';
COMMENT ON COLUMN tmm_work_type.work_type_name IS '勤務形態名称';
COMMENT ON COLUMN tmm_work_type.work_type_abbr IS '勤務形態略称';
COMMENT ON COLUMN tmm_work_type.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_work_type.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_work_type.insert_date IS '登録日';
COMMENT ON COLUMN tmm_work_type.insert_user IS '登録者';
COMMENT ON COLUMN tmm_work_type.update_date IS '更新日';
COMMENT ON COLUMN tmm_work_type.update_user IS '更新者';

-- Table: tmm_work_type_item

-- DROP TABLE tmm_work_type_item;

CREATE TABLE tmm_work_type_item
(
  tmm_work_type_item_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  work_type_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤務形態コード
  activate_date date NOT NULL, -- 有効日
  work_type_item_code character varying(16) NOT NULL DEFAULT ''::character varying, -- 勤務形態項目コード
  work_type_item_value timestamp without time zone NOT NULL, -- 勤務形態項目値
  preliminary character varying(64) NOT NULL DEFAULT ''::character varying, -- 勤務形態項目値(予備)
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_work_type_item_pkey PRIMARY KEY (tmm_work_type_item_id)
)
;
COMMENT ON TABLE tmm_work_type_item IS '勤務形態項目マスタ';
COMMENT ON COLUMN tmm_work_type_item.tmm_work_type_item_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_work_type_item.work_type_code IS '勤務形態コード';
COMMENT ON COLUMN tmm_work_type_item.activate_date IS '有効日';
COMMENT ON COLUMN tmm_work_type_item.work_type_item_code IS '勤務形態項目コード';
COMMENT ON COLUMN tmm_work_type_item.work_type_item_value IS '勤務形態項目値';
COMMENT ON COLUMN tmm_work_type_item.preliminary IS '勤務形態項目値(予備)';
COMMENT ON COLUMN tmm_work_type_item.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_work_type_item.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_work_type_item.insert_date IS '登録日';
COMMENT ON COLUMN tmm_work_type_item.insert_user IS '登録者';
COMMENT ON COLUMN tmm_work_type_item.update_date IS '更新日';
COMMENT ON COLUMN tmm_work_type_item.update_user IS '更新者';

-- Table: tmm_paid_holiday

-- DROP TABLE tmm_paid_holiday

CREATE TABLE tmm_paid_holiday
(
  tmm_paid_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  paid_holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 有休コード
  activate_date date NOT NULL, -- 有効日
  paid_holiday_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 有休名称
  paid_holiday_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 有休略称
  paid_holiday_type integer NOT NULL DEFAULT 0, -- 付与区分
  work_ratio integer NOT NULL DEFAULT 0, -- 出勤率
  schedule_giving integer NOT NULL DEFAULT 0, -- 仮付与日
  timely_paid_holiday_flag integer NOT NULL DEFAULT 0, -- 時間単位有休機能
  timely_paid_holiday_time integer NOT NULL DEFAULT 0, -- 有休単位時間
  time_unit_paid_holiday integer NOT NULL DEFAULT 0, -- 時間単位限度日数
  max_carry_over_amount integer NOT NULL DEFAULT 0, -- 最大繰越日数
  total_max_amount integer NOT NULL DEFAULT 0, -- 合計最大保有日数
  max_carry_over_year integer NOT NULL DEFAULT 0, -- 有休繰越
  point_date_month integer NOT NULL DEFAULT 0, -- 基準日(月)
  point_date_day integer NOT NULL DEFAULT 0, -- 基準日(日)
  general_point_amount integer NOT NULL DEFAULT 0, -- 登録情報超過後(基準日)
  general_joining_month integer NOT NULL DEFAULT 0, -- 登録情報超過後(月)
  general_joining_amount integer NOT NULL DEFAULT 0, -- 登録情報超過後(日)
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_paid_holiday_pkey PRIMARY KEY (tmm_paid_holiday_id)
)
;
COMMENT ON TABLE tmm_paid_holiday IS '有給休暇マスタ';
COMMENT ON COLUMN tmm_paid_holiday.tmm_paid_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_paid_holiday.paid_holiday_code IS '有休コード';
COMMENT ON COLUMN tmm_paid_holiday.activate_date IS '有効日';
COMMENT ON COLUMN tmm_paid_holiday.paid_holiday_name IS '有休名称';
COMMENT ON COLUMN tmm_paid_holiday.paid_holiday_abbr IS '有休略称';
COMMENT ON COLUMN tmm_paid_holiday.paid_holiday_type IS '付与区分';
COMMENT ON COLUMN tmm_paid_holiday.work_ratio IS '出勤率';
COMMENT ON COLUMN tmm_paid_holiday.schedule_giving IS '仮付与日';
COMMENT ON COLUMN tmm_paid_holiday.timely_paid_holiday_flag IS '時間単位有休機能';
COMMENT ON COLUMN tmm_paid_holiday.timely_paid_holiday_time IS '有休単位時間';
COMMENT ON COLUMN tmm_paid_holiday.time_unit_paid_holiday IS '時間単位限度日数';
COMMENT ON COLUMN tmm_paid_holiday.max_carry_over_amount IS '有休繰越';
COMMENT ON COLUMN tmm_paid_holiday.total_max_amount IS '合計最大保有日数';
COMMENT ON COLUMN tmm_paid_holiday.max_carry_over_year IS '最大繰越年数';
COMMENT ON COLUMN tmm_paid_holiday.point_date_month IS '基準日(月)';
COMMENT ON COLUMN tmm_paid_holiday.point_date_day IS '基準日(日)';
COMMENT ON COLUMN tmm_paid_holiday.general_point_amount IS '登録情報超過後(基準日)';
COMMENT ON COLUMN tmm_paid_holiday.general_joining_month IS '登録情報超過後(月)';
COMMENT ON COLUMN tmm_paid_holiday.general_joining_amount IS '登録情報超過後(日)';
COMMENT ON COLUMN tmm_paid_holiday.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_paid_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_paid_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmm_paid_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmm_paid_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmm_paid_holiday.update_user IS '更新者';

-- Table: tmm_paid_holiday_first_year

-- DROP TABLE tmm_paid_holiday_first_year

CREATE TABLE tmm_paid_holiday_first_year
(
  tmm_paid_holiday_first_year_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  paid_holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 有休コード
  activate_date date NOT NULL, -- 有効日
  entrance_month integer NOT NULL DEFAULT 0, -- 入社月
  giving_month integer NOT NULL DEFAULT 0, -- 付与月
  giving_amount integer NOT NULL DEFAULT 0, -- 付与日数
  giving_limit integer NOT NULL DEFAULT 0, -- 利用期限
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_paid_holiday_first_year_pkey PRIMARY KEY (tmm_paid_holiday_first_year_id)
)
;
COMMENT ON TABLE tmm_paid_holiday_first_year IS '有給休暇初年度マスタ';
COMMENT ON COLUMN tmm_paid_holiday_first_year.tmm_paid_holiday_first_year_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_paid_holiday_first_year.paid_holiday_code IS '有休コード';
COMMENT ON COLUMN tmm_paid_holiday_first_year.activate_date IS '有効日';
COMMENT ON COLUMN tmm_paid_holiday_first_year.entrance_month IS '入社月';
COMMENT ON COLUMN tmm_paid_holiday_first_year.giving_month IS '付与月';
COMMENT ON COLUMN tmm_paid_holiday_first_year.giving_amount IS '付与日数';
COMMENT ON COLUMN tmm_paid_holiday_first_year.giving_limit IS '利用期限';
COMMENT ON COLUMN tmm_paid_holiday_first_year.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_paid_holiday_first_year.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_paid_holiday_first_year.insert_date IS '登録日';
COMMENT ON COLUMN tmm_paid_holiday_first_year.insert_user IS '登録者';
COMMENT ON COLUMN tmm_paid_holiday_first_year.update_date IS '更新日';
COMMENT ON COLUMN tmm_paid_holiday_first_year.update_user IS '更新者';

-- Table: tmm_paid_holiday_point_date

-- DROP TABLE tmm_paid_holiday_point_date;

CREATE TABLE tmm_paid_holiday_point_date
(
  tmm_paid_holiday_point_date_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  paid_holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 有休コード
  activate_date date NOT NULL, -- 有効日
  times_point_date integer NOT NULL DEFAULT 0, -- 基準日経過回数
  point_date_amount integer NOT NULL DEFAULT 0, -- 付与日数
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_paid_holiday_point_date_pkey PRIMARY KEY (tmm_paid_holiday_point_date_id)
)
;
COMMENT ON TABLE tmm_paid_holiday_point_date IS '有給休暇基準日マスタ';
COMMENT ON COLUMN tmm_paid_holiday_point_date.tmm_paid_holiday_point_date_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_paid_holiday_point_date.paid_holiday_code IS '有休コード';
COMMENT ON COLUMN tmm_paid_holiday_point_date.activate_date IS '有効日';
COMMENT ON COLUMN tmm_paid_holiday_point_date.times_point_date IS '基準日経過回数';
COMMENT ON COLUMN tmm_paid_holiday_point_date.point_date_amount IS '付与日数';
COMMENT ON COLUMN tmm_paid_holiday_point_date.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_paid_holiday_point_date.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_paid_holiday_point_date.insert_date IS '登録日';
COMMENT ON COLUMN tmm_paid_holiday_point_date.insert_user IS '登録者';
COMMENT ON COLUMN tmm_paid_holiday_point_date.update_date IS '更新日';
COMMENT ON COLUMN tmm_paid_holiday_point_date.update_user IS '更新者';

-- Table: tmm_paid_holiday_entrance_date

-- DROP TABLE tmm_paid_holiday_entrance_date;

CREATE TABLE tmm_paid_holiday_entrance_date
(
  tmm_paid_holiday_entrance_date_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  paid_holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 有休コード
  activate_date date NOT NULL, -- 有効日
  work_month integer NOT NULL DEFAULT 0, -- 勤続勤務月数
  joining_date_amount integer NOT NULL DEFAULT 0, -- 付与日数
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_paid_holiday_entrance_date_pkey PRIMARY KEY (tmm_paid_holiday_entrance_date_id)
)
;
COMMENT ON TABLE tmm_paid_holiday_entrance_date IS '有給休暇入社日マスタ';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.tmm_paid_holiday_entrance_date_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.paid_holiday_code IS '有休コード';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.activate_date IS '有効日';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.work_month IS '勤続勤務月数';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.joining_date_amount IS '付与日数';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.insert_date IS '登録日';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.insert_user IS '登録者';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.update_date IS '更新日';
COMMENT ON COLUMN tmm_paid_holiday_entrance_date.update_user IS '更新者';

-- Table: tmm_stock_holiday

-- DROP TABLE tmm_stock_holiday;

CREATE TABLE tmm_stock_holiday
(
  tmm_stock_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  paid_holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 有休コード
  activate_date date NOT NULL, -- 有効日
  stock_year_amount integer NOT NULL DEFAULT 0, -- 最大年間積立日数
  stock_total_amount integer NOT NULL DEFAULT 0, -- 最大合計積立日数
  stock_limit_date integer NOT NULL DEFAULT 0, -- 有効期限
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_stock_holiday_pkey PRIMARY KEY (tmm_stock_holiday_id)
)
;
COMMENT ON TABLE tmm_stock_holiday IS 'ストック休暇マスタ';
COMMENT ON COLUMN tmm_stock_holiday.tmm_stock_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_stock_holiday.paid_holiday_code IS '有休コード';
COMMENT ON COLUMN tmm_stock_holiday.activate_date IS '有効日';
COMMENT ON COLUMN tmm_stock_holiday.stock_year_amount IS '最大年間積立日数';
COMMENT ON COLUMN tmm_stock_holiday.stock_total_amount IS '最大合計積立日数';
COMMENT ON COLUMN tmm_stock_holiday.stock_limit_date IS '有効期限';
COMMENT ON COLUMN tmm_stock_holiday.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_stock_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_stock_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmm_stock_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmm_stock_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmm_stock_holiday.update_user IS '更新者';

-- Table: tmm_holiday

-- DROP TABLE tmm_holiday;

CREATE TABLE tmm_holiday
(
  tmm_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 休暇コード
  activate_date date NOT NULL, -- 有効日
  holiday_type integer NOT NULL DEFAULT 0, -- 休暇区分
  holiday_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 休暇名称
  holiday_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 休暇略称
  holiday_giving double precision NOT NULL DEFAULT 0, -- 標準付与日数
  no_limit integer NOT NULL DEFAULT 0, -- 付与日数無制限
  holiday_limit_month integer NOT NULL DEFAULT 0, -- 取得期限(月)
  holiday_limit_day integer NOT NULL DEFAULT 0, -- 取得期限(日)
  continuous_acquisition integer NOT NULL DEFAULT 0, -- 連続取得
  paid_holiday_calc integer NOT NULL DEFAULT 0, -- 出勤率計算
  salary integer NOT NULL DEFAULT 0, -- 有給/無給
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_holiday_pkey PRIMARY KEY (tmm_holiday_id)
)
;
COMMENT ON TABLE tmm_holiday IS '休暇種別マスタ';
COMMENT ON COLUMN tmm_holiday.tmm_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_holiday.holiday_code IS '休暇コード';
COMMENT ON COLUMN tmm_holiday.activate_date IS '有効日';
COMMENT ON COLUMN tmm_holiday.holiday_type IS '休暇区分';
COMMENT ON COLUMN tmm_holiday.holiday_name IS '休暇名称';
COMMENT ON COLUMN tmm_holiday.holiday_abbr IS '休暇略称';
COMMENT ON COLUMN tmm_holiday.holiday_giving IS '標準付与日数';
COMMENT ON COLUMN tmm_holiday.no_limit IS '付与日数無制限';
COMMENT ON COLUMN tmm_holiday.holiday_limit_month IS '取得期限(月)';
COMMENT ON COLUMN tmm_holiday.holiday_limit_day IS '取得期限(日)';
COMMENT ON COLUMN tmm_holiday.continuous_acquisition IS '連続取得';
COMMENT ON COLUMN tmm_holiday.paid_holiday_calc IS '出勤率計算';
COMMENT ON COLUMN tmm_holiday.salary IS '有給/無給';
COMMENT ON COLUMN tmm_holiday.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmm_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmm_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmm_holiday.update_user IS '更新者';

-- Table: tmd_holiday

-- DROP TABLE tmd_holiday;

CREATE TABLE tmd_holiday
(
  tmd_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  activate_date date NOT NULL, -- 有効日
  holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 休暇コード
  holiday_type integer NOT NULL DEFAULT 0, -- 休暇区分
  giving_day double precision NOT NULL DEFAULT 0, -- 付与日数
  cancel_day double precision NOT NULL DEFAULT 0, -- 廃棄日数
  holiday_limit_date date NOT NULL, -- 取得期限
  holiday_limit_month integer NOT NULL DEFAULT 0, -- 取得期限(月)
  holiday_limit_day integer NOT NULL DEFAULT 0, -- 取得期限(日)
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_holiday_pkey PRIMARY KEY (tmd_holiday_id)
)
;
COMMENT ON TABLE tmd_holiday IS '休暇データ';
COMMENT ON COLUMN tmd_holiday.tmd_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_holiday.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_holiday.activate_date IS '有効日';
COMMENT ON COLUMN tmd_holiday.holiday_code IS '休暇コード';
COMMENT ON COLUMN tmd_holiday.holiday_type IS '休暇区分';
COMMENT ON COLUMN tmd_holiday.giving_day IS '付与日数';
COMMENT ON COLUMN tmd_holiday.cancel_day IS '廃棄日数';
COMMENT ON COLUMN tmd_holiday.holiday_limit_date IS '取得期限';
COMMENT ON COLUMN tmd_holiday.holiday_limit_month IS '取得期限(月)';
COMMENT ON COLUMN tmd_holiday.holiday_limit_day IS '取得期限(日)';
COMMENT ON COLUMN tmd_holiday.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmd_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmd_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmd_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmd_holiday.update_user IS '更新者';

-- Table: tmd_paid_holiday

-- DROP TABLE tmd_paid_holiday;

CREATE TABLE tmd_paid_holiday
(
  tmd_paid_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  activate_date date NOT NULL, -- 有効日
  acquisition_date date NOT NULL, -- 取得日
  limit_date date NOT NULL, -- 期限日
  hold_day double precision NOT NULL DEFAULT 0, -- 保有日数
  hold_hour integer NOT NULL DEFAULT 0, -- 保有時間数
  giving_day double precision NOT NULL DEFAULT 0, -- 付与日数
  giving_hour integer NOT NULL DEFAULT 0, -- 付与時間数
  cancel_day double precision NOT NULL DEFAULT 0, -- 廃棄日数
  cancel_hour integer NOT NULL DEFAULT 0, -- 廃棄時間数
  use_day double precision NOT NULL DEFAULT 0, -- 使用日数
  use_hour integer NOT NULL DEFAULT 0, -- 使用時間数
  temporary_flag integer NOT NULL DEFAULT 0, -- 仮付与フラグ
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_paid_holiday_pkey PRIMARY KEY (tmd_paid_holiday_id)
)
;
COMMENT ON TABLE tmd_paid_holiday IS '有給休暇データ';
COMMENT ON COLUMN tmd_paid_holiday.tmd_paid_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_paid_holiday.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_paid_holiday.activate_date IS '有効日';
COMMENT ON COLUMN tmd_paid_holiday.acquisition_date IS '取得日';
COMMENT ON COLUMN tmd_paid_holiday.limit_date IS '期限日';
COMMENT ON COLUMN tmd_paid_holiday.hold_day IS '保有日数';
COMMENT ON COLUMN tmd_paid_holiday.hold_hour IS '保有時間数';
COMMENT ON COLUMN tmd_paid_holiday.giving_day IS '付与日数';
COMMENT ON COLUMN tmd_paid_holiday.giving_hour IS '付与時間数';
COMMENT ON COLUMN tmd_paid_holiday.cancel_day IS '廃棄日数';
COMMENT ON COLUMN tmd_paid_holiday.cancel_hour IS '廃棄時間数';
COMMENT ON COLUMN tmd_paid_holiday.use_day IS '使用日数';
COMMENT ON COLUMN tmd_paid_holiday.use_hour IS '使用時間数';
COMMENT ON COLUMN tmd_paid_holiday.temporary_flag IS '仮付与フラグ';
COMMENT ON COLUMN tmd_paid_holiday.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmd_paid_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_paid_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmd_paid_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmd_paid_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmd_paid_holiday.update_user IS '更新者';

-- Table: tmt_paid_holiday

-- DROP TABLE tmt_paid_holiday;

CREATE TABLE tmt_paid_holiday
(
  tmt_paid_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  activate_date date NOT NULL, -- 有効日
  acquisition_date date NOT NULL, -- 取得日
  giving_day double precision NOT NULL DEFAULT 0, -- 付与日数
  giving_hour integer NOT NULL DEFAULT 0, -- 付与時間数
  cancel_day double precision NOT NULL DEFAULT 0, -- 廃棄日数
  cancel_hour integer NOT NULL DEFAULT 0, -- 廃棄時間数
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmt_paid_holiday_pkey PRIMARY KEY (tmt_paid_holiday_id)
)
;
COMMENT ON TABLE tmt_paid_holiday IS '有給休暇トランザクション';
COMMENT ON COLUMN tmt_paid_holiday.tmt_paid_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmt_paid_holiday.personal_id IS '個人ID';
COMMENT ON COLUMN tmt_paid_holiday.activate_date IS '有効日';
COMMENT ON COLUMN tmt_paid_holiday.acquisition_date IS '取得日';
COMMENT ON COLUMN tmt_paid_holiday.giving_day IS '付与日数';
COMMENT ON COLUMN tmt_paid_holiday.giving_hour IS '付与時間数';
COMMENT ON COLUMN tmt_paid_holiday.cancel_day IS '廃棄日数';
COMMENT ON COLUMN tmt_paid_holiday.cancel_hour IS '廃棄時間数';
COMMENT ON COLUMN tmt_paid_holiday.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmt_paid_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmt_paid_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmt_paid_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmt_paid_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmt_paid_holiday.update_user IS '更新者';

-- Table: tmd_timely_paid_holiday

-- DROP TABLE tmd_timely_paid_holiday;

CREATE TABLE tmd_timely_paid_holiday
(
  tmd_timely_paid_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  activate_date date NOT NULL, -- 有効日
  acquisition_date date NOT NULL, -- 取得日
  possible_hour integer NOT NULL DEFAULT 0, -- 利用可能時間数
  giving_hour integer NOT NULL DEFAULT 0, -- 付与時間数
  cancel_hour integer NOT NULL DEFAULT 0, -- 廃棄時間数
  use_hour integer NOT NULL DEFAULT 0, -- 使用時間数
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_timely_paid_holiday_pkey PRIMARY KEY (tmd_timely_paid_holiday_id)
)
;
COMMENT ON TABLE tmd_timely_paid_holiday IS '時間単位有給休暇データ';
COMMENT ON COLUMN tmd_timely_paid_holiday.tmd_timely_paid_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_timely_paid_holiday.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_timely_paid_holiday.activate_date IS '有効日';
COMMENT ON COLUMN tmd_timely_paid_holiday.acquisition_date IS '取得日';
COMMENT ON COLUMN tmd_timely_paid_holiday.possible_hour IS '利用可能時間数';
COMMENT ON COLUMN tmd_timely_paid_holiday.giving_hour IS '付与時間数';
COMMENT ON COLUMN tmd_timely_paid_holiday.cancel_hour IS '廃棄時間数';
COMMENT ON COLUMN tmd_timely_paid_holiday.use_hour IS '使用時間数';
COMMENT ON COLUMN tmd_timely_paid_holiday.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmd_timely_paid_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_timely_paid_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmd_timely_paid_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmd_timely_paid_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmd_timely_paid_holiday.update_user IS '更新者';

-- Table: tmd_stock_holiday

-- DROP TABLE tmd_stock_holiday;

CREATE TABLE tmd_stock_holiday
(
  tmd_stock_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  activate_date date NOT NULL, -- 有効日
  acquisition_date date NOT NULL, -- 取得日
  limit_date date NOT NULL, -- 期限日
  hold_day double precision NOT NULL DEFAULT 0, -- 保有日数
  giving_day double precision NOT NULL DEFAULT 0, -- 付与日数
  cancel_day double precision NOT NULL DEFAULT 0, -- 廃棄日数
  use_day double precision NOT NULL DEFAULT 0, -- 使用日数
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmd_stock_holiday_pkey PRIMARY KEY (tmd_stock_holiday_id)
)
;
COMMENT ON TABLE tmd_stock_holiday IS 'ストック休暇データ';
COMMENT ON COLUMN tmd_stock_holiday.tmd_stock_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmd_stock_holiday.personal_id IS '個人ID';
COMMENT ON COLUMN tmd_stock_holiday.activate_date IS '有効日';
COMMENT ON COLUMN tmd_stock_holiday.acquisition_date IS '取得日';
COMMENT ON COLUMN tmd_stock_holiday.limit_date IS '期限日';
COMMENT ON COLUMN tmd_stock_holiday.hold_day IS '保有日数';
COMMENT ON COLUMN tmd_stock_holiday.giving_day IS '付与日数';
COMMENT ON COLUMN tmd_stock_holiday.cancel_day IS '廃棄日数';
COMMENT ON COLUMN tmd_stock_holiday.use_day IS '使用日数';
COMMENT ON COLUMN tmd_stock_holiday.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmd_stock_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmd_stock_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmd_stock_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmd_stock_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmd_stock_holiday.update_user IS '更新者';

-- Table: tmt_stock_holiday

-- DROP TABLE tmt_stock_holiday;

CREATE TABLE tmt_stock_holiday
(
  tmt_stock_holiday_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  activate_date date NOT NULL, -- 有効日
  acquisition_date date NOT NULL, -- 取得日
  giving_day double precision NOT NULL DEFAULT 0, -- 付与日数
  cancel_day double precision NOT NULL DEFAULT 0, -- 廃棄日数
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmt_stock_holiday_pkey PRIMARY KEY (tmt_stock_holiday_id)
)
;
COMMENT ON TABLE tmt_stock_holiday IS 'ストック休暇トランザクション';
COMMENT ON COLUMN tmt_stock_holiday.tmt_stock_holiday_id IS 'レコード識別ID';
COMMENT ON COLUMN tmt_stock_holiday.personal_id IS '個人ID';
COMMENT ON COLUMN tmt_stock_holiday.activate_date IS '有効日';
COMMENT ON COLUMN tmt_stock_holiday.acquisition_date IS '取得日';
COMMENT ON COLUMN tmt_stock_holiday.giving_day IS '付与日数';
COMMENT ON COLUMN tmt_stock_holiday.cancel_day IS '廃棄日数';
COMMENT ON COLUMN tmt_stock_holiday.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmt_stock_holiday.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmt_stock_holiday.insert_date IS '登録日';
COMMENT ON COLUMN tmt_stock_holiday.insert_user IS '登録者';
COMMENT ON COLUMN tmt_stock_holiday.update_date IS '更新日';
COMMENT ON COLUMN tmt_stock_holiday.update_user IS '更新者';

-- Table: tmm_schedule

-- DROP TABLE tmm_schedule;

CREATE TABLE tmm_schedule
(
  tmm_schedule_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  schedule_code character varying(10) NOT NULL DEFAULT ''::character varying, -- カレンダコード
  activate_date date NOT NULL, -- 有効日
  schedule_name character varying(50) NOT NULL DEFAULT ''::character varying, -- カレンダ名称
  schedule_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- カレンダ略称
  fiscal_year integer NOT NULL DEFAULT 0, -- 年度
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_schedule_pkey PRIMARY KEY (tmm_schedule_id)
)
;
COMMENT ON TABLE tmm_schedule IS 'カレンダマスタ';
COMMENT ON COLUMN tmm_schedule.tmm_schedule_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_schedule.schedule_code IS 'カレンダコード';
COMMENT ON COLUMN tmm_schedule.activate_date IS '有効日';
COMMENT ON COLUMN tmm_schedule.schedule_name IS 'カレンダ名称';
COMMENT ON COLUMN tmm_schedule.schedule_abbr IS 'カレンダ略称';
COMMENT ON COLUMN tmm_schedule.fiscal_year IS '年度';
COMMENT ON COLUMN tmm_schedule.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_schedule.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_schedule.insert_date IS '登録日';
COMMENT ON COLUMN tmm_schedule.insert_user IS '登録者';
COMMENT ON COLUMN tmm_schedule.update_date IS '更新日';
COMMENT ON COLUMN tmm_schedule.update_user IS '更新者';

-- Table: tmm_schedule_date

-- DROP TABLE tmm_schedule_date;

CREATE TABLE tmm_schedule_date
(
  tmm_schedule_date_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  schedule_code character varying(10) NOT NULL DEFAULT ''::character varying, -- カレンダコード
  activate_date date NOT NULL, -- 有効日
  schedule_date date NOT NULL, -- 日
  works integer NOT NULL DEFAULT 0, -- 勤務回数
  work_type_code character varying(20) NOT NULL DEFAULT ''::character varying, -- 勤務形態コード
  remark character varying(50) NOT NULL DEFAULT ''::character varying, -- 備考
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_schedule_date_pkey PRIMARY KEY (tmm_schedule_date_id)
)
;
COMMENT ON TABLE tmm_schedule_date IS 'カレンダ日マスタ';
COMMENT ON COLUMN tmm_schedule_date.tmm_schedule_date_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_schedule_date.schedule_code IS 'カレンダコード';
COMMENT ON COLUMN tmm_schedule_date.activate_date IS '有効日';
COMMENT ON COLUMN tmm_schedule_date.schedule_date IS '日';
COMMENT ON COLUMN tmm_schedule_date.works IS '勤務回数';
COMMENT ON COLUMN tmm_schedule_date.work_type_code IS '勤務形態コード';
COMMENT ON COLUMN tmm_schedule_date.remark IS '備考';
COMMENT ON COLUMN tmm_schedule_date.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_schedule_date.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_schedule_date.insert_date IS '登録日';
COMMENT ON COLUMN tmm_schedule_date.insert_user IS '登録者';
COMMENT ON COLUMN tmm_schedule_date.update_date IS '更新日';
COMMENT ON COLUMN tmm_schedule_date.update_user IS '更新者';

-- Table: tmm_cutoff

-- DROP TABLE tmm_cutoff;

CREATE TABLE tmm_cutoff
(
  tmm_cutoff_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  cutoff_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 締日コード
  activate_date date NOT NULL, -- 有効日
  cutoff_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 締日名称
  cutoff_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 締日略称
  cutoff_date integer NOT NULL DEFAULT 0, -- 締日
  cutoff_type character varying(50) NOT NULL DEFAULT ''::character varying, -- 締区分
  no_approval integer NOT NULL DEFAULT 0, -- 未承認仮締
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_cutoff_pkey PRIMARY KEY (tmm_cutoff_id)
)
;
COMMENT ON TABLE tmm_cutoff IS '締日マスタ';
COMMENT ON COLUMN tmm_cutoff.tmm_cutoff_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_cutoff.cutoff_code IS '締日コード';
COMMENT ON COLUMN tmm_cutoff.activate_date IS '有効日';
COMMENT ON COLUMN tmm_cutoff.cutoff_name IS '締日名称';
COMMENT ON COLUMN tmm_cutoff.cutoff_abbr IS '締日略称';
COMMENT ON COLUMN tmm_cutoff.cutoff_date IS '締日';
COMMENT ON COLUMN tmm_cutoff.cutoff_type IS '締区分';
COMMENT ON COLUMN tmm_cutoff.no_approval IS '未承認仮締';
COMMENT ON COLUMN tmm_cutoff.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_cutoff.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_cutoff.insert_date IS '登録日';
COMMENT ON COLUMN tmm_cutoff.insert_user IS '登録者';
COMMENT ON COLUMN tmm_cutoff.update_date IS '更新日';
COMMENT ON COLUMN tmm_cutoff.update_user IS '更新者';

-- Table: tmm_application

-- DROP TABLE tmm_application;

CREATE TABLE tmm_application
(
  tmm_application_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  application_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 設定適用コード
  activate_date date NOT NULL, -- 有効日
  application_type integer NOT NULL DEFAULT 0, -- 設定適用区分
  application_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 設定適用名称
  application_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 設定適用略称
  work_setting_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤怠設定コード
  schedule_code character varying(10) NOT NULL DEFAULT ''::character varying, -- カレンダコード
  paid_holiday_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 有休コード
  work_place_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤務地コード
  employment_contract_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 雇用契約コード
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 所属コード
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 職位コード
  personal_ids text NOT NULL DEFAULT ''::character varying, -- 個人ID
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT tmm_application_pkey PRIMARY KEY (tmm_application_id)
)
;
COMMENT ON TABLE tmm_application IS '設定適用マスタ';
COMMENT ON COLUMN tmm_application.tmm_application_id IS 'レコード識別ID';
COMMENT ON COLUMN tmm_application.application_code IS '設定適用コード';
COMMENT ON COLUMN tmm_application.activate_date IS '有効日';
COMMENT ON COLUMN tmm_application.application_type IS '設定適用区分';
COMMENT ON COLUMN tmm_application.application_name IS '設定適用名称';
COMMENT ON COLUMN tmm_application.application_abbr IS '設定適用略称';
COMMENT ON COLUMN tmm_application.work_setting_code IS '勤怠設定コード';
COMMENT ON COLUMN tmm_application.schedule_code IS 'カレンダコード';
COMMENT ON COLUMN tmm_application.paid_holiday_code IS '有休コード';
COMMENT ON COLUMN tmm_application.work_place_code IS '勤務地コード';
COMMENT ON COLUMN tmm_application.employment_contract_code IS '雇用契約コード';
COMMENT ON COLUMN tmm_application.section_code IS '所属コード';
COMMENT ON COLUMN tmm_application.position_code IS '職位コード';
COMMENT ON COLUMN tmm_application.personal_ids IS '個人ID';
COMMENT ON COLUMN tmm_application.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN tmm_application.delete_flag IS '削除フラグ';
COMMENT ON COLUMN tmm_application.insert_date IS '登録日';
COMMENT ON COLUMN tmm_application.insert_user IS '登録者';
COMMENT ON COLUMN tmm_application.update_date IS '更新日';
COMMENT ON COLUMN tmm_application.update_user IS '更新者';

