-- 
-- MosP - Mind Open Source Project    http://www.mosp.jp/
-- Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
-- 
-- This program is free software: you can redistribute it and/or
-- modify it under the terms of the GNU Affero General Public License
-- as published by the Free Software Foundation, either version 3
-- of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
-- 
SET client_encoding = 'UTF8';
--SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;
SET default_tablespace = '';
SET default_with_oids = false;

-- Table: pfa_human_concurrent

-- DROP TABLE pfa_human_concurrent;

CREATE TABLE pfa_human_concurrent
(
  pfa_human_concurrent_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  start_date date NOT NULL, -- 開始日
  end_date date, -- 終了日
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 所属コード
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 職位コード
  concurrent_remark text NOT NULL DEFAULT ''::text, -- 備考
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pft_human_concurrent_pkey PRIMARY KEY (pfa_human_concurrent_id)
)
;
COMMENT ON TABLE pfa_human_concurrent IS '人事兼務情報';
COMMENT ON COLUMN pfa_human_concurrent.pfa_human_concurrent_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_human_concurrent.personal_id IS '個人ID';
COMMENT ON COLUMN pfa_human_concurrent.start_date IS '開始日';
COMMENT ON COLUMN pfa_human_concurrent.end_date IS '終了日';
COMMENT ON COLUMN pfa_human_concurrent.section_code IS '所属コード';
COMMENT ON COLUMN pfa_human_concurrent.position_code IS '職位コード';
COMMENT ON COLUMN pfa_human_concurrent.concurrent_remark IS '備考';
COMMENT ON COLUMN pfa_human_concurrent.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_human_concurrent.insert_date IS '登録日';
COMMENT ON COLUMN pfa_human_concurrent.insert_user IS '登録者';
COMMENT ON COLUMN pfa_human_concurrent.update_date IS '更新日';
COMMENT ON COLUMN pfa_human_concurrent.update_user IS '更新者';

-- Table: pfa_human_entrance

-- DROP TABLE pfa_human_entrance;

CREATE TABLE pfa_human_entrance
(
  pfa_human_entrance_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  entrance_date date NOT NULL, -- 入社日
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pft_human_entrance_pkey PRIMARY KEY (pfa_human_entrance_id)
)
;
COMMENT ON TABLE pfa_human_entrance IS '人事入社情報';
COMMENT ON COLUMN pfa_human_entrance.pfa_human_entrance_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_human_entrance.personal_id IS '個人ID';
COMMENT ON COLUMN pfa_human_entrance.entrance_date IS '入社日';
COMMENT ON COLUMN pfa_human_entrance.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_human_entrance.insert_date IS '登録日';
COMMENT ON COLUMN pfa_human_entrance.insert_user IS '登録者';
COMMENT ON COLUMN pfa_human_entrance.update_date IS '更新日';
COMMENT ON COLUMN pfa_human_entrance.update_user IS '更新者';

-- Table: pfa_human_retirement

-- DROP TABLE pfa_human_retirement;

CREATE TABLE pfa_human_retirement
(
  pfa_human_retirement_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  retirement_date date NOT NULL, -- 退職日
  retirement_reason character varying(10) NOT NULL DEFAULT ''::character varying, -- 退職理由
  retirement_detail text NOT NULL DEFAULT ''::text, -- 詳細
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pft_human_retirement_pkey PRIMARY KEY (pfa_human_retirement_id)
)
;
COMMENT ON TABLE pfa_human_retirement IS '人事退職情報';
COMMENT ON COLUMN pfa_human_retirement.pfa_human_retirement_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_human_retirement.personal_id IS '個人ID';
COMMENT ON COLUMN pfa_human_retirement.retirement_date IS '退職日';
COMMENT ON COLUMN pfa_human_retirement.retirement_reason IS '退職理由';
COMMENT ON COLUMN pfa_human_retirement.retirement_detail IS '詳細';
COMMENT ON COLUMN pfa_human_retirement.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_human_retirement.insert_date IS '登録日';
COMMENT ON COLUMN pfa_human_retirement.insert_user IS '登録者';
COMMENT ON COLUMN pfa_human_retirement.update_date IS '更新日';
COMMENT ON COLUMN pfa_human_retirement.update_user IS '更新者';

-- Table: pfa_human_suspension

-- DROP TABLE pfa_human_suspension;

CREATE TABLE pfa_human_suspension
(
  pfa_human_suspension_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  start_date date NOT NULL, -- 開始日
  end_date date, -- 終了日
  schedule_end_date date NOT NULL, -- 終了予定日
  allowance_type character varying(10) NOT NULL DEFAULT ''::character varying, -- 給与区分
  suspension_reason text NOT NULL DEFAULT ''::text, -- 理由
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pft_human_suspension_pkey PRIMARY KEY (pfa_human_suspension_id)
)
;
COMMENT ON TABLE pfa_human_suspension IS '人事休職情報';
COMMENT ON COLUMN pfa_human_suspension.pfa_human_suspension_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_human_suspension.personal_id IS '個人ID';
COMMENT ON COLUMN pfa_human_suspension.start_date IS '開始日';
COMMENT ON COLUMN pfa_human_suspension.end_date IS '終了日';
COMMENT ON COLUMN pfa_human_suspension.schedule_end_date IS '終了予定日';
COMMENT ON COLUMN pfa_human_suspension.allowance_type IS '給与区分';
COMMENT ON COLUMN pfa_human_suspension.suspension_reason IS '理由';
COMMENT ON COLUMN pfa_human_suspension.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_human_suspension.insert_date IS '登録日';
COMMENT ON COLUMN pfa_human_suspension.insert_user IS '登録者';
COMMENT ON COLUMN pfa_human_suspension.update_date IS '更新日';
COMMENT ON COLUMN pfa_human_suspension.update_user IS '更新者';

-- Table: pfa_user_password

-- DROP TABLE pfa_user_password;

CREATE TABLE pfa_user_password
(
  pfa_user_password_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  user_id character varying(50) NOT NULL DEFAULT ''::character varying, -- ユーザID
  change_date date NOT NULL, -- 変更日
  "password" character varying(50) NOT NULL DEFAULT ''::character varying, -- パスワード
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pft_password_pkey PRIMARY KEY (pfa_user_password_id)
)
;
COMMENT ON TABLE pfa_user_password IS 'ユーザパスワード情報';
COMMENT ON COLUMN pfa_user_password.pfa_user_password_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_user_password.user_id IS 'ユーザID';
COMMENT ON COLUMN pfa_user_password.change_date IS '変更日';
COMMENT ON COLUMN pfa_user_password."password" IS 'パスワード';
COMMENT ON COLUMN pfa_user_password.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_user_password.insert_date IS '登録日';
COMMENT ON COLUMN pfa_user_password.insert_user IS '登録者';
COMMENT ON COLUMN pfa_user_password.update_date IS '更新日';
COMMENT ON COLUMN pfa_user_password.update_user IS '更新者';

-- Table: pfm_employment_contract

-- DROP TABLE pfm_employment_contract;

CREATE TABLE pfm_employment_contract
(
  pfm_employment_contract_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  employment_contract_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 雇用契約コード
  activate_date date NOT NULL, -- 有効日
  employment_contract_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 雇用契約名称
  employment_contract_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 雇用契約略称
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_employment_contract_pkey PRIMARY KEY (pfm_employment_contract_id)
)
;
COMMENT ON TABLE pfm_employment_contract IS '雇用契約マスタ';
COMMENT ON COLUMN pfm_employment_contract.pfm_employment_contract_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_employment_contract.employment_contract_code IS '雇用契約コード';
COMMENT ON COLUMN pfm_employment_contract.activate_date IS '有効日';
COMMENT ON COLUMN pfm_employment_contract.employment_contract_name IS '雇用契約名称';
COMMENT ON COLUMN pfm_employment_contract.employment_contract_abbr IS '雇用契約略称';
COMMENT ON COLUMN pfm_employment_contract.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_employment_contract.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_employment_contract.insert_date IS '登録日';
COMMENT ON COLUMN pfm_employment_contract.insert_user IS '登録者';
COMMENT ON COLUMN pfm_employment_contract.update_date IS '更新日';
COMMENT ON COLUMN pfm_employment_contract.update_user IS '更新者';

-- Table: pfm_human

-- DROP TABLE pfm_human;

CREATE TABLE pfm_human
(
  pfm_human_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  activate_date date NOT NULL, -- 有効日
  employee_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 社員コード
  last_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 姓
  first_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 名
  last_kana character varying(50) NOT NULL DEFAULT ''::character varying, -- カナ姓
  first_kana character varying(50) NOT NULL DEFAULT ''::character varying, -- カナ名
  employment_contract_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 雇用契約コード
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 所属コード
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 職位コード
  work_place_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤務地コード
  mail character varying(50) NOT NULL DEFAULT ''::character varying, -- メールアドレス
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_human_basis_pkey PRIMARY KEY (pfm_human_id)
)
;
COMMENT ON TABLE pfm_human IS '人事マスタ';
COMMENT ON COLUMN pfm_human.pfm_human_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_human.personal_id IS '個人ID';
COMMENT ON COLUMN pfm_human.activate_date IS '有効日';
COMMENT ON COLUMN pfm_human.employee_code IS '社員コード';
COMMENT ON COLUMN pfm_human.last_name IS '姓';
COMMENT ON COLUMN pfm_human.first_name IS '名';
COMMENT ON COLUMN pfm_human.last_kana IS 'カナ姓';
COMMENT ON COLUMN pfm_human.first_kana IS 'カナ名';
COMMENT ON COLUMN pfm_human.employment_contract_code IS '雇用契約コード';
COMMENT ON COLUMN pfm_human.section_code IS '所属コード';
COMMENT ON COLUMN pfm_human.position_code IS '職位コード';
COMMENT ON COLUMN pfm_human.work_place_code IS '勤務地コード';
COMMENT ON COLUMN pfm_human.mail IS 'メールアドレス';
COMMENT ON COLUMN pfm_human.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_human.insert_date IS '登録日';
COMMENT ON COLUMN pfm_human.insert_user IS '登録者';
COMMENT ON COLUMN pfm_human.update_date IS '更新日';
COMMENT ON COLUMN pfm_human.update_user IS '更新者';

-- Table: pfm_position

-- DROP TABLE pfm_position;

CREATE TABLE pfm_position
(
  pfm_position_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 職位コード
  activate_date date NOT NULL, -- 有効日
  position_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 職位名称
  position_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 職位略称
  position_grade integer NOT NULL DEFAULT 0, -- 等級
  position_level integer NOT NULL DEFAULT 0, -- 号数
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_position_pkey PRIMARY KEY (pfm_position_id)
)
;
COMMENT ON TABLE pfm_position IS '職位マスタ';
COMMENT ON COLUMN pfm_position.pfm_position_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_position.position_code IS '職位コード';
COMMENT ON COLUMN pfm_position.activate_date IS '有効日';
COMMENT ON COLUMN pfm_position.position_name IS '職位名称';
COMMENT ON COLUMN pfm_position.position_abbr IS '職位略称';
COMMENT ON COLUMN pfm_position.position_grade IS '等級';
COMMENT ON COLUMN pfm_position.position_level IS '号数';
COMMENT ON COLUMN pfm_position.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_position.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_position.insert_date IS '登録日';
COMMENT ON COLUMN pfm_position.insert_user IS '登録者';
COMMENT ON COLUMN pfm_position.update_date IS '更新日';
COMMENT ON COLUMN pfm_position.update_user IS '更新者';

-- Table: pfm_section

-- DROP TABLE pfm_section;

CREATE TABLE pfm_section
(
  pfm_section_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 所属コード
  activate_date date NOT NULL, -- 有効日
  section_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 所属名称
  section_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 所属略称
  section_display character varying(50) NOT NULL DEFAULT ''::character varying, -- 所属表示名称
  class_route text NOT NULL DEFAULT ''::text, -- 階層経路
  close_flag integer NOT NULL DEFAULT 0, -- 閉鎖フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_section_pkey PRIMARY KEY (pfm_section_id)
)
;
COMMENT ON TABLE pfm_section IS '所属マスタ';
COMMENT ON COLUMN pfm_section.pfm_section_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_section.section_code IS '所属コード';
COMMENT ON COLUMN pfm_section.activate_date IS '有効日';
COMMENT ON COLUMN pfm_section.section_name IS '所属名称';
COMMENT ON COLUMN pfm_section.section_abbr IS '所属略称';
COMMENT ON COLUMN pfm_section.section_display IS '所属表示名称';
COMMENT ON COLUMN pfm_section.class_route IS '階層経路';
COMMENT ON COLUMN pfm_section.close_flag IS '閉鎖フラグ';
COMMENT ON COLUMN pfm_section.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_section.insert_date IS '登録日';
COMMENT ON COLUMN pfm_section.insert_user IS '登録者';
COMMENT ON COLUMN pfm_section.update_date IS '更新日';
COMMENT ON COLUMN pfm_section.update_user IS '更新者';

-- Table: pfm_user

-- DROP TABLE pfm_user;

CREATE TABLE pfm_user
(
  pfm_user_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  user_id character varying(50) NOT NULL DEFAULT ''::character varying, -- ユーザID
  activate_date date NOT NULL, -- 有効日
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  role_code character varying(50) NOT NULL DEFAULT ''::character varying, -- ロールコード
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_user_pkey PRIMARY KEY (pfm_user_id)
)
;
COMMENT ON TABLE pfm_user IS 'ユーザマスタ';
COMMENT ON COLUMN pfm_user.pfm_user_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_user.user_id IS 'ユーザID';
COMMENT ON COLUMN pfm_user.activate_date IS '有効日';
COMMENT ON COLUMN pfm_user.personal_id IS '個人ID';
COMMENT ON COLUMN pfm_user.role_code IS 'ロールコード';
COMMENT ON COLUMN pfm_user.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_user.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_user.insert_date IS '登録日';
COMMENT ON COLUMN pfm_user.insert_user IS '登録者';
COMMENT ON COLUMN pfm_user.update_date IS '更新日';
COMMENT ON COLUMN pfm_user.update_user IS '更新者';

-- Table: pfm_work_place

-- DROP TABLE pfm_work_place;

CREATE TABLE pfm_work_place
(
  pfm_work_place_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  work_place_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤務地コード
  activate_date date NOT NULL, -- 有効日
  work_place_name character varying(50) NOT NULL DEFAULT ''::character varying, -- 勤務地名称
  work_place_kana character varying(50) NOT NULL DEFAULT ''::character varying, -- 勤務地カナ
  work_place_abbr character varying(5) NOT NULL DEFAULT ''::character varying, -- 勤務地略称
  prefecture character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤務地都道府県
  address_1 character varying(50) NOT NULL DEFAULT ''::character varying, -- 勤務地市区町村
  address_2 character varying(50) NOT NULL DEFAULT ''::character varying, -- 勤務地番地
  address_3 character varying(50) NOT NULL DEFAULT ''::character varying, -- 勤務地建物情報
  postal_code_1 character varying(3) NOT NULL DEFAULT ''::character varying, -- 勤務地郵便番号1
  postal_code_2 character varying(4) NOT NULL DEFAULT ''::character varying, -- 勤務地郵便番号2
  phone_number_1 character varying(5) NOT NULL DEFAULT ''::character varying, -- 勤務地電話番号1
  phone_number_2 character varying(4) NOT NULL DEFAULT ''::character varying, -- 勤務地電話番号2
  phone_number_3 character varying(4) NOT NULL DEFAULT ''::character varying, -- 勤務地電話番号3
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_work_place_pkey PRIMARY KEY (pfm_work_place_id)
)
;
COMMENT ON TABLE pfm_work_place IS '勤務地マスタ';
COMMENT ON COLUMN pfm_work_place.pfm_work_place_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_work_place.work_place_code IS '勤務地コード';
COMMENT ON COLUMN pfm_work_place.activate_date IS '有効日';
COMMENT ON COLUMN pfm_work_place.work_place_name IS '勤務地名称';
COMMENT ON COLUMN pfm_work_place.work_place_kana IS '勤務地カナ';
COMMENT ON COLUMN pfm_work_place.work_place_abbr IS '勤務地略称';
COMMENT ON COLUMN pfm_work_place.prefecture IS '勤務地都道府県';
COMMENT ON COLUMN pfm_work_place.address_1 IS '勤務地市区町村';
COMMENT ON COLUMN pfm_work_place.address_2 IS '勤務地番地';
COMMENT ON COLUMN pfm_work_place.address_3 IS '勤務地建物情報';
COMMENT ON COLUMN pfm_work_place.postal_code_1 IS '勤務地郵便番号1';
COMMENT ON COLUMN pfm_work_place.postal_code_2 IS '勤務地郵便番号2';
COMMENT ON COLUMN pfm_work_place.phone_number_1 IS '勤務地電話番号1';
COMMENT ON COLUMN pfm_work_place.phone_number_2 IS '勤務地電話番号2';
COMMENT ON COLUMN pfm_work_place.phone_number_3 IS '勤務地電話番号3';
COMMENT ON COLUMN pfm_work_place.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_work_place.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_work_place.insert_date IS '登録日';
COMMENT ON COLUMN pfm_work_place.insert_user IS '登録者';
COMMENT ON COLUMN pfm_work_place.update_date IS '更新日';
COMMENT ON COLUMN pfm_work_place.update_user IS '更新者';

-- Table: pft_workflow

-- DROP TABLE pft_workflow;

CREATE TABLE pft_workflow
(
  pft_workflow_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  workflow bigint NOT NULL DEFAULT 0, -- ワークフロー番号
  workflow_stage integer NOT NULL DEFAULT 0, -- 段階
  workflow_status character varying(10) NOT NULL DEFAULT ''::character varying, -- 状況
  route_code character varying(10) NOT NULL DEFAULT ''::character varying, -- ルートコード
  function_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 機能コード
  approver_id text NOT NULL DEFAULT ''::text, -- 承認者個人ID
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pft_workflow_pkey PRIMARY KEY (pft_workflow_id)
)
;
COMMENT ON TABLE pft_workflow IS 'ワークフロー';
COMMENT ON COLUMN pft_workflow.pft_workflow_id IS 'レコード識別ID';
COMMENT ON COLUMN pft_workflow.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN pft_workflow.workflow_stage IS '段階';
COMMENT ON COLUMN pft_workflow.workflow_status IS '状況';
COMMENT ON COLUMN pft_workflow.route_code IS 'ルートコード';
COMMENT ON COLUMN pft_workflow.function_code IS '機能コード';
COMMENT ON COLUMN pft_workflow.approver_id IS '承認者個人ID';
COMMENT ON COLUMN pft_workflow.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pft_workflow.insert_date IS '登録日';
COMMENT ON COLUMN pft_workflow.insert_user IS '登録者';
COMMENT ON COLUMN pft_workflow.update_date IS '更新日';
COMMENT ON COLUMN pft_workflow.update_user IS '更新者';

-- Table: pft_workflow_comment

-- DROP TABLE pft_workflow_comment;

CREATE TABLE pft_workflow_comment
(
  pft_workflow_comment_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  workflow bigint NOT NULL DEFAULT 0, -- ワークフロー番号
  workflow_stage integer NOT NULL DEFAULT 0, -- 段階
  workflow_status character varying(10) NOT NULL DEFAULT ''::character varying, -- 状況
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 個人ID
  workflow_comment character varying(50) NOT NULL DEFAULT ''::character varying, -- コメント
  workflow_date timestamp without time zone NOT NULL, -- 日時
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pft_workflow_comment_pkey PRIMARY KEY (pft_workflow_comment_id)
)
;
COMMENT ON TABLE pft_workflow_comment IS 'ワークフローコメント';
COMMENT ON COLUMN pft_workflow_comment.pft_workflow_comment_id IS 'レコード識別ID';
COMMENT ON COLUMN pft_workflow_comment.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN pft_workflow_comment.workflow_stage IS '段階';
COMMENT ON COLUMN pft_workflow_comment.workflow_status IS '状況';
COMMENT ON COLUMN pft_workflow_comment.personal_id IS '個人ID';
COMMENT ON COLUMN pft_workflow_comment.workflow_comment IS 'コメント';
COMMENT ON COLUMN pft_workflow_comment.workflow_date IS '日時';
COMMENT ON COLUMN pft_workflow_comment.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pft_workflow_comment.insert_date IS '登録日';
COMMENT ON COLUMN pft_workflow_comment.insert_user IS '登録者';
COMMENT ON COLUMN pft_workflow_comment.update_date IS '更新日';
COMMENT ON COLUMN pft_workflow_comment.update_user IS '更新者';

-- Table: pfm_approval_unit

-- DROP TABLE pfm_approval_unit;

CREATE TABLE pfm_approval_unit
(
  pfm_approval_unit_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  unit_code character varying(10) NOT NULL DEFAULT ''::character varying, -- ユニットコード
  activate_date date NOT NULL, -- 有効日
  unit_name character varying(50) NOT NULL DEFAULT ''::character varying, -- ユニット名称
  unit_type character varying(10) NOT NULL DEFAULT ''::character varying, -- ユニット区分
  approver_personal_id character varying(250) NOT NULL DEFAULT ''::character varying, -- 承認者個人ID
  approver_section_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 承認者所属コード
  approver_position_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 承認者職位コード
  route_stage integer NOT NULL DEFAULT 0, -- 複数決済
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_approval_unit_pkey PRIMARY KEY (pfm_approval_unit_id)
)
;
COMMENT ON TABLE pfm_approval_unit IS '承認ユニットマスタ';
COMMENT ON COLUMN pfm_approval_unit.pfm_approval_unit_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_approval_unit.unit_code IS 'ユニットコード';
COMMENT ON COLUMN pfm_approval_unit.activate_date IS '有効日';
COMMENT ON COLUMN pfm_approval_unit.unit_name IS 'ユニット名称';
COMMENT ON COLUMN pfm_approval_unit.unit_type IS 'ユニット区分';
COMMENT ON COLUMN pfm_approval_unit.approver_personal_id IS '承認者個人ID';
COMMENT ON COLUMN pfm_approval_unit.approver_section_code IS '承認者所属コード';
COMMENT ON COLUMN pfm_approval_unit.approver_position_code IS '承認者職位コード';
COMMENT ON COLUMN pfm_approval_unit.route_stage IS '複数決済';
COMMENT ON COLUMN pfm_approval_unit.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_approval_unit.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_approval_unit.insert_date IS '登録日';
COMMENT ON COLUMN pfm_approval_unit.insert_user IS '登録者';
COMMENT ON COLUMN pfm_approval_unit.update_date IS '更新日';
COMMENT ON COLUMN pfm_approval_unit.update_user IS '更新者';

-- Table: pfm_approval_route

-- DROP TABLE pfm_approval_route;

CREATE TABLE pfm_approval_route
(
  pfm_approval_route_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  route_code character varying(10) NOT NULL DEFAULT ''::character varying, -- ルートコード
  activate_date date NOT NULL, -- 有効日
  route_name character varying(50) NOT NULL DEFAULT ''::character varying, -- ルート名称
  approval_count integer NOT NULL DEFAULT 0, -- 承認階層
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_approval_route_pkey PRIMARY KEY (pfm_approval_route_id)
)
;
COMMENT ON TABLE pfm_approval_route IS '承認ルートマスタ';
COMMENT ON COLUMN pfm_approval_route.pfm_approval_route_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_approval_route.route_code IS 'ルートコード';
COMMENT ON COLUMN pfm_approval_route.activate_date IS '有効日';
COMMENT ON COLUMN pfm_approval_route.route_name IS 'ルート名称';
COMMENT ON COLUMN pfm_approval_route.approval_count IS '承認階層';
COMMENT ON COLUMN pfm_approval_route.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_approval_route.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_approval_route.insert_date IS '登録日';
COMMENT ON COLUMN pfm_approval_route.insert_user IS '登録者';
COMMENT ON COLUMN pfm_approval_route.update_date IS '更新日';
COMMENT ON COLUMN pfm_approval_route.update_user IS '更新者';

-- Table: pfa_approval_route_unit

-- DROP TABLE pfa_approval_route_unit;

CREATE TABLE pfa_approval_route_unit
(
  pfa_approval_route_unit_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  route_code character varying(10) NOT NULL DEFAULT ''::character varying, -- ルートコード
  activate_date date NOT NULL, -- 有効日
  approval_stage integer NOT NULL DEFAULT 0, -- 承認段階
  unit_code character varying(10) NOT NULL DEFAULT ''::character varying, -- ユニットコード
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfa_approval_route_unit_pkey PRIMARY KEY (pfa_approval_route_unit_id)
)
;
COMMENT ON TABLE pfa_approval_route_unit IS '承認ルートユニットマスタ';
COMMENT ON COLUMN pfa_approval_route_unit.pfa_approval_route_unit_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_approval_route_unit.route_code IS 'ルートコード';
COMMENT ON COLUMN pfa_approval_route_unit.activate_date IS '有効日';
COMMENT ON COLUMN pfa_approval_route_unit.approval_stage IS '承認段階';
COMMENT ON COLUMN pfa_approval_route_unit.unit_code IS 'ユニットコード';
COMMENT ON COLUMN pfa_approval_route_unit.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfa_approval_route_unit.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_approval_route_unit.insert_date IS '登録日';
COMMENT ON COLUMN pfa_approval_route_unit.insert_user IS '登録者';
COMMENT ON COLUMN pfa_approval_route_unit.update_date IS '更新日';
COMMENT ON COLUMN pfa_approval_route_unit.update_user IS '更新者';

-- Table: pft_message

-- DROP TABLE pft_message;

CREATE TABLE pft_message
(
  pft_message_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  message_no character varying(10) NOT NULL DEFAULT ''::character varying, -- メッセージNo
  start_date date NOT NULL, -- 公開開始日
  end_date date NOT NULL, -- 公開終了日
  message_type integer NOT NULL DEFAULT 0, -- メッセージ区分
  message_importance integer NOT NULL DEFAULT 0, -- 重要度
  message_title character varying(255) NOT NULL DEFAULT ''::character varying, -- メッセージタイトル
  message_body text NOT NULL DEFAULT ''::character varying, -- メッセージ本文
  application_type integer NOT NULL DEFAULT 0, -- メッセージ適用範囲区分
  work_place_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤務地コード
  employment_contract_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 雇用契約コード
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 所属コード
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 職位コード
  personal_ids text NOT NULL DEFAULT ''::character varying, -- 個人ID
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pft_message_pkey PRIMARY KEY (pft_message_id)
)
;
COMMENT ON TABLE pft_message IS 'メッセージテーブル';
COMMENT ON COLUMN pft_message.pft_message_id IS 'レコード識別ID';
COMMENT ON COLUMN pft_message.message_no IS 'メッセージNo';
COMMENT ON COLUMN pft_message.start_date IS '公開開始日';
COMMENT ON COLUMN pft_message.end_date IS '公開終了日';
COMMENT ON COLUMN pft_message.message_type IS 'メッセージ区分';
COMMENT ON COLUMN pft_message.message_importance IS '重要度';
COMMENT ON COLUMN pft_message.message_title IS 'メッセージタイトル';
COMMENT ON COLUMN pft_message.message_body IS 'メッセージ本文';
COMMENT ON COLUMN pft_message.application_type IS 'メッセージ適用範囲区分';
COMMENT ON COLUMN pft_message.work_place_code IS '勤務地コード';
COMMENT ON COLUMN pft_message.employment_contract_code IS '雇用契約コード';
COMMENT ON COLUMN pft_message.section_code IS '所属コード';
COMMENT ON COLUMN pft_message.position_code IS '職位コード';
COMMENT ON COLUMN pft_message.personal_ids IS '個人ID';
COMMENT ON COLUMN pft_message.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pft_message.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pft_message.insert_date IS '登録日';
COMMENT ON COLUMN pft_message.insert_user IS '登録者';
COMMENT ON COLUMN pft_message.update_date IS '更新日';
COMMENT ON COLUMN pft_message.update_user IS '更新者';


-- Table: pft_sub_approver

-- DROP TABLE pft_sub_approver;

CREATE TABLE pft_sub_approver
(
  pft_sub_approver_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  sub_approver_no character varying(10) NOT NULL DEFAULT ''::character varying, -- 代理承認者登録No
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 代理元個人ID
  workflow_type integer NOT NULL DEFAULT 0, -- フロー区分
  start_date date NOT NULL, -- 代理開始日
  end_date date NOT NULL, -- 代理終了日
  sub_approver_id character varying(10) NOT NULL DEFAULT ''::character varying, -- 代理承認者個人ID
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pft_sub_approver_pkey PRIMARY KEY (pft_sub_approver_id)
)
;
COMMENT ON TABLE pft_sub_approver IS '代理承認者テーブル';
COMMENT ON COLUMN pft_sub_approver.pft_sub_approver_id IS 'レコード識別ID';
COMMENT ON COLUMN pft_sub_approver.sub_approver_no IS '代理承認者登録No';
COMMENT ON COLUMN pft_sub_approver.personal_id IS '代理元個人ID';
COMMENT ON COLUMN pft_sub_approver.workflow_type IS 'フロー区分';
COMMENT ON COLUMN pft_sub_approver.start_date IS '代理開始日';
COMMENT ON COLUMN pft_sub_approver.end_date IS '代理終了日';
COMMENT ON COLUMN pft_sub_approver.sub_approver_id IS '代理承認者個人ID';
COMMENT ON COLUMN pft_sub_approver.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pft_sub_approver.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pft_sub_approver.insert_date IS '登録日';
COMMENT ON COLUMN pft_sub_approver.insert_user IS '登録者';
COMMENT ON COLUMN pft_sub_approver.update_date IS '更新日';
COMMENT ON COLUMN pft_sub_approver.update_user IS '更新者';


-- Table: pfm_route_application

-- DROP TABLE pfm_route_application;

CREATE TABLE pfm_route_application
(
  pfm_route_application_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  route_application_code character varying(10) NOT NULL DEFAULT ''::character varying, -- ルート適用コード
  activate_date date NOT NULL, -- 有効日
  route_application_name character varying(50) NOT NULL DEFAULT ''::character varying, -- ルート適用名称
  route_code character varying(10) NOT NULL DEFAULT ''::character varying, -- ルートコード
  workflow_type integer NOT NULL DEFAULT 0, -- フロー区分
  route_application_type integer NOT NULL DEFAULT 0, -- ルート適用区分
  work_place_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 勤務地コード
  employment_contract_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 雇用契約コード
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 所属コード
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, -- 職位コード
  personal_ids text NOT NULL DEFAULT ''::character varying, -- 個人ID
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_approval_route_application_pkey PRIMARY KEY (pfm_route_application_id)
)
;
COMMENT ON TABLE pfm_route_application IS 'ルート適用マスタ';
COMMENT ON COLUMN pfm_route_application.pfm_route_application_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_route_application.route_application_code IS 'ルート適用コード';
COMMENT ON COLUMN pfm_route_application.activate_date IS '有効日';
COMMENT ON COLUMN pfm_route_application.route_application_name IS 'ルート適用名称';
COMMENT ON COLUMN pfm_route_application.route_code IS 'ルートコード';
COMMENT ON COLUMN pfm_route_application.workflow_type IS 'フロー区分';
COMMENT ON COLUMN pfm_route_application.route_application_type IS 'ルート適用区分';
COMMENT ON COLUMN pfm_route_application.work_place_code IS '勤務地コード';
COMMENT ON COLUMN pfm_route_application.employment_contract_code IS '雇用契約コード';
COMMENT ON COLUMN pfm_route_application.section_code IS '所属コード';
COMMENT ON COLUMN pfm_route_application.position_code IS '職位コード';
COMMENT ON COLUMN pfm_route_application.personal_ids IS '個人ID';
COMMENT ON COLUMN pfm_route_application.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_route_application.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_route_application.insert_date IS '登録日';
COMMENT ON COLUMN pfm_route_application.insert_user IS '登録者';
COMMENT ON COLUMN pfm_route_application.update_date IS '更新日';
COMMENT ON COLUMN pfm_route_application.update_user IS '更新者';

-- Table: pfm_import

-- DROP TABLE pfm_import;

CREATE TABLE pfm_import
(
  pfm_import_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  import_code character varying(10) NOT NULL DEFAULT ''::character varying, -- インポートコード
  import_name character varying(50) NOT NULL DEFAULT ''::character varying, -- インポート名称
  import_table character varying(50) NOT NULL DEFAULT ''::character varying, -- データ区分
  type character varying(50) NOT NULL DEFAULT ''::character varying, -- データ型
  header integer NOT NULL DEFAULT 0, -- ヘッダ有無
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_import_pkey PRIMARY KEY (pfm_import_id)
)
;
COMMENT ON TABLE pfm_import IS 'インポートマスタ';
COMMENT ON COLUMN pfm_import.pfm_import_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_import.import_code IS 'インポートコード';
COMMENT ON COLUMN pfm_import.import_name IS 'インポート名称';
COMMENT ON COLUMN pfm_import.import_table IS 'データ区分';
COMMENT ON COLUMN pfm_import.type IS 'データ型';
COMMENT ON COLUMN pfm_import.header IS 'ヘッダ有無';
COMMENT ON COLUMN pfm_import.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_import.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_import.insert_date IS '登録日';
COMMENT ON COLUMN pfm_import.insert_user IS '登録者';
COMMENT ON COLUMN pfm_import.update_date IS '更新日';
COMMENT ON COLUMN pfm_import.update_user IS '更新者';

-- Table: pfa_import_field

-- DROP TABLE pfa_import_field;

CREATE TABLE pfa_import_field
(
  pfa_import_field_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  import_code character varying(10) NOT NULL DEFAULT ''::character varying, -- インポートコード
  field_name character varying(50) NOT NULL DEFAULT ''::character varying, -- フィールド名称
  field_order integer NOT NULL DEFAULT 0, -- フィールド順番
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfa_import_field_pkey PRIMARY KEY (pfa_import_field_id)
)
;
COMMENT ON TABLE pfa_import_field IS 'インポートフィールド情報';
COMMENT ON COLUMN pfa_import_field.pfa_import_field_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_import_field.import_code IS 'インポートコード';
COMMENT ON COLUMN pfa_import_field.field_name IS 'フィールド名称';
COMMENT ON COLUMN pfa_import_field.field_order IS 'フィールド順番';
COMMENT ON COLUMN pfa_import_field.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfa_import_field.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_import_field.insert_date IS '登録日';
COMMENT ON COLUMN pfa_import_field.insert_user IS '登録者';
COMMENT ON COLUMN pfa_import_field.update_date IS '更新日';
COMMENT ON COLUMN pfa_import_field.update_user IS '更新者';

-- Table: pfm_export

-- DROP TABLE pfm_export;

CREATE TABLE pfm_export
(
  pfm_export_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  export_code character varying(10) NOT NULL DEFAULT ''::character varying, -- エクスポートコード
  export_name character varying(50) NOT NULL DEFAULT ''::character varying, -- エクスポート名称
  export_table character varying(50) NOT NULL DEFAULT ''::character varying, -- データ区分
  type character varying(50) NOT NULL DEFAULT ''::character varying, -- データ型
  header integer NOT NULL DEFAULT 0, -- ヘッダ有無
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfm_export_pkey PRIMARY KEY (pfm_export_id)
)
;
COMMENT ON TABLE pfm_export IS 'エクスポートマスタ';
COMMENT ON COLUMN pfm_export.pfm_export_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_export.export_code IS 'エクスポートコード';
COMMENT ON COLUMN pfm_export.export_name IS 'エクスポート名称';
COMMENT ON COLUMN pfm_export.export_table IS 'データ区分';
COMMENT ON COLUMN pfm_export.type IS 'データ型';
COMMENT ON COLUMN pfm_export.header IS 'ヘッダ有無';
COMMENT ON COLUMN pfm_export.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_export.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_export.insert_date IS '登録日';
COMMENT ON COLUMN pfm_export.insert_user IS '登録者';
COMMENT ON COLUMN pfm_export.update_date IS '更新日';
COMMENT ON COLUMN pfm_export.update_user IS '更新者';

-- Table: pfa_export_field

-- DROP TABLE pfa_export_field;

CREATE TABLE pfa_export_field
(
  pfa_export_field_id bigint NOT NULL DEFAULT 0, -- レコード識別ID
  export_code character varying(10) NOT NULL DEFAULT ''::character varying, -- エクスポートコード
  field_name character varying(50) NOT NULL DEFAULT ''::character varying, -- フィールド名称
  field_order integer NOT NULL DEFAULT 0, -- フィールド順番
  inactivate_flag integer NOT NULL DEFAULT 0, -- 無効フラグ
  delete_flag integer NOT NULL DEFAULT 0, -- 削除フラグ
  insert_date timestamp without time zone NOT NULL, -- 登録日
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 登録者
  update_date timestamp without time zone NOT NULL, -- 更新日
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, -- 更新者
  CONSTRAINT pfa_export_field_pkey PRIMARY KEY (pfa_export_field_id)
)
;
COMMENT ON TABLE pfa_export_field IS 'エクスポートフィールド情報';
COMMENT ON COLUMN pfa_export_field.pfa_export_field_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_export_field.export_code IS 'エクスポートコード';
COMMENT ON COLUMN pfa_export_field.field_name IS 'フィールド名称';
COMMENT ON COLUMN pfa_export_field.field_order IS 'フィールド順番';
COMMENT ON COLUMN pfa_export_field.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfa_export_field.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_export_field.insert_date IS '登録日';
COMMENT ON COLUMN pfa_export_field.insert_user IS '登録者';
COMMENT ON COLUMN pfa_export_field.update_date IS '更新日';
COMMENT ON COLUMN pfa_export_field.update_user IS '更新者';
