/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 振替日重複チェックエラーメッセージ。
 */
var MSG_TRANSFER_REPETITION_CHECK	= "TMW0216";

/**
 * 登録/削除確認メッセージ。
 */
var MSG_DIFFERENCE_REQUEST_CHECK	= "TMW0230";

/**
 * 画面読込時追加処理
 * @param 無し
 * @return 無し
 * @throws 実行時例外
 */
function onLoadExtra() {
	// 振替休暇申請範囲1判定
//	setOnChangeHandler("pltEditSubstitute1Range", checkSubstitute1Range);
//	checkSubstitute1Range();
	// 出勤日(年)判定
//	setOnChangeHandler("pltEditRequestYear", checkEditRequestYear);
//	checkEditRequestYear();
	// 出勤日(月)判定
//	setOnChangeHandler("pltEditRequestMonth", checkEditRequestMonth);
//	checkEditRequestMonth();
	// 振替日1(月)判定
//	setOnChangeHandler("pltEditSubstitute1Year", checkEditSubstitute1Year);
//	checkEditSubstitute1Year();
	// 振替日1(月)判定
//	setOnChangeHandler("pltEditSubstitute1Month", checkEditSubstitute1Month);
//	checkEditSubstitute1Month();
	// 振替日1(日)判定
//	setOnChangeHandler("pltEditSubstitute1Day", checkEditSubstitute1Day);
//	checkEditSubstitute1Day();
	// 振替日1(範囲)判定
//	setOnChangeHandler("pltEditSubstitute1Range", checkEditSubstitute1Range);
//	checkEditSubstitute1Range();
	// 振替日2(月)判定
//	setOnChangeHandler("pltEditSubstitute2Year", checkEditSubstitute2Year);
//	checkEditSubstitute2Year();
	// 振替日2(月)判定
//	setOnChangeHandler("pltEditSubstitute2Month", checkEditSubstitute2Month);
//	checkEditSubstitute2Month();
	// 振替日2(日)判定
//	setOnChangeHandler("pltEditSubstitute2Day", checkEditSubstitute2Day);
//	checkEditSubstitute2Day();
	// 振替日2(範囲)判定
//	setOnChangeHandler("pltEditSubstitute2Range", checkEditSubstitute2Range);
//	checkEditSubstitute2Range();
	// 承認状況がNULLの場合は全項目を読取専用にする
	if (jsStatusApplication == ""){
		setDisabled("pltEditRequestYear", false);
		setDisabled("pltEditRequestMonth", false);
		setDisabled("pltEditRequestDay", true);
		setDisabled("btnRequestDate", true);
		setDisabled("pltEditSubstitute", true);
		setDisabled("pltEditStartHour", true);
		setDisabled("pltEditStartMinute", true);
		setDisabled("pltEditEndHour", true);
		setDisabled("pltEditEndMinute", true);
		setDisabled("pltEditSubstitute1Year", true);
		setDisabled("pltEditSubstitute1Month", true);
		setDisabled("pltEditSubstitute1Day", true);
		setDisabled("pltEditSubstitute1Range", true);
//		setDisabled("pltEditSubstitute2Year", true);
//		setDisabled("pltEditSubstitute2Month", true);
//		setDisabled("pltEditSubstitute2Day", true);
//		setDisabled("pltEditSubstitute2Range", true);
		setDisabled("txtEditRequestReason", true);
		setDisabled("btnRegist", true);
		setDisabled("btnDraft", true);
//		setDisabled("btnDelete", true);
		return;
	}
	// 出勤日が無効の場合は出勤年/月以外は編集不可にする
	var editRequestDay = getFormValue("pltEditRequestDay");
	if( editRequestDay == "" ){
		setDisabled("pltEditSubstitute", true);
		setDisabled("pltEditRequestDay", true);
		setDisabled("btnRequestDate", true);
		return;
	} else{
		setDisabled("pltEditSubstitute", false);
		setDisabled("pltEditRequestDay", false);
		setDisabled("btnRequestDate", false);
	}
	// 未申請
	if (jsStatusApplication == "Unclaimed"){
		setDisabled("btnDelete", true);
	}
	// 未承認
	if (jsStatusApplication == "Unauthorized"){
		setDisabled("btnRegist", true);
		setDisabled("btnDraft", true);
		setDisabled("btnDelete", true);
	}
	
	// 有効日(編集)モード確認
	if (modeActivateDate == MODE_ACTIVATE_DATE_FIXED) {
		// 有効日編集不可
		setDisabled("pltEditRequestYear", true);
		setDisabled("pltEditRequestMonth", true);
		setDisabled("pltEditRequestDay", true);
		setDisabled("pltEditSubstitute", true);
		// 登録ボタン利用可
		setDisabled("btnRegist", false);
		setDisabled("btnDraft", false);
//		setDisabled("btnDelete", false);
		var substitute = getFormValue("pltEditSubstitute");
		// 申請日が法定/所定休日で読取領域の変更(法定/所定休日判定方法は未実装)
		if( substitute == 1 ){
			// 法定休日で振替休暇申請
			setDisabled("pltEditStartHour", false);
			setDisabled("pltEditStartMinute", false);
			setDisabled("pltEditEndHour", false);
			setDisabled("pltEditEndMinute", false);
			setDisabled("pltEditSubstitute1Year", false);
			setDisabled("pltEditSubstitute1Month", false);
			setDisabled("pltEditSubstitute1Day", false);
			setDisabled("pltEditSubstitute1Range", true);
//			setDisabled("pltEditSubstitute2Year", true);
//			setDisabled("pltEditSubstitute2Month", true);
//			setDisabled("pltEditSubstitute2Day", true);
//			setDisabled("pltEditSubstitute2Range", true);
			// 所定休日で振替休暇申請
			setDisabled("pltEditStartHour", false);
			setDisabled("pltEditStartMinute", false);
			setDisabled("pltEditEndHour", false);
			setDisabled("pltEditEndMinute", false);
			setDisabled("pltEditSubstitute1Year", false);
			setDisabled("pltEditSubstitute1Month", false);
			setDisabled("pltEditSubstitute1Day", false);
			setDisabled("pltEditSubstitute1Range", false);
			var substitute1Range = getFormValue("pltEditSubstitute1Range");
//			if( substitute1Range != 1 ){
//				setDisabled("pltEditSubstitute2Year", false);
//				setDisabled("pltEditSubstitute2Month", false);
//				setDisabled("pltEditSubstitute2Day", false);
//				setDisabled("pltEditSubstitute2Range", false);
//			} else {
//				setDisabled("pltEditSubstitute2Year", true);
//				setDisabled("pltEditSubstitute2Month", true);
//				setDisabled("pltEditSubstitute2Day", true);
//				setDisabled("pltEditSubstitute2Range", true);
//			}
		} else {
			// 法定休日で振替休暇非申請
			setDisabled("pltEditStartHour", false);
			setDisabled("pltEditStartMinute", false);
			setDisabled("pltEditEndHour", false);
			setDisabled("pltEditEndMinute", false);
			setDisabled("pltEditSubstitute1Year", true);
			setDisabled("pltEditSubstitute1Month", true);
			setDisabled("pltEditSubstitute1Day", true);
			setDisabled("pltEditSubstitute1Range", true);
//			setDisabled("pltEditSubstitute2Year", true);
//			setDisabled("pltEditSubstitute2Month", true);
//			setDisabled("pltEditSubstitute2Day", true);
//			setDisabled("pltEditSubstitute2Range", true);
		}
		// 所定、法定休日のチェック
		if(jsModeLegalHoliday == "on" ){
			// 法定
			if (jsModeWorkPlanFlag == "2"){
				// 申請しない
				setDisabled("pltEditStartHour", false);
				setDisabled("pltEditStartMinute", false);
				setDisabled("pltEditEndHour", false);
				setDisabled("pltEditEndMinute", false);
				setDisabled("pltEditSubstitute1Year", true);
				setDisabled("pltEditSubstitute1Month", true);
				setDisabled("pltEditSubstitute1Day", true);
				setDisabled("pltEditSubstitute1Range", true);
//				setDisabled("pltEditSubstitute2Year", true);
//				setDisabled("pltEditSubstitute2Month", true);
//				setDisabled("pltEditSubstitute2Day", true);
//				setDisabled("pltEditSubstitute2Range", true);
			} else {
				// 申請する
				setDisabled("pltEditStartHour", true);
				setDisabled("pltEditStartMinute", true);
				setDisabled("pltEditEndHour", true);
				setDisabled("pltEditEndMinute", true);
				setDisabled("pltEditSubstitute1Year", false);
				setDisabled("pltEditSubstitute1Month", false);
				setDisabled("pltEditSubstitute1Day", false);
				setDisabled("pltEditSubstitute1Range", true);
//				setDisabled("pltEditSubstitute2Year", true);
//				setDisabled("pltEditSubstitute2Month", true);
//				setDisabled("pltEditSubstitute2Day", true);
//				setDisabled("pltEditSubstitute2Range", true);
			}
		} else {
			if (jsModeWorkPlanFlag == "2"){
				// 申請しない
				setDisabled("pltEditStartHour", false);
				setDisabled("pltEditStartMinute", false);
				setDisabled("pltEditEndHour", false);
				setDisabled("pltEditEndMinute", false);
				setDisabled("pltEditSubstitute1Year", true);
				setDisabled("pltEditSubstitute1Month", true);
				setDisabled("pltEditSubstitute1Day", true);
				setDisabled("pltEditSubstitute1Range", true);
//				setDisabled("pltEditSubstitute2Year", true);
//				setDisabled("pltEditSubstitute2Month", true);
//				setDisabled("pltEditSubstitute2Day", true);
//				setDisabled("pltEditSubstitute2Range", true);
			} else {
				// 申請する
				setDisabled("pltEditStartHour", true);
				setDisabled("pltEditStartMinute", true);
				setDisabled("pltEditEndHour", true);
				setDisabled("pltEditEndMinute", true);
				setDisabled("pltEditSubstitute1Year", false);
				setDisabled("pltEditSubstitute1Month", false);
				setDisabled("pltEditSubstitute1Day", false);
				setDisabled("pltEditSubstitute1Range", false);
//				setDisabled("pltEditSubstitute2Year", false);
//				setDisabled("pltEditSubstitute2Month", false);
//				setDisabled("pltEditSubstitute2Day", false);
//				setDisabled("pltEditSubstitute2Range", false);
			}
		}
	} else {
		// 有効日編集可
		setDisabled("pltEditRequestYear", false);
		setDisabled("pltEditRequestMonth", false);
		setDisabled("pltEditRequestDay", false);
		setDisabled("pltEditSubstitute", false);
		// 登録ボタン利用不可
		setDisabled("btnRegist", true);
		setDisabled("btnDraft", true);
		// 編集項目の利用不可
		setDisabled("pltEditStartHour", false);
		setDisabled("pltEditStartMinute", false);
		setDisabled("pltEditEndHour", false);
		setDisabled("pltEditEndMinute", false);
		setDisabled("pltEditSubstitute1Year", true);
		setDisabled("pltEditSubstitute1Month", true);
		setDisabled("pltEditSubstitute1Day", true);
		setDisabled("pltEditSubstitute1Range", true);
//		setDisabled("pltEditSubstitute2Year", true);
//		setDisabled("pltEditSubstitute2Month", true);
//		setDisabled("pltEditSubstitute2Day", true);
//		setDisabled("pltEditSubstitute2Range", true);
	}
	// 勤務予定時刻の表示
	// 振替申請しない場合のみ、勤務予定時刻を行う
	if (jsModeWorkPlanFlag == "2"){
		setDisabled("pltEditStartHour", false);
		setDisabled("pltEditStartMinute", false);
		setDisabled("pltEditEndHour", false);
		setDisabled("pltEditEndMinute", false);
	} else {
		setDisabled("pltEditStartHour", true);
		setDisabled("pltEditStartMinute", true);
		setDisabled("pltEditEndHour", true);
		setDisabled("pltEditEndMinute", true);
	}
}

/**
 * 画面読込時追加処理
 * @param 無し
 * @return 無し
 * @throws 実行時例外
 */
function checkSubstitute(aryMessage, event) {
	var substitute = getFormValue("pltEditSubstitute");
//	if( substitute == 1 ){
		// 所定休日だった場合、振替日の重複チェックを実施する(法定/所定休日判定方法は未実装)
		// 振替休暇申請範囲1が全休以外の場合は重複チェック実施
		var substitute1Range = getFormValue("pltEditSubstitute1Range");
//		if( substitute1Range != 1 ){
//			var substitute1Year = getFormValue("pltEditSubstitute1Year");
//			var substitute2Year = getFormValue("pltEditSubstitute2Year");
//			if( substitute1Year == substitute2Year ){
//				var substitute1Month = getFormValue("pltEditSubstitute1Month");
//				var substitute2Month = getFormValue("pltEditSubstitute2Month");
//				if( substitute1Month == substitute2Month ){
//					var substitute1Day = getFormValue("pltEditSubstitute1Day");
//					var substitute2Day = getFormValue("pltEditSubstitute2Day");
//					if( substitute1Day == substitute2Day ){
//						if (aryMessage.length == 0) {
//							setFocus(substitute1Year);
//						}
//						setBgColor(substitute1Year, COLOR_FIELD_ERROR);
//						aryMessage.push(getMessage(MSG_TRANSFER_REPETITION_CHECK, null));
//						return;
//					}
//				}
//			}
//		}
//	}	
}

/**
 * 振替休暇申請範囲1のチェック処理
 * @param 無し
 * @return 無し
 */
function checkSubstitute1Range() {
	var substitute1Range = getFormValue("pltEditSubstitute1Range");
//	if( substitute1Range != 1 ){
//		setDisabled("pltEditSubstitute2Year", false);
//		setDisabled("pltEditSubstitute2Month", false);
//		setDisabled("pltEditSubstitute2Day", false);
//		setDisabled("pltEditSubstitute2Range", false);
//	} else {
//		setDisabled("pltEditSubstitute2Year", true);
//		setDisabled("pltEditSubstitute2Month", true);
//		setDisabled("pltEditSubstitute2Day", true);
//		setDisabled("pltEditSubstitute2Range", true);
//	}
}

/**
 * 出勤日/振替申請プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditRequestYear() {
	// リクエスト送信
	doSubmit(document.form, 'TM1606');
}

/**
 * 出勤日/振替申請プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditRequestMonth() {
	// リクエスト送信
	doSubmit(document.form, 'TM1606');
}

/**
 * 振替日1(年)プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditSubstitute1Year() {
	// リクエスト送信
	doSubmit(document.form, 'TM1698');
}

/**
 * 振替日1(月)プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditSubstitute1Month() {
	// リクエスト送信
	doSubmit(document.form, 'TM1698');
}

/**
 * 振替日1(日)プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditSubstitute1Day() {
	// リクエスト送信
	doSubmit(document.form, 'TM1698');
}

/**
 * 振替日1(範囲)プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditSubstitute1Range() {
	// リクエスト送信
	doSubmit(document.form, 'TM1698');
}

/**
 * 振替日2(年)プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditSubstitute2Year() {
	// リクエスト送信
	doSubmit(document.form, 'TM1698');
}

/**
 * 振替日2(月)プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditSubstitute2Month() {
	// リクエスト送信
	doSubmit(document.form, 'TM1698');
}

/**
 * 振替日2(日)プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditSubstitute2Day() {
	// リクエスト送信
	doSubmit(document.form, 'TM1698');
}

/**
 * 振替日2(範囲)プルダウン変更時の更新処理
 * @param 無し
 * @return 無し
 */
function checkEditSubstitute2Range() {
	// リクエスト送信
	doSubmit(document.form, 'TM1698');
}

/**
 * 振替日1の入力チェックを行った後、更新系確認メッセージを出し、振替日2のチェックを行う。<br>
 * データ登録、更新時等に用いる。<br>
 * @param event          イベントオブジェクト
 * @param validateTarget 入力チェック対象(null：チェックを行わない、""：全体をチェック)
 * @param objExtraCheck  追加チェック関数オブジェクト(null：追加チェック無し)
 * @param cmd            コマンド
 * @return 無し
 */
function submitDiffcheckRegist1(event, validateTarget, objExtraCheck, cmd) {
	if( jsModeDifferenceRequest1 == "on" ){
		var flg = 0;
		if ( getFormValue("pltEditSubstitute1Range") == "2" || getFormValue("pltEditSubstitute1Range") == "3" ) {
			flg = 1;
		}
		if( flg == 1 ){
			// 入力チェック
			if (validate(validateTarget, objExtraCheck, event)) {
				// 更新系確認メッセージ
				if (confirm(getMessage(MSG_DIFFERENCE_REQUEST_CHECK, jsModeRequestDate1))) {
					// 振替日2の入力チェック
					submitDiffcheckRegist2(event, validateTarget, objExtraCheck, cmd);
				}
			}
		} else {
			submitRegist(event, validateTarget, objExtraCheck, cmd);
		}
	} else {
		submitRegist(event, validateTarget, objExtraCheck, cmd);
	}
}

/**
 * 振替日2の入力チェックを行った後、更新系確認メッセージを出し、リクエストを送信する。<br>
 * データ登録、更新時等に用いる。<br>
 * @param event          イベントオブジェクト
 * @param validateTarget 入力チェック対象(null：チェックを行わない、""：全体をチェック)
 * @param objExtraCheck  追加チェック関数オブジェクト(null：追加チェック無し)
 * @param cmd            コマンド
 * @return 無し
 */
/*
function submitDiffcheckRegist2(event, validateTarget, objExtraCheck, cmd) {
	if( jsModeDifferenceRequest2 == "on" ){
		var flg = 0;
		if ( getFormValue("pltEditSubstitute2Range") == "2" || getFormValue("pltEditSubstitute2Range") == "3" ) {
			flg = 1;
		}
		if( flg == 1 ){
			// 入力チェック
			if (validate(validateTarget, objExtraCheck, event)) {
				// 更新系確認メッセージ
				if (confirm(getMessage(MSG_DIFFERENCE_REQUEST_CHECK, jsModeRequestDate2))) {
					// リクエスト送信
					doSubmit(document.form, cmd);
				}
			}
		} else {
			submitRegist(event, validateTarget, objExtraCheck, cmd);
		}
	} else {
		submitRegist(event, validateTarget, objExtraCheck, cmd);
	}
}
*/

/**
 * 追加チェックを行う。<br>
 * @param aryMessage エラーメッセージ格納配列
 * @param event イベント
 * @return 無し
 */
function checkDateExtra(aryMessage, event) {
	checkDate("pltEditRequestYear", "pltEditRequestMonth", "pltEditRequestDay", aryMessage); 
}

/**
 * 追加チェックを行う。<br>
 * @param aryMessage エラーメッセージ格納配列
 * @param event イベント
 * @return 無し
 */
function checkSubstituteDateExtra(aryMessage, event) {
	checkDate("pltEditSubstitute1Year", "pltEditSubstitute1Month", "pltEditSubstitute1Day", aryMessage); 
}

/**
 * 追加チェックを行う。<br>
 * @param aryMessage エラーメッセージ格納配列
 * @param event イベント
 * @return 無し
 */
function checkExtra(aryMessage, event) {
	// チェックボックス必須確認
	checkBoxRequired("ckbSelect", aryMessage);
}
