<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software: you can redistribute it and/or
modify it under the terms of the GNU Affero General Public License
as published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ page
language     = "java"
pageEncoding = "UTF-8"
buffer       = "128kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@page 
import="jp.mosp.framework.base.MospParams"
import="jp.mosp.framework.constant.MospConst"
import="jp.mosp.framework.utils.HtmlUtility"
import="jp.mosp.platform.comparator.base.EmployeeCodeComparator"
import="jp.mosp.platform.comparator.base.EmployeeNameComparator"
import="jp.mosp.platform.comparator.base.SectionCodeComparator"
import="jp.mosp.platform.constant.PlatformConst"
import="jp.mosp.platform.utils.PlatformUtility"
import="jp.mosp.time.constant.TimeConst"
import="jp.mosp.time.management.action.ApprovalListAction"
import="jp.mosp.time.management.action.ApprovalCardAction"
import="jp.mosp.time.management.vo.ApprovalCardVo"
import="jp.mosp.time.management.vo.ApprovalListVo"
import="jp.mosp.time.comparator.settings.ManagementRequestRequestDateComparator"
import="jp.mosp.time.comparator.settings.ManagementRequestRequestTypeComparator"
import="jp.mosp.time.comparator.settings.ManagementRequestStageStateComparator"
import="jp.mosp.time.comparator.settings.ManagementRequestRequestInfoComparator"
%><%
MospParams params = (MospParams)request.getAttribute(MospConst.ATT_MOSP_PARAMS);
ApprovalListVo vo = (ApprovalListVo)params.getVo();
%>
<div class="List">
	<table class="LeftListTable">
		<tr>
			<th class="ListSelectTh"><%= params.getName("Approval") %><%= params.getName("Type") %></th>
			<th class="ListSelectTh"><%= params.getName("Ram") %><%= params.getName("Approval") %><%= params.getName("Count") %><%= params.getName("Num") %></th>
			<th class="ListSelectTh"></th>
			<td class="Divider">
			<th class="ListSelectTh"><%= params.getName("Approval") %><%= params.getName("Type") %></th>
			<th class="ListSelectTh"><%= params.getName("Ram") %><%= params.getName("Approval") %><%= params.getName("Count") %><%= params.getName("Num") %></th>
			<th class="ListSelectTh"></th>
			<td class="Divider">
			<th class="ListSelectTh"><%= params.getName("Approval") %><%= params.getName("Type") %></th>
			<th class="ListSelectTh"><%= params.getName("Ram") %><%= params.getName("Approval") %><%= params.getName("Count") %><%= params.getName("Num") %></th>
			<th class="ListSelectTh"></th>
		</tr>
		<tr>
			<td class="SelectTd"><%= params.getName("WorkManage") %><%= params.getName("Approval") %></td>
			<td class="SelectTd" id="lblAttendance"><%= vo.getLblAttendance() %><%= params.getName("Count") %></td>
			<td class="SelectTd">
				<button type="button" class="Name2Button" id="btnAttendance" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_TYPE %>', '<%= ApprovalListAction.CMD_WORK_MANAGE %>', 'null' , 'null'), '<%= ApprovalListAction.CMD_SEARCH %>');"><%= params.getName("Display") %></button>
			</td>
			<td class="Divider">
			<td class="SelectTd"><%= params.getName("Holiday") %><%= params.getName("GoingWork") %><%= params.getName("Approval") %></td>
			<td class="SelectTd" id="lblWorkOnHoliday"><%= vo.getLblWorkOnHoliday() %><%= params.getName("Count") %></td>
			<td class="SelectTd">
				<button type="button" class="Name2Button" id="btnWorkOnHoliday" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_TYPE %>', '<%= ApprovalListAction.CMD_HOLIDAY_GOINGWORK %>', 'null' , 'null'), '<%= ApprovalListAction.CMD_SEARCH %>');"><%= params.getName("Display") %></button>
			</td>
			<td class="Divider">
			<td class="SelectTd"><%= params.getName("All") %><%= params.getName("Approval") %></td>
			<td class="SelectTd" id="lblTotalApproval"><%= vo.getLblTotalApproval() %><%= params.getName("Count") %></td>
			<td class="SelectTd">
				<button type="button" class="Name2Button" id="btnTotalApproval" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_TYPE %>', '<%= ApprovalListAction.CMD_ALL_APPROVAL %>', 'null' , 'null'), '<%= ApprovalListAction.CMD_SEARCH %>');"><%= params.getName("Display") %></button>
			</td>
		</tr>
		<tr>
			<td class="SelectTd"><%= params.getName("OvertimeWork") %><%= params.getName("Approval") %></td>
			<td class="SelectTd" id="lblOverTime"><%= vo.getLblOverTime() %><%= params.getName("Count") %></td>
			<td class="SelectTd">
				<button type="button" class="Name2Button" id="btnOverTime" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_TYPE %>', '<%= ApprovalListAction.CMD_OVERTIME_WORK %>', 'null' , 'null'), '<%= ApprovalListAction.CMD_SEARCH %>');"><%= params.getName("Display") %></button>
			</td>
			<td class="Divider">
			<td class="SelectTd"><%= params.getName("CompensatoryHoliday") %><%= params.getName("Approval") %></td>
			<td class="SelectTd" id="lblSubHoliday"><%= vo.getLblSubHoliday() %><%= params.getName("Count") %></td>
			<td class="SelectTd">
				<button type="button" class="Name2Button" id="btnSubHoliday" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_TYPE %>', '<%= ApprovalListAction.CMD_COMPENSATORY_HOLIDAY %>', 'null' , 'null'), '<%= ApprovalListAction.CMD_SEARCH %>');"><%= params.getName("Display") %></button>
			</td>
			<td class="Blank" colspan="4">
		</tr>
		<tr>
			<td class="SelectTd"><%= params.getName("Vacation") %><%= params.getName("Approval") %></td>
			<td class="SelectTd" id="lblHoliday"><%= vo.getLblHoliday() %><%= params.getName("Count") %></td>
			<td class="SelectTd">
				<button type="button" class="Name2Button" id="btnHoliday" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_TYPE %>', '<%= ApprovalListAction.CMD_VACATION %>', 'null' , 'null'), '<%= ApprovalListAction.CMD_SEARCH %>');"><%= params.getName("Display") %></button>
			</td>
			<td class="Divider">
			<td class="SelectTd"><%= params.getName("TimeDifference") %><%= params.getName("GoingWork") %><%= params.getName("Approval") %></td>
			<td class="SelectTd" id="Difference"><%= vo.getLblDifference() %><%= params.getName("Count") %></td>
			<td class="SelectTd">
				<button type="button" class="Name2Button" id="btnDifference" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_TYPE %>', '<%= ApprovalListAction.CMD_TIMEDIFFERENCE_GOINGWORK %>', 'null' , 'null'), '<%= ApprovalListAction.CMD_SEARCH %>');"><%= params.getName("Display") %></button>
			</td>
			<td class="Blank" colspan="4">
		</tr>
	</table>
</div>
<%= HtmlUtility.getListInfoFlex(params, vo.getList(), vo.getPageCommand(), vo.getDataPerPage(), vo.getSelectIndex()) %>
<div class="FixList" id="divUpdate">
	<table class="LeftListTable" id="list">
		<thead>
			<tr>
				<th class="ListSelectTh" id="thButton"></th>
				<th class="ListSortTh" id="thEmployeeCode" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= EmployeeCodeComparator.class.getName() %>'), '<%= ApprovalListAction.CMD_SORT %>')"><%= params.getName("Employee") %><%= params.getName("Code") %><%= PlatformUtility.getSortMark(EmployeeCodeComparator.class.getName(), params) %></th>
				<th class="ListSortTh" id="thEmployeeName" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= EmployeeNameComparator.class.getName() %>'), '<%= ApprovalListAction.CMD_SORT %>')"><%= params.getName("Employee") %><%= params.getName("FirstName") %><%= PlatformUtility.getSortMark(EmployeeNameComparator.class.getName(), params) %></th>
				<th class="ListSortTh" id="thSection" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= SectionCodeComparator.class.getName() %>'), '<%= ApprovalListAction.CMD_SORT %>')"><%= params.getName("Section") %><%= PlatformUtility.getSortMark(SectionCodeComparator.class.getName(), params) %></th>
				<th class="ListSortTh" id="thApprovalType" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= ManagementRequestRequestTypeComparator.class.getName() %>'), '<%= ApprovalListAction.CMD_SORT %>')"><%= params.getName("Type") %><%= PlatformUtility.getSortMark(ManagementRequestRequestTypeComparator.class.getName(), params) %></th>
				<th class="ListSortTh" id="thApprovalDate" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= ManagementRequestRequestDateComparator.class.getName() %>'), '<%= ApprovalListAction.CMD_SORT %>')"><%= params.getName("Date") %><%= PlatformUtility.getSortMark(ManagementRequestRequestDateComparator.class.getName(), params) %></th>
				<th class="ListSortTh" id="thRequestInfo" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= ManagementRequestRequestInfoComparator.class.getName() %>'), '<%= ApprovalListAction.CMD_SORT %>')"><%= params.getName("Application") %><%= params.getName("Information") %><%= params.getName("Detail") %><%= PlatformUtility.getSortMark(ManagementRequestRequestInfoComparator.class.getName(), params) %></th>
				<th class="ListSortTh" id="thState" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= ManagementRequestStageStateComparator.class.getName() %>'), '<%= ApprovalListAction.CMD_SORT %>')"><%= params.getName("State") %><%= PlatformUtility.getSortMark(ManagementRequestStageStateComparator.class.getName(), params) %></th>
				<th class="ListSelectTh" id="thSingle">
<%
if (vo.getAryLblEmployeeCode().length > 0) {
%>
					<input type="checkbox" class="" id="ckbSelect" onclick="doAllBoxChecked(this);">
<%
}
%>
				</th>
			</tr>
		</thead>
		<tbody>
<%
for (int i = 0; i < vo.getAryLblEmployeeCode().length; i++) {
%>
			<tr>
				<td class="ListSelectTd">
					<button type="button" class="Name2Button" id="btnSelect" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= vo.getAryLblRequestDate()[i] %>', '<%= PlatformConst.PRM_TRANSFERRED_CODE %>' , '<%= vo.getAryLblEmployeeCode()[i] %>', '<%= TimeConst.PRM_TRANSFERRED_STAGE %>' , '<%= vo.getAryStage()[i] %>', '<%= TimeConst.PRM_TRANSFERRED_STATE %>' , '<%= vo.getAryState()[i] %>', '<%= PlatformConst.PRM_TRANSFERRED_WORKFLOW %>', '<%= vo.getAryWorkflow()[i] %>'), '<%= vo.getAryLblRequestTypeCmd()[i] %>');"><%= params.getName("Detail") %></button></td>
				<td class="ListInputTd"  id=""><%= vo.getAryLblEmployeeCode()[i] %></td>
				<td class="ListInputTd"  id=""><%= vo.getAryLblEmployeeName()[i] %></td>
				<td class="ListSelectTd" id=""><%= vo.getAryLblSection()[i] 	%></td>
				<td class="ListSelectTd" id=""><%= vo.getAryLblRequestType()[i] %></td>
				<td class="ListSelectTd" id=""><%= vo.getAryLblRequestDate()[i] %></td>
				<td class="ListSelectTd" id="" <%= vo.getAryBackColor()[i] %>><%= vo.getAryLblRequestInfo()[i] %></td>
				<td class="ListSelectTd" id="">
					<a class="Link" id="linkApprovalHistory" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_CODE %>', '<%= vo.getAryLblEmployeeCode()[i] %>', '<%= TimeConst.PRM_TRANSFERRED_GENERIC_CODE %>', '<%= vo.getAryLblRequestFunctionCode()[i] %>', '<%= PlatformConst.PRM_TRANSFERRED_RECORD_ID %>', '<%= vo.getAryCkbApprovalListId()[i] %>', '<%= PlatformConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= vo.getAryRequestDate()[i] %>'), '<%= vo.getAryLblRequestTypeHistoryCmd()[i] %>');"><%= vo.getAryLblState()[i] %></a>
				</td>
				<td class="ListSelectTd"><input type="checkbox" class="SelectCheckBox" id="ckbSelect" name="ckbSelect" value="<%= vo.getAryWorkflow()[i] %>" <%= HtmlUtility.getChecked(vo.getAryWorkflow()[i], vo.getCkbSelect()) %> /></td>
			</tr>
<%
}
%>
<%
if (vo.getAryLblEmployeeCode().length > 0) {
%>
			<tr>
				<td class="TitleTd" colspan="9">
					<span class="TableButtonSpan">
						<button type="button" class="Name4Button" id="btnUpdate" onclick="submitRegist(event, 'divUpdate', checkExtra, '<%= ApprovalListAction.CMD_BATCH_APPROVAL %>');"><%= params.getName("Approval") %></button>
					</span>
				</td>
			</tr>
<%
}
%>
		</tbody>
	</table>
</div>
<%
if (vo.getAryLblEmployeeCode().length > 0) {
%>
<div class="MoveUpLink" id="divMoveUp">
	<a onclick="pageToTop();"><%= params.getName("UpperTriangular") %><%= params.getName("TopOfPage") %></a>
</div>
<%
}
%>
