/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.report.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.AdjustmentCalcVo;
import jp.mosp.payroll.common.vo.AdjustmentListVo;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.report.dto.AdjustDataDto;
import jp.mosp.payroll.report.dto.WithholdingListDto;

public class AdjustDataOutputAction extends AdjustmentAction {
	
	// R}h
	private static final String	CMD_OUTPUT_FOR_YEAR	= "P3050";
	private static final String	CMD_OUTPUT_FOR_CURR	= "P3052";
	
	// ݒe[u
	public List<MosPConfDto>	listConf;
	public String[][]			aryEra;
	public String[][]			aryStation;
	public String[][]			aryPltIncomeTaxType;
	public String[][]			aryPltAdjustmentType;
	public String[][]			aryPltHandicapType;
	public String[][]			aryPltWidowType;
	public String[][]			aryPltStudentType;
	public String[][]			aryPltSpouseIntendType;
	public String[][]			aryPltLiveWithType;
	public String[][]			aryPltSpouseType;
	public String[][]			aryPltDependentType;
	public String[][]			aryGender;
	

	/**
	 * RXgN^
	 */
	public AdjustDataOutputAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// ^ǗҌmF
		confirmPayrollAuth();
		// Џ擾
		setCompanyDataInfo();
		// DAO
		prepareDao();
		// z擾
		aryStation = getStationArrayAll();
		aryPosition = getPositionArrayAll();
		aryEra = getCodeArray(PayrollConst.TID_JAPANESE);
		aryPltIncomeTaxType = LegalConst.INCOME_TAX_ARRAY;
		aryPltAdjustmentType = LegalConst.ADJUSTMENT_ARRAY;
		aryPltHandicapType = LegalConst.HANDICAP_ARRAY;
		aryPltWidowType = LegalConst.WIDOW_ARRAY;
		aryPltStudentType = LegalConst.STUDENT_ARRAY;
		aryPltSpouseIntendType = LegalConst.SPOUSE_INTEND_ARRAY;
		aryPltLiveWithType = LegalConst.LIVE_WITH_ARRAY;
		aryPltSpouseType = LegalConst.SPOUSE_ARRAY;
		aryPltDependentType = LegalConst.DEPENDENT_ARRAY;
		// aݒ擾
		listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		// Ǖw(v) Up
		aryGender = getCodeArray(PayrollConst.TID_GENDER);
		// R}h̏
		if (cmd.equals(CMD_OUTPUT_FOR_YEAR)) {
			// VO̎擾
			AdjustmentListVo vo = (AdjustmentListVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getPltReportYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			Date date = vo.getDate(String.valueOf(vo.getPltReportYear()), String
				.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// Nf[^쐬
			List<AdjustDataDto> list = getAdjustDataList(date, vo);
			// o̓t@Cݒ
			String fileName = vo.getPltReportYear() + PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_ADJUST_DATA;
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			// o͓eݒ
			request.setAttribute(MospConst.ATT_FILE_OBJECT, makeAdjustData(list));
		} else if (cmd.equals(CMD_OUTPUT_FOR_CURR)) {
			// VO̎擾
			AdjustmentCalcVo vo = (AdjustmentCalcVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getHidAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾(Ώ۔N12/1)
			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String
				.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// Nf[^쐬
			List<AdjustDataDto> list = getAdjustDataList(date, vo);
			// o̓t@Cݒ
			String fileName = vo.getHidAdjustYear() + PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_ADJUST_DATA;
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			// o͓eݒ
			request.setAttribute(MospConst.ATT_FILE_OBJECT, makeAdjustData(list));
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		
	}
	
	/**
	 * Nf[^擾B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<AdjustDataDto> getAdjustDataList(Date targetYear, MosPVo vo) throws Exception {
		// Nf[^擾
		List<CdAdjustmentDto> listAdjustment = cdAdjustmentDao.findForWithholdVote(MospUtility.getYear(targetYear),
				null);
		// 򒥎냊Xg
		List<AdjustDataDto> list = new ArrayList<AdjustDataDto>();
		// Nf[^Xg쐬
		for (CdAdjustmentDto cdAdjustmentDto : listAdjustment) {
			// ЈR[hݒ
			kCode = cdAdjustmentDto.getKCode();
			// lݒ
			setHumanInfo(cdAdjustmentDto);
			// ^Aܗ^擾
			setPaymentBonusInfo();
			// Nf[^ݒ
			AdjustDataDto dto = new AdjustDataDto(adjustYear, cdAdjustmentDto, mKihonDto, mKojinDto, cmIncomeTaxDto,
					cmMidwayEnterDto, listPaymentData, listBonusData, pdPayDeductionDao, cmCompanyDto);
			// {lݒ
			setWidowType(dto);
			// 敪ݒ
			setMonthType(dto);
			// taݒ
			setJapanDate(dto);
			// R[hݒ
			setDtoCodeName(dto);
			// R[h̐ݒ(Nf[^p)
			setDataForAdjustData(dto);
			// Xgɐݒ
			list.add(dto);
		}
		// Nf[^XgmF
		if (list.size() == 0) {
			setVo(vo);
			setUrl(vo.getRetUrl());
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_ADJUST_REPORT, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_NO_PAYMENT_DETAIL, errMessage);
		}
		return list;
	}
	
	/**
	 * Nf[^쐬
	 * @param list Nf[^Xg
	 * @return Nf[^
	 * @throws Exception 
	 */
	private StringBuffer makeAdjustData(List<AdjustDataDto> list) throws Exception {
		// [쐬
		StringBuffer sb = new StringBuffer();
		// wb_[ݒ
		sb.append(makeAdjustDataTitle());
		for (AdjustDataDto dto : list) {
			sb.append(getCsvData(dto.getKCode())); // ЈR[h
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getStationCode())); // R[h
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getKName())); // Ј
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getGeneralLifeIns().intValue())); // یxz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getPrivatePension().intValue())); // lNxz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getLifeInsDeduction().intValue())); // یT
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getEarthquakeIns().intValue())); // nkیxz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getLongTermDamageIns().intValue())); // Qی
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getDamageInsDeduction().intValue())); // nkیT
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSocInsDeduction().intValue())); // Еۋ^T
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData("0")); // Nxz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSocialInsDeduction().intValue())); // Еې\T
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getMutualAidDeduction().intValue())); // K͋ϊ|
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSpouseSumIncome().intValue())); // zҍv
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSpouseSpDeduction().intValue())); // zғʍT
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getHouseLoanDeduction().intValue())); // ZؓT
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getIncomeTaxType())); // ېŋ敪
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getAdjustmentType())); // N敪
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSelfWidowType())); // {l敪P
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSelfHandicapType())); // {l敪Q
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSelfStudentType())); // {l敪R
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSpouseIntendType())); // zҋ敪
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getGeneralDependent())); // ʕ}{e
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSpecificDependent())); // }{e
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getElderlyDependent())); // Vl}{e
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getLiveWithEldRel())); // Ve
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getLiveWithHandiGe())); // 
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getLiveWithHandiSp())); // 
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getLiveWithHandiEl())); // Vl
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getLiveWithHandiEr())); // Ve
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getGeneralHandicap())); // ʏQ
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSpecificHandicap())); // ʏQ
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getAllowanceAdjustment().intValue())); // xz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getTaxFreeAdjustment().intValue())); // ېŒz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSocInsAdjustment().intValue())); // Љیz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getTaxIncAdjustment().intValue())); // Œz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getStrMidwayType())); // r敪
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getFormerIncome().intValue())); // rz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getFormerInsurance().intValue())); // rЉی
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getFormerTax().intValue())); // r
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getTotalPayTotalAllowance().intValue())); // E蓖
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getTotalBonTotalAllowance().intValue())); // ܗ^
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getMidwayAdjustIncome().intValue())); // rE
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getTotalAllowance().intValue() + dto.getMidwayAdjustIncome().intValue())); // z
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getTaxFree().intValue())); // ېŎxz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getTaxFreeAdjustment().intValue())); // ېŒz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getTaxFree().intValue() + dto.getTaxFreeAdjustment().intValue())); // ېŋz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getAdjTotalAllowance().intValue())); //  ېŎz 
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getAfterDeductIncome().intValue())); // ^Tい
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getDependentsDeduction().intValue())); // z}{bT
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getIncomeDeductSum().intValue())); // Tvz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getCalcTaxedIncome().intValue())); //  ېŋ^ 
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getCalcIncomeTax().intValue())); //  N  z 
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getFinalIncomeTax().intValue())); //   N  z
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getAdjTotalIncome().intValue())); // 򒥎Ŋz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getTaxGap().intValue())); //  ߕsz 
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData("^N")); // N@
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData("")); // PƊҕt@
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData("Eܗ^")); //  
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getWithholdSlipNotes())); // EvP
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData("")); // EvQ
			sb.append(PayrollConst.STR_CSV_NEW_LINE);
		}
		return sb;
	}
	
	/**
	 * Nf[^^Cg쐬
	 * @return CSV
	 * @throws Exception 
	 */
	private StringBuffer makeAdjustDataTitle() throws Exception {
		StringBuffer sb = new StringBuffer();
		sb.append(getCsvData("Јԍ"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("R[h"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(""));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("یxz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("lNxz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("یT"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("nkیxz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Qی"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("nkیT"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Еۋ^T"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Nxz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Еې\T"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("K͋ϊ|"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("zҍv"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("zғʍT"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ZؓT"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ېŋ敪"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("N敪"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("{l敪P"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("{l敪Q"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("{l敪R"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("zҋ敪"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ʕ}{e"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("}{e"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Vl}{e"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Ve"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(""));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(""));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Vl"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Ve"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ʏQ"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ʏQ"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("xz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ېŒz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Љیz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Œz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("r敪"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("rz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("rЉی"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("r"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("E蓖"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ܗ^"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("rE"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("z"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ېŎxz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ېŒz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ېŋzv"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ېŎz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("^Tい"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("z}{bT"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("Tvz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("ېŋ^"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("NŊz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("NŊz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("򒥎Ŋz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("፷ߕsz"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("N@"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("PƊҕt@"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(""));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("EvP"));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData("EvQ"));
		sb.append(PayrollConst.STR_CSV_NEW_LINE);
		return sb;
	}
	
	/**
	 * Џݒ
	 * @param dto
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected void setCompanyDataInfo() throws SQLException, IllegalAccessException, NoSuchFieldException {
		CmCompanyDao dao = new CmCompanyDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		cmCompanyDto = dao.findAll();
	}
	
	/**
	 * lݒ
	 * @param dto 
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws MospException 
	 */
	protected void setHumanInfo(CdAdjustmentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		if (dto != null) {
			// ЈR[hݒ
			kCode = dto.getKCode();
			// NŏI𗚗擾ΏیƂĎgp
			Date targetDate = getLastDateOfYear(adjustYear);
			// l{擾
			mKihonDto = mKihonPayrollDao.findForKey(kCode);
			if (mKihonDto == null) {
				// l{񂪖ꍇ
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_HUMAN_DATA, "");
				addErrMessage(errMessage);
			}
			// l{ݒ
			// lǗ擾
			mKojinDto = mKojinDao.findForKey(kCode);
			
			// l^擾
			cmIncomeTaxDto = cmIncomeTaxDao.findForEmployeeDate(kCode, targetDate);
			cmMidwayEnterDto = cmMidwayEnterDao.findForKey(kCode);
			
		}
	}
	
	/**
	 * ^Aܗ^擾
	 * @param vo
	 * @throws Exception 
	 */
	protected void setPaymentBonusInfo() throws Exception {
		// vZΏۋ^f[^擾
		listPaymentData = phPaymentDao.findForConditionDate(kCode, targetBefDate, targetAffDate);
		// vZΏۏܗ^f[^擾
		listBonusData = phBonusDao.findForConditionDate(kCode, startAdjDate, lastDate);
		// ^f[^mF
		setTargetPaymentData();
		// Ώۃf[^ŌvZ(o^Ȃ)
		calcTargetIncomeTax(false);
	}
	
	/**
	 * 敪ݒ
	 * @param dto
	 */
	private void setMonthType(WithholdingListDto dto) {
		dto.setMonthType01("1");
		dto.setMonthType02("2");
		dto.setMonthType03("3");
		dto.setMonthType04("4");
		dto.setMonthType05("5");
		dto.setMonthType06("6");
		dto.setMonthType07("7");
		dto.setMonthType08("8");
		dto.setMonthType09("9");
		dto.setMonthType10("10");
		dto.setMonthType11("11");
		dto.setMonthType12("12");
	}
	
	/**
	 * {l敪ݒ
	 * @param dto
	 */
	private void setWidowType(WithholdingListDto dto) {
		if (cmIncomeTaxDto != null) {
			String widowType = cmIncomeTaxDto.getSelfWidowType();
			// Ǖw(v)̏ꍇ͐ʂŔfĐݒAݒȂ̏ꍇ͈ʉǕw
			if (widowType.equals(LegalConst.WIDOW_GENERAL)) {
				// DTOmF
				if (mKojinDto != null) {
					String gender = mKojinDto.getSeibetu();
					// Ǖv
					if (gender.equals(aryGender[0][0])) {
						dto.setWidow(PayrollConst.ADJ_APPLICABLE);
					}
					// ʉǕw
					if (gender.equals(aryGender[1][0])) {
						dto.setGeWidow(PayrollConst.ADJ_APPLICABLE);
					}
				} else {
					// ʂ̐ݒ肪Ȃꍇ͈ʉǕwɐݒ
					dto.setGeWidow(PayrollConst.ADJ_APPLICABLE);
				}
			} else if (widowType.equals(LegalConst.WIDOW_SPECIAL)) {
				// ʉǕw
				dto.setSpWidow(PayrollConst.ADJ_APPLICABLE);
			}
		}
	}
	
	/**
	 * at擾
	 * @param dto
	 * @throws MospException
	 */
	private void setJapanDate(WithholdingListDto dto) throws MospException {
		String[] strDate;
		// \pN擾(Ώ۔N)
		if (targetAffDate != null) {
			strDate = getJpImperialCal(listConf, targetAffDate);
			strDate[0] = getCodeName(strDate[0], aryEra);
			dto.setAdjustYear(strDate[0] + strDate[1]);
			
		}
		if (mKojinDto != null) {
			if (mKojinDto.getSeinenbi() != 0) {
				// N
				strDate = getJpImperialCal(listConf, DateUtil.convIntegerDateToDate(mKojinDto.getSeinenbi()));
				strDate[0] = getCodeName(strDate[0], aryEra);
				dto.setBirthDate(strDate[0] + " " + strDate[1] + PayrollConst.NAM_YEAR + " " + strDate[2] + " "
						+ PayrollConst.NAM_MONTH + " " + strDate[3] + PayrollConst.NAM_DAY);
			} else {
				dto.setBirthDate(" " + " " + " " + PayrollConst.NAM_YEAR + " " + " " + " " + PayrollConst.NAM_MONTH
						+ " " + " " + PayrollConst.NAM_DAY);
				
			}
		}
	}
	
	/**
	 * R[h̐ݒ
	 * @param dto
	 */
	private void setDtoCodeName(WithholdingListDto dto) {
		if (cmIncomeTaxDto != null) {
			// ېŋ敪
			dto.setIncomeTaxType(getCodeName(dto.getIncomeTaxType(), aryPltIncomeTaxType));
			// N敪
			dto.setAdjustmentType(getCodeName(dto.getAdjustmentType(), aryPltAdjustmentType));
		}
		if (mKihonDto != null) {
			// R[h
			String stationCode = dto.getPositionCode() + " - " + dto.getStationCode();
			// 
			dto.setStationCode(stationCode);
		}
		// EsȂ̂ŋ
		dto.setPositionCode("");
	}
	
	/**
	 * R[h̐ݒ(Nf[^p)
	 * @param dto
	 */
	private void setDataForAdjustData(AdjustDataDto dto) {
		dto.setSelfWidowType(getCodeName(dto.getSelfWidowType(), LegalConst.WIDOW_ARRAY)); // {lǕw敪
		dto.setSelfHandicapType(getCodeName(dto.getSelfHandicapType(), LegalConst.HANDICAP_ARRAY)); // {lQ敪
		dto.setSelfStudentType(getCodeName(dto.getSelfStudentType(), LegalConst.STUDENT_ARRAY)); // {lw敪
		dto.setSpouseIntendType(getCodeName(dto.getSpouseIntendType(), LegalConst.SPOUSE_INTEND_ARRAY)); // zҋ敪
	}
	
}
