/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.kintai.common.dto.MKihonDto;

/**
 * @author koike
 *
 */
public class MKihonPayrollDao extends MKihonDao {
	
	/**
	 * sB
	 */
	public MKihonPayrollDao() {
		super();
	}
	
	/**
	 * ɂf[^擾B
	 * @param tsdate t
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<MKihonDto> find(int tsdate) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append("(");
		sb.append(COL_TSDATE + " = 0 ");
		sb.append(" OR ");
		sb.append(COL_TSDATE + " >= ? ");
		sb.append(") ");
		sb.append(" ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tsdate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B(Г`ގГԂ̎Ј)
	 * @param  startAdjDate Г
	 * @param  lastDate ގГ
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<MKihonDto> findForSection(int startAdjDate, int lastDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_NYDATE + " <= ? ");
		sb.append(" AND ");
		sb.append("(");
		sb.append(COL_TSDATE + " = 0 ");
		sb.append(" OR ");
		sb.append(COL_TSDATE + " >= ? ");
		sb.append(") ");
		sb.append(" ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, startAdjDate);
			setParam(index++, lastDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public String getHistoryTable() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append("SELECT ");
		sb.append(COL_KCODE + " H_K_CODE, ");
		sb.append("MAX(" + COL_NYDATE + ") H_EXPECTED_DATE ");
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_NYDATE + " <= ? ");
//		sb.append(	"AND ");
//		sb.append(	COL_APPLIED_DATE + " IS NOT NULL ");
		sb.append("GROUP BY " + COL_KCODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_KCODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_NYDATE + " <= HISTORY.H_EXPECTED_DATE");
		sb.append(") " + TABLE + " ");
		return sb.toString();
	}
	
	/**
	 * NΏۊOf[^p
	 * @return SQL
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public String getDeleteAdjustData() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE ");
		sb.append("(");
		sb.append(COL_NYDATE);
		sb.append(" > ");
		sb.append("?");
		sb.append(") ");
		sb.append(" OR (");
		sb.append(COL_NYDATE);
		sb.append(" <= ");
		sb.append("?");
		sb.append(" AND ");
		sb.append(COL_TSDATE);
		sb.append(" <= ");
		sb.append("? ) ");
		return sb.toString();
	}
	
	/**
	 * ɂf[^擾(NvZp(l))
	 * @param kCode ЈR[h
	 * @param startDate Ώ۔NJn
	 * @param lastDate Ώ۔NŏI
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	public MKihonDto findForAdjustEmpData(String kCode, int startDate, int lastDate) throws IllegalAccessException,
			SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(" * ");
		sb.append("FROM ");
		sb.append(getHistoryEmpTable());
		sb.append("WHERE ");
		sb.append(COL_NYDATE + " <= ?");
		sb.append(" AND ");
		sb.append(COL_TSDATE + " >= ?");
		sb.append(" OR ");
		sb.append(COL_TSDATE + " = 0 ");
		try {
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			setParam(index++, lastDate);
			setParam(index++, lastDate);
			setParam(index++, startDate);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^SQL擾(Ј)
	 * @return f[^擾SQL
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public String getHistoryEmpTable() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append("SELECT ");
		sb.append(COL_KCODE + " H_K_CODE, ");
		sb.append("MAX(" + COL_TSDATE + ") H_EXPECTED_DATE ");
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_KCODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_TSDATE + " <= ? ");
//		sb.append(	"AND ");
//		sb.append(	COL_APPLIED_DATE + " IS NOT NULL ");
		sb.append("GROUP BY " + COL_KCODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_KCODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_TSDATE + " = HISTORY.H_EXPECTED_DATE");
		sb.append(") " + TABLE + " ");
		return sb.toString();
	}
	
	/**
	 * Nɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param expectedDate KpN(L[)
	 * @return UhBasisDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public MKihonDto findForDate(String kCode, int expectedDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_KCODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_NYDATE + " = (");
			sb.append("SELECT MAX(" + COL_NYDATE + ") ");
			sb.append("FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_KCODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_NYDATE + " <= ? ");
//			sb.append("AND ");
//			sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
			sb.append(")");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, kCode);
			setParam(index++, expectedDate);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_kihonDto m_kihonR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MKihonDto mapping() throws SQLException {
		MKihonDto dto = new MKihonDto();
		dto.setKCode(rs.getString(COL_KCODE)); //ЈR[h
		dto.setSimei(rs.getString(COL_SIMEI)); //
		dto.setFurigana(rs.getString(COL_FURIGANA)); //ӂ肪
		dto.setSCode(rs.getString(COL_SCODE)); //R[h
		dto.setYCode(rs.getString(COL_YCODE)); //ER[h
		dto.setTokyu(rs.getString(COL_TOKYU)); //
		dto.setJCode(rs.getString(COL_JCODE)); //ƏR[h
		dto.setNyDate(rs.getInt(COL_NYDATE)); //Г
		dto.setTsDate(rs.getInt(COL_TSDATE)); //ސE
		dto.setKnKubun(rs.getString(COL_KNKUBUN)); //xސE敪
		dto.setKyKubun(rs.getString(COL_KYKUBUN)); //^敪
		dto.setTxKubun(rs.getString(COL_TXKUBUN)); //ŋ敪
		dto.setTxKubunx(rs.getString(COL_TXKUBUNX)); //̑ŋ敪
		dto.setKmKubun(rs.getString(COL_KMKUBUN)); //g敪
		dto.setPtKubun(rs.getString(COL_PTKUBUN)); //p[g敪
		dto.setShKubun(rs.getString(COL_SHKUBUN)); //x敪
		dto.setSiwakeCd(rs.getString(COL_SIWAKECD)); //dWvR[h
		dto.setHaigusya(rs.getString(COL_HAIGUSYA)); //}{z
		dto.setFuyosu(rs.getInt(COL_FUYOSU)); //}{Ƒ
		dto.setYukyu(rs.getDouble(COL_YUKYU)); //Lc
		dto.setNenrei(rs.getInt(COL_NENREI)); //N
		dto.setKinzoku(rs.getInt(COL_KINZOKU)); //ΑN
		dto.setKenpoNo(rs.getString(COL_KENPONO)); //۔ԍ
		dto.setKohoNo(rs.getString(COL_KOHONO)); //۔ԍ
		dto.setKUser(rs.getString(COL_KUSER)); //[U
		dto.setPassw(rs.getString(COL_PASSW)); //pX[h
		dto.setEmail(rs.getString(COL_EMAIL)); //email
		dto.setNinsyo(rs.getString(COL_NINSYO)); //F؎
		dto.setDataLvl(rs.getInt(COL_DATALVL)); //f[^x
		dto.setProgLevel(rs.getInt(COL_PROGLEVEL)); //vOgp
		return dto;
	}
	
	/**
	 * ЈR[hpTuNG[
	 * @return ЈR[hTuNG[
	 */
	public static String getSelectForSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_KCODE + " ");
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_KCODE + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_SIMEI + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_FURIGANA + " LIKE ? ");
		return sb.toString();
	}
	
}
