/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.AdjustmentDto;

/**
 * @author koike 
 *
 */
public class AdjustmentDao extends PayrollDao {
	
	// 
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE_KIHON			= MKihonDao.TABLE + "." + MKihonDao.COL_KCODE;
	
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE_INC_TAX			= CmIncomeTaxDao.TABLE + "." + CmIncomeTaxDao.COL_K_CODE;
	
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE_MID_ENT			= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_K_CODE;
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE_ADJUST			= CdAdjustmentDao.TABLE + "." + CdAdjustmentDao.COL_K_CODE;
	
	/**
	 * Ј
	 */
	public static final String	COL_K_NAME					= MKihonDao.TABLE + "." + MKihonDao.COL_SIMEI;
	
	/**
	 * Јض
	 */
	public static final String	COL_K_KANA					= MKihonDao.TABLE + "." + MKihonDao.COL_FURIGANA;
	
	/**
	 * R[h
	 */
	public static final String	COL_STATION_CODE			= MKihonDao.TABLE + "." + MKihonDao.COL_SCODE;
	
	/**
	 * EʃR[h
	 */
	public static final String	COL_POSITION_CODE			= MKihonDao.TABLE + "." + MKihonDao.COL_YCODE;
	
	/**
	 * Г
	 */
	public static final String	COL_ENTRANCE_DATE			= MKihonDao.TABLE + "." + MKihonDao.COL_NYDATE;
	
	/**
	 * ގГ
	 */
	public static final String	COL_RETIREMENT_DATE			= MKihonDao.TABLE + "." + MKihonDao.COL_TSDATE;
	
	/**
	 * œKpN
	 */
	public static final String	COL_INC_EXPECTED_DATE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_INC_EXPECTED_DATE;
	/**
	 * ېŋ敪
	 */
	public static final String	COL_INCOME_TAX_TYPE			= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_INCOME_TAX_TYPE;
	/**
	 * N敪
	 */
	public static final String	COL_ADJUSTMENT_TYPE			= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_ADJUSTMENT_TYPE;
	/**
	 * {lǕw敪
	 */
	public static final String	COL_SELF_WIDOW_TYPE			= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SELF_WIDOW_TYPE;
	/**
	 * {lQ敪
	 */
	public static final String	COL_SELF_HANDICAP_TYPE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SELF_HANDICAP_TYPE;
	/**
	 * {lw敪
	 */
	public static final String	COL_SELF_STUDENT_TYPE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SELF_STUDENT_TYPE;
	/**
	 * zҋ敪
	 */
	public static final String	COL_SPOUSE_INTEND_TYPE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SPOUSE_INTEND_TYPE;
	/**
	 * ʕ}{e
	 */
	public static final String	COL_GENERAL_DEPENDENT		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_GENERAL_DEPENDENT;
	/**
	 * }{e
	 */
	public static final String	COL_SPECIFIC_DEPENDENT		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SPECIFIC_DEPENDENT;
	/**
	 * Vl}{e
	 */
	public static final String	COL_ELDERLY_DEPENDENT		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_ELDERLY_DEPENDENT;
	/**
	 * Ve
	 */
	public static final String	COL_LIVE_WITH_ELD_REL		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_ELD_REL;
	/**
	 * 
	 */
	public static final String	COL_LIVE_WITH_HANDI_GE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_HANDI_GE;
	/**
	 * 
	 */
	public static final String	COL_LIVE_WITH_HANDI_SP		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_HANDI_SP;
	/**
	 * Vl
	 */
	public static final String	COL_LIVE_WITH_HANDI_EL		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_HANDI_EL;
	/**
	 * Ve
	 */
	public static final String	COL_LIVE_WITH_HANDI_ER		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_HANDI_ER;
	/**
	 * ʏQ
	 */
	public static final String	COL_GENERAL_HANDICAP		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_GENERAL_HANDICAP;
	/**
	 * ʏQ
	 */
	public static final String	COL_SPECIFIC_HANDICAP		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SPECIFIC_HANDICAP;
	/**
	 * }{̐
	 */
	public static final String	COL_DEPENDENT_COUNT			= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_DEPENDENT_COUNT;
	/**
	 * rЋ敪
	 */
	public static final String	COL_MIDWAY_TYPE				= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_MIDWAY_TYPE;
	/**
	 * OΖz
	 */
	public static final String	COL_FORMER_INCOME			= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_FORMER_INCOME;
	/**
	 * OΖЉیz
	 */
	public static final String	COL_FORMER_INSURANCE		= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_FORMER_INSURANCE;
	/**
	 * OΖ揊Ŋz
	 */
	public static final String	COL_FORMER_TAX				= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_FORMER_TAX;
	/**
	 * N
	 */
	public static final String	COL_ADJUST_YEAR				= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_ADJUST_YEAR;
	/**
	 * NvZ
	 */
	public static final String	COL_ADJUST_STATUS			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_ADJUST_STATUS;
	/**
	 * ʂ̐ی
	 */
	public static final String	COL_GENERAL_LIFE_INS		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_GENERAL_LIFE_INS;
	/**
	 * lNی
	 */
	public static final String	COL_PRIVATE_PENSION			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_PRIVATE_PENSION;
	/**
	 * یTz
	 */
	public static final String	COL_LIFE_INS_DEDUCTION		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_LIFE_INS_DEDUCTION;
	/**
	 * nkی
	 */
	public static final String	COL_EARTHQUAKE_INS			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_EARTHQUAKE_INS;
	/**
	 * Qی
	 */
	public static final String	COL_LONG_TERM_DAMAGE_INS	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_LONG_TERM_DAMAGE_INS;
	/**
	 * QیTz
	 */
	public static final String	COL_DAMAGE_INS_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_DAMAGE_INS_DEDUCTION;
	/**
	 * ЉیTz
	 */
	public static final String	COL_SOCIAL_INS_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_SOCIAL_INS_DEDUCTION;
	/**
	 * K͊Ƌϓ|Tz
	 */
	public static final String	COL_MUTUAL_AID_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_MUTUAL_AID_DEDUCTION;
	/**
	 * z҂̖{N̍vžϊz
	 */
	public static final String	COL_SPOUSE_SUM_INCOME		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_SPOUSE_SUM_INCOME;
	/**
	 * zғʍTz
	 */
	public static final String	COL_SPOUSE_SP_DEDUCTION		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_SPOUSE_SP_DEDUCTION;
	/**
	 * ZؓʍTz
	 */
	public static final String	COL_HOUSE_LOAN_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_HOUSE_LOAN_DEDUCTION;
	/**
	 * xz
	 */
	public static final String	COL_ALLOWANCE_ADJUSTMENT	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_ALLOWANCE_ADJUSTMENT;
	/**
	 * ېŒz
	 */
	public static final String	COL_TAX_FREE_ADJUSTMENT		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_TAX_FREE_ADJUSTMENT;
	/**
	 * Љیz
	 */
	public static final String	COL_SOC_INS_ADJUSTMENT		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_SOC_INS_ADJUSTMENT;
	/**
	 * Œz
	 */
	public static final String	COL_TAX_INC_ADJUSTMENT		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_TAX_INC_ADJUSTMENT;
	/**
	 * 򒥎[Ev
	 */
	public static final String	COL_WITHHOLD_SLIP_NOTES		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_WITHHOLD_SLIP_NOTES;
	/**
	 * ^A蓖z
	 */
	public static final String	COL_PAYMENT_ALLOWANCE		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_PAYMENT_ALLOWANCE;
	/**
	 * ^A蓖Ŋz
	 */
	public static final String	COL_PAYMENT_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_PAYMENT_INCOME_TAX;
	/**
	 * ܗ^z
	 */
	public static final String	COL_BONUS_ALLOWANCE			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_BONUS_ALLOWANCE;
	/**
	 * ܗ^Ŋz
	 */
	public static final String	COL_BONUS_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_BONUS_INCOME_TAX;
	/**
	 * rAz
	 */
	public static final String	COL_MIDWAY_ADJUST_INCOME	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_MIDWAY_ADJUST_INCOME;
	/**
	 * rAŊz
	 */
	public static final String	COL_MIDWAY_ADJUST_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_MIDWAY_ADJUST_TAX;
	/**
	 * ^T̋^̋z
	 */
	public static final String	COL_AFTER_DEDUCT_INCOME		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_AFTER_DEDUCT_INCOME;
	
	/**
	 * Љی^̍T
	 */
	public static final String	COL_PAY_INS_DEDUCTION		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_PAY_INS_DEDUCTION;
	/**
	 * zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	 */
	public static final String	COL_DEPENDENTS_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_DEPENDENTS_DEDUCTION;
	/**
	 * ېŋ^z
	 */
	public static final String	COL_CALC_TAXED_INCOME		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_CALC_TAXED_INCOME;
	/**
	 * ZoNŊz
	 */
	public static final String	COL_CALC_INCOME_TAX			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_CALC_INCOME_TAX;
	/**
	 * NNŊz
	 */
	public static final String	COL_ADJUSTED_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_ADJUSTED_INCOME_TAX;
	/**
	 * N藦TzŊz
	 */
	public static final String	COL_DEDUCTED_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_DEDUCTED_INCOME_TAX;
	/**
	 * NŊz
	 */
	public static final String	COL_FINAL_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_FINAL_INCOME_TAX;
	/**
	 * ЈR[h
	 */
	public static final int		NUM_K_CODE_KIHON			= 1;
	
	/**
	 * ЈR[h
	 */
	public static final int		NUM_K_CODE_INC_TAX			= 2;
	
	/**
	 * ЈR[h
	 */
	public static final int		NUM_K_CODE_MID_ENT			= 3;
	/**
	 * ЈR[h
	 */
	public static final int		NUM_K_CODE_ADJUST			= 4;
	
	/**
	 * Ј
	 */
	public static final int		NUM_K_NAME					= 5;
	
	/**
	 * Јض
	 */
	public static final int		NUM_K_KANA					= 6;
	
	/**
	 * R[h
	 */
	public static final int		NUM_STATION_CODE			= 7;
	
	/**
	 * EʃR[h
	 */
	public static final int		NUM_POSITION_CODE			= 8;
	
	/**
	 * Г
	 */
	public static final int		NUM_ENTRANCE_DATE			= 9;
	
	/**
	 * ގГ
	 */
	public static final int		NUM_RETIREMENT_DATE			= 10;
	
	/**
	 * œKpN
	 */
	public static final int		NUM_INC_EXPECTED_DATE		= 11;
	/**
	 * ېŋ敪
	 */
	public static final int		NUM_INCOME_TAX_TYPE			= 12;
	/**
	 * N敪
	 */
	public static final int		NUM_ADJUSTMENT_TYPE			= 13;
	/**
	 * {lǕw敪
	 */
	public static final int		NUM_SELF_WIDOW_TYPE			= 14;
	/**
	 * {lQ敪
	 */
	public static final int		NUM_SELF_HANDICAP_TYPE		= 15;
	/**
	 * {lw敪
	 */
	public static final int		NUM_SELF_STUDENT_TYPE		= 16;
	/**
	 * zҋ敪
	 */
	public static final int		NUM_SPOUSE_INTEND_TYPE		= 17;
	/**
	 * ʕ}{e
	 */
	public static final int		NUM_GENERAL_DEPENDENT		= 18;
	/**
	 * }{e
	 */
	public static final int		NUM_SPECIFIC_DEPENDENT		= 19;
	/**
	 * Vl}{e
	 */
	public static final int		NUM_ELDERLY_DEPENDENT		= 20;
	/**
	 * Ve
	 */
	public static final int		NUM_LIVE_WITH_ELD_REL		= 21;
	/**
	 * 
	 */
	public static final int		NUM_LIVE_WITH_HANDI_GE		= 22;
	/**
	 * 
	 */
	public static final int		NUM_LIVE_WITH_HANDI_SP		= 23;
	/**
	 * Vl
	 */
	public static final int		NUM_LIVE_WITH_HANDI_EL		= 24;
	/**
	 * Ve
	 */
	public static final int		NUM_LIVE_WITH_HANDI_ER		= 25;
	/**
	 * ʏQ
	 */
	public static final int		NUM_GENERAL_HANDICAP		= 26;
	/**
	 * ʏQ
	 */
	public static final int		NUM_SPECIFIC_HANDICAP		= 27;
	/**
	 * }{̐
	 */
	public static final int		NUM_DEPENDENT_COUNT			= 28;
	/**
	 * rЋ敪
	 */
	public static final int		NUM_MIDWAY_TYPE				= 29;
	/**
	 * OΖz
	 */
	public static final int		NUM_FORMER_INCOME			= 30;
	/**
	 * OΖЉیz
	 */
	public static final int		NUM_FORMER_INSURANCE		= 31;
	/**
	 * OΖ揊Ŋz
	 */
	public static final int		NUM_FORMER_TAX				= 32;
	/**
	 * N
	 */
	public static final int		NUM_ADJUST_YEAR				= 33;
	/**
	 * NvZ
	 */
	public static final int		NUM_ADJUST_STATUS			= 34;
	/**
	 * ʂ̐ی
	 */
	public static final int		NUM_GENERAL_LIFE_INS		= 35;
	/**
	 * lNی
	 */
	public static final int		NUM_PRIVATE_PENSION			= 36;
	/**
	 * یTz
	 */
	public static final int		NUM_LIFE_INS_DEDUCTION		= 37;
	/**
	 * nkی
	 */
	public static final int		NUM_EARTHQUAKE_INS			= 38;
	/**
	 * Qی
	 */
	public static final int		NUM_LONG_TERM_DAMAGE_INS	= 39;
	/**
	 * QیTz
	 */
	public static final int		NUM_DAMAGE_INS_DEDUCTION	= 40;
	/**
	 * ЉیTz
	 */
	public static final int		NUM_SOCIAL_INS_DEDUCTION	= 41;
	/**
	 * K͊Ƌϓ|Tz
	 */
	public static final int		NUM_MUTUAL_AID_DEDUCTION	= 42;
	/**
	 * z҂̖{N̍vžϊz
	 */
	public static final int		NUM_SPOUSE_SUM_INCOME		= 43;
	/**
	 * zғʍTz
	 */
	public static final int		NUM_SPOUSE_SP_DEDUCTION		= 44;
	/**
	 * ZؓʍTz
	 */
	public static final int		NUM_HOUSE_LOAN_DEDUCTION	= 45;
	/**
	 * xz
	 */
	public static final int		NUM_ALLOWANCE_ADJUSTMENT	= 46;
	/**
	 * ېŒz
	 */
	public static final int		NUM_TAX_FREE_ADJUSTMENT		= 47;
	/**
	 * Љیz
	 */
	public static final int		NUM_SOC_INS_ADJUSTMENT		= 48;
	/**
	 * Œz
	 */
	public static final int		NUM_TAX_INC_ADJUSTMENT		= 49;
	/**
	 * 򒥎[Ev
	 */
	public static final int		NUM_WITHHOLD_SLIP_NOTES		= 50;
	/**
	 * ^A蓖z
	 */
	public static final int		NUM_PAYMENT_ALLOWANCE		= 51;
	/**
	 * ^A蓖Ŋz
	 */
	public static final int		NUM_PAYMENT_INCOME_TAX		= 52;
	/**
	 * ܗ^z
	 */
	public static final int		NUM_BONUS_ALLOWANCE			= 53;
	/**
	 * ܗ^Ŋz
	 */
	public static final int		NUM_BONUS_INCOME_TAX		= 54;
	/**
	 * rAz
	 */
	public static final int		NUM_MIDWAY_ADJUST_INCOME	= 55;
	/**
	 * rAŊz
	 */
	public static final int		NUM_MIDWAY_ADJUST_TAX		= 56;
	/**
	 * ^T̋^̋z
	 */
	public static final int		NUM_AFTER_DEDUCT_INCOME		= 57;
	/**
	 * Љی^̍T
	 */
	public static final int		NUM_PAY_INS_DEDUCTION		= 58;
	/**
	 * zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	 */
	public static final int		NUM_DEPENDENTS_DEDUCTION	= 59;
	/**
	 * ېŋ^z
	 */
	public static final int		NUM_CALC_TAXED_INCOME		= 60;
	/**
	 * ZoNŊz
	 */
	public static final int		NUM_CALC_INCOME_TAX			= 61;
	/**
	 * NNŊz
	 */
	public static final int		NUM_ADJUSTED_INCOME_TAX		= 62;
	/**
	 * N藦TzŊz
	 */
	public static final int		NUM_DEDUCTED_INCOME_TAX		= 63;
	/**
	 * NŊz
	 */
	public static final int		NUM_FINAL_INCOME_TAX		= 64;
	

	/**
	 * RXgN^
	 */
	public AdjustmentDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<AdjustmentDto> mappingAll() throws SQLException {
		List<AdjustmentDto> all = new ArrayList<AdjustmentDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return AdjustmentListDto NR[h
	 * @throws SQLException SQLOꍇ
	 */
	private AdjustmentDto mapping() throws SQLException {
		AdjustmentDto dto = new AdjustmentDto();
		dto.setKCode(rs.getString(NUM_K_CODE_KIHON)); // ЈR[h
		
		dto.setKName(rs.getString(NUM_K_NAME)); // Ј
		dto.setKKana(rs.getString(NUM_K_KANA)); // Јض
		dto.setStationCode(rs.getString(NUM_STATION_CODE)); // R[h
		dto.setPositionCode(rs.getString(NUM_POSITION_CODE)); // EʃR[h
		dto.setEntranceDate(rs.getInt(NUM_ENTRANCE_DATE)); // Г
		dto.setRetirementDate(rs.getInt(NUM_RETIREMENT_DATE)); // ގГ
		
		dto.setIncExpectedDate(rs.getDate(NUM_INC_EXPECTED_DATE)); // œKpN
		dto.setIncomeTaxType(rs.getString(NUM_INCOME_TAX_TYPE)); // ېŋ敪
		dto.setAdjustmentType(rs.getString(NUM_ADJUSTMENT_TYPE)); // N敪
		dto.setSelfWidowType(rs.getString(NUM_SELF_WIDOW_TYPE)); // {lǕw敪
		dto.setSelfHandicapType(rs.getString(NUM_SELF_HANDICAP_TYPE)); // {lQ敪
		dto.setSelfStudentType(rs.getString(NUM_SELF_STUDENT_TYPE)); // {lw敪
		dto.setSpouseIntendType(rs.getString(NUM_SPOUSE_INTEND_TYPE)); // zҋ敪
		dto.setGeneralDependent(rs.getInt(NUM_GENERAL_DEPENDENT)); // ʕ}{e
		dto.setSpecificDependent(rs.getInt(NUM_SPECIFIC_DEPENDENT)); // }{e
		dto.setElderlyDependent(rs.getInt(NUM_ELDERLY_DEPENDENT)); // Vl}{e
		dto.setLiveWithEldRel(rs.getInt(NUM_LIVE_WITH_ELD_REL)); // Ve
		dto.setLiveWithHandiGe(rs.getInt(NUM_LIVE_WITH_HANDI_GE)); // 
		dto.setLiveWithHandiSp(rs.getInt(NUM_LIVE_WITH_HANDI_SP)); // 
		dto.setLiveWithHandiEl(rs.getInt(NUM_LIVE_WITH_HANDI_EL)); // Vl
		dto.setLiveWithHandiEr(rs.getInt(NUM_LIVE_WITH_HANDI_ER)); // Ve
		dto.setGeneralHandicap(rs.getInt(NUM_GENERAL_HANDICAP)); // ʏQ
		dto.setSpecificHandicap(rs.getInt(NUM_SPECIFIC_HANDICAP)); // ʏQ
		dto.setDependentCount(rs.getInt(NUM_DEPENDENT_COUNT)); // }{̐
		
		dto.setMidwayType(rs.getString(NUM_MIDWAY_TYPE)); // rЋ敪
		dto.setFormerIncome(rs.getInt(NUM_FORMER_INCOME)); // OΖz
		dto.setFormerInsurance(rs.getInt(NUM_FORMER_INSURANCE)); // OΖЉیz
		dto.setFormerTax(rs.getInt(NUM_FORMER_TAX)); // OΖ揊Ŋz
		
		dto.setAdjustYear(rs.getInt(NUM_ADJUST_YEAR)); // N
		dto.setAdjustStatus(rs.getString(NUM_ADJUST_STATUS)); // NvZ
		dto.setGeneralLifeIns(rs.getInt(NUM_GENERAL_LIFE_INS)); // ʂ̐ی
		dto.setPrivatePension(rs.getInt(NUM_PRIVATE_PENSION)); // lNی
		dto.setLifeInsDeduction(rs.getInt(NUM_LIFE_INS_DEDUCTION)); // یTz
		dto.setEarthquakeIns(rs.getInt(NUM_EARTHQUAKE_INS)); // nkی
		dto.setLongTermDamageIns(rs.getInt(NUM_LONG_TERM_DAMAGE_INS)); // Qی
		dto.setDamageInsDeduction(rs.getInt(NUM_DAMAGE_INS_DEDUCTION)); // QیTz
		dto.setSocialInsDeduction(rs.getInt(NUM_SOCIAL_INS_DEDUCTION)); // ЉیTz
		dto.setMutualAidDeduction(rs.getInt(NUM_MUTUAL_AID_DEDUCTION)); // K͊Ƌϓ|Tz
		dto.setSpouseSumIncome(rs.getInt(NUM_SPOUSE_SUM_INCOME)); // z҂̖{N̍vžϊz
		dto.setSpouseSpDeduction(rs.getInt(NUM_SPOUSE_SP_DEDUCTION)); // zғʍTz
		dto.setHouseLoanDeduction(rs.getInt(NUM_HOUSE_LOAN_DEDUCTION)); // ZؓʍTz
		dto.setAllowanceAdjustment(rs.getInt(NUM_ALLOWANCE_ADJUSTMENT)); // xz
		dto.setTaxFreeAdjustment(rs.getInt(NUM_TAX_FREE_ADJUSTMENT)); // ېŒz
		dto.setSocInsAdjustment(rs.getInt(NUM_SOC_INS_ADJUSTMENT)); // Љیz
		dto.setTaxIncAdjustment(rs.getInt(NUM_TAX_INC_ADJUSTMENT)); // Œz
		dto.setWithholdSlipNotes(rs.getString(NUM_WITHHOLD_SLIP_NOTES)); // 򒥎[Ev
		dto.setPaymentAllowance(rs.getInt(NUM_PAYMENT_ALLOWANCE)); // ^A蓖z
		dto.setPaymentIncomeTax(rs.getInt(NUM_PAYMENT_INCOME_TAX)); // ^A蓖Ŋz
		dto.setBonusAllowance(rs.getInt(NUM_BONUS_ALLOWANCE)); // ܗ^z
		dto.setBonusIncomeTax(rs.getInt(NUM_BONUS_INCOME_TAX)); // ܗ^Ŋz
		dto.setMidwayAdjustIncome(rs.getInt(NUM_MIDWAY_ADJUST_INCOME)); // rAz
		dto.setMidwayAdjustTax(rs.getInt(NUM_MIDWAY_ADJUST_TAX)); // rAŊz
		dto.setAfterDeductIncome(rs.getInt(NUM_AFTER_DEDUCT_INCOME)); // ^T̋^̋z
		dto.setPayInsDeduction(rs.getInt(NUM_PAY_INS_DEDUCTION)); // Љی^̍T
		dto.setDependentsDeduction(rs.getInt(NUM_DEPENDENTS_DEDUCTION)); // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
		dto.setCalcTaxedIncome(rs.getInt(NUM_CALC_TAXED_INCOME)); // ېŋ^z
		dto.setCalcIncomeTax(rs.getInt(NUM_CALC_INCOME_TAX)); // ZoNŊz
		dto.setAdjustedIncomeTax(rs.getInt(NUM_ADJUSTED_INCOME_TAX)); // NNŊz
		dto.setDeductedIncomeTax(rs.getInt(NUM_DEDUCTED_INCOME_TAX)); // N藦TzŊz
		dto.setFinalIncomeTax(rs.getInt(NUM_FINAL_INCOME_TAX)); // NŊz
		
		return dto;
	}
	
	/**
	 * ɂNf[^擾
	 * @param adjustYear N
	 * @param lastDate NŏI
	 * @param kCode ЈR[h
	 * @param kName Ј
	 * @param kKana Јض
	 * @param retirementFlag 
	 * @param positionCode 
	 * @param adjustmentType 
	 * @param midwayType 
	 * @param adjustStatus 
	 * @return List (DTOList)
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	public List<AdjustmentDto> findForCondition(int adjustYear, Date lastDate, String kCode, String kName,
			String kKana, String retirementFlag, String positionCode, String adjustmentType, String midwayType,
			String adjustStatus) throws IllegalAccessException, SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE_KIHON + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_NAME + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_KANA + " LIKE ? ");
		if (retirementFlag != null && retirementFlag.equals(String.valueOf(PayrollConst.RETIREMENT_FLAG_ON))) {
			sb.append("AND ");
			sb.append(COL_RETIREMENT_DATE + " <= ? ");
		} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(PayrollConst.RETIREMENT_FLAG_OFF))) {
			sb.append("AND ");
			sb.append("( ");
			sb.append(COL_RETIREMENT_DATE + " = 0 ");
			sb.append("OR ");
			sb.append(COL_RETIREMENT_DATE + " > ? ");
			sb.append(") ");
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_POSITION_CODE + " = ? ");
		}
		if (adjustmentType != null && !adjustmentType.equals("")) {
			sb.append("AND ");
			sb.append(COL_ADJUSTMENT_TYPE + " = ? ");
		}
		if (midwayType != null && !midwayType.equals("")) {
			sb.append("AND ");
			sb.append(COL_MIDWAY_TYPE + " = ? ");
		}
		if (adjustStatus != null && adjustStatus.equals(PayrollConst.ADJU_STATUS_NON)) {
			sb.append("AND ");
			sb.append(COL_ADJUST_STATUS + " IS NULL ");
		} else if (adjustStatus != null && !adjustStatus.equals("")) {
			sb.append("AND ");
			sb.append(COL_ADJUST_STATUS + " = ? ");
		}
		try {
			prepareStatement(getSelectStatement(getClass()) + getAdjustmentTable() + sb.toString());
			setParam(index++, DateUtil.convDateToInteger(lastDate));
			setParam(index++, lastDate);
			setParam(index++, adjustYear);
			setParam(index++, "%" + kCode + "%");
			setParam(index++, "%" + kName + "%");
			setParam(index++, "%" + kKana + "%");
			if (retirementFlag != null && !retirementFlag.equals("")) {
				setParam(index++, DateUtil.convDateToInteger(lastDate));
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			if (adjustmentType != null && !adjustmentType.equals("")) {
				setParam(index++, adjustmentType);
			}
			if (midwayType != null && !midwayType.equals("")) {
				setParam(index++, midwayType);
			}
			if (adjustStatus != null && !adjustStatus.equals("") && !adjustStatus.equals(PayrollConst.ADJU_STATUS_NON)) {
				setParam(index++, adjustStatus);
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂNf[^擾
	 * @param adjustDate N
	 * @param endDate    NŏI
	 * @param kCode      ЈR[h
	 * @return List (DTOList)
	 * @throws IllegalAccessException  \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	public AdjustmentDto findForEmployee(Date adjustDate, Date endDate, String kCode) throws IllegalAccessException,
			SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE_KIHON + " = ? ");
		try {
			prepareStatement(getSelectStatement(getClass()) + getAdjustmentTable() + sb.toString());
			setParam(index++, endDate);
			setParam(index++, adjustDate);
			setParam(index++, adjustDate);
			setParam(index++, kCode);
			executeQuery();
			AdjustmentDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Nf[^r[SQL擾
	 * @return Nf[^r[擾SQL
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public String getAdjustmentTable() throws IllegalAccessException {
		MKihonPayrollDao kihonPayrollDao = new MKihonPayrollDao();
		CmIncomeTaxDao cmIncomeTaxDao = new CmIncomeTaxDao();
		CdAdjustmentDao cdAdjustmentDao = new CdAdjustmentDao();
		StringBuffer sb = new StringBuffer();
		sb.append(" ");
		sb.append("FROM ");
		sb.append("(");
		sb.append("(");
		sb.append("(");
		sb.append(kihonPayrollDao.getHistoryTable() + " ");
		sb.append("LEFT JOIN ");
		sb.append(cmIncomeTaxDao.getHistoryTableForDate() + " ");
		sb.append("ON " + COL_K_CODE_KIHON + " = " + COL_K_CODE_INC_TAX);
		sb.append(") ");
		sb.append("LEFT JOIN ");
		sb.append(CmMidwayEnterDao.TABLE + " ");
		sb.append("ON " + COL_K_CODE_KIHON + " = " + COL_K_CODE_MID_ENT);
		sb.append(") ");
		sb.append("LEFT JOIN ");
		sb.append(cdAdjustmentDao.getTableForDate() + " ");
		sb.append("ON " + COL_K_CODE_KIHON + " = " + COL_K_CODE_ADJUST);
		sb.append(") ");
		return sb.toString();
	}
	
}
