/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.base;

import java.util.Calendar;
import java.util.Date;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

/**
 * MosP^vZJŗLpȃ\bh񋟂B<br><br>
 */
public class PayrollUtility {
	
	/**
	 * t擾B
	 * @param strDate t(yyyymmdd)
	 * @return t
	 * @throws MospException MosPOꍇ
	 */
	public static Date getDate(String strDate) throws MospException {
		if (strDate == null || strDate.length() != 8) {
			throw new MospException(MospConst.EX_DATE_INVALID);
		}
		return MospUtility.getDate(strDate.substring(0, 4) + PayrollConst.SEPARATOR_DATE + strDate.substring(4, 6)
				+ PayrollConst.SEPARATOR_DATE + strDate.substring(6, 8));
	}
	
	/**
	 * N擾B
	 * @param birthDate N
	 * @param toDate    NNZ
	 * @return N
	 */
	public static int getAge(Date birthDate, Date toDate) {
		// 擾
		int age = 0;
		// N擾
		age = MospUtility.getYear(toDate) - MospUtility.getYear(birthDate);
		// NNZaNȂ0
		if (age < 0) {
			age = 0;
			return age;
		}
		// Ώیaȍ~
		if (MospUtility.getMonth(toDate) - MospUtility.getMonth(birthDate) > 0) {
			return age;
		} else if (MospUtility.getMonth(toDate) - MospUtility.getMonth(birthDate) == 0) {
			// Ώۓaȍ~
			if (MospUtility.getDay(toDate) - MospUtility.getDay(birthDate) > 0) {
				return age;
			} else if (MospUtility.getDay(toDate) - MospUtility.getDay(birthDate) == 0) {
				// Ώۓa
				return age;
			} else {
				// ΏۓaȑO
				return age - 1;
			}
		} else {
			// ΏیaȑO
			return age - 1;
		}
	}
	
	/**
	 * 𑀍삷B
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public static Date addDay(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, amount);
		return cal.getTime();
	}
	
}
