/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.vo;

import java.util.Calendar;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.mospcommon.system.dto.CmAgreementWorkOnDto;

/**
 * @author matsusita
 *
 */
public class WorkOnHolidayAgreementCardVo extends MosPVo {
	
	private static final long	serialVersionUID					= -8225974150609632307L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT							= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE							= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_ON_CODE				= "txtWorkOnCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_TYPE_NAME				= "txtWorkTypeName";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CAUSE						= "txtCause";
	/**
	 * 
	 */
	public static final String	PRM_CKB_STANDARD_WEEK_HOLIDAY_SUN	= "ckbStandardWeekHolidaySun";
	/**
	 * 
	 */
	public static final String	PRM_CKB_STANDARD_WEEK_HOLIDAY_MON	= "ckbStandardWeekHolidayMon";
	/**
	 * 
	 */
	public static final String	PRM_CKB_STANDARD_WEEK_HOLIDAY_TUE	= "ckbStandardWeekHolidayTue";
	/**
	 * 
	 */
	public static final String	PRM_CKB_STANDARD_WEEK_HOLIDAY_WED	= "ckbStandardWeekHolidayWed";
	/**
	 * 
	 */
	public static final String	PRM_CKB_STANDARD_WEEK_HOLIDAY_THU	= "ckbStandardWeekHolidayThu";
	/**
	 * 
	 */
	public static final String	PRM_CKB_STANDARD_WEEK_HOLIDAY_FRI	= "ckbStandardWeekHolidayFri";
	/**
	 * 
	 */
	public static final String	PRM_CKB_STANDARD_WEEK_HOLIDAY_SAT	= "ckbStandardWeekHolidaySat";
	/**
	 * 
	 */
	public static final String	PRM_PLT_OFFICIAL_HOLIDAY			= "pltOfficialHoliday";
	/**
	 * 
	 */
	public static final String	PRM_PLT_JAPANESE_HOLIDAY_FLAG		= "pltJapaneseHolidayFlag";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOLIDAY_MASTER_FLAG			= "pltHolidayMasterFlag";
	/**
	 * 
	 */
	public static final String	PRM_TXT_STANDARD_HOLIDAY_RATE		= "txtStandardHolidayRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OFFICIAL_HOLIDAY_RATE		= "txtOfficialHolidayRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_NUMBER_OF_WORK_ON			= "txtNumberOfWorkOn";
	/**
	 * 
	 */
	public static final String	PRM_TXT_START_TIME_HOUR				= "txtStartTimeHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_START_TIME_MIN				= "txtStartTimeMin";
	/**
	 * 
	 */
	public static final String	PRM_TXT_END_TIME_HOUR				= "txtEndTimeHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_END_TIME_MIN				= "txtEndTimeMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_DATE_YEAR				= "pltStartDateYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_DATE_MONTH			= "pltStartDateMonth";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_DATE_DAY				= "pltStartDateDay";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE						= "pltDelete";
	
	// tB[h
	private String				txtWorkOnCode;
	private String				txtWorkTypeName;
	private String				txtCause;
	private String				ckbStandardWeekHolidaySun;
	private String				ckbStandardWeekHolidayMon;
	private String				ckbStandardWeekHolidayTue;
	private String				ckbStandardWeekHolidayWed;
	private String				ckbStandardWeekHolidayThu;
	private String				ckbStandardWeekHolidayFri;
	private String				ckbStandardWeekHolidaySat;
	private String				pltOfficialHoliday;
	private String				pltJapaneseHolidayFlag;
	private String				pltHolidayMasterFlag;
	private String				txtStandardHolidayRate;
	private String				txtOfficialHolidayRate;
	private String				txtNumberOfWorkOn;
	private String				txtStartTimeHour;
	private String				txtStartTimeMin;
	private String				txtEndTimeHour;
	private String				txtEndTimeMin;
	private String				pltStartDateYear;
	private String				pltStartDateMonth;
	private String				pltStartDateDay;
	private String				pltDelete;
	
	// v_EXg
	/**
	 * j
	 */
	public String[][]			aryPltDayOfWeek;
	/**
	 * N
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltDay;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_WORK_ON_CODE;
	/**
	 * 
	 */
	public String				NAM_WORK_TYPE_NAME;
	/**
	 * 
	 */
	public String				NAM_CAUSE;
	/**
	 * 
	 */
	public String				NAM_STANDARD_WEEK_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_OFFICIAL_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_JAPANESE_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_MASTER;
	/**
	 * 
	 */
	public String				NAM_STANDARD_HOLIDAY_RATE;
	/**
	 * 
	 */
	public String				NAM_OFFICIAL_HOLIDAY_RATE;
	/**
	 * 
	 */
	public String				NAM_NUMBER_OF_WORK_ON;
	/**
	 * 
	 */
	public String				NAM_START_TIME;
	/**
	 * 
	 */
	public String				NAM_START_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_START_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_END_TIME;
	/**
	 * 
	 */
	public String				NAM_END_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_END_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_START_DATE;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public int					LEN_WORK_ON_CODE;
	/**
	 * 
	 */
	public int					LEN_WORK_TYPE_NAME;
	/**
	 * 
	 */
	public int					LEN_CAUSE;
	/**
	 * 
	 */
	public int					LEN_STANDARD_HOLIDAY_RATE;
	/**
	 * 
	 */
	public int					LEN_OFFICIAL_HOLIDAY_RATE;
	/**
	 * 
	 */
	public int					LEN_NUMBER_OF_WORK_ON;
	/**
	 * 
	 */
	public int					LEN_HOUR;
	/**
	 * 
	 */
	public int					LEN_MIN;
	
	// [h(0FVKo^A1FXV)
	private int					mode;
	

	/**
	 * RXgN^
	 */
	public WorkOnHolidayAgreementCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_WORK_ON_HOLIDAY_AGREEMENT;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuLaborAgreement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_WORK_ON_CODE = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_AGREEMENT + CommonConst.NAM_COMMON_CODE;
		NAM_WORK_TYPE_NAME = CommonConst.NAM_WORK_TYPE_NAME;
		NAM_CAUSE = CommonConst.NAM_SPECIFIC_CAUSE;
		NAM_STANDARD_WEEK_HOLIDAY = CommonConst.NAM_STANDARD_WEEK_HOLIDAY;
		NAM_OFFICIAL_HOLIDAY = CommonConst.NAM_OFFICIAL_HOLIDAY;
		NAM_JAPANESE_HOLIDAY = CommonConst.NAM_JAPANESE_HOLIDAY;
		NAM_HOLIDAY_MASTER = CommonConst.NAM_PUBLIC_HOLIDAY;
		NAM_STANDARD_HOLIDAY_RATE = CommonConst.NAM_STANDARD_WEEK_HOLIDAY + CommonConst.NAM_PREMIUM_RATE;
		NAM_OFFICIAL_HOLIDAY_RATE = CommonConst.NAM_OFFICIAL_HOLIDAY + CommonConst.NAM_PREMIUM_RATE;
		NAM_NUMBER_OF_WORK_ON = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_NUMBER_OF_DAYS;
		NAM_START_TIME = CommonConst.NAM_START + CommonConst.NAM_TIME;
		NAM_START_TIME_HOUR = CommonConst.NAM_START + CommonConst.NAM_TIME + CommonConst.NAM_ROUND_BRACKETS_LEFT
				+ CommonConst.NAM_HOUR + CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_START_TIME_MIN = CommonConst.NAM_START + CommonConst.NAM_TIME + CommonConst.NAM_ROUND_BRACKETS_LEFT
				+ CommonConst.NAM_MINUTES + CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_END_TIME = CommonConst.NAM_END + CommonConst.NAM_TIME;
		NAM_END_TIME_HOUR = CommonConst.NAM_END + CommonConst.NAM_TIME + CommonConst.NAM_ROUND_BRACKETS_LEFT
				+ CommonConst.NAM_HOUR + CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_END_TIME_MIN = CommonConst.NAM_END + CommonConst.NAM_TIME + CommonConst.NAM_ROUND_BRACKETS_LEFT
				+ CommonConst.NAM_MINUTES + CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_START_DATE = CommonConst.NAM_START_DATE;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_WORK_ON_CODE = 10;
		LEN_WORK_TYPE_NAME = 50;
		LEN_CAUSE = 65535;
		LEN_STANDARD_HOLIDAY_RATE = 3;
		LEN_OFFICIAL_HOLIDAY_RATE = 3;
		LEN_NUMBER_OF_WORK_ON = CommonConst.LEN_MONTH_DAY;
		LEN_HOUR = CommonConst.LEN_TIME_HOUR;
		LEN_MIN = CommonConst.LEN_TIME_MIN;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtWorkOnCode(CommonConst.NAM_COMMON_STRING_INITIAL_VALUE);
		setTxtWorkTypeName(CommonConst.NAM_COMMON_STRING_INITIAL_VALUE);
		setTxtCause(CommonConst.NAM_COMMON_STRING_INITIAL_VALUE);
		setCkbStandardWeekHolidaySun(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setCkbStandardWeekHolidayMon(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setCkbStandardWeekHolidayTue(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setCkbStandardWeekHolidayWed(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setCkbStandardWeekHolidayThu(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setCkbStandardWeekHolidayFri(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setCkbStandardWeekHolidaySat(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setPltOfficialHoliday(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setPltJapaneseHolidayFlag(String.valueOf(MospConst.DELETE_FLAG_OFF));
		setPltHolidayMasterFlag(String.valueOf(MospConst.DELETE_FLAG_OFF));
		setTxtStandardHolidayRate(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtOfficialHolidayRate(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtNumberOfWorkOn(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtStartTimeHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtStartTimeMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtEndTimeHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtEndTimeMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtWorkOnCode = request.getParameter(PRM_TXT_WORK_ON_CODE);
		txtWorkTypeName = request.getParameter(PRM_TXT_WORK_TYPE_NAME);
		txtCause = request.getParameter(PRM_TXT_CAUSE);
		ckbStandardWeekHolidaySun = getCheckBoxParam(request.getParameter(PRM_CKB_STANDARD_WEEK_HOLIDAY_SUN));
		ckbStandardWeekHolidayMon = getCheckBoxParam(request.getParameter(PRM_CKB_STANDARD_WEEK_HOLIDAY_MON));
		ckbStandardWeekHolidayTue = getCheckBoxParam(request.getParameter(PRM_CKB_STANDARD_WEEK_HOLIDAY_TUE));
		ckbStandardWeekHolidayWed = getCheckBoxParam(request.getParameter(PRM_CKB_STANDARD_WEEK_HOLIDAY_WED));
		ckbStandardWeekHolidayThu = getCheckBoxParam(request.getParameter(PRM_CKB_STANDARD_WEEK_HOLIDAY_THU));
		ckbStandardWeekHolidayFri = getCheckBoxParam(request.getParameter(PRM_CKB_STANDARD_WEEK_HOLIDAY_FRI));
		ckbStandardWeekHolidaySat = getCheckBoxParam(request.getParameter(PRM_CKB_STANDARD_WEEK_HOLIDAY_SAT));
		pltOfficialHoliday = request.getParameter(PRM_PLT_OFFICIAL_HOLIDAY);
		pltJapaneseHolidayFlag = request.getParameter(PRM_PLT_JAPANESE_HOLIDAY_FLAG);
		pltHolidayMasterFlag = request.getParameter(PRM_PLT_HOLIDAY_MASTER_FLAG);
		txtStandardHolidayRate = request.getParameter(PRM_TXT_STANDARD_HOLIDAY_RATE);
		txtOfficialHolidayRate = request.getParameter(PRM_TXT_OFFICIAL_HOLIDAY_RATE);
		/*
				txtNumberOfWorkOn = request.getParameter(PRM_TXT_NUMBER_OF_WORK_ON);
				txtStartTimeHour = request.getParameter(PRM_TXT_START_TIME_HOUR);
				txtStartTimeMin = request.getParameter(PRM_TXT_START_TIME_MIN);
				txtEndTimeHour = request.getParameter(PRM_TXT_END_TIME_HOUR);
				txtEndTimeMin = request.getParameter(PRM_TXT_END_TIME_MIN);
		*/
		pltStartDateYear = request.getParameter(PRM_PLT_START_DATE_YEAR);
		pltStartDateMonth = request.getParameter(PRM_PLT_START_DATE_MONTH);
		pltStartDateDay = request.getParameter(PRM_PLT_START_DATE_DAY);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(CmAgreementWorkOnDto dto) {
		txtWorkOnCode = dto.getWorkOnCode();
		txtWorkTypeName = dto.getWorkTypeName();
		txtCause = dto.getCause();
		String[] aryStandardWeekHoliday = StringUtil.divideByComma(dto.getStandardWeekHoliday());
		for (String dayOfWeek : aryStandardWeekHoliday) {
			if (dayOfWeek.equals(String.valueOf(Calendar.SUNDAY))) {
				ckbStandardWeekHolidaySun = dayOfWeek;
			} else if (dayOfWeek.equals(String.valueOf(Calendar.MONDAY))) {
				ckbStandardWeekHolidayMon = dayOfWeek;
			} else if (dayOfWeek.equals(String.valueOf(Calendar.TUESDAY))) {
				ckbStandardWeekHolidayTue = dayOfWeek;
			} else if (dayOfWeek.equals(String.valueOf(Calendar.WEDNESDAY))) {
				ckbStandardWeekHolidayWed = dayOfWeek;
			} else if (dayOfWeek.equals(String.valueOf(Calendar.THURSDAY))) {
				ckbStandardWeekHolidayThu = dayOfWeek;
			} else if (dayOfWeek.equals(String.valueOf(Calendar.FRIDAY))) {
				ckbStandardWeekHolidayFri = dayOfWeek;
			} else if (dayOfWeek.equals(String.valueOf(Calendar.SATURDAY))) {
				ckbStandardWeekHolidaySat = dayOfWeek;
			}
		}
		pltOfficialHoliday = dto.getOfficialHoliday();
		pltJapaneseHolidayFlag = dto.getJapaneseHolidayFlag();
		pltHolidayMasterFlag = dto.getHolidayMasterFlag();
		txtStandardHolidayRate = String.valueOf(dto.getStandardHolidayRate());
		txtOfficialHolidayRate = String.valueOf(dto.getOfficialHolidayRate());
		/*
				txtNumberOfWorkOn = String.valueOf(dto.getNumberOfWorkOn());
				txtStartTimeHour = TimeUtil.convIntegerTimeToStringHour(dto.getStartTime());
				txtStartTimeMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getStartTime());
				txtEndTimeHour = TimeUtil.convIntegerTimeToStringHour(dto.getEndTime());
				txtEndTimeMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getEndTime());
		*/
		pltStartDateYear = String.valueOf(MospUtility.getYear(dto.getStartDate()));
		pltStartDateMonth = String.valueOf(MospUtility.getMonth(dto.getStartDate()));
		pltStartDateDay = String.valueOf(MospUtility.getDay(dto.getStartDate()));
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmAgreementWorkOnDto dto) {
		dto.setWorkOnCode(txtWorkOnCode);
		dto.setWorkTypeName(txtWorkTypeName);
		dto.setCause(txtCause);
		StringBuffer sb = new StringBuffer();
		if (ckbStandardWeekHolidaySun.equals(String.valueOf(CommonConst.CHECKBOX_ON))) {
			sb.append(Calendar.SUNDAY);
			sb.append(MospConst.DATA_SEPARATOR);
		}
		if (ckbStandardWeekHolidayMon.equals(String.valueOf(CommonConst.CHECKBOX_ON))) {
			sb.append(Calendar.MONDAY);
			sb.append(MospConst.DATA_SEPARATOR);
		}
		if (ckbStandardWeekHolidayTue.equals(String.valueOf(CommonConst.CHECKBOX_ON))) {
			sb.append(Calendar.TUESDAY);
			sb.append(MospConst.DATA_SEPARATOR);
		}
		if (ckbStandardWeekHolidayWed.equals(String.valueOf(CommonConst.CHECKBOX_ON))) {
			sb.append(Calendar.WEDNESDAY);
			sb.append(MospConst.DATA_SEPARATOR);
		}
		if (ckbStandardWeekHolidayThu.equals(String.valueOf(CommonConst.CHECKBOX_ON))) {
			sb.append(Calendar.THURSDAY);
			sb.append(MospConst.DATA_SEPARATOR);
		}
		if (ckbStandardWeekHolidayFri.equals(String.valueOf(CommonConst.CHECKBOX_ON))) {
			sb.append(Calendar.FRIDAY);
			sb.append(MospConst.DATA_SEPARATOR);
		}
		if (ckbStandardWeekHolidaySat.equals(String.valueOf(CommonConst.CHECKBOX_ON))) {
			sb.append(Calendar.SATURDAY);
			sb.append(MospConst.DATA_SEPARATOR);
		}
		dto.setStandardWeekHoliday(sb.toString());
		dto.setOfficialHoliday(pltOfficialHoliday);
		dto.setJapaneseHolidayFlag(pltJapaneseHolidayFlag);
		dto.setHolidayMasterFlag(pltHolidayMasterFlag);
		dto.setStandardHolidayRate(Integer.parseInt(txtStandardHolidayRate));
		dto.setOfficialHolidayRate(Integer.parseInt(txtOfficialHolidayRate));
		/*
				dto.setNumberOfWorkOn(Integer.parseInt(txtNumberOfWorkOn));
				dto.setStartTime(TimeUtil.convStringTimeToIntegerTime(txtStartTimeHour, txtStartTimeMin));
				dto.setEndTime(TimeUtil.convStringTimeToIntegerTime(txtEndTimeHour, txtEndTimeMin));
		*/
		dto.setStartDate(DateUtil.getDate(pltStartDateYear, pltStartDateMonth, pltStartDateDay));
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtWorkOnCode, NAM_WORK_ON_CODE, PRM_TXT_WORK_ON_CODE);
		checkRequired(txtWorkTypeName, NAM_WORK_TYPE_NAME, PRM_TXT_WORK_TYPE_NAME);
		checkRequired(txtCause, NAM_CAUSE, PRM_TXT_CAUSE);
		checkRequired(txtStandardHolidayRate, NAM_STANDARD_HOLIDAY_RATE, PRM_TXT_STANDARD_HOLIDAY_RATE);
		checkRequired(txtOfficialHolidayRate, NAM_OFFICIAL_HOLIDAY_RATE, PRM_TXT_OFFICIAL_HOLIDAY_RATE);
		/*
				checkRequired(txtNumberOfWorkOn, NAM_NUMBER_OF_WORK_ON, PRM_TXT_NUMBER_OF_WORK_ON);
				checkRequired(txtStartTimeHour, NAM_START_TIME_HOUR, PRM_TXT_START_TIME_HOUR);
				checkRequired(txtStartTimeMin, NAM_START_TIME_MIN, PRM_TXT_START_TIME_MIN);
				checkRequired(txtEndTimeHour, NAM_END_TIME_HOUR, PRM_TXT_END_TIME_HOUR);
				checkRequired(txtEndTimeMin, NAM_END_TIME_MIN, PRM_TXT_END_TIME_MIN);
		*/
		// ^CvmF
		checkCode(txtWorkOnCode, NAM_WORK_ON_CODE, PRM_TXT_WORK_ON_CODE);
		checkNumber(txtStandardHolidayRate, NAM_STANDARD_HOLIDAY_RATE, PRM_TXT_STANDARD_HOLIDAY_RATE);
		checkNumber(txtOfficialHolidayRate, NAM_OFFICIAL_HOLIDAY_RATE, PRM_TXT_OFFICIAL_HOLIDAY_RATE);
		/*
				checkNumber(txtNumberOfWorkOn, NAM_NUMBER_OF_WORK_ON, PRM_TXT_NUMBER_OF_WORK_ON);
				checkNumber(txtStartTimeHour, NAM_START_TIME_HOUR, PRM_TXT_START_TIME_HOUR);
				checkNumber(txtStartTimeMin, NAM_START_TIME_MIN, PRM_TXT_START_TIME_MIN);
				checkNumber(txtEndTimeHour, NAM_END_TIME_HOUR, PRM_TXT_END_TIME_HOUR);
				checkNumber(txtEndTimeMin, NAM_END_TIME_MIN, PRM_TXT_END_TIME_MIN);
		*/
		// 񒷊mF
		checkLength(txtWorkOnCode, LEN_WORK_ON_CODE, NAM_WORK_ON_CODE, PRM_TXT_WORK_ON_CODE);
		checkLength(txtWorkTypeName, LEN_WORK_TYPE_NAME, NAM_WORK_TYPE_NAME, PRM_TXT_WORK_TYPE_NAME);
		checkLength(txtCause, LEN_CAUSE, NAM_CAUSE, PRM_TXT_CAUSE);
		checkLength(txtStandardHolidayRate, LEN_STANDARD_HOLIDAY_RATE, NAM_STANDARD_HOLIDAY_RATE,
				PRM_TXT_STANDARD_HOLIDAY_RATE);
		checkLength(txtOfficialHolidayRate, LEN_OFFICIAL_HOLIDAY_RATE, NAM_OFFICIAL_HOLIDAY_RATE,
				PRM_TXT_OFFICIAL_HOLIDAY_RATE);
		/*
				checkLength(txtNumberOfWorkOn, LEN_NUMBER_OF_WORK_ON, NAM_NUMBER_OF_WORK_ON, PRM_TXT_NUMBER_OF_WORK_ON);
				checkLength(txtStartTimeHour, LEN_HOUR, NAM_START_TIME_HOUR, PRM_TXT_START_TIME_HOUR);
				checkLength(txtStartTimeMin, LEN_MIN, NAM_START_TIME_MIN, PRM_TXT_START_TIME_MIN);
				checkLength(txtEndTimeHour, LEN_HOUR, NAM_END_TIME_HOUR, PRM_TXT_END_TIME_HOUR);
				checkLength(txtEndTimeMin, LEN_MIN, NAM_END_TIME_MIN, PRM_TXT_END_TIME_MIN);
		*/
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return txtWorkOnCode
	 */
	public String getTxtWorkOnCode() {
		return txtWorkOnCode;
	}
	
	/**
	 * @return txtWorkTypeName
	 */
	public String getTxtWorkTypeName() {
		return txtWorkTypeName;
	}
	
	/**
	 * @return txtCause
	 */
	public String getTxtCause() {
		return txtCause;
	}
	
	/**
	 * @return ckbStandardWeekHolidaySun
	 */
	public String getCkbStandardWeekHolidaySun() {
		return ckbStandardWeekHolidaySun;
	}
	
	/**
	 * @return ckbStandardWeekHolidayMon
	 */
	public String getCkbStandardWeekHolidayMon() {
		return ckbStandardWeekHolidayMon;
	}
	
	/**
	 * @return ckbStandardWeekHolidayTue
	 */
	public String getCkbStandardWeekHolidayTue() {
		return ckbStandardWeekHolidayTue;
	}
	
	/**
	 * @return ckbStandardWeekHolidayWed
	 */
	public String getCkbStandardWeekHolidayWed() {
		return ckbStandardWeekHolidayWed;
	}
	
	/**
	 * @return ckbStandardWeekHolidayThu
	 */
	public String getCkbStandardWeekHolidayThu() {
		return ckbStandardWeekHolidayThu;
	}
	
	/**
	 * @return ckbStandardWeekHolidayFri
	 */
	public String getCkbStandardWeekHolidayFri() {
		return ckbStandardWeekHolidayFri;
	}
	
	/**
	 * @return ckbStandardWeekHolidaySat
	 */
	public String getCkbStandardWeekHolidaySat() {
		return ckbStandardWeekHolidaySat;
	}
	
	/**
	 * @return pltOfficialHoliday
	 */
	public String getPltOfficialHoliday() {
		return pltOfficialHoliday;
	}
	
	/**
	 * @return pltJapaneseHolidayFlag
	 */
	public String getPltJapaneseHolidayFlag() {
		return pltJapaneseHolidayFlag;
	}
	
	/**
	 * @return pltHolidayMasterFlag
	 */
	public String getPltHolidayMasterFlag() {
		return pltHolidayMasterFlag;
	}
	
	/**
	 * @return txtStandardHolidayRate
	 */
	public String getTxtStandardHolidayRate() {
		return txtStandardHolidayRate;
	}
	
	/**
	 * @return txtOfficialHolidayRate
	 */
	public String getTxtOfficialHolidayRate() {
		return txtOfficialHolidayRate;
	}
	
	/**
	 * @return txtNumberOfWorkOn
	 */
	public String getTxtNumberOfWorkOn() {
		return txtNumberOfWorkOn;
	}
	
	/**
	 * @return txtStartTimeHour
	 */
	public String getTxtStartTimeHour() {
		return txtStartTimeHour;
	}
	
	/**
	 * @return txtStartTimeMin
	 */
	public String getTxtStartTimeMin() {
		return txtStartTimeMin;
	}
	
	/**
	 * @return txtEndTimeHour
	 */
	public String getTxtEndTimeHour() {
		return txtEndTimeHour;
	}
	
	/**
	 * @return txtEndTimeMin
	 */
	public String getTxtEndTimeMin() {
		return txtEndTimeMin;
	}
	
	/**
	 * @return pltStartDateYear
	 */
	public String getPltStartDateYear() {
		return pltStartDateYear;
	}
	
	/**
	 * @return pltStartDateMonth
	 */
	public String getPltStartDateMonth() {
		return pltStartDateMonth;
	}
	
	/**
	 * @return pltStartDateDay
	 */
	public String getPltStartDateDay() {
		return pltStartDateDay;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return txtWorkOnCode
	 */
	public String getEscTxtWorkOnCode() {
		return escapeHTML(txtWorkOnCode);
	}
	
	/**
	 * @return txtWorkTypeName
	 */
	public String getEscTxtWorkTypeName() {
		return escapeHTML(txtWorkTypeName);
	}
	
	/**
	 * @return txtCause
	 */
	public String getEscTxtCause() {
		return escapeHTML(txtCause);
	}
	
	/**
	 * @return ckbStandardWeekHolidaySun
	 */
	public String getEscCkbStandardWeekHolidaySun() {
		return getCheckBoxChecked(ckbStandardWeekHolidaySun);
	}
	
	/**
	 * @return ckbStandardWeekHolidayMon
	 */
	public String getEscCkbStandardWeekHolidayMon() {
		return getCheckBoxChecked(ckbStandardWeekHolidayMon);
	}
	
	/**
	 * @return ckbStandardWeekHolidayTue
	 */
	public String getEscCkbStandardWeekHolidayTue() {
		return getCheckBoxChecked(ckbStandardWeekHolidayTue);
	}
	
	/**
	 * @return ckbStandardWeekHolidayWed
	 */
	public String getEscCkbStandardWeekHolidayWed() {
		return getCheckBoxChecked(ckbStandardWeekHolidayWed);
	}
	
	/**
	 * @return ckbStandardWeekHolidayThu
	 */
	public String getEscCkbStandardWeekHolidayThu() {
		return getCheckBoxChecked(ckbStandardWeekHolidayThu);
	}
	
	/**
	 * @return ckbStandardWeekHolidayFri
	 */
	public String getEscCkbStandardWeekHolidayFri() {
		return getCheckBoxChecked(ckbStandardWeekHolidayFri);
	}
	
	/**
	 * @return ckbStandardWeekHolidaySat
	 */
	public String getEscCkbStandardWeekHolidaySat() {
		return getCheckBoxChecked(ckbStandardWeekHolidaySat);
	}
	
	/**
	 * @return txtStandardHolidayRate
	 */
	public String getEscTxtStandardHolidayRate() {
		return escapeHTML(txtStandardHolidayRate);
	}
	
	/**
	 * @return txtOfficialHolidayRate
	 */
	public String getEscTxtOfficialHolidayRate() {
		return escapeHTML(txtOfficialHolidayRate);
	}
	
	/**
	 * @return txtNumberOfWorkOn
	 */
	public String getEscTxtNumberOfWorkOn() {
		return escapeHTML(txtNumberOfWorkOn);
	}
	
	/**
	 * @return txtStartTimeHour
	 */
	public String getEscTxtStartTimeHour() {
		return escapeHTML(txtStartTimeHour);
	}
	
	/**
	 * @return txtStartTimeMin
	 */
	public String getEscTxtStartTimeMin() {
		return escapeHTML(txtStartTimeMin);
	}
	
	/**
	 * @return txtEndTimeHour
	 */
	public String getEscTxtEndTimeHour() {
		return escapeHTML(txtEndTimeHour);
	}
	
	/**
	 * @return txtEndTimeMin
	 */
	public String getEscTxtEndTimeMin() {
		return escapeHTML(txtEndTimeMin);
	}
	
	/**
	 * @param txtWorkOnCode Zbg txtWorkOnCode
	 */
	public void setTxtWorkOnCode(String txtWorkOnCode) {
		this.txtWorkOnCode = txtWorkOnCode;
	}
	
	/**
	 * @param txtWorkTypeName Zbg txtWorkTypeName
	 */
	public void setTxtWorkTypeName(String txtWorkTypeName) {
		this.txtWorkTypeName = txtWorkTypeName;
	}
	
	/**
	 * @param txtCause Zbg txtCause
	 */
	public void setTxtCause(String txtCause) {
		this.txtCause = txtCause;
	}
	
	/**
	 * @param ckbStandardWeekHolidaySun Zbg ckbStandardWeekHolidaySun
	 */
	public void setCkbStandardWeekHolidaySun(String ckbStandardWeekHolidaySun) {
		this.ckbStandardWeekHolidaySun = ckbStandardWeekHolidaySun;
	}
	
	/**
	 * @param ckbStandardWeekHolidayMon Zbg ckbStandardWeekHolidayMon
	 */
	public void setCkbStandardWeekHolidayMon(String ckbStandardWeekHolidayMon) {
		this.ckbStandardWeekHolidayMon = ckbStandardWeekHolidayMon;
	}
	
	/**
	 * @param ckbStandardWeekHolidayTue Zbg ckbStandardWeekHolidayTue
	 */
	public void setCkbStandardWeekHolidayTue(String ckbStandardWeekHolidayTue) {
		this.ckbStandardWeekHolidayTue = ckbStandardWeekHolidayTue;
	}
	
	/**
	 * @param ckbStandardWeekHolidayWed Zbg ckbStandardWeekHolidayWed
	 */
	public void setCkbStandardWeekHolidayWed(String ckbStandardWeekHolidayWed) {
		this.ckbStandardWeekHolidayWed = ckbStandardWeekHolidayWed;
	}
	
	/**
	 * @param ckbStandardWeekHolidayThu Zbg ckbStandardWeekHolidayThu
	 */
	public void setCkbStandardWeekHolidayThu(String ckbStandardWeekHolidayThu) {
		this.ckbStandardWeekHolidayThu = ckbStandardWeekHolidayThu;
	}
	
	/**
	 * @param ckbStandardWeekHolidayFri Zbg ckbStandardWeekHolidayFri
	 */
	public void setCkbStandardWeekHolidayFri(String ckbStandardWeekHolidayFri) {
		this.ckbStandardWeekHolidayFri = ckbStandardWeekHolidayFri;
	}
	
	/**
	 * @param ckbStandardWeekHolidaySat Zbg ckbStandardWeekHolidaySat
	 */
	public void setCkbStandardWeekHolidaySat(String ckbStandardWeekHolidaySat) {
		this.ckbStandardWeekHolidaySat = ckbStandardWeekHolidaySat;
	}
	
	/**
	 * @param pltOfficialHoliday Zbg pltOfficialHoliday
	 */
	public void setPltOfficialHoliday(String pltOfficialHoliday) {
		this.pltOfficialHoliday = pltOfficialHoliday;
	}
	
	/**
	 * @param pltJapaneseHolidayFlag Zbg pltJapaneseHolidayFlag
	 */
	public void setPltJapaneseHolidayFlag(String pltJapaneseHolidayFlag) {
		this.pltJapaneseHolidayFlag = pltJapaneseHolidayFlag;
	}
	
	/**
	 * @param pltHolidayMasterFlag Zbg pltHolidayMasterFlag
	 */
	public void setPltHolidayMasterFlag(String pltHolidayMasterFlag) {
		this.pltHolidayMasterFlag = pltHolidayMasterFlag;
	}
	
	/**
	 * @param txtStandardHolidayRate Zbg txtStandardHolidayRate
	 */
	public void setTxtStandardHolidayRate(String txtStandardHolidayRate) {
		this.txtStandardHolidayRate = txtStandardHolidayRate;
	}
	
	/**
	 * @param txtOfficialHolidayRate Zbg txtOfficialHolidayRate
	 */
	public void setTxtOfficialHolidayRate(String txtOfficialHolidayRate) {
		this.txtOfficialHolidayRate = txtOfficialHolidayRate;
	}
	
	/**
	 * @param txtNumberOfWorkOn Zbg txtNumberOfWorkOn
	 */
	public void setTxtNumberOfWorkOn(String txtNumberOfWorkOn) {
		this.txtNumberOfWorkOn = txtNumberOfWorkOn;
	}
	
	/**
	 * @param txtStartTimeHour Zbg txtStartTimeHour
	 */
	public void setTxtStartTimeHour(String txtStartTimeHour) {
		this.txtStartTimeHour = txtStartTimeHour;
	}
	
	/**
	 * @param txtStartTimeMin Zbg txtStartTimeMin
	 */
	public void setTxtStartTimeMin(String txtStartTimeMin) {
		this.txtStartTimeMin = txtStartTimeMin;
	}
	
	/**
	 * @param txtEndTimeHour Zbg txtEndTimeHour
	 */
	public void setTxtEndTimeHour(String txtEndTimeHour) {
		this.txtEndTimeHour = txtEndTimeHour;
	}
	
	/**
	 * @param txtEndTimeMin Zbg txtEndTimeMin
	 */
	public void setTxtEndTimeMin(String txtEndTimeMin) {
		this.txtEndTimeMin = txtEndTimeMin;
	}
	
	/**
	 * @param pltStartDateYear Zbg pltStartDateYear
	 */
	public void setPltStartDateYear(String pltStartDateYear) {
		this.pltStartDateYear = pltStartDateYear;
	}
	
	/**
	 * @param pltStartDateMonth Zbg pltStartDateMonth
	 */
	public void setPltStartDateMonth(String pltStartDateMonth) {
		this.pltStartDateMonth = pltStartDateMonth;
	}
	
	/**
	 * @param pltStartDateDay Zbg pltStartDateDay
	 */
	public void setPltStartDateDay(String pltStartDateDay) {
		this.pltStartDateDay = pltStartDateDay;
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
