/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.vo.MosPWorkFlowVo;

/**
 * @author yoshida
 *
 */
public class HolidayApprovalCardVo extends MosPWorkFlowVo {
	
	private static final long	serialVersionUID	= -1324346009148110367L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_SELECT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_APPROVED		= 1;
	/**
	 * 
	 */
	public static final int		MODE_VIEW			= 2;
	
	// tB[h
	private String				lblHolidayDate;
	private String				lblHolidayTime;
	private String				lblReason;
	private String				lblCauseComment;
	private String				lblReqestDate;
	private String				lblApprovalStatus;
	
	// Lxc
	private String				lblTotalRemainDays;
	private String				lblTotalRemainHour;
	// ԊOxc
	private String				lblSubstituteRemain;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_DATE;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_TIME;
	/**
	 * 
	 */
	public String				NAM_REQUEST_DATE;
	/**
	 * 
	 */
	public String				NAM_REASON;
	/**
	 * 
	 */
	public String				NAM_CAUSE_COMMENT;
	/**
	 * 
	 */
	public String				NAM_STATUS;
	/**
	 * 
	 */
	public String				NAM_COMMENT;
	
	// [h(0FFE߂A1FύXs)
	private int					mode;
	
	private boolean				useSubstitute;
	private boolean				useHourHoliday;
	

	/**
	 * RXgN^
	 */
	public HolidayApprovalCardVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_SELECT;
	}
	
	@Override
	public void setSubTitle() {
		subTitle = CommonConst.NAM_HOLIDAY_REQUEST + CommonConst.NAM_APPROVED;
		aryMenu = new String[][]{ { CMD_MENU_MAMAGE, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuManagerApproval(), };
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_HOLIDAY_DATE = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_DAY;
		NAM_HOLIDAY_TIME = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_COMMON_TIME;
		NAM_REQUEST_DATE = CommonConst.NAM_APPLICATION + CommonConst.NAM_DAY;
		NAM_REASON = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_REASON;
		NAM_CAUSE_COMMENT = CommonConst.NAM_CAUSE;
		NAM_STATUS = CommonConst.NAM_APPROVAL_STATE;
		NAM_COMMENT = CommonConst.NAM_COMMENT;
		LEN_COMMENT = 50;
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// 񒷊mF
		checkLength(getTxtComment(), LEN_COMMENT, NAM_COMMENT, PRM_TXT_COMMENT);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		// ԒPʔNx
		sb.append("var HOUR_HOLIDAY = ");
		sb.append(useHourHoliday);
		sb.append(";");
		// x@\
		sb.append("var SUBSTITUTE = ");
		sb.append(useSubstitute);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return lblHolidayDate
	 */
	public String getEscLblHolidayDate() {
		return escapeHTML(lblHolidayDate);
	}
	
	/**
	 * @return lblHolidayTime
	 */
	public String getEscLblHolidayTime() {
		return escapeHTML(lblHolidayTime);
	}
	
	/**
	 * @return lblReason
	 */
	public String getEscLblReason() {
		return escapeHTML(lblReason);
	}
	
	/**
	 * @return lblCauseComment
	 */
	public String getEscLblCauseComment() {
		return escapeHTML(lblCauseComment);
	}
	
	/**
	 * @return lblApprovalStatus
	 */
	public String getEscLblApprovalStatus() {
		return escapeHTML(lblApprovalStatus);
	}
	
	/**
	 * @return lblReqestDate
	 */
	public String getEscLblReqestDate() {
		return escapeHTML(lblReqestDate);
	}
	
	/**
	 * @return lblHolidayDate
	 */
	public String getLblHolidayDate() {
		return lblHolidayDate;
	}
	
	/**
	 * @return lblHolidayTime
	 */
	public String getLblHolidayTime() {
		return lblHolidayTime;
	}
	
	/**
	 * @return lblReason
	 */
	public String getLblReason() {
		return lblReason;
	}
	
	/**
	 * @return lblCauseComment
	 */
	public String getLblCauseComment() {
		return lblCauseComment;
	}
	
	/**
	 * @return lblReqestDate
	 */
	public String getLblReqestDate() {
		return lblReqestDate;
	}
	
	/**
	 * @return lblApprovalStatus
	 */
	public String getLblApprovalStatus() {
		return lblApprovalStatus;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param lblHolidayDate Zbg lblHolidayDate
	 */
	public void setLblHolidayDate(String lblHolidayDate) {
		this.lblHolidayDate = lblHolidayDate;
	}
	
	/**
	 * @param lblHolidayTime Zbg lblHolidayTime
	 */
	public void setLblHolidayTime(String lblHolidayTime) {
		this.lblHolidayTime = lblHolidayTime;
	}
	
	/**
	 * @param lblReason Zbg lblReason
	 */
	public void setLblReason(String lblReason) {
		this.lblReason = lblReason;
	}
	
	/**
	 * @param lblCauseComment Zbg lblCauseComment
	 */
	public void setLblCauseComment(String lblCauseComment) {
		this.lblCauseComment = lblCauseComment;
	}
	
	/**
	 * @param lblReqestDate Zbg lblReqestDate
	 */
	public void setLblReqestDate(String lblReqestDate) {
		this.lblReqestDate = lblReqestDate;
	}
	
	/**
	 * @param lblApprovalStatus Zbg lblApprovalStatus
	 */
	public void setLblApprovalStatus(String lblApprovalStatus) {
		this.lblApprovalStatus = lblApprovalStatus;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @return lblTotalRemainDays
	 */
	public String getLblTotalRemainDays() {
		return lblTotalRemainDays;
	}
	
	/**
	 * @return lblTotalRemainHour
	 */
	public String getLblTotalRemainHour() {
		return lblTotalRemainHour;
	}
	
	/**
	 * @return lblSubstituteRemain
	 */
	public String getLblSubstituteRemain() {
		return lblSubstituteRemain;
	}
	
	/**
	 * @param lblTotalRemainDays Zbg lblTotalRemainDays
	 */
	public void setLblTotalRemainDays(String lblTotalRemainDays) {
		this.lblTotalRemainDays = lblTotalRemainDays;
	}
	
	/**
	 * @param lblTotalRemainHour Zbg lblTotalRemainHour
	 */
	public void setLblTotalRemainHour(String lblTotalRemainHour) {
		this.lblTotalRemainHour = lblTotalRemainHour;
	}
	
	/**
	 * @param lblSubstituteRemain Zbg lblSubstituteRemain
	 */
	public void setLblSubstituteRemain(String lblSubstituteRemain) {
		this.lblSubstituteRemain = lblSubstituteRemain;
	}
	
	/**
	 * @return useSubstitute
	 */
	public boolean isUseSubstitute() {
		return useSubstitute;
	}
	
	/**
	 * @return useHourHoliday
	 */
	public boolean isUseHourHoliday() {
		return useHourHoliday;
	}
	
	/**
	 * @param useSubstitute Zbg useSubstitute
	 */
	public void setUseSubstitute(boolean useSubstitute) {
		this.useSubstitute = useSubstitute;
	}
	
	/**
	 * @param useHourHoliday Zbg useHourHoliday
	 */
	public void setUseHourHoliday(boolean useHourHoliday) {
		this.useHourHoliday = useHourHoliday;
	}
	
}
