/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.kintai.workflow.dto.AttendanceRouteDto;

/**
 * @author yoshida
 *
 */
public class AttendanceRouteListVo extends MosPVo {
	
	private static final long	serialVersionUID	= 7562923266126590833L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * txtKCode
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	/**
	 * txtKName
	 */
	public static final String	PRM_TXT_K_NAME		= "txtKName";
	/**
	 * txtRouteCode
	 */
	public static final String	PRM_TXT_ROUTE_CODE	= "txtRouteCode";
	/**
	 * pltOffice
	 */
	public static final String	PRM_PLT_OFFICE		= "pltOffice";
	/**
	 * pltSection
	 */
	public static final String	PRM_PLT_SECTION		= "pltSection";
	
	// tB[h
	/**
	 * 
	 */
	private String[][]			aryAttendanceRoute;
	
	private String				txtKCode;
	private String				txtKName;
	private String				txtRouteCode;
	private String				pltOffice;
	private String				pltSection;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_ROUTE_CODE;
	/**
	 * 
	 */
	public String				NAM_OFFICE;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_CODE;
	/**
	 * 
	 */
	public String				NAM_LAYER1;
	/**
	 * 
	 */
	public String				NAM_LAST_LAYER;
	/**
	 * 
	 */
	public int					LEN_CODE;
	/**
	 * 
	 */
	public int					LEN_NAME;
	
	// \[gL[
	/**
	 * keySectionCode
	 */
	public final String			KEY_SECTION			= "keySectionCode";
	/**
	 * keyKCode
	 */
	public final String			KEY_K_CODE			= "keyKCode";
	/**
	 * keyOffice
	 */
	public final String			KEY_OFFICE			= "keyOffice";
	
	// [h(0FȂA1F)
	private int					searchmode;
	
	// v_E
	/**
	 * 
	 */
	public String[][]			aryPltOffice;
	/**
	 * 
	 */
	public String[][]			aryPltSection;
	/**
	 * 
	 */
	public String[][]			aryPltUser;
	/**
	 * 
	 */
	public String[][]			aryPltUnit;
	

	/**
	 * RXgN^
	 */
	public AttendanceRouteListVo() {
		super();
		setViewPath(getClassName());
		txtKCode = "";
		txtKName = "";
		txtRouteCode = "";
		pltOffice = "";
		pltSection = "";
		aryAttendanceRoute = new String[0][0];
		setFormerKey(KEY_SECTION);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_APPROVAL_ATTENDANCE;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuApproval(), };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_ROUTE_CODE = CommonConst.NAM_APPROVAL_ROUTE + CommonConst.NAM_COMMON_CODE;
		NAM_OFFICE = CommonConst.NAM_OFFICE;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_LAYER1 = CommonConst.NAM_1ST_APPROVED;
		NAM_LAST_LAYER = CommonConst.NAM_2ND_APPROVED;
		LEN_CODE = CommonConst.LEN_K_CODE;
		LEN_NAME = CommonConst.LEN_K_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		txtRouteCode = request.getParameter(PRM_TXT_ROUTE_CODE);
		pltOffice = request.getParameter(PRM_PLT_OFFICE);
		pltSection = request.getParameter(PRM_PLT_SECTION);
	}
	
	@Override
	public void setFields(List<?> listAttendanceRoute) {
		// Xg̐ݒ
		list = listAttendanceRoute;
		// f[^̎擾
		count = listAttendanceRoute.size();
		// z̏
		aryAttendanceRoute = new String[count][6];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listAttendanceRoute.iterator();
		while (it.hasNext()) {
			AttendanceRouteDto dto = (AttendanceRouteDto)it.next();
			aryAttendanceRoute[i][0] = String.valueOf(dto.getRouteId());
			aryAttendanceRoute[i][1] = escapeHTML(getCodeName(dto.getSCode(), aryPltSection));
			aryAttendanceRoute[i][2] = escapeHTML(getCodeName(dto.getKCode(), aryPltUser));
			aryAttendanceRoute[i][3] = escapeHTML(getCodeName(dto.getLayer1(), aryPltUnit));
			aryAttendanceRoute[i][4] = escapeHTML(getCodeName(dto.getLastLayer(), aryPltUnit));
			aryAttendanceRoute[i][5] = escapeHTML(getCodeName(dto.getJCode(), aryPltOffice));
			i++;
		}
	}
	
	/**
	 * @return aryAttendanceRoute
	 */
	public String[][] getAryAttendanceRoute() {
		return aryAttendanceRoute.clone();
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtKName
	 */
	public String getTxtKName() {
		return txtKName;
	}
	
	/**
	 * @return txtRouteCode
	 */
	public String getTxtRouteCode() {
		return txtRouteCode;
	}
	
	/**
	 * @return pltOffice
	 */
	public String getPltOffice() {
		return pltOffice;
	}
	
	/**
	 * @return pltSection
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param aryAttendanceRoute Zbg aryAttendanceRoute
	 */
	public void setAryAttendanceRoute(String[][] aryAttendanceRoute) {
		this.aryAttendanceRoute = aryAttendanceRoute.clone();
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtKName Zbg txtKName
	 */
	public void setTxtKName(String txtKName) {
		this.txtKName = txtKName;
	}
	
	/**
	 * @param txtRouteCode Zbg txtRouteCode
	 */
	public void setTxtRouteCode(String txtRouteCode) {
		this.txtRouteCode = txtRouteCode;
	}
	
	/**
	 * @param pltOffice Zbg pltOffice
	 */
	public void setPltOffice(String pltOffice) {
		this.pltOffice = pltOffice;
	}
	
	/**
	 * @param pltSection Zbg pltSection
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
}
