/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.workflow.dto.CtOvertimeRequestDto;
import jp.mosp.kintai.workflow.vo.OverTimeApprovalCardVo;

/**
 * @author yoshida
 *
 */
public class OverTimeApprovalCardAction extends MosPWorkflowAction {
	
	// R}h
	/**
	 * K2136
	 */
	public static final String	CMD_CARD_SELECT		= "K2136";
	private static final String	CMD_CARD_APPROVED	= "K2137";
	private static final String	CMD_CARD_RETURNED	= "K2138";
	

	/**
	 * RXgN^
	 */
	public OverTimeApprovalCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_CARD_APPROVED)) {
			// F
			approved();
		} else if (cmd.equals(CMD_CARD_RETURNED)) {
			// 
			returned();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new OverTimeApprovalCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// [U̎擾
		getInfo(user.getUserId());
	}
	
	@Override
	protected void select() throws Exception {
		OverTimeApprovalCardVo vo = (OverTimeApprovalCardVo)getVo();
		// f[^̎擾
		CtOvertimeRequestDto dto = getOverTimeRequest(NumberUtil.getIntParam(key2));
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		// F󋵂̐ݒ
		setApprovalStatus(dto);
	}
	
	/**
	 * F
	 * @throws Exception 	Oꍇ
	 */
	private void approved() throws Exception {
		// DTO̎擾
		CtOvertimeRequestDto dto = (CtOvertimeRequestDto)getSessionDto();
		OverTimeApprovalCardVo vo = (OverTimeApprovalCardVo)getVo();
		// cƐ\F
		if (runOverTimeRequestApproved(dto)) {
			// R~bg
			commit();
			// bZ[W̕\
			setMessage(getMessage(CommonConst.MSG_CODE_WORKFLOW_UPDATE, ""));
		}
		// VOɏZbg
		vo.setFields(dto);
		// F󋵂̐ݒ
		setApprovalStatus(dto);
	}
	
	/**
	 * ߏ
	 * @throws Exception 	Oꍇ
	 */
	private void returned() throws Exception {
		// DTO̎擾
		CtOvertimeRequestDto dto = (CtOvertimeRequestDto)getSessionDto();
		OverTimeApprovalCardVo vo = (OverTimeApprovalCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// ߂
		if (runWorkflowReturnProcess(dto.getKCode(), dto.getWorkDate(), dto.getWorkflow(),
				CommonConst.NAM_OVER_TIME_REQUEST, vo.getTxtComment())) {
			// R~bg
			commit();
			// bZ[W̕\
			vo.setMessage(getMessage(CommonConst.MSG_CODE_WORKFLOW_UPDATE, ""));
		}
		// VOɏZbg
		vo.setFields(dto);
		// F󋵂̐ݒ
		setApprovalStatus(dto);
	}
	
	/**
	 * F󋵏̐ݒ
	 * @param dto			ΏDTO
	 * @throws Exception 	Oꍇ
	 */
	private void setApprovalStatus(CtOvertimeRequestDto dto) throws Exception {
		OverTimeApprovalCardVo vo = (OverTimeApprovalCardVo)getVo();
		setLabelBasisInfo(dto.getKCode());
		String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
		vo.setLblApprovalStatus(getApprovalName(statusCode));
		// [hݒ
		vo.setMode(OverTimeApprovalCardVo.MODE_VIEW);
		// FҊmF
		if (part().kintaiApproval().isApprover(dto.getKCode(), userBasis.getKCode(), statusCode, dto.getWorkDate())) {
			vo.setMode(OverTimeApprovalCardVo.MODE_SELECT);
			if (KintaiApprovalPart.is1stApproved(statusCode)) {
				vo.setMode(OverTimeApprovalCardVo.MODE_APPROVED);
			}
		}
		// ߂Rgꗗ
		setReturnedComment(dto.getKCode(), dto.getWorkflow());
		// Ώ۔N̎cƎԂ̍v		
		int overMonthly = part().kintai().getOverTimeForPeriod(dto.getKCode(), getStartDateForList(dto.getWorkDate()),
				getEndDateForList(dto.getWorkDate()));
		// Jgݒ
		setLaborAgreementInfo(dto.getKCode(), dto.getWorkDate());
		vo.setCaution(checkCautionOverTime(overMonthly, 0));
		vo.setWarning(checkWarningOverTime(overMonthly, 0));
		vo.setLblOverTimeMonthly(TimeUtil.convIntegerTimeToJPHours(overMonthly));
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
}
