/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.action;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.workflow.dto.AmRouteDto;
import jp.mosp.kintai.workflow.dto.AmUnitDto;
import jp.mosp.kintai.workflow.vo.ApprovalRouteListVo;

/**
 * @author yoshida
 *
 */
public class ApprovalRouteListAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_ROUTE_LIST_SHOW			= "S2820";
	private static final String	CMD_ROUTE_LIST_SEARCH		= "S2821";
	private static final String	CMD_ROUTE_LIST_RE_SEARCH	= "S2822";
	private static final String	CMD_ROUTE_LIST_SORT			= "S2823";
	

	/**
	 * RXgN^
	 */
	public ApprovalRouteListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ROUTE_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_ROUTE_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_ROUTE_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_ROUTE_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ApprovalRouteListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		ApprovalRouteListVo vo = (ApprovalRouteListVo)getVo();
		// jbg擾
		vo.aryPltUnit = getCurrentUnitArrayForList();
	}
	
	@Override
	protected void show() throws Exception {
		ApprovalRouteListVo vo = (ApprovalRouteListVo)getVo();
		// lɃZbg
		vo.setSearchmode(ApprovalRouteListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		ApprovalRouteListVo vo = (ApprovalRouteListVo)getVo();
		vo.setParams(request);
		searchRouteList();
		vo.setFormerKey(vo.KEY_ROUTE_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
	}
	
	@Override
	protected void research() throws Exception {
		ApprovalRouteListVo vo = (ApprovalRouteListVo)getVo();
		if (vo.getSearchmode() == ApprovalRouteListVo.SEARCH_ON) {
			removeSessionDto();
			searchRouteList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * [gXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchRouteList() throws Exception {
		ApprovalRouteListVo vo = (ApprovalRouteListVo)getVo();
		// 
		vo.setFields(routeDao().findForCondition(vo.getTxtRouteCode(), vo.getTxtUnitCode(), vo.getTxtKCode(),
				vo.getTxtKName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryRoute().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
		vo.setSearchmode(ApprovalRouteListVo.SEARCH_ON);
	}
	
	/**
	 * 󏳔FjbgR[hꗗiAM_UNITj
	 * @return@̏FjbgR[hXg
	 * @throws Exception 	Oꍇ
	 */
	private String[][] getCurrentUnitArrayForList() throws Exception {
		// ̎擾
		List<AmUnitDto> listUnit = unitDao().findForCurrentUnitArray(
				DateUtil.convDateFormattedByHyphen(DateUtil.getSystemDate()));
		// z̍쐬		
		String[][] aryUnitList = new String[listUnit.size()][2];
		for (int i = 0; i < listUnit.size(); i++) {
			aryUnitList[i][0] = listUnit.get(i).getUnitCode();
			aryUnitList[i][1] = getKName(listUnit.get(i).getMain());
		}
		return aryUnitList;
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		ApprovalRouteListVo vo = (ApprovalRouteListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		ApprovalRouteListVo vo = (ApprovalRouteListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		ApprovalRouteListVo vo = (ApprovalRouteListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_ROUTE_CODE)) {
			comp = new CompRouteCode();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * jbgR[hɂrNX
	 */
	protected static class CompRouteCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 7410652204380257012L;
		

		public int compare(Object obj1, Object obj2) {
			AmRouteDto dto1 = (AmRouteDto)obj1;
			AmRouteDto dto2 = (AmRouteDto)obj2;
			return dto1.getRtCode().compareTo(dto2.getRtCode());
		}
	}
	
}
