/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.dto.CmWorkTypeDto;

/**
 * @author yoshida
 *
 */
public class WorkTypeMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -3051204572322360172L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_SHIFT_CODE	= "txtShiftCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_SHIFT_NAME	= "txtShiftName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String[]			aryShiftCode;
	private String[]			aryShiftName;
	private String[]			aryWorkTable;
	private String[]			aryDelete;
	private String				txtShiftCode;
	private String				txtShiftName;
	private String				pltDelete;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_SHIFT_CODE;
	/**
	 * 
	 */
	public String				NAM_SHIFT_NAME;
	/**
	 * 
	 */
	public String				NAM_WORKING_TABLE;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public int					LEN_SHIFT_CODE;
	/**
	 * 
	 */
	public int					LEN_SHIFT_NAME;
	
	// \[gL[	
	/**
	 * 
	 */
	public final String			KEY_SHIFT_CODE		= "keyShiftCode";
	/**
	 * 
	 */
	public final String			KEY_SHIFT_NAME		= "keyShiftName";
	/**
	 * 
	 */
	public final String			KEY_DELETE			= "keyDelete";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public WorkTypeMasterListVo() {
		super();
		setViewPath(getClassName());
		txtShiftCode = "";
		txtShiftName = "";
		aryShiftCode = new String[0];
		aryShiftName = new String[0];
		aryWorkTable = new String[0];
		aryDelete = new String[0];
		setFormerKey(KEY_SHIFT_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_WORK_TYPE_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_SHIFT_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_SHIFT_NAME = CommonConst.NAM_WORKING_TYPE;
		NAM_WORKING_TABLE = CommonConst.NAM_WORKING_TABLE_INFO;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_SHIFT_CODE = 10;
		LEN_SHIFT_NAME = 50;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtShiftCode = request.getParameter(PRM_TXT_SHIFT_CODE);
		txtShiftName = request.getParameter(PRM_TXT_SHIFT_NAME);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	@Override
	public void setFields(List<?> listWorkingTable) {
		// Xg̐ݒ
		list = listWorkingTable;
		// f[^̎擾
		count = listWorkingTable.size();
		// z̏
		aryShiftCode = new String[count];
		aryShiftName = new String[count];
		aryWorkTable = new String[count];
		aryDelete = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listWorkingTable.iterator();
		while (it.hasNext()) {
			CmWorkTypeDto dto = (CmWorkTypeDto)it.next();
			aryShiftCode[i] = escapeHTML(dto.getShiftCode());
			aryShiftName[i] = escapeHTML(dto.getShiftName());
			aryWorkTable[i] = escapeHTML(convWorkTypeTimes(dto.getStartTime(), dto.getQuitTime()));
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			}
			i++;
		}
	}
	
	/**
	 * Ζ`Ԏϊ\bh
	 * @param start Jn
	 * @param quit I
	 * @return	string	
	 */
	private String convWorkTypeTimes(int start, int quit) {
		StringBuffer sb = new StringBuffer();
		// oΎ
		sb.append(TimeUtil.convIntegerTimeToStringTime(start));
		sb.append(" ");
		sb.append(CommonConst.STR_SLASH_SEPARATOR);
		sb.append(" ");
		// ދΎ
		sb.append(TimeUtil.getJPStringTime(quit));
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return txtShiftCode
	 */
	public String getEscTxtShiftCode() {
		return escapeHTML(txtShiftCode);
	}
	
	/**
	 * @return txtShiftName
	 */
	public String getEscTxtShiftName() {
		return escapeHTML(txtShiftName);
	}
	
	/**
	 * @return aryShiftCode
	 */
	public String[] getAryShiftCode() {
		return aryShiftCode.clone();
	}
	
	/**
	 * @return aryShiftName
	 */
	public String[] getAryShiftName() {
		return aryShiftName.clone();
	}
	
	/**
	 * @return aryWorkTable
	 */
	public String[] getAryWorkTable() {
		return aryWorkTable.clone();
	}
	
	/**
	 * @return aryDelete
	 */
	public String[] getAryDelete() {
		return aryDelete.clone();
	}
	
	/**
	 * @return txtShiftCode
	 */
	public String getTxtShiftCode() {
		return txtShiftCode;
	}
	
	/**
	 * @return txtShiftName
	 */
	public String getTxtShiftName() {
		return txtShiftName;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param txtShiftCode Zbg txtShiftCode
	 */
	public void setTxtShiftCode(String txtShiftCode) {
		this.txtShiftCode = txtShiftCode;
	}
	
	/**
	 * @param txtShiftName Zbg txtShiftName
	 */
	public void setTxtShiftName(String txtShiftName) {
		this.txtShiftName = txtShiftName;
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	/**
	 * @param aryShiftCode Zbg aryShiftCode
	 */
	public void setAryShiftCode(String[] aryShiftCode) {
		this.aryShiftCode = aryShiftCode.clone();
	}
	
	/**
	 * @param aryShiftName Zbg aryShiftName
	 */
	public void setAryShiftName(String[] aryShiftName) {
		this.aryShiftName = aryShiftName.clone();
	}
	
	/**
	 * @param aryWorkTable Zbg aryWorkTable
	 */
	public void setAryWorkTable(String[] aryWorkTable) {
		this.aryWorkTable = aryWorkTable.clone();
	}
	
	/**
	 * @param aryDelete Zbg aryDelete
	 */
	public void setAryDelete(String[] aryDelete) {
		this.aryDelete = aryDelete.clone();
	}
	
}
