/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public class LateReasonCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -6715261187985051137L;
	
	// p[^
	/**
	 * txtLateReason
	 */
	public static final String	PRM_TXT_LATE_REASON	= "txtLateReason";
	
	// tB[h
	private String[]			aryLateReason;
	private String[]			aryTxtLateReason;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_LATE_REASON;
	/**
	 * 
	 */
	public int					LEN_LATE_REASON;
	

	/**
	 * RXgN^
	 */
	public LateReasonCardVo() {
		super();
		setViewPath(getClassName());
		aryLateReason = new String[0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_LATE_REASON;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuReasonMaster());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_LATE_REASON = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_REASON;
		LEN_LATE_REASON = 15;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		aryTxtLateReason = request.getParameterValues(PRM_TXT_LATE_REASON);
	}
	
	/**
	 * tB[hݒ
	 * @param listLate	xRXg
	 */
	@Override
	public void setFields(List<?> listLate) {
		// z̏
		aryLateReason = StringUtil.getBlankArrayOneDimension(10);
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listLate.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			aryLateReason[i] = escapeHTML(dto.getTName());
			i++;
		}
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		for (int i = 0; i < aryTxtLateReason.length; i++) {
			// 񒷊mF
			checkLength(aryTxtLateReason[i], LEN_LATE_REASON, NAM_LATE_REASON, PRM_TXT_LATE_REASON + i);
		}
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	/**
	 * @return aryLateReason
	 */
	public String[] getAryLateReason() {
		return aryLateReason.clone();
	}
	
	/**
	 * @return aryTxtLateReason
	 */
	public String[] getAryTxtLateReason() {
		return aryTxtLateReason.clone();
	}
	
	/**
	 * @param aryLateReason Zbg aryLateReason
	 */
	public void setAryLateReason(String[] aryLateReason) {
		this.aryLateReason = aryLateReason.clone();
	}
	
	/**
	 * @param aryTxtLateReason Zbg aryTxtLateReason
	 */
	public void setAryTxtLateReason(String[] aryTxtLateReason) {
		this.aryTxtLateReason = aryTxtLateReason.clone();
	}
	
}
