/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.payroll.dto.MKintaiKeisanDto;

/**
 * @author yoshida
 *
 */
public class KeisanInformationCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 5208549895641511511L;
	
	// p[^[
	/**
	 * txtKTNen
	 */
	public static final String	PRM_TXT_KTNEN		= "txtKTNen";
	/**
	 * pltKTTuki
	 */
	public static final String	PRM_PLT_KTTUKI		= "pltKTTuki";
	/**
	 * txtKSNen
	 */
	public static final String	PRM_TXT_KSNEN		= "txtKSNen";
	/**
	 * pltKSTuki
	 */
	public static final String	PRM_PLT_KSTUKI		= "pltKSTuki";
	/**
	 * hidKShi
	 */
	public static final String	PRM_HID_KSHI		= "hidKShi";
	/**
	 * pltKKanryou
	 */
	public static final String	PRM_PLT_KKANRYOU	= "pltKKanryou";
	
	// tB[h
	private String				txtKTnen;
	private String				pltKTtuki;
	private String				txtKSnen;
	private String				pltKStuki;
	private String				hidKShi;
	private String				lblKShi;
	private String				pltKKanryou;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_KTNEN;
	/**
	 * 
	 */
	public String				NAM_KTTUKI;
	/**
	 * 
	 */
	public String				NAM_KSNEN;
	/**
	 * 
	 */
	public String				NAM_KSTUKI;
	/**
	 * 
	 */
	public String				NAM_KSHI;
	/**
	 * 
	 */
	public String				NAM_KKANRYOU;
	/**
	 * 
	 */
	public int					LEN_YEAR;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltDays;
	/**
	 * 
	 */
	public String[][]			aryPltCompleteFlag;
	

	/**
	 * RXgN^
	 */
	public KeisanInformationCardVo() {
		super();
		setViewPath(getClassName());
		txtKTnen = "0";
		pltKTtuki = "0";
		txtKSnen = "0";
		pltKStuki = "0";
		hidKShi = "0";
		lblKShi = "0";
		pltKKanryou = "0";
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ATT_CALCULATE_MENU + CommonConst.NAM_INFORMATION;
		aryMenu = new String[][]{ { CMD_MENU_PAYROLL, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_KTNEN = CommonConst.NAM_ATTENDANCE_CALCULATE + CommonConst.NAM_YEAR;
		NAM_KTTUKI = CommonConst.NAM_ATTENDANCE_CALCULATE + CommonConst.NAM_MONTH;
		NAM_KSNEN = CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_SUPPLY + CommonConst.NAM_YEAR;
		NAM_KSTUKI = CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_SUPPLY + CommonConst.NAM_MONTH;
		NAM_KSHI = CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_PROVIDED_DATE;
		NAM_KKANRYOU = CommonConst.NAM_CALCULATE_END + CommonConst.NAM_INFORMATION;
		LEN_YEAR = CommonConst.LEN_YEAR;
	}
	
	/**
	 * p[^ݒ
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtKTnen = request.getParameter(PRM_TXT_KTNEN);
		pltKTtuki = request.getParameter(PRM_PLT_KTTUKI);
		txtKSnen = request.getParameter(PRM_TXT_KSNEN);
		pltKStuki = request.getParameter(PRM_PLT_KSTUKI);
		hidKShi = request.getParameter(PRM_HID_KSHI);
		pltKKanryou = request.getParameter(PRM_PLT_KKANRYOU);
		lblKShi = hidKShi;
	}
	
	/**
	 * tB[hݒ(DTOVOɃZbg)
	 * @param dto Xg
	 */
	public void setFields(MKintaiKeisanDto dto) {
		txtKTnen = String.valueOf(dto.getKTNen());
		pltKTtuki = String.valueOf(dto.getKTTuki());
		txtKSnen = String.valueOf(dto.getKSNen());
		pltKStuki = String.valueOf(dto.getKSTuki());
		hidKShi = String.valueOf(dto.getKShi());
		pltKKanryou = dto.getKKanryou();
		lblKShi = hidKShi;
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MKintaiKeisanDto dto) {
		dto.setKTNen(Integer.parseInt(txtKTnen));
		dto.setKTTuki(Integer.parseInt(pltKTtuki));
		dto.setKSNen(Integer.parseInt(txtKSnen));
		dto.setKSTuki(Integer.parseInt(pltKStuki));
		dto.setKShi(Integer.parseInt(hidKShi));
		dto.setKKanryou(pltKKanryou);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		//ÓmFJn
		startValidation();
		//K{mF
		checkRequired(txtKTnen, NAM_KTNEN, PRM_TXT_KTNEN);
		checkRequired(txtKSnen, NAM_KSNEN, PRM_TXT_KSNEN);
		//񒷊mF
		checkLength(txtKTnen, LEN_YEAR, NAM_KTNEN, PRM_TXT_KTNEN);
		checkLength(txtKSnen, LEN_YEAR, NAM_KSNEN, PRM_TXT_KSNEN);
		//^CvmF(p)
		checkNumber(txtKTnen, NAM_KTNEN, PRM_TXT_KTNEN);
		checkNumber(txtKSnen, NAM_KSNEN, PRM_TXT_KSNEN);
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	/**
	 * @return txtKTnen
	 */
	public String getTxtKTnen() {
		return txtKTnen;
	}
	
	/**
	 * @return pltKTtuki
	 */
	public String getPltKTtuki() {
		return pltKTtuki;
	}
	
	/**
	 * @return txtKSnen
	 */
	public String getTxtKSnen() {
		return txtKSnen;
	}
	
	/**
	 * @return pltKStuki
	 */
	public String getPltKStuki() {
		return pltKStuki;
	}
	
	/**
	 * @return hidKShi
	 */
	public String getHidKShi() {
		return hidKShi;
	}
	
	/**
	 * @return lblKShi
	 */
	public String getLblKShi() {
		return lblKShi;
	}
	
	/**
	 * @return pltKKanryou
	 */
	public String getPltKKanryou() {
		return pltKKanryou;
	}
	
	/**
	 * @param txtKTnen Zbg txtKTnen
	 */
	public void setTxtKTnen(String txtKTnen) {
		this.txtKTnen = txtKTnen;
	}
	
	/**
	 * @param pltKTtuki Zbg pltKTtuki
	 */
	public void setPltKTtuki(String pltKTtuki) {
		this.pltKTtuki = pltKTtuki;
	}
	
	/**
	 * @param txtKSnen Zbg txtKSnen
	 */
	public void setTxtKSnen(String txtKSnen) {
		this.txtKSnen = txtKSnen;
	}
	
	/**
	 * @param pltKStuki Zbg pltKStuki
	 */
	public void setPltKStuki(String pltKStuki) {
		this.pltKStuki = pltKStuki;
	}
	
	/**
	 * @param hidKShi Zbg hidKShi
	 */
	public void setHidKShi(String hidKShi) {
		this.hidKShi = hidKShi;
	}
	
	/**
	 * @param lblKShi Zbg lblKShi
	 */
	public void setLblKShi(String lblKShi) {
		this.lblKShi = lblKShi;
	}
	
	/**
	 * @param pltKKanryou Zbg pltKKanryou
	 */
	public void setPltKKanryou(String pltKKanryou) {
		this.pltKKanryou = pltKKanryou;
	}
	
	/**
	 * @return txtKTnen
	 */
	public String getEscTxtKTnen() {
		return escapeHTML(txtKTnen);
	}
	
	/**
	 * @return txtKSnen
	 */
	public String getEscTxtKSnen() {
		return escapeHTML(txtKSnen);
	}
	
	/**
	 * @return lblKShi
	 */
	public String getEscLblKShi() {
		return escapeHTML(lblKShi);
	}
	
}
