/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dto.CmWorkTypeDto;
import jp.mosp.kintai.system.vo.WorkTypeMasterListVo;

/**
 * @author yoshida
 *
 */
public class WorkTypeMasterListAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_WORK_TYPE_MASTER_LIST_SHOW		= "S2600";	// \
	private static final String	CMD_WORK_TYPE_MASTER_LIST_SELECT	= "S2601";	// 
	private static final String	CMD_WORK_TYPE_MASTER_LIST_RE_SEARCH	= "S2602";	// Č
	private static final String	CMD_WORK_TYPE_MASTER_LIST_SORT		= "S2603";	// \[g
																				
	
	/**
	 * RXgN^
	 */
	public WorkTypeMasterListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_WORK_TYPE_MASTER_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_WORK_TYPE_MASTER_LIST_SELECT)) {
			// 
			search();
		} else if (cmd.equals(CMD_WORK_TYPE_MASTER_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_WORK_TYPE_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new WorkTypeMasterListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		WorkTypeMasterListVo vo = (WorkTypeMasterListVo)getVo();
		// lɃZbg
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setSearchmode(WorkTypeMasterListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		WorkTypeMasterListVo vo = (WorkTypeMasterListVo)getVo();
		vo.setParams(request);
		searchWorkTypeList();
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(WorkTypeMasterListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		WorkTypeMasterListVo vo = (WorkTypeMasterListVo)getVo();
		if (vo.getSearchmode() == WorkTypeMasterListVo.SEARCH_ON) {
			removeSessionDto();
			searchWorkTypeList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * Ζ`ԃXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchWorkTypeList() throws Exception {
		WorkTypeMasterListVo vo = (WorkTypeMasterListVo)getVo();
		// 
		vo.setFields(part().worktype().getCmWorkTypeDao().findForCondition(vo.getTxtShiftCode(), vo.getTxtShiftName(),
				vo.getPltDelete()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryShiftCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		WorkTypeMasterListVo vo = (WorkTypeMasterListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		WorkTypeMasterListVo vo = (WorkTypeMasterListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		WorkTypeMasterListVo vo = (WorkTypeMasterListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_SHIFT_CODE)) {
			comp = new CompShiftCode();
		} else if (key.equals(vo.KEY_SHIFT_NAME)) {
			comp = new CompShiftName();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompDeleteFlag();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * Ζ`ԂɂrNX
	 */
	protected static class CompShiftName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5911228170558115815L;
		

		public int compare(Object obj1, Object obj2) {
			CmWorkTypeDto dto1 = (CmWorkTypeDto)obj1;
			CmWorkTypeDto dto2 = (CmWorkTypeDto)obj2;
			return dto1.getShiftName().compareTo(dto2.getShiftName());
		}
	}
	
	/**
	 * R[hɂrNX
	 */
	protected static class CompShiftCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 433797660366561035L;
		

		public int compare(Object obj1, Object obj2) {
			CmWorkTypeDto dto1 = (CmWorkTypeDto)obj1;
			CmWorkTypeDto dto2 = (CmWorkTypeDto)obj2;
			return dto1.getShiftCode().compareTo(dto2.getShiftCode());
		}
	}
	
	/**
	 * 폜tOɂrNX
	 */
	protected static class CompDeleteFlag implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -3859584542003582185L;
		

		public int compare(Object obj1, Object obj2) {
			CmWorkTypeDto dto1 = (CmWorkTypeDto)obj1;
			CmWorkTypeDto dto2 = (CmWorkTypeDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}
	
}
