/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.schedule.action;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.part.RotationPart;
import jp.mosp.kintai.schedule.dao.CmRotationDao;
import jp.mosp.kintai.schedule.dto.CmRotationDto;
import jp.mosp.kintai.schedule.vo.ScheduleRotationCardVo;

/**
 * @author yoshida
 *
 */
public class ScheduleRotationCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_ROTATION_CARD_SHOW		= "K1215";	// \(ǉ)
	private static final String	CMD_ROTATION_CARD_SELECT	= "K1216";	// \(I)
	private static final String	CMD_ROTATION_CARD_INSERT	= "K1217";	// o^
	private static final String	CMD_ROTATION_CARD_UPDATE	= "K1218";	// XV
																		
	
	/**
	 * RXgN^
	 */
	public ScheduleRotationCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ROTATION_CARD_SHOW)) {
			// \(VK)
			show();
		} else if (cmd.equals(CMD_ROTATION_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_ROTATION_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_ROTATION_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ScheduleRotationCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		ScheduleRotationCardVo vo = (ScheduleRotationCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// R[h敪v_EXg쐬
		vo.aryPltWorkType = part().worktype().getWorkTypeInfoArrayWithHoliday();
		vo.aryPltHoliday = VariousUtil.getApplicableFlagArray();
		vo.setParams(request);
	}
	
	@Override
	protected void show() {
		ScheduleRotationCardVo vo = (ScheduleRotationCardVo)getVo();
		vo.setDefaultValues();
		vo.setMode(ScheduleRotationCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		ScheduleRotationCardVo vo = (ScheduleRotationCardVo)getVo();
		// f[^̎擾
		RotationPart rotation = (RotationPart)part().get(RotationPart.class.getCanonicalName());
		CmRotationDto dto = rotation.findForKey(userBasis.getKCode(), key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		// [hݒ
		vo.setMode(ScheduleRotationCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		ScheduleRotationCardVo vo = (ScheduleRotationCardVo)getVo();
		// p[^̑ÓmF
		vo.validate();
		RotationPart rotation = (RotationPart)part().get(RotationPart.class.getCanonicalName());
		// DAȌ
		CmRotationDao dao = rotation.getCmRotationDao();
		// ݃`FbN
		chkDuplicate(dao.findForKey(userBasis.getKCode(), vo.getTxtRTCode()));
		// DTȌ
		CmRotationDto dto = new CmRotationDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setDtoFields(dto);
		dto.setKCode(userBasis.getKCode());
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(userBasis.getKCode(), dto.getRtCode());
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ScheduleRotationCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		CmRotationDto dto = (CmRotationDto)getSessionDto();
		ScheduleRotationCardVo vo = (ScheduleRotationCardVo)getVo();
		// p[^̑ÓmF
		vo.validate();
		RotationPart rotation = (RotationPart)part().get(RotationPart.class.getCanonicalName());
		// DAȌ
		CmRotationDao dao = rotation.getCmRotationDao();
		// rmF
		chkExclusive(dto, dao.findForUpdate(userBasis.getKCode(), vo.getTxtRTCode()));
		// DTȌ
		vo.setDtoFields(dto);
		dto.setKCode(userBasis.getKCode());
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		CmRotationDto retDto = dao.findForKey(userBasis.getKCode(), dto.getRtCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ScheduleRotationCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
}
