/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.schedule.action;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.schedule.dto.MScheduleDto;
import jp.mosp.kintai.schedule.vo.ScheduleEditCardVo;

/**
 * @author yoshida
 *
 */
public class ScheduleEditCardAction extends AttendanceTotalAction {
	
	// R}h
	private static final String	CMD_EDIT_CARD_SHOW		= "K1240";
	private static final String	CMD_EDIT_CARD_SEARCH	= "K1242";
	private static final String	CMD_EDIT_CARD_REGIST	= "K1244";
	

	/**
	 * RXgN^
	 */
	public ScheduleEditCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_EDIT_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_EDIT_CARD_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_EDIT_CARD_REGIST)) {
			// o^
			regist();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ScheduleEditCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		ScheduleEditCardVo vo = (ScheduleEditCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// v_E擾
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 3, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltWorkType = StringUtil.addArrayFirstRowSpace(part().worktype().getWorkTypeInfoArrayWithHoliday());
		// ΏێЈݒ
		vo.setSelectKCode(userBasis.getKCode());
		// bZ[W\
		// \납폜@bZ[WɃZbgB
		setMessage(CommonConst.MSG_SCHEDULE_EDIT_METHODS);
		setScheduleMenuButton();
	}
	
	@Override
	protected void show() throws Exception {
		ScheduleEditCardVo vo = (ScheduleEditCardVo)getVo();
		// \
		Date current = DateUtil.getSystemDate();
		// Ώ۔Nݒ
		vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
		// 
		searchScheduleList();
	}
	
	@Override
	protected void search() throws Exception {
		ScheduleEditCardVo vo = (ScheduleEditCardVo)getVo();
		// Ώ۔Nݒ
		vo.setParams(request);
		// 
		searchScheduleList();
	}
	
	/**
	 * \ꗗ
	 * @throws Exception 	Oꍇ
	 */
	private void searchScheduleList() throws Exception {
		ScheduleEditCardVo vo = (ScheduleEditCardVo)getVo();
		// ΑӃf[^擾
		getScheduleListForView(vo.getSelectKCode(), DateUtil.getYearMonth(vo.getPltYear(), vo.getPltMonth()));
		// Wvf[^Ԑݒ
		setScheduleHours(scheduleList);
		// Wvf[^z쐬
		makeScheduleArray(vo.getSelectKCode(), scheduleList);
		// I̐ݒ
		setLabelBasisInfo(vo.getSelectKCode());
		// VOݒ
		vo.setFields(aryAttendance);
	}
	
	/**
	 * Wvf[^z쐬
	 * @param kCode ΏێЈR[h
	 * @param scheduleList \񃊃Xg
	 * @throws Exception 	Oꍇ
	 */
	private void makeScheduleArray(String kCode, List<MScheduleDto> scheduleList) throws Exception {
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		final int size = 40;
		aryAttendance = new String[count][size];
		for (int i = 0; i < aryAttendance.length; i++) {
			for (int j = 0; j < aryAttendance[i].length; j++) {
				aryAttendance[i][j] = "";
			}
		}
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// t
			aryAttendance[i][0] = DateUtil.convDateToMonthDayShort(cal.getTime());
			// j
			aryAttendance[i][1] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			aryAttendance[i][9] = getDayOfWeekColorClass(cal.getTime());
			// lijՓAxj
			StringBuffer remark = new StringBuffer();
			String holidayName = getPublicHolidayName(cal.getTime());
			if (StringUtil.isNotNull(holidayName)) {
				remark.append(holidayName);
				remark.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
			aryAttendance[i][8] = remark.toString();
			// cƐ\
			if (part().overtime().isOverTimeRequest(kCode, cal.getTime())) {
				aryAttendance[i][8] += CommonConst.NAM_OVERTIME;
				aryAttendance[i][8] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			// xɐ\
			if (part().holidayRequest().existHolidayRequest(kCode, cal.getTime())) {
				aryAttendance[i][8] += CommonConst.NAM_VACATION_LEAVE;
				aryAttendance[i][8] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// f[^̐ݒ
		Iterator<MScheduleDto> it = scheduleList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MScheduleDto dto = it.next();
			Date scheduleDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (scheduleDate.compareTo(cal.getTime()) == 0) {
					// Ζ`Ԗ
					String kinmuName = "";
					// Ζ`ԃR[h
					String workCode = dto.getKinmu();
					if (KintaiCommonPart.isAvailableWorkType(dto)) {
						kinmuName = part().worktype().getWorkTypeName(dto.getKinmu());
						// oΎ
						aryAttendance[i][4] = dto.getSyJikoku();
						// ދΎ
						aryAttendance[i][5] = dto.getTaJikoku();
						// Ζ
						aryAttendance[i][6] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						// xe
						aryAttendance[i][7] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
					} else if (KintaiCommonPart.isWeekHoliday(dto) || KintaiCommonPart.isOfficialHoliday(dto)) {
						// TxxA@x\
						kinmuName = part().worktype().getWorkTypeName(dto.getKinmu());
					} else {
						// xɗR
						kinmuName = part().mospcode().getHolidayName(dto.getKKRiyuu());
					}
					aryAttendance[i][2] = kinmuName;
					aryAttendance[i][3] = workCode;
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}
	
	/**
	 * o^
	 * @throws Exception 	Oꍇ
	 */
	private void regist() throws Exception {
		ScheduleEditCardVo vo = (ScheduleEditCardVo)getVo();
		// p[^ݒ
		vo.setParams(request);
		// Αӏݒ
		setCalcParam();
		// XVEo^
		int number = registSchedule(vo.getSelectKCode(), makeScheduleMap(DateUtil.getYearMonth(vo.getPltYear(), vo
			.getPltMonth())));
		// R~bg
		commit();
		// \mF֑J
		setNextCmd(ScheduleConfirmListAction.CMD_CONFIRM_LIST_SEARCH);
		// bZ[Wݒ
		setMessage(getMessage(CommonConst.MSG_NUMBER_OF_UPDATES, String.valueOf(number)));
	}
	
	/**
	 * XPW[Map
	 * @param targetMonth Ώی
	 * @return o^pXPW[Map
	 * @throws Exception 	Oꍇ
	 */
	private Map<Date, String> makeScheduleMap(Date targetMonth) throws Exception {
		ScheduleEditCardVo vo = (ScheduleEditCardVo)getVo();
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		Date startDate = getStartDateForList(targetMonth);
		Date endDate = getEndDateForList(targetMonth);
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(startDate);
		// ̐ݒ
		int count = 0;
		Map<Date, String> scheduleMap = new HashMap<Date, String>();
		while (endDate.compareTo(cal.getTime()) >= 0) {
			scheduleMap.put(cal.getTime(), vo.getArySelectWorktype()[count]);
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		return scheduleMap;
	}
	
}
