/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.kintai.report.dto.CmOutPutDto;

/**
 * 
 */
public class OutPutMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= 6248095734423700381L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_CODE		= "txtCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_NAME		= "txtName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_SCOPE		= "pltScope";
	
	// tB[h
	private String[][]			aryOutPutMaster;
	private String				txtCode;
	private String				txtName;
	private String				pltScope;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_CODE;
	/**
	 * 
	 */
	public String				NAM_NAME;
	/**
	 * 
	 */
	public String				NAM_SCOPE;
	/**
	 * 
	 */
	public String				NAM_INDEX;
	/**
	 * 
	 */
	public int					LEN_NAME;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_CODE			= "keyCode";
	/**
	 * 
	 */
	public final String			KEY_NAME			= "keyName";
	/**
	 * 
	 */
	public final String			KEY_SCOPE			= "keyScope";
	/**
	 * 
	 */
	public final String			KEY_INDEX			= "keyIndex";
	
	// [h(0FȂA1F)
	/**
	 * 
	 */
	private int					searchmode;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltScope;
	

	/**
	 * RXgN^
	 */
	public OutPutMasterListVo() {
		super();
		setViewPath(getClassName());
		txtCode = "";
		txtName = "";
		pltScope = "";
		aryOutPutMaster = new String[0][0];
		setFormerKey(KEY_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_OUTPUT_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_PAYROLL, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_CODE = CommonConst.NAM_CMD_PRINT;
		NAM_NAME = CommonConst.NAM_BUTTON_NAME;
		NAM_SCOPE = CommonConst.NAM_SCOPE;
		NAM_INDEX = CommonConst.NAM_SHOW_ORDER;
		LEN_NAME = 20;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtCode = request.getParameter(PRM_TXT_CODE);
		txtName = request.getParameter(PRM_TXT_NAME);
		pltScope = request.getParameter(PRM_PLT_SCOPE);
	}
	
	@Override
	public void setFields(List<?> listCode) {
		// Xg̐ݒ
		list = listCode;
		// f[^̎擾
		count = listCode.size();
		// z̏
		aryOutPutMaster = new String[count][4];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listCode.iterator();
		while (it.hasNext()) {
			CmOutPutDto dto = (CmOutPutDto)it.next();
			aryOutPutMaster[i][0] = escapeHTML(dto.getCode());
			aryOutPutMaster[i][1] = escapeHTML(dto.getName());
			aryOutPutMaster[i][2] = escapeHTML(getCodeName(dto.getScope(), aryPltScope));
			aryOutPutMaster[i][3] = String.valueOf(dto.getViewIndex());
			i++;
		}
	}
	
	/**
	 * @return aryOutPutMaster
	 */
	public String[][] getAryOutPutMaster() {
		return aryOutPutMaster.clone();
	}
	
	/**
	 * @return txtCode
	 */
	public String getTxtCode() {
		return txtCode;
	}
	
	/**
	 * @return txtName
	 */
	public String getTxtName() {
		return txtName;
	}
	
	/**
	 * @return pltScope
	 */
	public String getPltScope() {
		return pltScope;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param aryOutPutMaster Zbg aryOutPutMaster
	 */
	public void setAryOutPutMaster(String[][] aryOutPutMaster) {
		this.aryOutPutMaster = aryOutPutMaster.clone();
	}
	
	/**
	 * @param txtCode Zbg txtCode
	 */
	public void setTxtCode(String txtCode) {
		this.txtCode = txtCode;
	}
	
	/**
	 * @param txtName Zbg txtName
	 */
	public void setTxtName(String txtName) {
		this.txtName = txtName;
	}
	
	/**
	 * @param pltScope Zbg pltScope
	 */
	public void setPltScope(String pltScope) {
		this.pltScope = pltScope;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
}
