/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.action;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.report.dao.MExportDao;
import jp.mosp.kintai.report.dto.MExportDto;
import jp.mosp.kintai.report.vo.ExportMasterCardVo;

/**
 * @author yoshida
 *
 */
public class ExportMasterCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_EXPORT_MASTER_CARD_SHOW		= "S1215";	// \(ǉ)
	private static final String	CMD_EXPORT_MASTER_CARD_SELECT	= "S1216";	// \(I)
	private static final String	CMD_EXPORT_MASTER_CARD_INSERT	= "S1217";	// o^
	private static final String	CMD_EXPORT_MASTER_CARD_UPDATE	= "S1218";	// XV
	private static final String	CMD_EXPORT_MASTER_CARD_DELETE	= "S1219";	// 폜
																			
	
	/**
	 * RXgN^
	 */
	public ExportMasterCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_EXPORT_MASTER_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_INSERT)) {
			// VKo^
			regist();
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_UPDATE)) {
			// XV
			regist();
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_DELETE)) {
			// 폜
			delete();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ExportMasterCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		ExportMasterCardVo vo = (ExportMasterCardVo)getVo();
		vo.aryTargetTable = getArrayTargetTable();
	}
	
	@Override
	protected void show() throws Exception {
		ExportMasterCardVo vo = (ExportMasterCardVo)getVo();
		// VOɏZbg
		vo.setTxtEName("");
		vo.setHidEFile(key1);
		vo.setLblEFile(StringUtil.getCodeName(vo.getHidEFile(), vo.aryTargetTable));
		// l񍀖ڐݒ
		vo.aryPltKintaiDataItem = getKintaiDataItem(vo.getHidEFile());
		vo.aryPltSelectDataItem = new String[0][2];
		// [hݒ
		vo.setMode(ExportMasterCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		ExportMasterCardVo vo = (ExportMasterCardVo)getVo();
		// VOɏZbg
		vo.setTxtEName(key1);
		vo.setHidEFile(key2);
		vo.setLblEFile(StringUtil.getCodeName(vo.getHidEFile(), vo.aryTargetTable));
		// l񍀖ڐݒ
		vo.aryPltKintaiDataItem = getKintaiDataItem(vo.getHidEFile());
		// f[^̎擾
		chkExist(part().export().getMExportDao().findForKey(vo.getTxtEName(), vo.getHidEFile(), 0));
		// l񍀖ڐݒ
		crtDataItem();
		// [hݒ
		vo.setMode(ExportMasterCardVo.MODE_UPDATE);
	}
	
	/**
	 * f[^}
	 * @throws Exception 	Oꍇ
	 */
	protected void regist() throws Exception {
		ExportMasterCardVo vo = (ExportMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MExportDao dao = part().export().getMExportDao();
		/*						
		 *  	2009/02/20	m.yoshida	G[Ή
		 */
		List<MExportDto> exportlist = dao.findForCondition(vo.getTxtEName(), vo.getHidEFile());
		if (cmd.equals(CMD_EXPORT_MASTER_CARD_INSERT)) {
			if (exportlist.size() > 0) {
				vo.addErrMessage(getMessage(MospConst.MSG_DUPLICATE, ""));
				return;
			}
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_UPDATE)) {
			if (exportlist.size() > 0) {
				dao.delete(vo.getTxtEName(), vo.getHidEFile());
			}
		}
		String[] arySelected = vo.getPltSelected();
		for (int i = 0; i < arySelected.length; i++) {
			MExportDto dto = new MExportDto();
			dto.setEName(vo.getTxtEName());
			dto.setEFile(vo.getHidEFile());
			dto.setELine(i);
			dto.setEFName(arySelected[i]);
			// o^
			dao.insert(dto);
		}
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ExportMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// l񍀖ڐݒ
		crtDataItem();
	}
	
	/**
	 * f[^폜
	 * @throws Exception 	Oꍇ
	 */
	protected void delete() throws Exception {
		ExportMasterCardVo vo = (ExportMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// f[^̍XV
		part().export().getMExportDao().delete(vo.getTxtEName(), vo.getHidEFile());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_DELETE, ""));
		// l񍀖ڐݒ
		vo.aryPltKintaiDataItem = new String[0][2];
		vo.aryPltSelectDataItem = new String[0][2];
		// [hݒ
		vo.setMode(ExportMasterCardVo.MODE_UPDATE);
	}
	
	/**
	 * Iڂ̃Xg쐬
	 * @throws Exception 	Oꍇ
	 */
	protected void crtDataItem() throws Exception {
		ExportMasterCardVo vo = (ExportMasterCardVo)getVo();
		// l񍀖ڐݒ
		List<MExportDto> mExportList = part().export().getMExportDao().findForCondition(vo.getTxtEName(),
				vo.getHidEFile());
		String[][] aryKintaiDataItem = getKintaiDataItem(vo.getHidEFile());
		// ڂ̑I
		vo.aryPltSelectDataItem = new String[mExportList.size()][2];
		int t = 0;
		for (int i = 0; i < mExportList.size(); i++) {
			MExportDto dto = mExportList.get(i);
			for (int j = 0; j < aryKintaiDataItem.length; j++) {
				if (aryKintaiDataItem[j][0].equals(dto.getEFName())) {
					vo.aryPltSelectDataItem[i][0] = aryKintaiDataItem[j][0];
					vo.aryPltSelectDataItem[i][1] = aryKintaiDataItem[j][1];
					aryKintaiDataItem[j][0] = "";
					t++;
				} else if (StringUtil.isNotNull(aryKintaiDataItem[j][0])) {
					vo.aryPltSelectDataItem[i][0] = dto.getEFName();
					vo.aryPltSelectDataItem[i][1] = VariousUtil.getCsvSplitInfo(dto.getEFName(), 3);
				}
			}
		}
		String[][] aryPltDataItem = new String[aryKintaiDataItem.length - t][2];
		int n = 0;
		for (String[] element : aryKintaiDataItem) {
			if (StringUtil.isNotNull(element[0])) {
				aryPltDataItem[n][0] = element[0];
				aryPltDataItem[n][1] = element[1];
				n++;
			}
		}
		vo.aryPltKintaiDataItem = aryPltDataItem;
	}
	
	/**
	 * Ώۃe[u̔z
	 * @return	String[][]	Ώۃe[u̔z
	 */
	protected String[][] getArrayTargetTable() {
		return new String[][]{ { CommonConst.CODE_TABLE_M_KIHON, CommonConst.NAM_TABLE_M_KIHON },
			{ CommonConst.CODE_TABLE_M_KINTAI, CommonConst.NAM_TABLE_M_KINTAI },
			{ CommonConst.CODE_TABLE_M_SYUKKINBO, CommonConst.NAM_TABLE_M_SYUKKINBO },
			{ CommonConst.CODE_TABLE_M_YUKYU, CommonConst.NAM_TABLE_M_YUKYU }, };
	}
	
	/**
	 * GNX|[g񍀖ڐݒ
	 * @param strFLID	Ώۃe[uR[h
	 * @return	String[][]	GNX|[g񍀖ڔz
	 * @throws Exception 	Oꍇ
	 */
	protected String[][] getKintaiDataItem(String strFLID) throws Exception {
		return part().export().getKintaiDataItem(strFLID);
	}
	
}
