/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.payroll.dto.MKintaiKeisanDto;

/**
 * M_KINTAIKEISAN(ΑӌvZ)DAONX B
 */
public class MKintaiKeisanDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * M_KINTAIKEISAN(ΑӌvZ)B
	 */
	public static final String	TABLE			= "M_KINTAIKEISAN";
	
	/**
	 * KEY_1 = KTNEN(^vZN)B
	 */
	public static final String	KEY_1			= "KTNEN";
	
	// 
	/**
	 * KTNEN(^vZN)B
	 */
	public static final String	COL_KTNEN		= "KTNEN";
	/**
	 * KTTUKI(^vZ)B
	 */
	public static final String	COL_KTTUKI		= "KTTUKI";
	/**
	 * KSNEN(^xN)B
	 */
	public static final String	COL_KSNEN		= "KSNEN";
	/**
	 * KSTUKI(^x)B
	 */
	public static final String	COL_KSTUKI		= "KSTUKI";
	/**
	 * KSHI(^x)B
	 */
	public static final String	COL_KSHI		= "KSHI";
	/**
	 * KKANRYOU(^)B
	 */
	public static final String	COL_KKANRYOU	= "KKANRYOU";
	/**
	 * STNEN(ܗ^vZN)B
	 */
	public static final String	COL_STNEN		= "STNEN";
	/**
	 * STTUKI(ܗ^vZ)B
	 */
	public static final String	COL_STTUKI		= "STTUKI";
	/**
	 * SSNEN(ܗ^xN)B
	 */
	public static final String	COL_SSNEN		= "SSNEN";
	/**
	 * SSTUKI(ܗ^x)B
	 */
	public static final String	COL_SSTUKI		= "SSTUKI";
	/**
	 * SSHI(ܗ^x)B
	 */
	public static final String	COL_SSHI		= "SSHI";
	/**
	 * SKANRYOU(ܗ^)B
	 */
	public static final String	COL_SKANRYOU	= "SKANRYOU";
	/**
	 * NTNEN(NvZN)B
	 */
	public static final String	COL_NTNEN		= "NTNEN";
	/**
	 * NKANRYOU(N)B
	 */
	public static final String	COL_NKANRYOU	= "NKANRYOU";
	/**
	 * TTNEN(ZvZN)B
	 */
	public static final String	COL_TTNEN		= "TTNEN";
	/**
	 * TTTUKI(ZvZ)B
	 */
	public static final String	COL_TTTUKI		= "TTTUKI";
	/**
	 * TKANRYOU(Z芮)B
	 */
	public static final String	COL_TKANRYOU	= "TKANRYOU";
	/**
	 * GTNEN(όvZN)B
	 */
	public static final String	COL_GTNEN		= "GTNEN";
	/**
	 * GTTUKI(όvZ)B
	 */
	public static final String	COL_GTTUKI		= "GTTUKI";
	/**
	 * GKANRYOU(ϊ)B
	 */
	public static final String	COL_GKANRYOU	= "GKANRYOU";
	

	/**
	 * RXgN^
	 */
	public MKintaiKeisanDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MKintaiKeisanDto> mappingAll() throws SQLException {
		List<MKintaiKeisanDto> all = new ArrayList<MKintaiKeisanDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_kintaikeisanDto m_kintaikeisanR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MKintaiKeisanDto mapping() throws SQLException {
		MKintaiKeisanDto dto = new MKintaiKeisanDto();
		dto.setKTNen(rs.getInt(COL_KTNEN)); //^vZN
		dto.setKTTuki(rs.getInt(COL_KTTUKI)); //^vZ
		dto.setKSNen(rs.getInt(COL_KSNEN)); //^xN
		dto.setKSTuki(rs.getInt(COL_KSTUKI)); //^x
		dto.setKShi(rs.getInt(COL_KSHI)); //^x
		dto.setKKanryou(rs.getString(COL_KKANRYOU)); //^
		dto.setSTNen(rs.getInt(COL_STNEN)); //ܗ^vZN
		dto.setSTTuki(rs.getInt(COL_STTUKI)); //ܗ^vZ
		dto.setSSNen(rs.getInt(COL_STNEN)); //ܗ^xN
		dto.setSSTuki(rs.getInt(COL_SSTUKI)); //ܗ^x
		dto.setSSHi(rs.getInt(COL_SSHI)); //ܗ^x
		dto.setSKanryou(rs.getString(COL_SKANRYOU)); //ܗ^
		dto.setNTNen(rs.getInt(COL_NTNEN)); //NvZN
		dto.setNKanryou(rs.getString(COL_NKANRYOU)); //N
		dto.setTTNen(rs.getInt(COL_TTNEN)); //ZvZN
		dto.setTTTuki(rs.getInt(COL_TTTUKI)); //ZvZ
		dto.setTKanryou(rs.getString(COL_TKANRYOU)); //Z芮
		dto.setGTNen(rs.getInt(COL_GTNEN)); //όvZN
		dto.setGTTuki(rs.getInt(COL_GTTUKI)); //όvZ
		dto.setGKanryou(rs.getString(COL_GKANRYOU)); //ϊ
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<?> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param ktnen ^vZN(L[)
	 * @return m_kintaikeisanDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiKeisanDto findForKey(String ktnen) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, Integer.parseInt(ktnen));
			executeQuery();
			MKintaiKeisanDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param ktnen ^vZN(L[)
	 * @return m_kintaikeisanDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiKeisanDto findForKey(int ktnen) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, ktnen);
			executeQuery();
			MKintaiKeisanDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param ktnen ^vZN(L[)
	 * @return m_kintaikeisanDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiKeisanDto findForUpdate(String ktnen) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, Integer.parseInt(ktnen));
			executeQuery();
			MKintaiKeisanDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param ktnen ^vZN(L[)
	 * @return m_kintaikeisanDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiKeisanDto findForUpdate(int ktnen) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, ktnen);
			executeQuery();
			MKintaiKeisanDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾
	 * @return m_kintaikeisanDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiKeisanDto findForCalc() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()));
			executeQuery();
			MKintaiKeisanDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾
	 * @return m_kintaikeisanDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiKeisanDto findForUpdate() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getForUpdate());
			executeQuery();
			MKintaiKeisanDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param ktnen ^vZN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String ktnen) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KTNEN);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, ktnen);
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int insert(MKintaiKeisanDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int update(MKintaiKeisanDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKTNen());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int delete(MKintaiKeisanDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKTNen());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MKintaiKeisanDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKTNen()); //^vZN
		setParam(index++, dto.getKTTuki()); //^vZ
		setParam(index++, dto.getKSNen()); //^xN
		setParam(index++, dto.getKSTuki()); //^x
		setParam(index++, dto.getKShi()); //^x
		setParam(index++, dto.getKKanryou()); //^
		setParam(index++, dto.getSTNen()); //ܗ^vZN
		setParam(index++, dto.getSTTuki()); //ܗ^vZ
		setParam(index++, dto.getSSNen()); //ܗ^xN
		setParam(index++, dto.getSSTuki()); //ܗ^x
		setParam(index++, dto.getSSHi()); //ܗ^x
		setParam(index++, dto.getSKanryou()); //ܗ^
		setParam(index++, dto.getNTNen()); //NvZN
		setParam(index++, dto.getNKanryou()); //N
		setParam(index++, dto.getTTNen()); //ZvZN
		setParam(index++, dto.getTTTuki()); //ZvZ
		setParam(index++, dto.getTKanryou()); //Z芮
		setParam(index++, dto.getGTNen()); //όvZN
		setParam(index++, dto.getGTTuki()); //όvZ
		setParam(index++, dto.getGKanryou()); //ϊ
		setCommonParams(isInsert);
	}
	
}
