/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.kintai.vo.AttendanceHolidayCardVo;
import jp.mosp.kintai.schedule.dto.MScheduleDto;

/**
 * @author yoshida
 *
 */
public class AttendanceHolidayCardAction extends MosPWorkflowAction {
	
	// R}h
	/**
	 * 
	 */
	public static final String	CMD_HOLIDAY_CARD_SHOW		= "K1130";
	private static final String	CMD_HOLIDAY_CARD_REGIST		= "K1132";
	private static final String	CMD_HOLIDAY_CARD_DELETE		= "K1133";
	private static final String	CMD_HOLIDAY_CARD_DRAFT		= "K1134";
	private static final String	CMD_HOLIDAY_CARD_REFLECT	= "K1135";
	

	/**
	 * RXgN^
	 */
	public AttendanceHolidayCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_HOLIDAY_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_HOLIDAY_CARD_REGIST)) {
			// o^
			regist(false);
		} else if (cmd.equals(CMD_HOLIDAY_CARD_DELETE)) {
			// 폜
			delete();
		} else if (CMD_HOLIDAY_CARD_DRAFT.equals(cmd)) {
			// 
			regist(true);
		} else if (CMD_HOLIDAY_CARD_REFLECT.equals(cmd)) {
			// \̔f
			reflect();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceHolidayCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		AttendanceHolidayCardVo vo = (AttendanceHolidayCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// [Nv_E
		vo.aryPltSubstituteYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 1, 2);
		// [v_E
		vo.aryPltSubstituteMonth = StringUtil.getMonthArray();
		// [v_E
		vo.aryPltSubstituteDay = StringUtil.getDayArray();
		// xɗRv_E
		vo.aryPltHolidayReason = part().mospcode().getHolidayReasonArray();
		// xɏؖv_E
		vo.aryPltHolidayCertificate = getMosPCodeArray(CommonConst.TID_HOLIDAY_CERTIFICATE);
		// ΑӊǗR}h
		setSubTitleMenu();
	}
	
	@Override
	protected void show() throws Exception {
		AttendanceHolidayCardVo vo = (AttendanceHolidayCardVo)getVo();
		// \ڂ̏
		vo.initFields();
		vo.setDraft(true);
		// \̏
		setAttendanceInfo();
		// Αӌ
		MSyukkinboDto dto = kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate(), false);
		if (VariousUtil.isNotNull(dto)) {
			// VOɏݒ
			vo.setFields(dto);
			if (!KintaiApprovalPart.isDraft(dto)) {
				vo.setDraft(false);
			}
		}
		// \[h̃Zbg
		setMode(dto);
	}
	
	/**
	 * xɓo^
	 * @param isDraft		tO
	 * @throws Exception	Oꍇ
	 */
	private void regist(boolean isDraft) throws Exception {
		AttendanceHolidayCardVo vo = (AttendanceHolidayCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// ЈR[h
		String kCode = vo.getHidKCode();
		// Ώ۔N
		Date targetDate = DateUtil.convStringDateToDate(vo.getHidDate());
		// Αӌ
		MSyukkinboDto dto = kintai().getSyukkinboInfo(kCode, targetDate, true);
		// Αӏݒ
		setCalcParam();
		// vZtO
		if (isDailyAutoCalc) {
			// SxxɎ
			vo.setHolidayTimes(allHoliday);
		}
		if (VariousUtil.isNull(dto)) {
			// INSERT
			dto = new MSyukkinboDto();
			// vZ
			vo.setDtoFields(dto);
			dto.setSyozoku(getBelongSectionCode(kCode));
			if (isDraft) {
				dto.setSnRiyuu(CommonConst.CODE_DRAFT);
			}
			// ݃`FbN
			chkDuplicate(kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), false));
			// Nx̏FꍇAf
			margeHolidayRequest(dto);
			// o^tO
			boolean insertFlag = true;
			// Lx̏ꍇAclB
			if (KintaiCommonPart.isAllHoliday(dto)) {
				if (!part().holidayRequest().isApprovedPaidHolidayRequestAll(dto)) {
					insertFlag = checkRemainPaidHoliday(kCode, targetDate, 1, 0);
				}
			}
			// ԊOx̏ꍇAclB
			if (part().mospcode().useSubstituteHolidayFunction() && KintaiCommonPart.isSubstituteAll(dto)) {
				if (!part().holidayRequest().isApprovedSubstituteHolidayRequestAll(dto)) {
					insertFlag = checkRemainSubstitute(kCode, targetDate, 1);
				}
			}
			if (insertFlag) {
				// o^		
				syukkinboDao().insertHoliday(dto);
				// bZ[Wݒ
				setMessage(getMessage(MospConst.MSG_INSERT, ""));
			}
		} else {
			// Fς݂̏ꍇ̓bZ[W\Ao^s
			if (KintaiApprovalPart.isApproved(dto)) {
				// bZ[Wݒ
				setMessage(getMessage(CommonConst.MSG_ALREADY_APPROVED, getMessageDate(dto)));
			} else {
				// UPDATE
				// rmF
				chkExclusive(dto, kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), true));
				// vZ
				vo.setDtoFields(dto);
				if (isDraft) {
					dto.setSnRiyuu(CommonConst.CODE_DRAFT);
				}
				// Nx̏FꍇAf
				margeHolidayRequest(dto);
				// XVtO
				boolean updateFlag = true;
				// Lx̏ꍇAclB
				if (KintaiCommonPart.isAllHoliday(dto)) {
					if (!part().holidayRequest().isApprovedPaidHolidayRequestAll(dto)) {
						updateFlag = checkRemainPaidHoliday(kCode, targetDate, 1, 0);
					}
				}
				// ԊOx̏ꍇAclB
				if (part().mospcode().useSubstituteHolidayFunction() && KintaiCommonPart.isSubstituteAll(dto)) {
					if (!part().holidayRequest().isApprovedSubstituteHolidayRequestAll(dto)) {
						updateFlag = checkRemainSubstitute(kCode, targetDate, 1);
					}
				}
				if (updateFlag) {
					// XV
					syukkinboDao().update(dto);
					// bZ[Wݒ
					setMessage(getMessage(MospConst.MSG_UPDATE, ""));
				}
			}
		}
		// R~bg
		commit();
		// Αӈꗗ֑J
		setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
	}
	
	/**
	 * \̔f
	 * @throws Exception	Oꍇ
	 */
	private void reflect() throws Exception {
		AttendanceHolidayCardVo vo = (AttendanceHolidayCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		String kCode = vo.getHidKCode();
		String strTargetDate = vo.getHidDate();
		MScheduleDto dto = part().kintai().getScheduleInfo(kCode, strTargetDate);
		if (VariousUtil.isNull(dto)) {
			dto = kintai().createScheduleInfo(getBasisInfo(kCode), DateUtil.convStringDateToDate(strTargetDate),
					CommonConst.ATTENDANCE_TYPE_HOLIDAY);
			dto.setKKRiyuu(vo.getPltHolidayReason());
		}
		// xɐ\ƃ}[W
		margeHolidayRequest(dto);
		// VOɏݒ
		vo.setFields(KintaiCommonPart.copyToSyukkinbo(dto));
	}
	
}
