/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.List;

import jp.mosp.common.part.BasePart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.schedule.dao.CmRotationDao;
import jp.mosp.kintai.schedule.dto.CmRotationDto;

/**
 * Ζp^[pPartNX
 * @author yoshida
 *	@version	0.0.3
 */
public class RotationPart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public RotationPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public RotationPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private CmRotationDao	rotationDao;
	

	/**
	 * CM_ROTATIONe[upDAO擾
	 * @return	ςCmRotationDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public CmRotationDao getCmRotationDao() throws Exception {
		if (VariousUtil.isNull(rotationDao)) {
			rotationDao = (CmRotationDao)getPreparedDao(CmRotationDao.class.getCanonicalName());
		}
		return rotationDao;
	}
	
	/**
	 * Ζp^[z擾
	 * @param kCode			ΏێЈR[h
	 * @param rotationCode	Ώۗ֔ԃp^[R[h
	 * @return	Ζp^[z
	 * @throws Exception	Oꍇ
	 */
	public String[] getRotationInfoArray(String kCode, String rotationCode) throws Exception {
		CmRotationDto dto = findForKey(kCode, rotationCode);
		String[] aryRotaiton = new String[10];
		if (VariousUtil.chkExistDto(dto)) {
			aryRotaiton[0] = dto.getDay1();
			aryRotaiton[1] = dto.getDay2();
			aryRotaiton[2] = dto.getDay3();
			aryRotaiton[3] = dto.getDay4();
			aryRotaiton[4] = dto.getDay5();
			aryRotaiton[5] = dto.getDay6();
			aryRotaiton[6] = dto.getDay7();
			aryRotaiton[7] = dto.getDay8();
			aryRotaiton[8] = dto.getDay9();
			aryRotaiton[9] = dto.getDay10();
		} else {
			aryRotaiton = new String[0];
		}
		return aryRotaiton;
	}
	
	/**
	 * jՓtO擾
	 * @param rotationCode	Ώۗ֔ԃp^[R[h
	 * @return 0cfalseA1ctrue
	 * @throws Exception	Oꍇ
	 */
	public boolean getPublicHolidayFlag(String rotationCode) throws Exception {
		CmRotationDto dto = findForKey(user.getKCode(), rotationCode);
		if (VariousUtil.chkExistDto(dto) && dto.getHolidayFlag() != 0) {
			return true;
		}
		return false;
	}
	
	/**
	 * ֔ԃp^[擾
	 * @since	0.0.2
	 * @param kCode			ΏێЈR[h
	 * @param rotationCode	Ώۗ֔ԃp^[R[h
	 * @return	֔ԃp^[
	 * @throws Exception	Oꍇ
	 */
	public CmRotationDto findForKey(String kCode, String rotationCode) throws Exception {
		return getCmRotationDao().findForKey(kCode, rotationCode);
	}
	
	/**
	 * ֔ԃp^[z擾
	 * @since	0.0.3
	 * @param kCode		ΏێЈR[h
	 * @return	֔ԃp^[z
	 * @throws Exception	Oꍇ
	 */
	public String[][] getRotationArray(String kCode) throws Exception {
		List<CmRotationDto> listRotation = getCmRotationDao().findForCondition(kCode);
		String[][] aryRotation = new String[listRotation.size()][2];
		for (int i = 0; i < aryRotation.length; i++) {
			aryRotation[i][0] = listRotation.get(i).getRtCode();
			aryRotation[i][1] = listRotation.get(i).getRtName();
		}
		return aryRotation;
	}
	
}
