/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

/**
 * ΑӍڌvZ@
 * @author yoshida
 *	@version	0.0.4
 */
public class KintaiCalcPart {
	
	/**
	 * 1Ԃ̕
	 */
	private static final int	NUM_1HOUR_MIN		= 60;
	/**
	 * J@iĺjO\l̘JԂZԂ̏ꍇ
	 */
	private static final int	NUM_OVER_6HOUR		= 6;
	/**
	 * J@iĺjO\l̘JԂԂ̏ꍇ
	 */
	private static final int	NUM_OVER_8HOUR		= 8;
	/**
	 * KoΎ
	 */
	protected int				regStartTime		= 0;
	/**
	 * KދΎ
	 */
	protected int				regQuitTime			= 0;
	/**
	 * KΖ
	 */
	protected int				regWorkTime			= 0;
	/**
	 * Kxe
	 */
	protected int				regBreakTime		= 0;
	/**
	 * cƊJnOxe
	 * @since	0.0.3
	 */
	protected int				beforeOverTime		= 0;
	/**
	 * cƋxeԎxΏےPʎ
	 * @since	0.0.3
	 */
	protected int				overTimeUnit		= 0;
	/**
	 * cƋxe
	 * @since	0.0.3
	 */
	protected int				overTimeInterval	= 0;
	/**
	 * x
	 */
	protected int				lateTime			= 0;
	/**
	 * Ζ
	 */
	protected int				workTime			= 0;
	/**
	 * ގ
	 */
	protected int				leaveTime			= 0;
	/**
	 * cƎ
	 */
	protected int				overTime			= 0;
	/**
	 * xe
	 */
	protected int				intervalTime		= 0;
	/**
	 * [鎞
	 */
	protected int				lateNightTime		= 0;
	/**
	 * xo
	 */
	protected int				holidayWorkTime		= 0;
	/**
	 * @cƎ
	 */
	protected int				innerOverTime		= 0;
	/**
	 * [鎞ԊJn
	 */
	protected int				lateNightStart		= 0;
	/**
	 * [鎞ԏI
	 */
	protected int				lateNightEnd		= 0;
	/**
	 * x
	 */
	protected int				halfHoliday			= 0;
	/**
	 * ͒Pʁij
	 */
	protected int				inputUnit			= 1;
	/**
	 * @J
	 * @since	0.0.2
	 */
	protected int				legalHours			= 0;
	/**
	 * ۂߌoΎ
	 */
	protected int				roundStart			= 0;
	/**
	 * ۂߌދΎ
	 */
	protected int				roundQuit			= 0;
	/**
	 * ۂߏf
	 * @since 0.0.4
	 */
	protected boolean			useRoundNumber		= true;
	

	/**
	 * RXgN^
	 * <p>
	 * {@link KintaiCalcPart#setWorkTypeInfo(int, int, int, int)}A
	 * {@link KintaiCalcPart#setLateNightInfo(int, int)}A
	 * {@link KintaiCalcPart#setHalfHoliday(int)}A
	 * {@link KintaiCalcPart#setLegalHours(int)}A
	 * {@link KintaiCalcPart#setInputUnit(int)}A
	 * {@link KintaiCalcPart#setOverTimeIntervalInfo(int, int, int)}
	 * KsĂB
	 * </p>
	 */
	public KintaiCalcPart() {
		
	}
	
	/**
	 * RXgN^
	 * @param regStartTime		KoΎ
	 * @param regQuitTime		KދΎ
	 * @param regWorkTime		KΖ
	 * @param regBreakTime		Kxe
	 * @param lateNightStart	[鎞ԊJniji48Ԑj
	 * @param lateNightEnd		[鎞ԏIiji48Ԑj
	 * @param halfHoliday		xԁij	
	 * @param legalHours		@Jԁij	
	 * @param inputUnit			Pʎԁij
	 * @param beforeOverTime	cƊJnOxe
	 * @param overTimeUnit		cƋxeԎxΏےPʎ
	 * @param overTimeInterval	cƋxe
	 */
	@Deprecated
	public KintaiCalcPart(int regStartTime, int regQuitTime, int regWorkTime, int regBreakTime, int lateNightStart,
			int lateNightEnd, int halfHoliday, int legalHours, int inputUnit, int beforeOverTime, int overTimeUnit,
			int overTimeInterval) {
		// e퍀ڐݒ
		setParams(regStartTime, regQuitTime, regWorkTime, regBreakTime, lateNightStart, lateNightEnd, halfHoliday,
				legalHours, inputUnit, beforeOverTime, overTimeUnit, overTimeInterval);
	}
	
	/**
	 * e퍀ڐݒ
	 * @param regStartTime		KoΎ
	 * @param regQuitTime		KދΎ
	 * @param regWorkTime		KΖ
	 * @param regBreakTime		Kxe
	 * @param lateNightStart	[鎞ԊJniji48Ԑj
	 * @param lateNightEnd		[鎞ԏIiji48Ԑj
	 * @param halfHoliday		xԁij	
	 * @param legalHours		@Jԁij	
	 * @param inputUnit			Pʎԁij
	 * @param beforeOverTime	cƊJnOxe
	 * @param overTimeUnit		cƋxeԎxΏےPʎ
	 * @param overTimeInterval	cƋxe
	 */
	@Deprecated
	public void setParams(int regStartTime, int regQuitTime, int regWorkTime, int regBreakTime, int lateNightStart,
			int lateNightEnd, int halfHoliday, int legalHours, int inputUnit, int beforeOverTime, int overTimeUnit,
			int overTimeInterval) {
		// eK莞Ԑݒ
		setWorkTypeInfo(regStartTime, regQuitTime, regWorkTime, regBreakTime);
		// Ԑݒ
		setHours(lateNightStart, lateNightEnd, halfHoliday, legalHours, inputUnit, beforeOverTime, overTimeUnit,
				overTimeInterval);
	}
	
	/**
	 * Ԑݒ
	 * @param lateNightStart	[鎞ԊJniji48Ԑj
	 * @param lateNightEnd		[鎞ԏIiji48Ԑj
	 * @param halfHoliday		xԁij
	 * @param legalHours		@Jԁij
	 * @param inputUnit			Pʎԁij
	 * @param beforeOverTime	cƊJnOxe
	 * @param overTimeUnit		cƋxeԎxΏےPʎ
	 * @param overTimeInterval	cƋxe
	 */
	@Deprecated
	public void setHours(int lateNightStart, int lateNightEnd, int halfHoliday, int legalHours, int inputUnit,
			int beforeOverTime, int overTimeUnit, int overTimeInterval) {
		// [鎞Ԑݒ
		setLateNightInfo(lateNightStart, lateNightEnd);
		// x
		setHalfHoliday(halfHoliday);
		// @J
		setLegalHours(legalHours);
		// ͒Pʁij
		setInputUnit(inputUnit);
		// cƋxeݒ
		setOverTimeIntervalInfo(beforeOverTime, overTimeUnit, overTimeInterval);
	}
	
	/**
	 * [鎞Ԑݒ
	 * @param lateNightStart	[鎞ԊJniji48Ԑj
	 * @param lateNightEnd		[鎞ԏIiji48Ԑj
	 */
	public void setLateNightInfo(int lateNightStart, int lateNightEnd) {
		this.lateNightStart = lateNightStart;
		this.lateNightEnd = lateNightEnd;
	}
	
	/**
	 * cƋxeݒ
	 * @since	0.0.3
	 * @param beforeOverTime	cƊJnOxe
	 * @param overTimeUnit		cƋxeԎxΏےPʎ
	 * @param overTimeInterval	cƋxe
	 */
	public void setOverTimeIntervalInfo(int beforeOverTime, int overTimeUnit, int overTimeInterval) {
		this.beforeOverTime = beforeOverTime;
		this.overTimeUnit = overTimeUnit;
		this.overTimeInterval = overTimeInterval;
	}
	
	/**
	 * eK莞Ԑݒ
	 * @param regStartTime		KoΎ
	 * @param regQuitTime		KދΎ
	 * @param regWorkTime		KΖ
	 * @param regBreakTime		Kxe
	 */
	public void setWorkTypeInfo(int regStartTime, int regQuitTime, int regWorkTime, int regBreakTime) {
		this.regStartTime = regStartTime;
		this.regQuitTime = regQuitTime;
		this.regWorkTime = regWorkTime;
		this.regBreakTime = regBreakTime;
	}
	
	/**
	 * 
	 */
	public void clearAll() {
		regStartTime = 0;
		regQuitTime = 0;
		regWorkTime = 0;
		regBreakTime = 0;
		beforeOverTime = 0;
		overTimeUnit = 0;
		overTimeInterval = 0;
		lateTime = 0;
		workTime = 0;
		leaveTime = 0;
		overTime = 0;
		intervalTime = 0;
		lateNightTime = 0;
		holidayWorkTime = 0;
		innerOverTime = 0;
		lateNightStart = 0;
		lateNightEnd = 0;
		halfHoliday = 0;
		inputUnit = 1;
		legalHours = 0;
		roundStart = 0;
		roundQuit = 0;
	}
	
	/**
	 * 
	 */
	public void clearValue() {
		workTime = 0;
		intervalTime = 0;
		lateTime = 0;
		leaveTime = 0;
		overTime = 0;
		lateNightTime = 0;
		holidayWorkTime = 0;
		innerOverTime = 0;
	}
	
	/**
	 * ΑӌvZ
	 * @param inputStart		oΎ
	 * @param inputQuit			ދΎ
	 * @param isStartHalf		oΔx敪
	 * @param isQuitHalf		ދΔx敪
	 * @param isWorkOnHoliday	xof
	 */
	public void runCalculate(int inputStart, int inputQuit, boolean isStartHalf, boolean isQuitHalf,
			boolean isWorkOnHoliday) {
		// o΋敪ԌvZ
		runCalcStartTime(inputStart, isStartHalf, isWorkOnHoliday);
		// ދ΋敪ԌvZ
		runCalcQuitTime(inputStart, inputQuit, isStartHalf || isQuitHalf, isWorkOnHoliday);
	}
	
	/**
	 * o΋敪ԌvZ
	 * @param inputStart		oΎ
	 * @param isStartHalf		oΔx敪
	 * @param isWorkOnHoliday	xof
	 */
	public void runCalcStartTime(int inputStart, boolean isStartHalf, boolean isWorkOnHoliday) {
		// x
		lateTime = 0;
		if (!isStartHalf && !isWorkOnHoliday) {
			// x = oΎ - WoΎ
			lateTime = inputStart - regStartTime;
			// ۂߏ
			if (lateTime > 0 && useRoundNumber) {
				if (lateTime % inputUnit > 0) {
					// xԂPʎԂŊ]肪0傫ꍇ͒xԂɒPʎԂ𑫂
					lateTime += inputUnit;
				}
				lateTime -= lateTime % inputUnit;
			}
			if (lateTime < 0) {
				lateTime = 0;
			}
		}
	}
	
	/**
	 * ދ΋敪ԌvZ
	 * @param inputStart		oΎ
	 * @param inputQuit			ދΎ
	 * @param isHalf			x敪
	 * @param isWorkOnHoliday	xof
	 */
	public void runCalcQuitTime(int inputStart, int inputQuit, boolean isHalf, boolean isWorkOnHoliday) {
		int quit = inputQuit;
		// ދΎ0ɂȂ邱Ƃ͖
		if (inputQuit == 0) {
			quit = regQuitTime;
		}
		// ΖԌvZ
		calcWorkTimes(inputStart, quit);
		// ގԌvZ
		calcLeaveEarlyTimes(quit, isHalf);
		// xeԌvZ
		calcIntervalTimes();
		// [鎞ԌvZ
		calcLateNightTimes(inputStart, quit);
		// cƎԌvZi@cƁAcƋxeԁj
		calcOverTimes(isHalf);
		// xoԌvZ
		calcHolidayWork(isWorkOnHoliday);
	}
	
	/**
	 * ΖԌvZ
	 * @param inputStart		oΎ
	 * @param inputQuit			ދΎ
	 */
	private void calcWorkTimes(int inputStart, int inputQuit) {
		// PʎԖ̏oΎ
		int remainderStart = 0;
		// ۂߏf
		if (useRoundNumber) {
			remainderStart = inputStart % inputUnit;
		}
		// ۂ߂oΎ
		roundStart = inputStart - remainderStart;
		if (remainderStart > 0) {
			// PʎԖ̏oΎԂ0傫ꍇ͊ۂ߂oΎɒPʎԂ𑫂
			roundStart += inputUnit;
		}
		// PʎԖ̑ދΎ
		int remainderQuit = 0;
		// ۂߏf
		if (useRoundNumber) {
			remainderQuit = inputQuit % inputUnit;
		}
		// ۂ߂ދΎ
		roundQuit = inputQuit - remainderQuit;
		// Ζ = ދΎ - oΎ
		workTime = roundQuit - roundStart;
		// ΖԂ}CiX̏ꍇA0Ƃ
		if (workTime < 0) {
			workTime = 0;
		}
	}
	
	/**
	 * ގԌvZ
	 * @param inputQuit		ދΎ
	 * @param isHalf		x敪
	 */
	private void calcLeaveEarlyTimes(int inputQuit, boolean isHalf) {
		leaveTime = 0;
		if (!isHalf) {
			// ގ = WގЎ - ގЎ
			leaveTime = regQuitTime - inputQuit;
			// ۂߏf
			if (leaveTime > 0 && useRoundNumber) {
				if (leaveTime % inputUnit > 0) {
					// ގԂPʎԂŊ]肪0傫ꍇ͑ގԂɒPʎԂ𑫂
					leaveTime += inputUnit;
					// ۂ
					leaveTime -= leaveTime % inputUnit;
				}
			}
			if (leaveTime < 0) {
				leaveTime = 0;
			}
		}
	}
	
	/**
	 * xeԌvZ
	 */
	private void calcIntervalTimes() {
		// xe
		intervalTime = 0;
		// 6Ԉȏ̏ꍇAKxe
		if (workTime >= NUM_1HOUR_MIN * NUM_OVER_6HOUR) {
			intervalTime = regBreakTime;
		}
		// 8Ԉȏ̏ꍇA60
		if (workTime >= NUM_1HOUR_MIN * NUM_OVER_8HOUR) {
			intervalTime = NUM_1HOUR_MIN;
		}
	}
	
	/**
	 * [鎞ԌvZ
	 * @param inputStart	oΎ
	 * @param inputQuit		ދΎ
	 */
	private void calcLateNightTimes(int inputStart, int inputQuit) {
		// [鎞
		lateNightTime = 0;
		// oΎ[鎞JnԈȏ̏ꍇ
		if (inputStart >= lateNightStart) {
			// ދΎ - oΎ
			lateNightTime = inputQuit - inputStart;
		} else {
			// ދΎ - [鎞ԊJn
			lateNightTime = inputQuit - lateNightStart;
		}
		// ۂߏf
		if (lateNightTime > 0 && useRoundNumber) {
			// ۂ
			lateNightTime -= lateNightTime % inputUnit;
		}
		// x
		// [鎞ԊJnoΎȏ̏ꍇ
		if (inputStart >= lateNightStart) {
			// [鎞ԌvZ[鎞ԊJn - oΎ傫ꍇ
			if (lateNightTime > (lateNightEnd - inputStart)) {
				lateNightTime = lateNightEnd - inputStart;
			}
		} else {
			// [鎞ԌvZ[鎞ԊJn - [鎞ԏI傫ꍇ
			if (lateNightTime > (lateNightEnd - lateNightStart)) {
				lateNightTime = lateNightEnd - lateNightStart;
			}
		}
		// [鎞Ԃ}CiX̏ꍇA0Ƃ
		if (lateNightTime < 0) {
			lateNightTime = 0;
		}
	}
	
	/**
	 * cƎԌvZ
	 * @param isHalf		x敪
	 */
	private void calcOverTimes(boolean isHalf) {
		// x + Ζ
		int totalWorkTime = lateTime + workTime;
		// cƎ
		overTime = 0;
		// x
		if (isHalf) {
			totalWorkTime -= halfHoliday;
		}
		// @cƎ
		innerOverTime = 0;
		// ΖΏێ > WΖ
		if (totalWorkTime >= regWorkTime) {
			// cƎ = ΖΏێ - WΖ
			overTime = totalWorkTime - regWorkTime;
			// K
			int regActualTime = regWorkTime - intervalTime;
			// KԂ@JԈȉ̏ꍇ
			if (regActualTime < legalHours) {
				// @cƎ
				innerOverTime = totalWorkTime - regWorkTime;
			}
			// @JԂ𒴂ꍇ
			if (totalWorkTime > legalHours + NUM_1HOUR_MIN) {
				// @cƎ
				innerOverTime = legalHours - regActualTime;
				// cƋxe
				int overInterval = 0;
				// [鎞ԋxe
				int lateNightInterval = 0;
				// cƊJn
				int overTimeStart = regStartTime + legalHours + NUM_1HOUR_MIN;
				// cƊJnOxe
				if (beforeOverTime > 0) {
					overInterval += beforeOverTime;
					overTime -= beforeOverTime;
					overTimeStart += beforeOverTime;
				}
				// PʎԂƂ̎cƋxe
				if (overTimeUnit > 0) {
					int intervalCount = overTime / overTimeUnit;
					if (intervalCount > 0) {
						int overTimeLap = overTimeStart;
						for (int i = 0; i < intervalCount; i++) {
							overTimeLap += overTimeUnit;
							// [鎞Ԃɂꍇ
							if (overTimeLap >= lateNightStart && overTimeLap <= lateNightEnd) {
								lateNightInterval += overTimeInterval;
							}
						}
						int totalInterval = intervalCount * overTimeInterval;
						overInterval += totalInterval;
						overTime -= totalInterval;
					}
				}
				if (lateNightTime > 0) {
					lateNightTime -= lateNightInterval;
				}
				// xeԂɎcƋxeԂǉB
				intervalTime += overInterval;
			}
		}
		if (innerOverTime > 0) {
			overTime -= innerOverTime;
		}
		if (overTime < 0) {
			overTime = 0;
		}
		if (innerOverTime < 0) {
			innerOverTime = 0;
		}
		if (lateNightTime < 0) {
			lateNightTime = 0;
		}
	}
	
	/**
	 * xoԌvZ
	 * @param isWorkOnHoliday	xof
	 */
	private void calcHolidayWork(boolean isWorkOnHoliday) {
		holidayWorkTime = 0;
		if (isWorkOnHoliday) {
			holidayWorkTime = workTime - intervalTime;
		}
	}
	
	/**
	 * Ζ
	 * @return	ΖԌvZl
	 */
	public int getWorkTime() {
		return workTime;
	}
	
	/**
	 * xe
	 * @return	xeԌvZl
	 */
	public int getIntervalTime() {
		return intervalTime;
	}
	
	/**
	 * x
	 * @return	xԌvZl
	 */
	public int getLateTime() {
		return lateTime;
	}
	
	/**
	 * ގ
	 * @return	ގԌvZl
	 */
	public int getLeaveTime() {
		return leaveTime;
	}
	
	/**
	 * cƎ
	 * @return	cƎԌvZl
	 */
	public int getOverTime() {
		return overTime;
	}
	
	/**
	 * [鎞
	 * @return	[鎞ԌvZl
	 */
	public int getLateNightTime() {
		return lateNightTime;
	}
	
	/**
	 * xo
	 * @return	xoԌvZl
	 */
	public int getHolidayWorkTime() {
		return holidayWorkTime;
	}
	
	/**
	 * ԓcƎ
	 * @return	ԓcƎԌvZl
	 */
	public int getInnerOverTime() {
		return innerOverTime;
	}
	
	/**
	 * ۂߏf
	 * @param useRoundNumber Zbg useRoundNumber
	 */
	public void setUseRoundNumber(boolean useRoundNumber) {
		this.useRoundNumber = useRoundNumber;
	}
	
	/**
	 * @param halfHoliday Zbg halfHoliday
	 */
	public void setHalfHoliday(int halfHoliday) {
		this.halfHoliday = halfHoliday;
	}
	
	/**
	 * @param legalHours Zbg legalHours
	 */
	public void setLegalHours(int legalHours) {
		this.legalHours = legalHours;
	}
	
	/**
	 * @param inputUnit Zbg inputUnit
	 */
	public void setInputUnit(int inputUnit) {
		if (inputUnit > 1) {
			this.inputUnit = inputUnit;
		}
	}
	
}
