/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.workflow.dao.AmRouteDao;
import jp.mosp.kintai.workflow.dao.AmUnitDao;
import jp.mosp.kintai.workflow.dto.AmUnitDto;

/**
 * FpPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class ApprovalPart extends KintaiBasePart {
	
	/**
	 * RXgN^
	 */
	public ApprovalPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	public ApprovalPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private AmUnitDao	amUnitDao;
	

	/**
	 * Fpjbge[upDAO擾
	 * @return	ςAmUnitDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public AmUnitDao getAmUnitDao() throws Exception {
		if (VariousUtil.isNull(amUnitDao)) {
			amUnitDao = (AmUnitDao)getPreparedDao(AmUnitDao.class.getCanonicalName());
		}
		return amUnitDao;
	}
	

	/**
	 * AmRouteDaoCX^X
	 */
	private AmRouteDao	amRouteDao;
	

	/**
	 * Fp[ge[upDAO擾
	 * @return	ςAmRouteDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public AmRouteDao getAmRouteDao() throws Exception {
		if (VariousUtil.isNull(amRouteDao)) {
			amRouteDao = (AmRouteDao)getPreparedDao(AmRouteDao.class.getCanonicalName());
		}
		return amRouteDao;
	}
	
	/**
	 * 󏳔FjbgR[hꗗiAM_UNITj
	 * @return@̏FjbgR[hXg
	 * @throws Exception Oꍇ
	 */
	public String[][] getCurrentUnitArray() throws Exception {
		String targetDate = DateUtil.convDateFormattedByHyphen(DateUtil.getSystemDate());
		// ̎擾
		List<AmUnitDto> listUnit = getAmUnitDao().findForCurrentUnitArray(targetDate);
		// z̍쐬		
		String[][] aryUnit = new String[listUnit.size()][2];
		for (int i = 0; i < aryUnit.length; i++) {
			aryUnit[i][0] = listUnit.get(i).getUnitCode();
			StringBuffer sb = new StringBuffer();
			sb.append(part().human().getKName(listUnit.get(i).getMain()));
			sb.append(CommonConst.STR_SLASH_SEPARATOR);
			sb.append(part().human().getKName(listUnit.get(i).getAgent()));
			aryUnit[i][1] = sb.toString();
		}
		return aryUnit;
	}
	
	/**
	 * Ώ۔NFjbg擾
	 * @since	0.0.2
	 * @param unitCode		ΏۃjbgR[h
	 * @param kCode			ΏێЈR[h
	 * @param startDate		ΏۊJnN
	 * @return	Ώ۔NFjbgDTO
	 * @throws Exception Oꍇ
	 */
	public AmUnitDto getCurrentUnit(String unitCode, String kCode, String startDate) throws Exception {
		return getAmUnitDao().findForCurrentUnit(unitCode, kCode, startDate);
	}
	
	/**
	 * Ώ۔NΏۃjbgR[hFҔf
	 * @since	0.0.2
	 * @param unitcode		ΏۃjbgR[h
	 * @param approver		ΏۏFҎЈR[h
	 * @param targetDate	Ώ۔N
	 * @return
	 * <p>
	 * Ώ۔NFjbgDTOꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isApprover(String unitcode, String approver, Date targetDate) throws Exception {
		return VariousUtil.chkExistDto(getCurrentUnit(unitcode, approver, DateUtil
			.convDateFormattedByHyphen(targetDate)));
	}
	
}
