/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * e[ubN[eBeB
 * @author yoshida
 *	@version	0.0.1
 */
public class TableLockUtil {
	
	private static final String	FLD_TABLE	= "TABLE";
	
	private LockTableDao		tableLock;
	private List<String>		tableList;
	

	/**
	 * RXgN^
	 */
	public TableLockUtil() {
		
	}
	
	/**
	 * RXgN^()
	 * @param cfg	MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 * @param cmd	NGXgꂽCommandB
	 * @param aspUser	OCASP[U[B
	 * @param user	OC[U[B
	 * @param conn 	DBRlNVB
	 */
	public TableLockUtil(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		init(cfg, cmd, aspUser, user, conn);
		setTableList(getTableInitList());
	}
	
	/**
	 * 
	 * @param cfg	MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 * @param cmd	NGXgꂽCommandB
	 * @param aspUser	OCASP[U[B
	 * @param user	OC[U[B
	 * @param conn 	DBRlNVB
	 */
	public void init(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		tableLock = new LockTableDao();
		tableLock.initDao(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * e[ubN(WRITE)
	 * @throws MospException MosPOꍇ
	 * @throws SQLException SQLOꍇ
	 */
	public void lockTables() throws SQLException, MospException {
		tableLock.lockTables(tableList);
	}
	
	/**
	 * e[ubN
	 * @param tableList		Ώۃe[uꗗ
	 * @throws MospException MosPOꍇ
	 * @throws SQLException SQLOꍇ
	 */
	public void lockTables(List<String> tableList) throws SQLException, MospException {
		setTableList(tableList);
		lockTables();
	}
	
	/**
	 * e[ubN
	 * @throws MospException MosPOꍇ
	 * @throws SQLException SQLOꍇ
	 */
	public void unLockTables() throws SQLException, MospException {
		tableLock.unLockTables();
	}
	
	/**
	 * Ώۃe[uꗗ
	 * @return	e[uꗗXg
	 */
	public List<String> getTableInitList() {
		return new ArrayList<String>();
	}
	
	/**
	 * Ώۃe[uꗗݒ
	 * @param tableList Ώۃe[uꗗ
	 */
	public void setTableList(List<String> tableList) {
		this.tableList = tableList;
	}
	
	/**
	 * Ώۃe[uDaoǉ
	 * @param dao	ΏDAO
	 * @param isWrite 	݃bNtO
	 */
	public void addTargetTable(BaseDao dao, boolean isWrite) {
		if (VariousUtil.isNull(tableList)) {
			tableList = getTableInitList();
		}
		StringBuffer sb = new StringBuffer();
		sb.append(getTableName(dao));
		sb.append(CommonConst.STR_UNDER_SEPARATOR);
		sb.append(isWrite);
		tableList.add(sb.toString());
	}
	
	/**
	 * Ώۃe[uDaoǉ
	 * @param tableName 	Ώۃe[u
	 * @param isWrite 		݃bNtO
	 */
	public void addTargetTable(String tableName, boolean isWrite) {
		if (VariousUtil.isNull(tableList)) {
			tableList = getTableInitList();
		}
		StringBuffer sb = new StringBuffer();
		sb.append(tableName);
		sb.append(CommonConst.STR_UNDER_SEPARATOR);
		sb.append(isWrite);
		tableList.add(sb.toString());
	}
	
	/**
	 * Ώۃe[u擾
	 * @param dao		ΏDAO
	 * @return	Ώۃe[u
	 */
	public String getTableName(BaseDao dao) {
		return getTableName(dao, FLD_TABLE);
	}
	
	/**
	 * Ώۃe[u擾
	 * @param dao		ΏDAO
	 * @param fieldName		e[utB[hiTABLEj
	 * @return	Ώۃe[u
	 */
	public String getTableName(BaseDao dao, String fieldName) {
		String tableName = "";
		try {
			tableName = String.valueOf(dao.getClass().getField(fieldName).get(null));
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		}
		return tableName;
	}
	

	/**
	 * e[ubNpDAO
	 * @author yoshida
	 * @version 0.0.2
	 */
	private static class LockTableDao extends BaseDao {
		
		/**
		 * RXgN^
		 */
		public LockTableDao() {
			super();
		}
		
		/**
		 * e[ubN
		 * @param tableList			Ώۃe[uꗗ
		 * @throws SQLException SQLOꍇ
		 * @throws MospException  MosPOꍇ
		 */
		public void lockTables(List<String> tableList) throws SQLException, MospException {
			try {
				prepareStatement(getLockTableSQL(tableList));
				executeUpdate();
			} catch (SQLException e) {
				throw e;
			} finally {
				releaseResultSet();
				releasePreparedStatement();
			}
		}
		
		/**
		 * e[ubN
		 * @throws SQLException SQLOꍇ
		 * @throws MospException  MosPOꍇ
		 */
		public void unLockTables() throws SQLException, MospException {
			if (getRdbmsType() == 1) {
				try {
					prepareStatement("UNLOCK TABLES ");
					executeUpdate();
				} catch (SQLException e) {
					throw e;
				} finally {
					releaseResultSet();
					releasePreparedStatement();
				}
			}
		}
		
		/**
		 * e[ubNpSQL
		 * @param tableList		Ώۃe[uꗗ
		 * @return	e[ubNpSQL
		 * @throws MospException MosPOꍇ
		 */
		private String getLockTableSQL(List<String> tableList) throws MospException {
			StringBuffer sb = new StringBuffer();
			switch (getRdbmsType()) {
				case 1:
					// MySQL̏ꍇ
					sb.append("LOCK TABLES ");
					for (String table : tableList) {
						String[] code = table.split(CommonConst.STR_UNDER_SEPARATOR);
						sb.append(code[0]);
						if (Boolean.parseBoolean(code[1])) {
							sb.append(" WRITE ");
						} else {
							sb.append(" READ ");
						}
						sb.append(CommonConst.STR_UNDER_SEPARATOR);
					}
					sb.delete(sb.lastIndexOf(CommonConst.STR_UNDER_SEPARATOR), sb.length());
					break;
				case 2:
					// PostgreSQL̏ꍇ
					sb.append("LOCK TABLE ");
					for (String table : tableList) {
						String[] code = table.split(CommonConst.STR_UNDER_SEPARATOR);
						if (Boolean.parseBoolean(code[1])) {
							sb.append(code[0]);
							sb.append(CommonConst.STR_UNDER_SEPARATOR);
						}
					}
					sb.delete(sb.lastIndexOf(CommonConst.STR_UNDER_SEPARATOR), sb.length());
					break;
				default:
					break;
			}
			return sb.toString();
		}
		
	}
	
}
