/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.util.JDOMUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOXML {
    private static final Map instances = LazyMap.decorate(new HashMap(), new Transformer(){

        public Object transform(Object object) {
            return new OOXML((String)object);
        }
    });
    private final String version;

    public static OOXML get(String string) {
        return (OOXML)instances.get(string);
    }

    public static final String getTabS() {
        return "<text:tab-stop/>";
    }

    public static final String getLineBreakS() {
        return "<text:line-break/>";
    }

    private static final String rt2oo(String string, String string2, String string3) {
        return string.replaceAll("\\[" + string2 + "\\]", "<text:span text:style-name=\"" + string3 + "\">").replaceAll("\\[/" + string2 + "\\]", "</text:span>");
    }

    public static final String encodeOOWS(String string) {
        String string2 = JDOMUtils.OUTPUTTER.escapeElementEntities(string).replaceAll("\n", OOXML.getLineBreakS()).replaceAll("\t", OOXML.getTabS());
        String string3 = "";
        Pattern pattern = Pattern.compile("  +");
        Matcher matcher = pattern.matcher(string2);
        int n = 0;
        while (matcher.find()) {
            string3 = string3 + string2.substring(n, matcher.start()) + "<text:s text:c=\"" + matcher.group().length() + "\"/>";
            n = matcher.end();
        }
        string3 = string3 + string2.substring(n);
        return string3;
    }

    private OOXML(String string) {
        this.version = string;
    }

    public final String getVersion() {
        return this.version;
    }

    private NS getNS() {
        return NS.get(this.getVersion());
    }

    public final String isValid(Document document) {
        if (this.getVersion().equals("OpenDocument")) {
            try {
                return JDOMUtils.isValid(document, "http://relaxng.org/ns/structure/1.0", this.getClass().getResource("oofficeDTDs/OpenDocument-strict-schema-v1.1.rng"));
            }
            catch (SAXException sAXException) {
                throw new IllegalStateException("relaxNG schemas pb", sAXException);
            }
        }
        for (Namespace namespace : this.getNS().getALL()) {
            document.getRootElement().addNamespaceDeclaration(namespace);
        }
        return JDOMUtils.isValidDTD(document, OOUtils.getBuilderLoadDTD());
    }

    public final Element getLineBreak() {
        return new Element("line-break", this.getNS().getTEXT());
    }

    public final Element getTab() {
        return new Element("tab-stop", this.getNS().getTEXT());
    }

    protected final List encodeRT_L(String string, Map map) {
        String string2 = JDOMUtils.OUTPUTTER.escapeElementEntities(string);
        for (Map.Entry entry : map.entrySet()) {
            string2 = OOXML.rt2oo(string2, (String)entry.getKey(), (String)entry.getValue());
        }
        try {
            return JDOMUtils.parseString(string2, this.getNS().getALL());
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException("could not parse " + string2, jDOMException);
        }
    }

    public final Element encodeRT(String string, Map map) {
        return new Element("span", this.getNS().getTEXT()).addContent(this.encodeRT_L(string, map));
    }

    private Element createSpaces(String string) {
        return new Element("s", this.getNS().getTEXT()).setAttribute("c", string.length() + "", this.getNS().getTEXT());
    }

    public final Element encodeWS(String string) {
        return new Element("span", this.getNS().getTEXT()).setContent(this.encodeWSasList(string));
    }

    private final List<Content> encodeWSasList(String string) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        Matcher matcher = Pattern.compile("\n|\t| {2,}").matcher(string);
        int n = 0;
        while (matcher.find()) {
            arrayList.add(new Text(string.substring(n, matcher.start())));
            switch (matcher.group().charAt(0)) {
                case '\n': {
                    arrayList.add(this.getLineBreak());
                    break;
                }
                case '\t': {
                    arrayList.add(this.getTab());
                    break;
                }
                case ' ': {
                    arrayList.add(this.createSpaces(matcher.group()));
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown item: " + matcher.group());
                }
            }
            n = matcher.end();
        }
        arrayList.add(new Text(string.substring(n)));
        return arrayList;
    }

    public final void encodeWS(Text text) {
        Parent parent = text.getParent();
        int n = parent.indexOf(text);
        text.detach();
        parent.getContent().addAll(n, this.encodeWSasList(text.getText()));
    }

    public final Element encodeWS(Element element) {
        XPath xPath;
        try {
            xPath = OOUtils.getXPath(".//text()", NS.getVersion(element));
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException("cannot create XPath", jDOMException);
        }
        try {
            for (Text text : new ArrayList(xPath.selectNodes(element))) {
                this.encodeWS(text);
            }
        }
        catch (JDOMException jDOMException) {
            throw new IllegalArgumentException("cannot find text nodes of " + element, jDOMException);
        }
        return element;
    }
}

