/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.vo;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.dto.PaymentListDto;
import jp.mosp.payroll.payment.action.PaymentListAction;

public class PaymentListVo extends PayrollVo {
	
	private static final long	serialVersionUID	= -6810707735163877932L;
	
	// tB[h
	private int					pltYear;
	private int					pltMonth;
	private String				txtKCode;
	private String				txtKKana;
	private String				pltOffice;
	private String				pltSection;
	private String				pltPosition;
	private String				lblTargetMonth;
	
	// tB[h(ꗗ)
	private String[]			aryKCode;
	private String[]			aryKName;
	private String[]			aryOffice;
	private String[]			arySection;
	private String[]			aryPosition;
	private String[]			aryPayTotal;
	
	// v_E
	private String[][]			pitYear;
	private String[][]			pitMonth;
	private String[][]			pitOffice;
	private String[][]			pitSection;
	private String[][]			pitPosition;
	
	/**
	 * p[^(^vZJnN)B
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	
	/**
	 * p[^(^vZJn)B
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	
	/**
	 * p[^(ЈR[h)B
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	
	/**
	 * p[^(ЈJi)B
	 */
	public static final String	PRM_TXT_K_KANA		= "txtKKana";
	
	/**
	 * p[^(Ə)B
	 */
	public static final String	PRM_PLT_OFFICE		= "pltOffice";
	
	/**
	 * p[^()B
	 */
	public static final String	PRM_PLT_SECTION		= "pltSection";
	
	/**
	 * p[^(E)B
	 */
	public static final String	PRM_PLT_POSITION	= "pltPosition";
	

	/**
	 * {@link PayrollVo#PayrollVo()}sB
	 */
	public PaymentListVo() {
		super();
		aryKCode = new String[0];
		aryKName = new String[0];
		aryOffice = new String[0];
		arySection = new String[0];
		aryPosition = new String[0];
		aryPayTotal = new String[0];
		setPageCommand(PaymentListAction.CMD_PAGE);
		setSortKey("1");
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_PAYROLL") + getName("C_DATA") + getName("C_LIST");
		addAryMenu("P1001", getName("P_PAYMENT") + getName("P_CALCULATE") + getName("C_MENU") + getName("C_TO"));
	}
	
	/**
	 * NGXgp[^擾Aݒ肷B
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltYear = getIntParam(request.getParameter(PRM_PLT_YEAR));
		pltMonth = getIntParam(request.getParameter(PRM_PLT_MONTH));
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKKana = request.getParameter(PRM_TXT_K_KANA);
		pltOffice = request.getParameter(PRM_PLT_OFFICE);
		pltSection = request.getParameter(PRM_PLT_SECTION);
		pltPosition = request.getParameter(PRM_PLT_POSITION);
	}
	
	/**
	 * tB[hݒ肷B<br>
	 * @param list DTOXg
	 */
	public void setFields(List<PaymentListDto> list) {
		// f[^̎擾
		count = list.size();
		// z̏
		aryKCode = new String[count];
		aryKName = new String[count];
		aryOffice = new String[count];
		arySection = new String[count];
		aryPosition = new String[count];
		aryPayTotal = new String[count];
		// f[^̐ݒ
		for (int i = 0; i < list.size(); i++) {
			PaymentListDto dto = list.get(i);
			aryKCode[i] = dto.getKCode();
			aryKName[i] = dto.getSimei();
			aryOffice[i] = dto.getOfficeName();
			arySection[i] = dto.getSectionName();
			aryPosition[i] = dto.getPositionName();
			aryPayTotal[i] = String.valueOf(dto.getPaymentTotal());
		}
	}
	
	/**
	 * ^vZJn擾B
	 * @return ^vZJn
	 */
	public int getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * ^vZJnݒ肷B
	 * @param pltMonth ݒ肷鋋^vZJn
	 */
	public void setPltMonth(int pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * ^vZJnN擾B
	 * @return ^vZJnN
	 */
	public int getPltYear() {
		return pltYear;
	}
	
	/**
	 * ^vZJnNݒ肷B
	 * @param pltYear ݒ肷鋋^vZJnN
	 */
	public void setPltYear(int pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getPitMonth() {
		return getAryField(pitMonth);
	}
	
	/**
	 * v_EACeݒ肷B
	 * @param pitMonth ݒ肷錎v_EACe
	 */
	public void setPitMonth(String[][] pitMonth) {
		this.pitMonth = getAryField(pitMonth);
	}
	
	/**
	 * Nv_EACe擾B
	 * @return Nv_EACe
	 */
	public String[][] getPitYear() {
		return getAryField(pitYear);
	}
	
	/**
	 * Nv_EACeݒ肷B
	 * @param pitYear ݒ肷Nv_EACe
	 */
	public void setPitYear(String[][] pitYear) {
		this.pitYear = getAryField(pitYear);
	}
	
	/**
	 * Əv_EACe擾B
	 * @return Əv_EACe
	 */
	public String[][] getPitOffice() {
		return getAryField(pitOffice);
	}
	
	/**
	 * Əv_EACeݒ肷B
	 * @param pitOffice ݒ肷鎖Əv_EACe
	 */
	public void setPitOffice(String[][] pitOffice) {
		this.pitOffice = getAryField(pitOffice);
	}
	
	/**
	 * Ev_EACe擾B
	 * @return Ev_EACe
	 */
	public String[][] getPitPosition() {
		return getAryField(pitPosition);
	}
	
	/**
	 * Ev_EACeݒ肷B
	 * @param pitPosition ݒ肷Ev_EACe
	 */
	public void setPitPosition(String[][] pitPosition) {
		this.pitPosition = getAryField(pitPosition);
	}
	
	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getPitSection() {
		return getAryField(pitSection);
	}
	
	/**
	 * v_EACeݒ肷B
	 * @param pitSection ݒ肷鏊v_EACe
	 */
	public void setPitSection(String[][] pitSection) {
		this.pitSection = getAryField(pitSection);
	}
	
	/**
	 * ƏR[h擾B
	 * @return ƏR[h
	 */
	public String getPltOffice() {
		return pltOffice;
	}
	
	/**
	 * ƏR[hݒ肷B
	 * @param pltOffice ݒ肷鎖ƏR[h
	 */
	public void setPltOffice(String pltOffice) {
		this.pltOffice = pltOffice;
	}
	
	/**
	 * ER[h擾B
	 * @return ER[h
	 */
	public String getPltPosition() {
		return pltPosition;
	}
	
	/**
	 * ER[hݒ肷B
	 * @param pltPosition ݒ肷ER[h
	 */
	public void setPltPosition(String pltPosition) {
		this.pltPosition = pltPosition;
	}
	
	/**
	 * R[h擾B
	 * @return R[h
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * R[hݒ肷B
	 * @param pltSection ݒ肷鏊R[h
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
	/**
	 * ЈR[h擾B
	 * @return ЈR[h
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * ЈR[h擾(GXP[v)B
	 * @return ЈR[h
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * ЈR[hݒ肷B
	 * @param txtKCode ݒ肷ЈR[h
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * ЈJi擾B
	 * @return ЈJi
	 */
	public String getTxtKKana() {
		return txtKKana;
	}
	
	/**
	 * ЈJi擾(GXP[v)B
	 * @return ЈJi
	 */
	public String getEscTxtKKana() {
		return escapeHTML(txtKKana);
	}
	
	/**
	 * ЈJiݒ肷B
	 * @param txtKKana ݒ肷ЈJi
	 */
	public void setTxtKKana(String txtKKana) {
		this.txtKKana = txtKKana;
	}
	
	/**
	 * Ώ۔N擾B
	 * @return Ώ۔N
	 */
	public String getLblTargetMonth() {
		return lblTargetMonth;
	}
	
	/**
	 * Ώ۔Nݒ肷B
	 * @param lblTargetMonth ݒ肷Ώ۔N
	 */
	public void setLblTargetMonth(String lblTargetMonth) {
		this.lblTargetMonth = lblTargetMonth;
	}
	
	/**
	 * ЈR[h(ꗗ)擾B
	 * @param idx CfbNX
	 * @return ЈR[h
	 */
	public String getAryKCode(int idx) {
		return escapeHTML(aryKCode[idx]);
	}
	
	/**
	 * Ј(ꗗ)擾B
	 * @param idx CfbNX
	 * @return Ј
	 */
	public String getAryKName(int idx) {
		return escapeHTML(aryKName[idx]);
	}
	
	/**
	 * Ə(ꗗ)擾B
	 * @param idx CfbNX
	 * @return Ə
	 */
	public String getAryOffice(int idx) {
		return escapeHTML(aryOffice[idx]);
	}
	
	/**
	 * E(ꗗ)擾B
	 * @param idx CfbNX
	 * @return E
	 */
	public String getAryPosition(int idx) {
		return escapeHTML(aryPosition[idx]);
	}
	
	/**
	 * (ꗗ)擾B
	 * @param idx CfbNX
	 * @return 
	 */
	public String getArySection(int idx) {
		return escapeHTML(arySection[idx]);
	}
	
	/**
	 * xz(ꗗ)擾B
	 * @param idx CfbNX
	 * @return xz
	 */
	public String getAryPayTotal(int idx) {
		return escapeHTML(aryPayTotal[idx]);
	}
	
}
