/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.PaymentListDao;
import jp.mosp.payroll.dao.PhPaymentDao;
import jp.mosp.payroll.dto.PaymentListDto;
import jp.mosp.payroll.payment.vo.PaymentListVo;

/**
 * ^f[^ꗗʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_SEARCH}
 * </li><li>
 * {@link #CMD_RE_SEARCH}
 * </li><li>
 * {@link #CMD_SORT}
 * </li><li>
 * {@link #CMD_PAGE}
 * </li></ul>
 */
public class PaymentListAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * ^vZ̔N擾A\B<br>
	 * ^vZ̔NȂꍇ́AVXeN\B<br>
	 */
	public static final String	CMD_SHOW		= "P1240";
	
	/**
	 * R}hB<br><br>
	 * w肳ꂽŋ^f[^̌sAꗗ\B<br>
	 */
	public static final String	CMD_SEARCH		= "P1241";
	
	/**
	 * ČR}hB<br><br>
	 * ۑꂽŋ^f[^̌sAꗗ\B<br>
	 */
	public static final String	CMD_RE_SEARCH	= "P1242";
	
	/**
	 * \[gR}hB<br><br>
	 * w肳ꂽŋ^f[^̕בւsAꗗ\B<br>
	 */
	public static final String	CMD_SORT		= "P1243";
	
	/**
	 * y[WR}hB<br><br>
	 * w肳ꂽŋ^f[^̃y[WJsAꗗ\B<br>
	 */
	public static final String	CMD_PAGE		= "P1244";
	

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public PaymentListAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentListVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (cmd.equals(CMD_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_RE_SEARCH)) {
			// Č
			reSearch();
		} else if (cmd.equals(CMD_SORT)) {
			// \[g
			sort();
		} else if (cmd.equals(CMD_PAGE)) {
			// y[W
			page();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br><br>
	 * @throws Exception 
	 */
	@Override
	public void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		PaymentListVo vo = (PaymentListVo)getVo();
		// VXet擾
		Date sysDate = new Date();
		// v_EACeݒ
		vo.setPitYear(getYearArray(PayrollConst.DEFAULT_CURRENT_YEAR, MospUtility.getYear(sysDate) + 1));
		vo.setPitMonth(getMonthArray());
		vo.setPitOffice(getOfficeArray());
		vo.setPitSection(getSectionArrayAll());
		vo.setPitPosition(getPositionArrayAll());
		// vZ擾
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT);
		// vZmF
		if (current == null) {
			// VOtB[hݒ
			vo.setPltYear(MospUtility.getYear(sysDate));
			vo.setPltMonth(MospUtility.getMonth(sysDate));
			return;
		}
		// VOtB[hݒ
		vo.setTxtKCode("");
		vo.setTxtKKana("");
		vo.setPltYear(MospUtility.getYear(current));
		vo.setPltMonth(MospUtility.getMonth(current));
		// Xg擾
		getList();
	}
	
	/**
	 * sB
	 * @throws Exception 
	 */
	@Override
	public void search() throws Exception {
		// VO擾
		PaymentListVo vo = (PaymentListVo)getVo();
		// p[^擾
		vo.setParams(request);
		// Xg擾
		getList();
	}
	
	/**
	 * 	ČsB
	 * @throws Exception 
	 */
	private void reSearch() throws Exception {
		// Xg擾
		getList();
	}
	
	/**
	 * \[gsB
	 * @throws Exception 
	 */
	private void sort() throws Exception {
		// VO擾
		PaymentListVo vo = (PaymentListVo)getVo();
		// \[gݒ
		vo.setSortKey(key1);
		vo.setSelectIndex(1);
		// Xg擾
		getList();
	}
	
	/**
	 * y[WsB
	 * @throws Exception 
	 */
	private void page() throws Exception {
		// VO擾
		PaymentListVo vo = (PaymentListVo)getVo();
		// y[Wݒ
		vo.setSelectIndex(Integer.parseInt(key1));
		// Xg擾
		getList();
	}
	
	/**
	 * Xg擾B
	 * @throws Exception 
	 */
	private void getList() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		PaymentListVo vo = (PaymentListVo)getVo();
		// Ώ۔N擾
		Date targetMonth = getDate(vo.getPltYear(), vo.getPltMonth(), PayrollConst.TIME_DEFAULT_DAY);
		vo.setLblTargetMonth(MospUtility.getDateString(targetMonth, PayrollConst.FORMAT_DATE));
		// DAO
		PaymentListDao dao = new PaymentListDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.countForPaymentList(vo.getTxtKCode(), vo.getTxtKKana(), vo.getPltOffice(), vo
			.getPltSection(), vo.getPltPosition(), targetMonth));
		// 
		List<PaymentListDto> list = dao.findForPaymentList(vo.getTxtKCode(), vo.getTxtKKana(), vo.getPltOffice(), vo
			.getPltSection(), vo.getPltPosition(), targetMonth, getSortKey(), vo.getIsAscending(), vo.getDataPerPage(),
				vo.getOffset());
		// ̎擾pz擾
		String[][] aryOffice = getOfficeArrayAll();
		String[][] arySection = getSectionArrayAll();
		String[][] aryPosition = getPositionArrayAll();
		// R[hϊ
		for (PaymentListDto dto : list) {
			dto.setOfficeName(getCodeName(dto.getJCode(), aryOffice));
			dto.setSectionName(getCodeName(dto.getSCode(), arySection));
			dto.setPositionName(getCodeName(dto.getYCode(), aryPosition));
		}
		// VOɐݒ
		vo.setFields(list);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getCount() == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * \[gL[擾B<br>
	 * @return \[gL[
	 */
	private String getSortKey() {
		// VO擾
		PaymentListVo vo = (PaymentListVo)getVo();
		// IL[擾
		String selectKey = vo.getSelectKey();
		// \[gL[擾
		String sortKey = PhPaymentDao.TABLE + "." + PhPaymentDao.COL_KCODE;
		if (selectKey == null) {
			// 
		} else if (selectKey.equals("2")) {
			sortKey = MKihonDao.COL_FURIGANA;
		} else if (selectKey.equals("3")) {
			sortKey = MKihonDao.COL_JCODE;
		} else if (selectKey.equals("4")) {
			sortKey = MKihonDao.COL_SCODE;
		} else if (selectKey.equals("5")) {
			sortKey = MKihonDao.COL_YCODE;
		} else if (selectKey.equals("6")) {
			sortKey = PhPaymentDao.COL_PAYMENT_TOTAL;
		}
		return sortKey;
	}
	
}
