/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * CM_AGREEMENT_OVER_TIME(ԊO}X^)DTONXB
 */
public class CmAgreementOverTimeDto extends BaseDto {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID		= 7014448145234445670L;
	// tB[h
	private int					overtimeid				= 0;
	private String				overtimecode			= "";
	private String				worktypename			= "";
	private String				cause					= "";
	private String				agreetype				= "";
	private String				limitcode				= "";
	private int					overtimerate			= 0;
	private int					cautionmonth			= 0;
	private int					monthlyovertimerate		= 0;
	private int					subacquirerate			= 0;
	private int					subacquireholidayrate	= 0;
	private int					subquitrate				= 0;
	private Date				startdate				= null;
	private int					deleteflag				= 0;
	

	/**
	 * RXgN^B
	 */
	public CmAgreementOverTimeDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return overtimeid 	ԊOIDB
	 */
	public int getOverTimeId() {
		return overtimeid;
	}
	
	/**
	 * @return overtimecode 	ԊOR[hB
	 */
	public String getOverTimeCode() {
		return overtimecode;
	}
	
	/**
	 * @return worktypename 	Ɩ̎ށB
	 */
	public String getWorkTypeName() {
		return worktypename;
	}
	
	/**
	 * @return cause 	̓IRB
	 */
	public String getCause() {
		return cause;
	}
	
	/**
	 * @return agreetype 	ށB
	 */
	public String getAgreeType() {
		return agreetype;
	}
	
	/**
	 * @return limitcode 	xR[hB
	 */
	public String getLimitCode() {
		return limitcode;
	}
	
	/**
	 * @return overtimerate 	ԊOB
	 */
	public int getOverTimeRate() {
		return overtimerate;
	}
	
	/**
	 * @return cautionmonth 	60ԎԊOxԁB
	 */
	public int getCautionMonth() {
		return cautionmonth;
	}
	
	/**
	 * @return monthlyovertimerate 	60ԎԊOB
	 */
	public int getMonthlyOverTimeRate() {
		return monthlyovertimerate;
	}
	
	/**
	 * @return subacquirerate 	֋xɎ擾B
	 */
	public int getSubAcquireRate() {
		return subacquirerate;
	}
	
	/**
	 * @return subacquireholidayrate 	֋xɎ擾xB
	 */
	public int getSubAcquireHolidayRate() {
		return subacquireholidayrate;
	}
	
	/**
	 * @return subquitrate 	֋xɕB
	 */
	public int getSubQuitRate() {
		return subquitrate;
	}
	
	/**
	 * @return startdate 	JnNB
	 */
	public Date getStartDate() {
		return (Date)startdate.clone();
	}
	
	/**
	 * @return deleteflag 	폜tOB
	 */
	public int getDeleteFlag() {
		return deleteflag;
	}
	
	/**
	 * @param overtimeid 	Zbg鎞ԊOIDB
	 */
	public void setOverTimeId(int overtimeid) {
		this.overtimeid = overtimeid;
	}
	
	/**
	 * @param overtimecode 	Zbg鎞ԊOR[hB
	 */
	public void setOverTimeCode(String overtimecode) {
		this.overtimecode = overtimecode;
	}
	
	/**
	 * @param worktypename 	ZbgƖ̎ށB
	 */
	public void setWorkTypeName(String worktypename) {
		this.worktypename = worktypename;
	}
	
	/**
	 * @param cause 	Zbg̓IRB
	 */
	public void setCause(String cause) {
		this.cause = cause;
	}
	
	/**
	 * @param agreetype 	Zbg鋦ށB
	 */
	public void setAgreeType(String agreetype) {
		this.agreetype = agreetype;
	}
	
	/**
	 * @param limitcode 	ZbgxR[hB
	 */
	public void setLimitCode(String limitcode) {
		this.limitcode = limitcode;
	}
	
	/**
	 * @param overtimerate 	Zbg鎞ԊOB
	 */
	public void setOverTimeRate(int overtimerate) {
		this.overtimerate = overtimerate;
	}
	
	/**
	 * @param cautionmonth 	Zbg錎60ԎԊOxԁB
	 */
	public void setCautionMonth(int cautionmonth) {
		this.cautionmonth = cautionmonth;
	}
	
	/**
	 * @param monthlyovertimerate 	Zbg錎60ԎԊOB
	 */
	public void setMonthlyOverTimeRate(int monthlyovertimerate) {
		this.monthlyovertimerate = monthlyovertimerate;
	}
	
	/**
	 * @param subacquirerate 	Zbg֋xɎ擾B
	 */
	public void setSubAcquireRate(int subacquirerate) {
		this.subacquirerate = subacquirerate;
	}
	
	/**
	 * @param subacquireholidayrate 	Zbg֋xɎ擾xB
	 */
	public void setSubAcquireHolidayRate(int subacquireholidayrate) {
		this.subacquireholidayrate = subacquireholidayrate;
	}
	
	/**
	 * @param subquitrate 	Zbg֋xɕB
	 */
	public void setSubQuitRate(int subquitrate) {
		this.subquitrate = subquitrate;
	}
	
	/**
	 * @param startdate 	ZbgJnNB
	 */
	public void setStartDate(Date startdate) {
		this.startdate = (Date)startdate.clone();
	}
	
	/**
	 * @param deleteflag 	Zbg폜tOB
	 */
	public void setDeleteFlag(int deleteflag) {
		this.deleteflag = deleteflag;
	}
	
}
