/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dto.MSyozokuDto;
import jp.mosp.kintai.system.vo.SyozokuMasterListVo;

/**
 * @author yoshida
 *
 */
public class SyozokuMasterListAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_SYOZOKU_LIST_SHOW		= "S2100";	// \
	private static final String	CMD_SYOZOKU_LIST_SEARCH		= "S2101";	// 
	private static final String	CMD_SYOZOKU_LIST_RE_SEARCH	= "S2102";	// Č
	private static final String	CMD_SYOZOKU_TYPE_LIST_SORT	= "S2103";	// \[g
																		
	
	/**
	 * RXgN^
	 */
	public SyozokuMasterListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_SYOZOKU_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_SYOZOKU_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_SYOZOKU_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_SYOZOKU_TYPE_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new SyozokuMasterListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		SyozokuMasterListVo vo = (SyozokuMasterListVo)getVo();
		// lɃZbg	
		vo.setSearchmode(SyozokuMasterListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		SyozokuMasterListVo vo = (SyozokuMasterListVo)getVo();
		vo.setParams(request);
		searchSyozokuMasterList();
		vo.setFormerKey(vo.KEY_S_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(SyozokuMasterListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		SyozokuMasterListVo vo = (SyozokuMasterListVo)getVo();
		if (vo.getSearchmode() == SyozokuMasterListVo.SEARCH_ON) {
			removeSessionDto();
			searchSyozokuMasterList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * Xg
	 * @throws Exception 	Oꍇ
	 */
	private void searchSyozokuMasterList() throws Exception {
		SyozokuMasterListVo vo = (SyozokuMasterListVo)getVo();
		vo.setFields(part().section().getMSyozokuDao().findForCondition(vo.getTxtSCode(), vo.getTxtSName()));
		// ΏۂȂꍇ̃bZ[Wݒ
		if (vo.getArySCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		SyozokuMasterListVo vo = (SyozokuMasterListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		SyozokuMasterListVo vo = (SyozokuMasterListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		SyozokuMasterListVo vo = (SyozokuMasterListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_S_CODE)) {
			comp = new CompSyozokuCode();
		} else if (key.equals(vo.KEY_S_NAME)) {
			comp = new CompSyozokuName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * R[hɂrNX
	 */
	protected static class CompSyozokuCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -1583394950071248662L;
		

		public int compare(Object obj1, Object obj2) {
			MSyozokuDto dto1 = (MSyozokuDto)obj1;
			MSyozokuDto dto2 = (MSyozokuDto)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}
	
	/**
	 * ɂrNX
	 */
	protected static class CompSyozokuName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5375772027347639889L;
		

		public int compare(Object obj1, Object obj2) {
			MSyozokuDto dto1 = (MSyozokuDto)obj1;
			MSyozokuDto dto2 = (MSyozokuDto)obj2;
			return dto1.getSName().compareTo(dto2.getSName());
		}
	}
	
}
