/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dao.MSyozokuDao;
import jp.mosp.kintai.common.dto.MSyozokuDto;
import jp.mosp.kintai.system.vo.SyozokuMasterCardVo;

/**
 * @author yoshida
 *
 */
public class SyozokuMasterCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_SYOZOKU_CARD_SHOW	= "S2105";	// \(ǉ)
	private static final String	CMD_SYOZOKU_CARD_SELECT	= "S2106";	// \(I)
	private static final String	CMD_SYOZOKU_CARD_INSERT	= "S2107";	// o^
	private static final String	CMD_SYOZOKU_CARD_UPDATE	= "S2108";	// XV
	private static final String	CMD_SYOZOKU_CARD_DELETE	= "S2109";	// 폜
																	
	
	/**
	 * RXgN^
	 */
	public SyozokuMasterCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ		
		prepareVo(false);
		//  
		init();
		// R}h̏
		if (cmd.equals(CMD_SYOZOKU_CARD_SHOW)) {
			// \(VK)
			show();
		} else if (cmd.equals(CMD_SYOZOKU_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_SYOZOKU_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_SYOZOKU_CARD_UPDATE)) {
			// XV
			update();
		} else if (cmd.equals(CMD_SYOZOKU_CARD_DELETE)) {
			// 폜
			delete();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new SyozokuMasterCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() {
		SyozokuMasterCardVo vo = (SyozokuMasterCardVo)getVo();
		vo.setTxtSCode1("");
		vo.setTxtSCode2("");
		vo.setTxtSCode3("");
		vo.setTxtSName("");
		vo.setMode(SyozokuMasterCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		SyozokuMasterCardVo vo = (SyozokuMasterCardVo)getVo();
		// f[^̎擾
		MSyozokuDto dto = part().section().getSectionInfo(key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		setMode();
		//ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		SyozokuMasterCardVo vo = (SyozokuMasterCardVo)getVo();
		vo.setParams(request);
		// p[^[̑ÓmF
		vo.validate();
		// DTȌ
		MSyozokuDto dto = new MSyozokuDto();
		vo.setDtoFields(dto);
		// DAȌ
		MSyozokuDao dao = part().section().getMSyozokuDao();
		// ݃`FbN
		chkDuplicate(dao.findForKey(dto.getSCode()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		MSyozokuDto retDto = dao.findForKey(dto.getSCode());
		chkInsert(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		MSyozokuDto dto = (MSyozokuDto)getSessionDto();
		SyozokuMasterCardVo vo = (SyozokuMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MSyozokuDao dao = part().section().getMSyozokuDao();
		// DTȌ
		vo.setDtoFields(dto);
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getSCode()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MSyozokuDto retDto = dao.findForKey(dto.getSCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * f[^폜
	 * @throws Exception 	Oꍇ
	 */
	private void delete() throws Exception {
		// DTO̎擾
		MSyozokuDto dto = (MSyozokuDto)getSessionDto();
		SyozokuMasterCardVo vo = (SyozokuMasterCardVo)getVo();
		// f[^̍XV
		part().section().getMSyozokuDao().delete(dto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_DELETE, ""));
	}
	
	/**
	 * [hݒ
	 * @throws Exception 	Oꍇ
	 */
	private void setMode() throws Exception {
		SyozokuMasterCardVo vo = (SyozokuMasterCardVo)getVo();
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(SyozokuMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(SyozokuMasterCardVo.MODE_UPDATE);
		}
	}
	
}
