/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.common.action.MosPHumanAction;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.system.vo.FirstHumanAccountCardVo;

/**
 * @author yoshida
 *
 */
public class FirstHumanAccountCardAction extends MosPHumanAction {
	
	// R}h
	private static final String	CMD_FIRST_HUMAN_ACCOUNT_CARD_SHOW	= "S2410";
	private static final String	CMD_FIRST_HUMAN_ACCOUNT_CARD_INSERT	= "S2417";
	

	/**
	 * RXgN^
	 */
	public FirstHumanAccountCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_FIRST_HUMAN_ACCOUNT_CARD_SHOW)) {
			show();
		} else if (cmd.equals(CMD_FIRST_HUMAN_ACCOUNT_CARD_INSERT)) {
			// VKo^
			insert();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new FirstHumanAccountCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// v_ẼZbg
		FirstHumanAccountCardVo vo = (FirstHumanAccountCardVo)getVo();
		vo.aryPltOfficeAll = getOfficeArrayAll();
		vo.aryPltSectionAll = getSectionArrayAll();
		vo.aryPltPosition = getPositionPltArray();
		// ƏAAEꌏo^ĂȂꍇ
		if (vo.aryPltOfficeAll.length == 0 || vo.aryPltPosition.length == 0 || vo.aryPltSectionAll.length == 0) {
			// bZ[Wݒ
			vo.setMessage(getMessage(MospConst.MSG_NO_CODE, ""));
		}
	}
	
	@Override
	protected void show() throws Exception {
		// l\
		setMode();
	}
	
	@Override
	protected void insert() throws Exception {
		FirstHumanAccountCardVo vo = (FirstHumanAccountCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// }X^f[^݊mF
		chkDuplicate(humanBasisDao().findForKey(vo.getTxtKCode()));
		// o^
		regist();
		// R~bg
		commit();
		// ꗗ\
		setNextCmd(AccountMasterListAction.CMD_ACCOUNT_MASTER_LIST_RE_SEARCH);
		// T[ubg֓]
		setUrl(MospConst.URL_SRV);
	}
	
	/**
	 * o^
	 * @throws Exception Oꍇ
	 */
	private void regist() throws Exception {
		FirstHumanAccountCardVo vo = (FirstHumanAccountCardVo)getVo();
		// DTO
		mKihonDto = new MKihonDto();
		mKihonDto.setKCode(vo.getTxtKCode());
		mKihonDto.setSimei(vo.getTxtUserName());
		mKihonDto.setSCode(vo.getPltSection());
		mKihonDto.setYCode(vo.getPltPosition().split(CommonConst.STR_TIME_SEPARATOR)[0]);
		mKihonDto.setTokyu(vo.getPltPosition().split(CommonConst.STR_TIME_SEPARATOR)[1]);
		mKihonDto.setJCode(vo.getPltOffice());
		mKihonDto.setKnKubun(String.valueOf(CommonConst.RETIREMENT_FLAG_OFF));
		// Гo^ɐݒ
		mKihonDto.setNyDate(DateUtil.convDateToInteger(DateUtil.getSystemDate()));
		// ݊mF
		String message = "";
		if (!chkExistDto(humanBasisDao().findForUpdate(mKihonDto.getKCode()))) {
			// VKo^
			humanBasisDao().insert(mKihonDto);
			// l{擾
			findHumanBasisInfo(mKihonDto.getKCode(), false);
			// [U[擾
			MosPUserDao dao = part().mospuser().getMosPUserDao();
			// [U
			if (!chkExistDto(dao.findForUpdate(mKihonDto.getKCode()))) {
				// [U[̍쐬
				CmUserDto cmUserDto = new CmUserDto();
				cmUserDto.setUserId(mKihonDto.getKCode());
				cmUserDto.setPassword(MospUtility.getDigest(MospUtility.getDigest(mKihonDto.getKCode())));
				cmUserDto.setKCode(mKihonDto.getKCode());
				cmUserDto.setUserName(mKihonDto.getSimei());
				cmUserDto.setAuthority(CommonConst.AUTHORITY_HUMAN);
				cmUserDto.setChangePass(new Date());
				cmUserDto.setDataLevel(CommonConst.DATA_DEFAULT_LEVEL);
				// o^
				dao.insert(cmUserDto);
				message = getMessage(MospConst.MSG_INSERT, "");
			} else {
				message = getMessage(MospConst.MSG_DUPLICATE, "");
			}
		} else {
			message = getMessage(MospConst.MSG_DUPLICATE, "");
		}
		// bZ[Wݒ
		setMessage(message);
	}
	
	/**
	 * [hݒ
	 * @throws Exception Oꍇ
	 */
	private void setMode() throws Exception {
		FirstHumanAccountCardVo vo = (FirstHumanAccountCardVo)getVo();
		List<CmUserDto> listHuman = part().mospuser().getMosPUserDao().findAllMosPUser();
		// HUMANmF
		boolean hasAuth = false;
		String[][] aryHuman = getConfArray(CommonConst.CONF_ID_HUMAN);
		for (CmUserDto dto : listHuman) {
			for (String[] ary : aryHuman) {
				if (ary[0].equals(dto.getAuthority())) {
					hasAuth = true;
					break;
				}
			}
		}
		if (hasAuth) {
			// bZ[Wݒ
			vo.setMessage(getMessage(MospConst.MSG_DUPLICATE, ""));
			vo.setMode(FirstHumanAccountCardVo.MODE_VIEW);
		} else {
			vo.setMode(FirstHumanAccountCardVo.MODE_INSERT);
		}
	}
	
}
