/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.schedule.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.schedule.dto.CmRotationDto;

/**
 * @author yoshida
 *
 */
public class ScheduleRotationCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -6565156858919918031L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_RT_CODE		= "txtRtCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_RT_NAME		= "txtRtName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOLIDAY		= "pltHoliday";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY1		= "pltDay1";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY2		= "pltDay2";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY3		= "pltDay3";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY4		= "pltDay4";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY5		= "pltDay5";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY6		= "pltDay6";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY7		= "pltDay7";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY8		= "pltDay8";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY9		= "pltDay9";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY10		= "pltDay10";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String				txtRTCode;
	private String				txtRTName;
	private String				pltHoliday;
	private String				pltDay1;
	private String				pltDay2;
	private String				pltDay3;
	private String				pltDay4;
	private String				pltDay5;
	private String				pltDay6;
	private String				pltDay7;
	private String				pltDay8;
	private String				pltDay9;
	private String				pltDay10;
	private String				pltDelete;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltWorkType;
	/**
	 * 
	 */
	public String[][]			aryPltHoliday;
	
	// [h(0FVKo^A1FXV)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_RT_CODE;
	/**
	 * 
	 */
	public String				NAM_RT_NAME;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_DAY1;
	/**
	 * 
	 */
	public String				NAM_DAY2;
	/**
	 * 
	 */
	public String				NAM_DAY3;
	/**
	 * 
	 */
	public String				NAM_DAY4;
	/**
	 * 
	 */
	public String				NAM_DAY5;
	/**
	 * 
	 */
	public String				NAM_DAY6;
	/**
	 * 
	 */
	public String				NAM_DAY7;
	/**
	 * 
	 */
	public String				NAM_DAY8;
	/**
	 * 
	 */
	public String				NAM_DAY9;
	/**
	 * 
	 */
	public String				NAM_DAY10;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public int					LEN_RT_CODE;
	/**
	 * 
	 */
	public int					LEN_RT_NAME;
	

	/**
	 * RXgN^
	 */
	public ScheduleRotationCardVo() {
		super();
		mode = MODE_INSERT;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_SCHEDULE_ROTATION_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuSchedule() };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_RT_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_RT_NAME = CommonConst.NAM_COMMON_MEISYO;
		NAM_HOLIDAY = CommonConst.NAM_PUBLIC_HOLIDAY;
		NAM_DAY1 = CommonConst.NAM_DAY1;
		NAM_DAY2 = CommonConst.NAM_DAY2;
		NAM_DAY3 = CommonConst.NAM_DAY3;
		NAM_DAY4 = CommonConst.NAM_DAY4;
		NAM_DAY5 = CommonConst.NAM_DAY5;
		NAM_DAY6 = CommonConst.NAM_DAY6;
		NAM_DAY7 = CommonConst.NAM_DAY7;
		NAM_DAY8 = CommonConst.NAM_DAY8;
		NAM_DAY9 = CommonConst.NAM_DAY9;
		NAM_DAY10 = CommonConst.NAM_DAY10;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_RT_CODE = 10;
		LEN_RT_NAME = 25;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtRTCode("");
		setTxtRTName("");
		setPltHoliday("0");
		setPltDay1("");
		setPltDay2("");
		setPltDay3("");
		setPltDay4("");
		setPltDay5("");
		setPltDay6("");
		setPltDay7("");
		setPltDay8("");
		setPltDay9("");
		setPltDay10("");
		setPltDelete("0");
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtRTCode = request.getParameter(PRM_TXT_RT_CODE);
		txtRTName = request.getParameter(PRM_TXT_RT_NAME);
		pltHoliday = request.getParameter(PRM_PLT_HOLIDAY);
		pltDay1 = request.getParameter(PRM_PLT_DAY1);
		pltDay2 = request.getParameter(PRM_PLT_DAY2);
		pltDay3 = request.getParameter(PRM_PLT_DAY3);
		pltDay4 = request.getParameter(PRM_PLT_DAY4);
		pltDay5 = request.getParameter(PRM_PLT_DAY5);
		pltDay6 = request.getParameter(PRM_PLT_DAY6);
		pltDay7 = request.getParameter(PRM_PLT_DAY7);
		pltDay8 = request.getParameter(PRM_PLT_DAY8);
		pltDay9 = request.getParameter(PRM_PLT_DAY9);
		pltDay10 = request.getParameter(PRM_PLT_DAY10);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(CmRotationDto dto) {
		txtRTCode = dto.getRtCode();
		txtRTName = dto.getRtName();
		pltHoliday = String.valueOf(dto.getHolidayFlag());
		pltDay1 = dto.getDay1();
		pltDay2 = dto.getDay2();
		pltDay3 = dto.getDay3();
		pltDay4 = dto.getDay4();
		pltDay5 = dto.getDay5();
		pltDay6 = dto.getDay6();
		pltDay7 = dto.getDay7();
		pltDay8 = dto.getDay8();
		pltDay9 = dto.getDay9();
		pltDay10 = dto.getDay10();
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmRotationDto dto) {
		dto.setRtCode(txtRTCode);
		dto.setRtName(txtRTName);
		dto.setHolidayFlag(Integer.parseInt(pltHoliday));
		dto.setDay1(pltDay1);
		dto.setDay2(pltDay2);
		dto.setDay3(pltDay3);
		dto.setDay4(pltDay4);
		dto.setDay5(pltDay5);
		dto.setDay6(pltDay6);
		dto.setDay7(pltDay7);
		dto.setDay8(pltDay8);
		dto.setDay9(pltDay9);
		dto.setDay10(pltDay10);
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	//ÓmFJn
	public void validate() throws MospException {
		startValidation();
		// K{mF
		checkRequired(txtRTCode, NAM_RT_CODE, PRM_TXT_RT_CODE);
		checkRequired(txtRTName, NAM_RT_NAME, PRM_TXT_RT_NAME);
		//^CvmF
		checkCode(txtRTCode, NAM_RT_CODE, PRM_TXT_RT_CODE);
		//񒷊mF		
		checkLength(txtRTCode, LEN_RT_CODE, NAM_RT_CODE, PRM_TXT_RT_CODE);
		checkLength(txtRTName, LEN_RT_NAME, NAM_RT_NAME, PRM_TXT_RT_NAME);
		//ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	/**
	 * @return txtRTCode
	 */
	public String getTxtRTCode() {
		return txtRTCode;
	}
	
	/**
	 * @return txtRTName
	 */
	public String getTxtRTName() {
		return txtRTName;
	}
	
	/**
	 * @return pltHoliday
	 */
	public String getPltHoliday() {
		return pltHoliday;
	}
	
	/**
	 * @return pltDay1
	 */
	public String getPltDay1() {
		return pltDay1;
	}
	
	/**
	 * @return pltDay2
	 */
	public String getPltDay2() {
		return pltDay2;
	}
	
	/**
	 * @return pltDay3
	 */
	public String getPltDay3() {
		return pltDay3;
	}
	
	/**
	 * @return pltDay4
	 */
	public String getPltDay4() {
		return pltDay4;
	}
	
	/**
	 * @return pltDay5
	 */
	public String getPltDay5() {
		return pltDay5;
	}
	
	/**
	 * @return pltDay6
	 */
	public String getPltDay6() {
		return pltDay6;
	}
	
	/**
	 * @return pltDay7
	 */
	public String getPltDay7() {
		return pltDay7;
	}
	
	/**
	 * @return pltDay8
	 */
	public String getPltDay8() {
		return pltDay8;
	}
	
	/**
	 * @return pltDay9
	 */
	public String getPltDay9() {
		return pltDay9;
	}
	
	/**
	 * @return pltDay10
	 */
	public String getPltDay10() {
		return pltDay10;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param txtRTCode Zbg txtRTCode
	 */
	public void setTxtRTCode(String txtRTCode) {
		this.txtRTCode = txtRTCode;
	}
	
	/**
	 * @param txtRTName Zbg txtRTName
	 */
	public void setTxtRTName(String txtRTName) {
		this.txtRTName = txtRTName;
	}
	
	/**
	 * @param pltHoliday Zbg pltHoliday
	 */
	public void setPltHoliday(String pltHoliday) {
		this.pltHoliday = pltHoliday;
	}
	
	/**
	 * @param pltDay1 Zbg pltDay1
	 */
	public void setPltDay1(String pltDay1) {
		this.pltDay1 = pltDay1;
	}
	
	/**
	 * @param pltDay2 Zbg pltDay2
	 */
	public void setPltDay2(String pltDay2) {
		this.pltDay2 = pltDay2;
	}
	
	/**
	 * @param pltDay3 Zbg pltDay3
	 */
	public void setPltDay3(String pltDay3) {
		this.pltDay3 = pltDay3;
	}
	
	/**
	 * @param pltDay4 Zbg pltDay4
	 */
	public void setPltDay4(String pltDay4) {
		this.pltDay4 = pltDay4;
	}
	
	/**
	 * @param pltDay5 Zbg pltDay5
	 */
	public void setPltDay5(String pltDay5) {
		this.pltDay5 = pltDay5;
	}
	
	/**
	 * @param pltDay6 Zbg pltDay6
	 */
	public void setPltDay6(String pltDay6) {
		this.pltDay6 = pltDay6;
	}
	
	/**
	 * @param pltDay7 Zbg pltDay7
	 */
	public void setPltDay7(String pltDay7) {
		this.pltDay7 = pltDay7;
	}
	
	/**
	 * @param pltDay8 Zbg pltDay8
	 */
	public void setPltDay8(String pltDay8) {
		this.pltDay8 = pltDay8;
	}
	
	/**
	 * @param pltDay9 Zbg pltDay9
	 */
	public void setPltDay9(String pltDay9) {
		this.pltDay9 = pltDay9;
	}
	
	/**
	 * @param pltDay10 Zbg pltDay10
	 */
	public void setPltDay10(String pltDay10) {
		this.pltDay10 = pltDay10;
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
