/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.FileUploadUtility;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.payroll.dto.KdPaidHolidayDto;
import jp.mosp.kintai.payroll.dto.MYukyuDto;

import org.apache.commons.fileupload.FileItem;

/**
 * @author nakamura
 *
 */
public class PaidHolidayImportCardVo extends MosPVo {
	
	private static final long		serialVersionUID	= 7407593935185524327L;
	
	// 萔
	/**
	 * \[h
	 */
	public static final int			MODE_VIEW			= 0;
	/**
	 * Abv[h[h
	 */
	public static final int			MODE_UPLOAD			= 1;
	/**
	 * |[g[h
	 */
	public static final int			MODE_REPORT			= 2;
	
	/**
	 * LxɃ[h
	 */
	public static final int			TABLE_OLD			= 1;
	/**
	 * VLxɃ[h
	 */
	public static final int			TABLE_NEW			= 2;
	
	// p[^[
	/**
	 * Abv[ht@C
	 */
	public static final String		PRM_FIL_UPLOAD_FILE	= "filUploadFile";
	
	// tB[h
	private FileItem				filUploadFile;
	private String[][]				aryYukyu;
	
	private List<MYukyuDto>			oldImportList;
	private List<KdPaidHolidayDto>	newImportList;
	private StringBuffer			errorReport;
	
	private String[]				aryColumnName;
	
	// [h
	private int						mode;
	private int						table;
	
	// tB[hyѐ
	/**
	 * ЈR[h
	 */
	public String					NAM_K_CODE;
	

	/**
	 * RXgN^[
	 */
	public PaidHolidayImportCardVo() {
		super();
		setViewPath(getClassName());
		aryYukyu = new String[0][0];
		aryColumnName = StringUtil.getBlankArrayOneDimension(9);
		mode = MODE_VIEW;
		table = 0;
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = "LxɏC|[g";
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuPaidHolidayManagement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
	}
	
	/**
	 * @param yukyuList		Lxɏ
	 */
	@Override
	public void setFields(List<?> yukyuList) {
		// Xg̐ݒ
		list = yukyuList;
		// f[^̎擾
		count = list.size();
		// z̏
		aryYukyu = new String[count][9];
		int i = 0;
		for (Object obj : yukyuList) {
			aryYukyu[i] = escapeArray((String[])obj);
			i++;
		}
	}
	
	/**
	 * p[^ݒ
	 * @param list	NGXgXg
	 * @throws Exception O
	 */
	public void setFilUploadFile(List<?> list) throws Exception {
		filUploadFile = FileUploadUtility.getMultipartFile(list, PRM_FIL_UPLOAD_FILE);
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append(" var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append(" var TABLE = ");
		sb.append(table);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return		Abv[ht@C
	 */
	public FileItem getFilUploadFile() {
		return filUploadFile;
	}
	
	/**
	 * @return		Lxɏ
	 */
	public String[][] getEscAryYukyu() {
		return aryYukyu.clone();
	}
	
	/**
	 * @return		VLxɃ[h
	 */
	public int getTable() {
		return table;
	}
	
	/**
	 * @param mode		[h
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @param table Zbg table
	 */
	public void setTable(int table) {
		this.table = table;
	}
	
	/**
	 * @param oldImportList Zbg oldImportList
	 */
	public void setOldImportList(List<MYukyuDto> oldImportList) {
		this.oldImportList = oldImportList;
	}
	
	/**
	 * @return oldImportList
	 */
	public List<MYukyuDto> getOldImportList() {
		return oldImportList;
	}
	
	/**
	 * @param newImportList Zbg newImportList
	 */
	public void setNewImportList(List<KdPaidHolidayDto> newImportList) {
		this.newImportList = newImportList;
	}
	
	/**
	 * @return newImportList
	 */
	public List<KdPaidHolidayDto> getNewImportList() {
		return newImportList;
	}
	
	/**
	 * @param errorReport Zbg errorReport
	 */
	public void setErrorReport(StringBuffer errorReport) {
		this.errorReport = errorReport;
	}
	
	/**
	 * @return errorReport
	 */
	public StringBuffer getErrorReport() {
		return errorReport;
	}
	
	/**
	 * @return aryColumnName
	 */
	public String[] getAryColumnName() {
		return aryColumnName.clone();
	}
	
	/**
	 * @param aryColumnName Zbg aryColumnName
	 */
	public void setAryColumnName(String[] aryColumnName) {
		this.aryColumnName = aryColumnName.clone();
	}
	
}
