/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.payroll.dto.MYukyuDto;

/**
 * @author yoshida
 *
 */
public class MYukyuDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * M_YUKYU
	 */
	public static final String	TABLE			= "M_YUKYU";
	/**
	 * ЈR[h
	 */
	public static final String	KEY_1			= "KCODE";
	/**
	 * ^vZN
	 */
	public static final String	KEY_2			= "KYUYOYMD";
	
	// 
	/**
	 * ЈR[h
	 */
	public static final String	COL_KCODE		= "KCODE";
	/**
	 * ^vZN
	 */
	public static final String	COL_KYUYOYMD	= "KYUYOYMD";
	/**
	 * OciNj
	 */
	public static final String	COL_ZZANT		= "ZZANT";
	/**
	 * OciONj
	 */
	public static final String	COL_ZZANZ		= "ZZANZ";
	/**
	 * gp
	 */
	public static final String	COL_SYOKA		= "SYOKA";
	/**
	 * 擾
	 */
	public static final String	COL_SYOTOKU		= "SYUTOKU";
	/**
	 * p
	 */
	public static final String	COL_HAIKI		= "HAIKI";
	/**
	 * ciNj
	 */
	public static final String	COL_TZANT		= "TZANT";
	/**
	 * ciONj
	 */
	public static final String	COL_TZANZ		= "TZANZ";
	

	/**
	 * RXgN^
	 */
	public MYukyuDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MYukyuDto> mappingAll() throws SQLException {
		List<MYukyuDto> all = new ArrayList<MYukyuDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return MYukyuDto m_yukyuR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MYukyuDto mapping() throws SQLException {
		MYukyuDto dto = new MYukyuDto();
		dto.setKCode(rs.getString(COL_KCODE)); //ЈR[h
		dto.setKyuyoYMD(rs.getInt(COL_KYUYOYMD)); //^vZN
		dto.setZZanT(rs.getDouble(COL_ZZANT)); //OciNj
		dto.setZZanZ(rs.getDouble(COL_ZZANZ)); //OciONj
		dto.setSyoka(rs.getDouble(COL_SYOKA)); //gp
		dto.setSyutoku(rs.getInt(COL_SYOTOKU)); //擾
		dto.setHaiki(rs.getDouble(COL_HAIKI)); //p
		dto.setTZanT(rs.getDouble(COL_TZANT)); //ciNj
		dto.setTZanZ(rs.getDouble(COL_TZANZ)); //ciONj
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<?> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @param kyuyoymd ^vZN(L[)
	 * @return MYukyuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MYukyuDto findForKey(String kcode, String kyuyoymd) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, Integer.parseInt(kyuyoymd));
			executeQuery();
			MYukyuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @param kyuyoymd ^vZN(L[)
	 * @return MYukyuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MYukyuDto findForKey(String kcode, int kyuyoymd) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, kyuyoymd);
			executeQuery();
			MYukyuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param kyuyoymd ^vZN(L[)
	 * @return MyukyuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MYukyuDto findForUpdate(String kcode, String kyuyoymd) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, Integer.parseInt(kyuyoymd));
			executeQuery();
			MYukyuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param kyuyoymd ^vZN(L[)
	 * @return MyukyuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MYukyuDto findForUpdate(String kcode, int kyuyoymd) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, kyuyoymd);
			executeQuery();
			MYukyuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param kyuyoymd ^vZN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MYukyuDto> findForList(String kcode, String kyuyoymd) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_KYUYOYMD);
		sb.append(" <= ? ");
		sb.append(" ORDER BY ");
		sb.append(COL_KYUYOYMD);
		sb.append(" ");
		sb.append(getDesc());
		sb.append(getLimit());
		sb.append(" 12");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kcode);
			setParam(index++, Integer.parseInt(kyuyoymd));
			executeQuery();
			List<MYukyuDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param kyuyoymd ^vZN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String kcode, String kyuyoymd) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_KYUYOYMD);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, kyuyoymd + "%");
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param startDate JnN
	 * @param endDate IN
	 * @return MYukyuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MYukyuDto findForPeriod(String kcode, int startDate, int endDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_KYUYOYMD);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_KYUYOYMD);
		sb.append(" <= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			MYukyuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param targetDate Ώ۔N
	 * @return MYukyuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MYukyuDto findForDateNearly(String kcode, int targetDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_KYUYOYMD);
		sb.append(" <= ? ");
		sb.append(getOrderBy());
		sb.append(COL_KYUYOYMD);
		sb.append(" ");
		sb.append(getDesc());
		sb.append(getLimit());
		sb.append("1");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kcode);
			setParam(index++, targetDate);
			executeQuery();
			MYukyuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param startDate Jn^vZN
	 * @param endDate Jn^vZN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MYukyuDto> findForCondition(String kcode, int startDate, int endDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_KYUYOYMD);
		sb.append(" >= ? AND ");
		sb.append(COL_KYUYOYMD);
		sb.append(" <= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			List<MYukyuDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param kyuyoymd ^vZN
	 * @return MYukyuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MYukyuDto findForFormer(String kcode, String kyuyoymd) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_KYUYOYMD);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, Integer.parseInt(kyuyoymd));
			executeQuery();
			MYukyuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int insert(MYukyuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * @param list		Lxɏ
	 * @param divSize	
	 * @return	}()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(List<MYukyuDto> list, int divSize) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			int listSize = list.size();
			int rev = listSize / divSize + 1;
			if (listSize % divSize == 0) {
				rev--;
			}
			int insertCount = 0;
			List<MYukyuDto> divList = new ArrayList<MYukyuDto>();
			for (int i = 0; i < rev; i++) {
				// XgdivƕB
				for (int k = 0; k < divSize; k++) {
					int count = k + (i * divSize);
					if (count >= listSize) {
						break;
					}
					divList.add(list.get(count));
				}
				int divListSize = divList.size();
				prepareStatement(getInsertQuery(getClass(), divListSize, divSize));
				for (MYukyuDto dto : divList) {
					setParams(dto, true);
				}
				executeUpdate();
				clearParams();
				index = 1;
				divList.clear();
				chkInsert(divListSize);
				insertCount += cnt;
			}
			return insertCount;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int update(MYukyuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getKyuyoYMD());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int delete(MYukyuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getKyuyoYMD());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MYukyuDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); //ЈR[h
		setParam(index++, dto.getKyuyoYMD()); //^vZN
		setParam(index++, dto.getZZanT()); //OciNj
		setParam(index++, dto.getZZanZ()); //OciONj
		setParam(index++, dto.getSyoka()); //gp
		setParam(index++, dto.getSyutoku()); //擾
		setParam(index++, dto.getHaiki()); //p
		setParam(index++, dto.getTZanT()); //ciNj
		setParam(index++, dto.getTZanZ()); //ciONj
		setCommonParams(isInsert);
	}
	
}
