/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.utils.CsvUtil;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.part.KintaiCompilePart;
import jp.mosp.kintai.payroll.dao.KdWorkDao;
import jp.mosp.kintai.payroll.dto.KdWorkDto;
import jp.mosp.kintai.payroll.dto.MKintaiDto;
import jp.mosp.kintai.payroll.vo.WorkCompileImportCardVo;

/**
 * @author nakamura
 *
 */
public class WorkCompileImportCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_SHOW	= "S1240";
	private static final String	CMD_UPLOAD	= "S1241";
	private static final String	CMD_IMPORT	= "S1242";
	private static final String	CMD_REPORT	= "S1243";
	
	private StringBuffer		errMessage;
	// t@CdmFp
	private HashSet<String>		hashSet;
	// G[
	private int					errorCount;
	// \pz
	private List<String[]>		viewList;
	// G[|[g
	private StringBuffer		errorReport;
	

	/**
	 * RXgN^[
	 */
	public WorkCompileImportCardAction() {
		super();
	}
	
	/* ( Javadoc)
	 * @see jp.mosp.common.common.ActionInterface#action()
	 */
	public void action() throws Exception {
		// VȌ
		prepareVo();
		// 
		init();
		// R}h̏
		if (CMD_SHOW.equals(cmd)) {
			// \
			show();
		} else if (CMD_UPLOAD.equals(cmd)) {
			// Abv[h
			upload();
		} else if (CMD_IMPORT.equals(cmd)) {
			// o^
			insert();
		} else if (CMD_REPORT.equals(cmd)) {
			// G[o
			report();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new WorkCompileImportCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		getConnection();
	}
	
	@Override
	protected void show() throws Exception {
		WorkCompileImportCardVo vo = (WorkCompileImportCardVo)getVo();
		vo.setMode(WorkCompileImportCardVo.MODE_VIEW);
	}
	
	/**
	 * Abv[h
	 * @throws Exception 	Oꍇ
	 */
	private void upload() throws Exception {
		WorkCompileImportCardVo vo = (WorkCompileImportCardVo)getVo();
		// t@Cݒ
		vo.setFilUploadFile(multipartFieldList);
		// Abv[ht@C
		String uploadFileName = vo.getFilUploadFile().getName();
		// VΑӏC|[gp̃Xg
		List<KdWorkDto> newImportList = new ArrayList<KdWorkDto>();
		// t@CdmFp
		hashSet = new HashSet<String>();
		// \pz
		viewList = new ArrayList<String[]>();
		// G[
		errorCount = 0;
		// G[|[g
		errorReport = new StringBuffer();
		// csvt@C
		if (uploadFileName.matches(".*" + ".csv" + ".*")) {
			String[][] aryAllValues = CsvUtil.getAllValues(getUploadFile(vo.getFilUploadFile()));
			String[] newTableHeader = part().compile().getNewWorkCsvHeader();
			int i = 0;
			for (String[] aryValue : aryAllValues) {
				// G[e
				errMessage = new StringBuffer();
				// wb_[
				if (i == 0) {
					if (StringUtil.checkArraysEquals(aryValue, newTableHeader)) {
						vo.setTable(WorkCompileImportCardVo.TABLE_NEW);
					} else {
						// G[bZ[W̕\
						addErrMessage(getMessage(CommonConst.MSG_INVALID_HEAD_TYPE, ""));
						break;
					}
				} else {
					if (vo.getTable() == WorkCompileImportCardVo.TABLE_NEW) {
						if (aryValue.length >= newTableHeader.length - 4) {
							// VΑӃe[u
							convDataToNewInfo(aryValue, newTableHeader, i, newImportList);
						} else {
							// G[bZ[W̕\
							addCsvErrMessage("WC0013", String.valueOf(i));
							addErrorReport(newTableHeader, aryValue);
						}
					}
				}
				i++;
			}
		} else {
			addErrMessage(getMessage(CommonConst.MSG_NO_CSV_DATA, ""));
		}
		// [h̐ݒ
		vo.setMode(WorkCompileImportCardVo.MODE_VIEW);
		// C|[gXgZbg
		vo.setNewImportList(newImportList);
		// bZ[W̕\
		setMessage(getMessage("IC0005", String.valueOf(newImportList.size())));
		if (newImportList.size() != 0) {
			// [h̐ݒ
			vo.setMode(WorkCompileImportCardVo.MODE_UPLOAD);
		}
		if (errorCount > 0) {
			// C|[głȂG[̏ڍׂZbg
			vo.setErrorReport(errorReport);
			// G[bZ[W
			StringBuffer sb = new StringBuffer();
			sb.append(errorCount);
			sb.append("̃f[^");
			addErrMessage(getMessage(CommonConst.MSG_NO_UPLOAD_KEY, sb.toString()));
			// [h̐ݒ
			vo.setMode(WorkCompileImportCardVo.MODE_REPORT);
		}
		// VOփZbg
		vo.setFields(viewList);
		vo.initListInfo();
	}
	
	@Override
	protected void insert() throws Exception {
		WorkCompileImportCardVo vo = (WorkCompileImportCardVo)getVo();
		// [h̐ݒ
		vo.setMode(WorkCompileImportCardVo.MODE_VIEW);
		// G[̂s
		HashSet<Integer> errSet = new HashSet<Integer>();
		// Insert
		int count = 0;
		// C|[gXg̏
		List<MKintaiDto> oldImportList = new ArrayList<MKintaiDto>();
		List<KdWorkDto> newImportList = new ArrayList<KdWorkDto>();
		List<KdWorkDto> importList = vo.getNewImportList();
		for (KdWorkDto dto : importList) {
			// xNDateɕϊ()
			Date date = DateUtil.getFirstDateOfMonth(dto.getSikyuYm().substring(0, 4), dto.getSikyuYm().substring(5));
			// J@{s̏ꍇ
			if (MosPCodePart.afterLegalReformDate(date)) {
				newImportList.add(dto);
			} else {
				oldImportList.add(convMKintaiDto(dto));
			}
		}
		if (VariousUtil.isNotNull(oldImportList)) {
			int i = 0;
			for (MKintaiDto dto : oldImportList) {
				// Ј̑݊mF
				if (part().human().isNotUseKCode(dto.getKCode())) {
					// G[bZ[W̕\
					addErrMessage(getMessage("IC0006", String.valueOf(i)));
					errSet.add(i);
				}
				// f[^̏dmF
				if (VariousUtil.isNotNull(part().compile().getKdWorkInfo(dto.getKCode(),
						DateUtil.getFirstDateOfMonth(dto.getSikyuYM().substring(0, 4), dto.getSikyuYM().substring(5))))) {
					// G[bZ[W̕\
					addErrMessage(getMessage("WC1023", ""));
					errSet.add(i);
				}
				i++;
			}
			if (errSet.size() == 0) {
				// o^
				count += part().compile().getMKintaiDao().insert(oldImportList, CommonConst.NUM_DIVIDE_NUMBER);
				// R~bg
				commit();
			}
		} else {
			// G[bZ[W̕\
			addErrMessage(getMessage("WC0018", ""));
		}
		if (VariousUtil.isNotNull(newImportList)) {
			// DAȌ
			KdWorkDao dao = part().compile().getKdWorkDao();
			int i = 0;
			for (KdWorkDto dto : newImportList) {
				// Ј̑݊mF
				if (part().human().isNotUseKCode(dto.getKCode())) {
					// G[bZ[W̕\
					addErrMessage(getMessage("IC0006", String.valueOf(i)));
					errSet.add(i);
				}
				if (VariousUtil.isNotNull(dao.findForKey(dto.getKCode(), dto.getSikyuYm()))) {
					// G[bZ[W̕\
					addErrMessage(getMessage("WC1023", ""));
					errSet.add(i);
				}
				i++;
			}
			if (errSet.size() == 0) {
				// o^
				count += dao.insert(newImportList, CommonConst.NUM_DIVIDE_NUMBER);
				// R~bg
				commit();
			}
		} else {
			// G[bZ[W̕\
			addErrMessage(getMessage("WC0018", ""));
		}
		// bZ[W̕\
		setMessage(getMessage("IC0014", String.valueOf(count)));
	}
	
	/**
	 * |[go
	 */
	private void report() {
		WorkCompileImportCardVo vo = (WorkCompileImportCardVo)getVo();
		if (vo.getTable() == WorkCompileImportCardVo.TABLE_NEW) {
			// o̓t@C
			request.setAttribute(MospConst.ATT_FILE_NAME, "WorkImportError.csv");
		}
		// o͓e
		request.setAttribute(MospConst.ATT_FILE_OBJECT, vo.getErrorReport());
		// V[PXԕsvݒ
		setNeedProcSeq(false);
	}
	
	/**
	 * @param aryValue f[^z
	 * @param aryHeader wb_[z
	 * @param i CfbNX
	 * @param newImportList VΑӏC|[gp̃Xg
	 * @throws Exception 	Oꍇ
	 */
	private void convDataToNewInfo(String[] aryValue, String[] aryHeader, int i, List<KdWorkDto> newImportList)
			throws Exception {
		// ЈR[h
		String kCode = aryValue[0];
		// xN
		String sikyuYM = "";
		// xN
		int sNen = 0;
		// x
		int sTuki = 0;
		// x
		int sHi = 0;
		// oΓ
		double sNissu = 0.0;
		// oΉ
		int sKaisu = 0;
		// Ζ
		int kinmuJi = 0;
		// xe
		int kyukeiJi = 0;
		// Lx
		double yukyu = 0.0;
		// ʋx
		double tokukyu = 0.0;
		// ʌΓ
		double kekkin = 0.0;
		// aΓ
		double sKekkin = 0.0;
		// ֋x
		double daikyu = 0.0;
		// U֋x
		double furikae = 0.0;
		// xɗR6
		double kkRiyuu6 = 0.0;
		// xɗR7
		double kkRiyuu7 = 0.0;
		// xɗR8
		double kkRiyuu8 = 0.0;
		// xɗR9
		double kkRiyuu9 = 0.0;
		// ̑x
		double sonota = 0.0;
		// xމ
		int tiSoKai = 0;
		// xގ
		int tiSoJikan = 0;
		// ʎcƎ
		int zaJikan = 0;
		// xoΎ
		int ksJikan = 0;
		// [Ζ
		int snJikan = 0;
		// FΎ蓖x
		int kaikin = 0;
		// H蓖x
		int syokujiKaisu = 0;
		// 1蓖x
		int cyokuKaisu1 = 0;
		// 2蓖x
		int cyokuKaisu2 = 0;
		// 3蓖x
		int cyokuKaisu3 = 0;
		// ̑x1
		int hokaKaisu1 = 0;
		// ̑x2
		int hokaKaisu2 = 0;
		// ̑x3
		int hokaKaisu3 = 0;
		// ̑x4
		int hokaKaisu4 = 0;
		// ̑x5
		int hokaKaisu5 = 0;
		// x\z
		int sinseiGaku = 0;
		// 1.00
		int warimasi1 = 0;
		// ԊO
		int weekDayOverTime = 0;
		// xԊO
		int weekHolidayOverTime = 0;
		// 60ԒߕԊO
		int monthlyOverTime = 0;
		// 60ԒߏxԊO
		int monthlyWeekHoliday = 0;
		// ԒPʔNx擾
		int hourHoliday = 0;
		// ԊOԑ̋xɎ擾
		double substituteHoliday = 0.0;
		// CtO
		int amendFlag = 0;
		try {
			// ڒmF
			checkLength(aryValue[0], aryHeader[0], CommonConst.LEN_K_CODE);
			checkLength(aryValue[1], aryHeader[1], CommonConst.LEN_SIKYU_YM);
			// lmF
			if (checkHalfValue(aryValue[5], aryHeader[5])) {
				sNissu = Double.parseDouble(aryValue[5]);
			}
			if (checkHalfValue(aryValue[9], aryHeader[9])) {
				yukyu = Double.parseDouble(aryValue[9]);
			}
			if (checkHalfValue(aryValue[10], aryHeader[10])) {
				tokukyu = Double.parseDouble(aryValue[10]);
			}
			if (checkHalfValue(aryValue[11], aryHeader[11])) {
				kekkin = Double.parseDouble(aryValue[11]);
			}
			if (checkHalfValue(aryValue[12], aryHeader[12])) {
				sKekkin = Double.parseDouble(aryValue[12]);
			}
			if (checkHalfValue(aryValue[13], aryHeader[13])) {
				daikyu = Double.parseDouble(aryValue[13]);
			}
			if (checkHalfValue(aryValue[14], aryHeader[14])) {
				furikae = Double.parseDouble(aryValue[14]);
			}
			if (checkHalfValue(aryValue[15], aryHeader[15])) {
				kkRiyuu6 = Double.parseDouble(aryValue[15]);
			}
			if (checkHalfValue(aryValue[16], aryHeader[16])) {
				kkRiyuu7 = Double.parseDouble(aryValue[16]);
			}
			if (checkHalfValue(aryValue[17], aryHeader[17])) {
				kkRiyuu8 = Double.parseDouble(aryValue[17]);
			}
			if (checkHalfValue(aryValue[18], aryHeader[18])) {
				kkRiyuu9 = Double.parseDouble(aryValue[18]);
			}
			if (checkHalfValue(aryValue[19], aryHeader[19])) {
				sonota = Double.parseDouble(aryValue[19]);
			}
			if (checkHalfValue(aryValue[42], aryHeader[42])) {
				substituteHoliday = Double.parseDouble(aryValue[42]);
			}
			if (checkNumber(aryValue[2], aryHeader[2])) {
				sNen = Integer.parseInt(aryValue[2]);
			}
			if (checkNumber(aryValue[3], aryHeader[3])) {
				sTuki = Integer.parseInt(aryValue[3]);
			}
			if (checkNumber(aryValue[4], aryHeader[4])) {
				sHi = Integer.parseInt(aryValue[4]);
			}
			if (checkNumber(aryValue[6], aryHeader[6])) {
				sKaisu = Integer.parseInt(aryValue[6]);
			}
			if (checkNumber(aryValue[7], aryHeader[7])) {
				kinmuJi = Integer.parseInt(aryValue[7]);
			}
			if (checkNumber(aryValue[8], aryHeader[8])) {
				kyukeiJi = Integer.parseInt(aryValue[8]);
			}
			if (checkNumber(aryValue[20], aryHeader[20])) {
				tiSoKai = Integer.parseInt(aryValue[20]);
			}
			if (checkNumber(aryValue[21], aryHeader[21])) {
				tiSoJikan = Integer.parseInt(aryValue[21]);
			}
			if (checkNumber(aryValue[22], aryHeader[22])) {
				zaJikan = Integer.parseInt(aryValue[22]);
			}
			if (checkNumber(aryValue[23], aryHeader[23])) {
				ksJikan = Integer.parseInt(aryValue[23]);
			}
			if (checkNumber(aryValue[24], aryHeader[24])) {
				snJikan = Integer.parseInt(aryValue[24]);
			}
			if (checkNumber(aryValue[25], aryHeader[25])) {
				kaikin = Integer.parseInt(aryValue[25]);
			}
			if (checkNumber(aryValue[26], aryHeader[26])) {
				syokujiKaisu = Integer.parseInt(aryValue[26]);
			}
			if (checkNumber(aryValue[27], aryHeader[27])) {
				cyokuKaisu1 = Integer.parseInt(aryValue[27]);
			}
			if (checkNumber(aryValue[28], aryHeader[28])) {
				cyokuKaisu2 = Integer.parseInt(aryValue[28]);
			}
			if (checkNumber(aryValue[29], aryHeader[29])) {
				cyokuKaisu3 = Integer.parseInt(aryValue[29]);
			}
			if (checkNumber(aryValue[30], aryHeader[30])) {
				hokaKaisu1 = Integer.parseInt(aryValue[30]);
			}
			if (checkNumber(aryValue[31], aryHeader[31])) {
				hokaKaisu2 = Integer.parseInt(aryValue[31]);
			}
			if (checkNumber(aryValue[32], aryHeader[32])) {
				hokaKaisu3 = Integer.parseInt(aryValue[32]);
			}
			if (checkNumber(aryValue[33], aryHeader[33])) {
				hokaKaisu4 = Integer.parseInt(aryValue[33]);
			}
			if (checkNumber(aryValue[34], aryHeader[34])) {
				hokaKaisu5 = Integer.parseInt(aryValue[34]);
			}
			if (checkNumber(aryValue[35], aryHeader[35])) {
				sinseiGaku = Integer.parseInt(aryValue[35]);
			}
			if (checkNumber(aryValue[36], aryHeader[36])) {
				warimasi1 = Integer.parseInt(aryValue[36]);
			}
			if (checkNumber(aryValue[37], aryHeader[37])) {
				weekDayOverTime = Integer.parseInt(aryValue[37]);
			}
			if (checkNumber(aryValue[38], aryHeader[38])) {
				weekHolidayOverTime = Integer.parseInt(aryValue[38]);
			}
			if (checkNumber(aryValue[39], aryHeader[39])) {
				monthlyOverTime = Integer.parseInt(aryValue[39]);
			}
			if (checkNumber(aryValue[40], aryHeader[40])) {
				monthlyWeekHoliday = Integer.parseInt(aryValue[40]);
			}
			if (checkNumber(aryValue[41], aryHeader[41])) {
				hourHoliday = Integer.parseInt(aryValue[41]);
			}
			if (checkNumber(aryValue[43], aryHeader[43])) {
				amendFlag = Integer.parseInt(aryValue[43]);
			}
			// ݊mF
			checkAvailableUser(kCode, i);
			// t̊mF
			Date dateSikyuYM = null;
			if (aryValue[1].length() > 5) {
				dateSikyuYM = checkTargetDate(aryValue[1].substring(0, 4), aryValue[1].substring(5), "1", aryHeader[1]);
			}
			if (VariousUtil.isNotNull(dateSikyuYM)) {
				sikyuYM = DateUtil.convDateToStringYearMonthShort(dateSikyuYM);
			}
			String strSikyuHeader = aryHeader[2] + "A" + aryHeader[3] + "A" + aryHeader[4];
			Date sikyuDate = checkTargetDate(aryValue[2], aryValue[3], aryValue[4], strSikyuHeader);
			if (VariousUtil.isNotNull(sikyuDate)) {
				sNen = MospUtility.getYear(sikyuDate);
				sTuki = MospUtility.getMonth(sikyuDate);
				sHi = MospUtility.getDay(sikyuDate);
			}
		} catch (NumberFormatException e) {
			// G[ꗗ֒ǉ
			addCsvErrMessage(CommonConst.MSG_INVALID_DATA_TYPE, String.valueOf(i));
		} catch (NullPointerException e) {
			// G[ꗗ֒ǉ			
			addCsvErrMessage(CommonConst.MSG_INVALID_DATA_TYPE, String.valueOf(i));
		} catch (MospException e) {
			// G[ꗗ֒ǉ
			addCsvErrMessage("WC1023", "");
		}
		if (!sikyuYM.equals("")) {
			// t@CdmF
			String hashCode = StringUtil.combineByComma(kCode, sikyuYM);
			if (!hashSet.contains(hashCode)) {
				hashSet.add(hashCode);
			} else {
				// t@CdG[bZ[W
				addCsvErrMessage("WC0027", "");
			}
			// f[^dmF
			if (VariousUtil.isNotNull(part().compile().getKdWorkInfo(kCode,
					DateUtil.getFirstDateOfMonth(sikyuYM.substring(0, 4), sikyuYM.substring(5))))) {
				// G[ꗗ֒ǉ
				addCsvErrMessage("WC1023", "");
			}
			if (VariousUtil.isNotNull(part().compile().getKintaiInfo(kCode,
					DateUtil.getFirstDateOfMonth(sikyuYM.substring(0, 4), sikyuYM.substring(5))))) {
				// G[ꗗ֒ǉ
				addCsvErrMessage("WC1023", "");
			}
		}
		if (errMessage.length() == 0) {
			// C|[gpXg֒ǉ
			newImportList.add(KintaiCompilePart.createKdWorkDto(kCode, sikyuYM, sNen, sTuki, sHi, sNissu, sKaisu,
					kinmuJi, kyukeiJi, yukyu, tokukyu, kekkin, sKekkin, daikyu, furikae, kkRiyuu6, kkRiyuu7, kkRiyuu8,
					kkRiyuu9, sonota, tiSoKai, tiSoJikan, zaJikan, ksJikan, snJikan, kaikin, syokujiKaisu, cyokuKaisu1,
					cyokuKaisu2, cyokuKaisu3, hokaKaisu1, hokaKaisu2, hokaKaisu3, hokaKaisu4, hokaKaisu5, sinseiGaku,
					warimasi1, weekDayOverTime, weekHolidayOverTime, monthlyOverTime, monthlyWeekHoliday, hourHoliday,
					substituteHoliday, amendFlag));
			// \pXg֒ǉ
			viewList.add(getViewArray(aryValue));
		} else {
			// G[ꗗ֒ǉ
			addErrorReport(aryHeader, aryValue);
		}
	}
	
	/**
	 * 񒷊mF(ő啶)
	 * <p>
	 * 񂪍ő啶蒷ꍇG[bZ[WڂɒǉB
	 * </p>
	 * @param value Ώە
	 * @param header Ώۃwb_[
	 * @param maxLength ő啶
	 * @throws MospException  	MosPOꍇ
	 */
	private void checkLength(String value, String header, int maxLength) throws MospException {
		StringBuffer sb = new StringBuffer();
		sb.append(".{0,");
		sb.append(maxLength);
		sb.append("}");
		if (!ValidateUtility.chkRegex(sb.toString(), value)) {
			addCsvErrMessage("WC0004", StringUtil.combineByComma(header, String.valueOf(maxLength)));
		}
	}
	
	/**
	 * @param msgCode bZ[WR[h
	 * @param rep u(ꍇ̓J}؂)
	 * @throws MospException 	MosPOꍇ
	 */
	private void addCsvErrMessage(String msgCode, String rep) throws MospException {
		errMessage.append(getCsvData(getMessage(msgCode, rep)));
		errMessage.append(CommonConst.STR_CSV_SEPARATOR);
	}
	
	/**
	 * lmF(_ȉ5)
	 * @param value Ώە
	 * @param header Ώۃwb_[
	 * @throws MospException 	MosPOꍇ
	 * @return 
	 * <p>
	 * Ώۂ0.5Ŋ؂ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	private boolean checkHalfValue(String value, String header) throws MospException {
		if (ValidateUtility.chkNumeric(value)) {
			double days = Double.parseDouble(value);
			if (String.valueOf(days).endsWith(".0") || String.valueOf(days).endsWith(".5")) {
				return true;
			}
		}
		addCsvErrMessage("WC0005", header);
		return false;
	}
	
	/**
	 * @param kCode ΏێЈR[h
	 * @param i CfbNX
	 * @throws Exception Oꍇ
	 */
	private void checkAvailableUser(String kCode, int i) throws Exception {
		// ݊mF
		if (part().human().isNotUseKCode(kCode)) {
			// G[ꗗ֒ǉ
			addCsvErrMessage("IC0006", String.valueOf(i));
		}
	}
	
	/**
	 * ^mF(_mF)
	 * @param value Ώە
	 * @param header Ώۃwb_[
	 * @throws MospException 	MosPOꍇ
	 * @return 
	 * <p>
	 * Ώۂ̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	private boolean checkNumber(String value, String header) throws MospException {
		if (!ValidateUtility.chkRegex("\\d*", value)) {
			addCsvErrMessage("WC0005", header);
			return false;
		}
		return true;
	}
	
	/**
	 * tϊ
	 * @param year N
	 * @param month 
	 * @param day 
	 * @param header Ώۃwb_[
	 * @return ϊt
	 * @throws MospException 	MosPOꍇ
	 */
	private Date checkTargetDate(String year, String month, String day, String header) throws MospException {
		Date date = null;
		// Date^ɕϊ
		date = DateUtil.convStringDateToDate(year + "/" + month + "/" + day);
		if (VariousUtil.isNotNull(date)) {
			if (!ValidateUtility.chkDate(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day))) {
				// G[ꗗ֒ǉ
				addCsvErrMessage("WC0006", header);
			}
		} else {
			// G[ꗗ֒ǉ
			addCsvErrMessage("WC0006", header);
		}
		return date;
	}
	
	private void addErrorReport(String[] aryHeader, String[] aryValue) {
		for (int i = 0; i < aryHeader.length - 1; i++) {
			if (i != aryHeader.length) {
				errorReport.append(getCsvData(aryHeader[i]) + CommonConst.STR_CSV_SEPARATOR);
			} else {
				errorReport.append(getCsvData(aryHeader[i]));
			}
		}
		errorReport.append(CommonConst.STR_CSV_NEW_LINE);
		for (int i = 0; i < aryValue.length - 1; i++) {
			if (i != aryValue.length) {
				errorReport.append(getCsvData(aryValue[i]) + CommonConst.STR_CSV_SEPARATOR);
			} else {
				errorReport.append(getCsvData(aryValue[i]));
			}
			
		}
		errorReport.append(errMessage);
		errorReport.deleteCharAt(errorReport.lastIndexOf(CommonConst.STR_CSV_SEPARATOR));
		errorReport.append(CommonConst.STR_CSV_NEW_LINE);
		errorCount++;
	}
	
	/**
	 * \pz̐ݒ
	 * @param aryValue Ώە
	 * @return \pz
	 */
	private String[] getViewArray(String[] aryValue) {
		String[] viewAry = new String[aryValue.length];
		for (int i = 0; i < aryValue.length - 4; i++) {
			if (i < 2) {
				viewAry[i] = aryValue[i];
			} else if (i == 2) {
				viewAry[i] = aryValue[i] + aryValue[i + 1] + aryValue[i + 2];
				i = i + 2;
			} else {
				viewAry[i - 2] = aryValue[i];
			}
		}
		return viewAry;
	}
	
	/**
	 * VΑӏΑӏɕϊ
	 * @param newDto VΑӏ
	 * @return Αӏ
	 */
	private static MKintaiDto convMKintaiDto(KdWorkDto newDto) {
		MKintaiDto dto = new MKintaiDto();
		dto.setKCode(newDto.getKCode());
		dto.setSikyuYM(newDto.getSikyuYm());
		dto.setSNen(newDto.getSNen());
		dto.setSTuki(newDto.getSTuki());
		dto.setSHi(newDto.getSHi());
		dto.setSNissu(newDto.getSNissu());
		dto.setSKaisu(newDto.getSKaisu());
		dto.setKinmuJi(newDto.getKinmuJi());
		dto.setKyukeiJi(newDto.getKyukeiJi());
		dto.setYukyu(newDto.getYukyu());
		dto.setTokuKyu(newDto.getTokukyu());
		dto.setKekkin(newDto.getKekkin());
		dto.setSKekkin(newDto.getSKekkin());
		dto.setDaiKyu(newDto.getDaikyu());
		dto.setFurikae(newDto.getFurikae());
		double totalOther = newDto.getSonota();
		totalOther += newDto.getKkRiyuu6();
		totalOther += newDto.getKkRiyuu7();
		totalOther += newDto.getKkRiyuu8();
		totalOther += newDto.getKkRiyuu9();
		dto.setSonota(Double.valueOf(totalOther).intValue());
		dto.setTiSoKai(newDto.getTiSoKai());
		dto.setTiJikan(newDto.getTiSoJikan());
		dto.setZaJikan(newDto.getZaJikan());
		dto.setKsJikan(newDto.getKsJikan());
		dto.setSnJikan(newDto.getSnJikan());
		dto.setKaikin(newDto.getKaikin());
		dto.setSyokujiKaisu(newDto.getSyokujiKaisu());
		dto.setCyokuKaisu1(newDto.getCyokuKaisu1());
		dto.setCyokuKaisu2(newDto.getCyokuKaisu2());
		dto.setCyokuKaisu3(newDto.getCyokuKaisu3());
		dto.setHokaKaisu1(newDto.getHokaKaisu1());
		dto.setHokaKaisu2(newDto.getHokaKaisu2());
		dto.setHokaKaisu3(newDto.getHokaKaisu3());
		dto.setHokaKaisu4(newDto.getHokaKaisu4());
		dto.setHokaKaisu5(newDto.getHokaKaisu5());
		dto.setNijiKyu(newDto.getHourHoliday());
		dto.setWarimasi1(newDto.getWarimasi1());
		return dto;
	}
}
